/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.common;

import com.indy.engine.core.common.Messages;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

public class UUID32 {
    private static final String ZEROS = "000000000000";
    private static Random rand;
    String random;
    byte[] inet;
    int hashCode;
    long timeStamp;

    private static Random getRandomInstance() throws NoSuchAlgorithmException {
        if (rand == null) {
            rand = SecureRandom.getInstanceStrong();
        }
        return rand;
    }

    public static UUID32 randomUUID(InetAddress addr, boolean secure, long tstamp, String sessionIdSalt) {
        UUID32 ret = new UUID32();
        try {
            byte[] ipaddr = addr != null ? addr.getAddress() : new byte[]{0, 1, 2, 3};
            ret.inet = ipaddr;
            ret.timeStamp = tstamp;
            int i = 0;
            if (secure) {
                SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
                i = prng.nextInt();
            } else {
                i = UUID32.getRandomInstance().nextInt();
            }
            Object strTemp = Integer.toHexString(i);
            while (((String)strTemp).length() < 8) {
                strTemp = "0" + (String)strTemp;
            }
            ret.random = ((String)strTemp).substring(4);
            if (sessionIdSalt != null) {
                ret.hashCode = sessionIdSalt.hashCode();
                if (ret.hashCode < 0) {
                    ret.hashCode = -1 * ret.hashCode;
                }
            } else {
                ret.hashCode = Math.abs(System.identityHashCode(ret));
            }
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new RuntimeException(Messages.getString("UUID32.0"), nsaex);
        }
        return ret;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        int i = 0;
        while (i < len) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            i += 2;
        }
        return data;
    }

    public static UUID32 decode(String str) {
        if (str != null && str.length() == 32) {
            UUID32 ret = new UUID32();
            String addressHex = str.substring(0, 8);
            try {
                ret.inet = UUID32.hexStringToByteArray(addressHex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String timeStampHex = str.substring(8, 20);
            String randomHex = str.substring(20, 24);
            while (timeStampHex.startsWith("0")) {
                timeStampHex = timeStampHex.substring(1);
            }
            BigInteger bi = new BigInteger(timeStampHex, 16);
            ret.timeStamp = bi.longValue();
            String hashCodeHex = str.substring(24, 32);
            while (hashCodeHex.startsWith("0")) {
                hashCodeHex = hashCodeHex.substring(1);
            }
            bi = hashCodeHex.length() == 0 ? new BigInteger("0") : new BigInteger(hashCodeHex, 16);
            ret.hashCode = bi.intValue();
            ret.random = randomHex;
            return ret;
        }
        return null;
    }

    public String toString() {
        String strTemp;
        byte[] ipaddr;
        StringBuilder strRetVal = new StringBuilder();
        byte[] byArray = ipaddr = this.inet;
        int n = ipaddr.length;
        int n2 = 0;
        while (n2 < n) {
            byte anIpaddr = byArray[n2];
            Byte b = new Byte(anIpaddr);
            strTemp = Integer.toHexString(b.intValue() & 0xFF);
            strRetVal.append(ZEROS.substring(0, 2 - strTemp.length()));
            strRetVal.append(strTemp);
            ++n2;
        }
        strTemp = Long.toHexString(this.timeStamp);
        strRetVal.append(ZEROS.substring(0, 12 - strTemp.length()));
        strRetVal.append(strTemp);
        strRetVal.append(this.random);
        strTemp = Long.toHexString(this.hashCode);
        strRetVal.append(ZEROS.substring(0, 8 - strTemp.length()));
        strRetVal.append(strTemp);
        return strRetVal.toString();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }
}

