/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.common.objects2;

import com.indy.engine.core.common.VariablePublicationMode;
import com.indy.engine.core.common.objects.VariableI;
import com.indy.engine.core.common.objects2.IVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Variable
implements IVariable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private String name = null;
    private String value = null;
    private String type = null;
    private boolean realTimeReport = false;
    private String source = null;
    private Object cumulativeValue = null;
    private long longValue;
    private long precLongValue;
    private String shortName;
    private String actionName;
    private VariableListener variableListener;
    boolean isCumulative = false;
    boolean toUpdate = false;
    String lastVbindedValue;
    private VariablePublicationMode variablePublicationMode;
    boolean originalSourceModified = false;

    public long getLongValue() {
        return this.longValue;
    }

    public Variable(Map<String, Object> map) {
        this.cumulativeValue = map.get("cumulativeValue");
        this.name = (String)map.get("name");
        this.realTimeReport = (Boolean)map.get("realTimeReport");
        this.source = (String)map.get("source");
        this.type = (String)map.get("type");
        this.value = (String)map.get("value");
        String currentMode = (String)map.get("variablePublicationMode");
        if (currentMode != null) {
            this.variablePublicationMode = VariablePublicationMode.valueOf(currentMode);
        }
    }

    public Variable() {
        this.realTimeReport = false;
    }

    public Variable(String pName, String pValue, String pType, boolean pIndyType, boolean isCumulative) {
        this.name = pName.startsWith("/") && pName.length() > 1 ? pName.substring(1) : pName;
        this.type = pType;
        this.realTimeReport = pIndyType;
        this.setValue(pValue, isCumulative);
    }

    public Variable(String pName, String pValue, String pType) {
        this.name = pName;
        this.source = this.value = pValue;
        this.type = pType;
    }

    public Variable(String pName, Object pValue) {
        this.name = pName;
        if (pValue != null) {
            this.value = pValue.toString();
        }
        this.source = this.value;
        this.type = pValue != null ? pValue.getClass().getSimpleName() : "String";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Object getTypedValue() {
        try {
            if (this.getType().equals("Integer")) {
                return Integer.valueOf(this.value);
            }
            if (this.getType().equals("Long")) {
                return Long.valueOf(this.value);
            }
            if (this.getType().equals("Float")) {
                return Double.valueOf(this.value);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void cumulValue() {
        if (this.value != null) {
            try {
                if (this.cumulativeValue == null) {
                    if (this.type.equals("Integer")) {
                        this.cumulativeValue = Integer.valueOf(this.value);
                    } else if (this.type.equals("Long")) {
                        this.cumulativeValue = Long.valueOf(this.value);
                    } else if (this.type.equals("Float")) {
                        this.cumulativeValue = Double.valueOf(this.value);
                    }
                } else if (this.type.equals("Integer")) {
                    this.cumulativeValue = (Integer)this.cumulativeValue + Integer.valueOf(this.value);
                } else if (this.type.equals("Long")) {
                    this.cumulativeValue = (Long)this.cumulativeValue + Long.valueOf(this.value);
                } else if (this.type.equals("Float")) {
                    this.cumulativeValue = (Double)this.cumulativeValue + Double.valueOf(this.value);
                }
            }
            catch (Exception e) {
                this.logger.warn("cumulValue", (Throwable)e);
            }
        }
    }

    public void setValue(String pValue, boolean cumulative) {
        this.isCumulative = cumulative;
        this.setValue(pValue);
    }

    @Override
    public void setValue(String pValue) {
        this.source = pValue;
        this.setValueOnly(pValue);
    }

    public void setValueOnly(String pValue) {
        this.setValueOnly(pValue, true);
    }

    public void setValueOnly(String pValue, boolean cumul) {
        this.value = pValue;
        if (cumul && this.isCumulative) {
            this.cumulValue();
        }
        this.setLongValue();
    }

    private void setLongValue() {
        if (this.isNumeric()) {
            this.precLongValue = this.longValue;
            this.longValue = this.toLongvalue();
            this.notifyChanged();
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public boolean isRealTimeReport() {
        return this.realTimeReport;
    }

    public void setRealTimeReport(boolean realTimeReport) {
        this.realTimeReport = realTimeReport;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public Object getCumulativeValue() {
        return this.cumulativeValue;
    }

    public void setValue(String lastValue, Object cumulativeValue) {
        if (cumulativeValue == null) {
            this.setValue(lastValue);
        } else {
            this.isCumulative = true;
            this.source = lastValue;
            this.value = lastValue;
            this.cumulativeValue = cumulativeValue;
            this.setLongValue();
        }
    }

    @Override
    public void clear() throws Exception {
        this.name = null;
        this.value = null;
        this.type = null;
        this.source = null;
        this.cumulativeValue = null;
        this.shortName = null;
        this.actionName = null;
        this.variableListener = null;
        this.variablePublicationMode = null;
    }

    public String toString() {
        String ret = null;
        ret = "Variable : \tName:" + this.name + "\n\tValue:" + this.value + "\n\tType:" + this.type + "\n";
        return ret;
    }

    public VariableI toVariableI() {
        VariableI var = new VariableI();
        var.setName(this.name);
        var.setCumulativeValue(this.cumulativeValue);
        var.setRealTimeReport(this.realTimeReport);
        var.setSource(this.source);
        var.setType(this.type);
        var.setValueOnly(this.value);
        return var;
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.cumulativeValue != null) {
            map.put("cumulativeValue", this.cumulativeValue);
        }
        if (this.name != null) {
            map.put("name", this.name);
        }
        map.put("realTimeReport", this.realTimeReport);
        if (this.source != null) {
            map.put("source", this.source);
        }
        if (this.type != null) {
            map.put("type", this.type);
        }
        if (this.value != null) {
            map.put("value", this.value);
        }
        if (this.variablePublicationMode != null) {
            map.put("variablePublicationMode", this.variablePublicationMode.name());
        }
        return map;
    }

    public static IVariable getVariable(Map<String, Object> object) {
        if (object != null) {
            return new Variable(object);
        }
        return null;
    }

    public static Map<String, Map<String, Object>> getVariableMap(Map<String, Variable> map) {
        if (map != null) {
            TreeMap<String, Map<String, Object>> result = new TreeMap<String, Map<String, Object>>();
            for (Map.Entry<String, Variable> entry : map.entrySet()) {
                IVariable o = entry.getValue();
                if (o == null) continue;
                result.put(entry.getKey(), o.toMap());
            }
            return result;
        }
        return null;
    }

    @Override
    public String getShortName() {
        String localName;
        if (this.shortName == null && (localName = this.getName()) != null) {
            int index = localName.lastIndexOf(47);
            this.shortName = index > -1 ? localName.substring(index + 1) : localName;
            if (this.shortName.startsWith("CORE_HTTP_REQUEST_HEADER_")) {
                this.shortName = this.shortName.toUpperCase();
            }
        }
        return this.shortName;
    }

    @Override
    public String getActionName() {
        int index;
        String localName;
        if (this.actionName == null && (localName = this.getName()) != null && (index = localName.lastIndexOf(47)) > -1) {
            this.actionName = localName.substring(0, index);
        }
        return this.actionName;
    }

    @Override
    public boolean isCore() {
        String localShortName = this.getShortName();
        if (localShortName != null) {
            return localShortName.startsWith("CORE_");
        }
        return false;
    }

    @Override
    public boolean isNumeric() {
        String localType = this.getType();
        return localType != null && (localType.equals("Integer") || localType.equals("Long"));
    }

    private long toLongvalue() {
        if (this.value != null) {
            Object localValue = null;
            if (this.isCumulative) {
                try {
                    localValue = this.getCumulativeValue();
                }
                catch (Exception e) {
                    this.logger.warn("Error getting cumulative value for variable ", (Throwable)e);
                }
            }
            if (localValue == null) {
                localValue = this.getTypedValue();
            }
            if (localValue != null) {
                String currentType = this.getType();
                if (currentType.equals("Integer")) {
                    return ((Integer)localValue).longValue();
                }
                if (currentType.equals("Long")) {
                    return (Long)localValue;
                }
            }
        }
        return 0L;
    }

    public void setVariableListener(VariableListener variableListener) {
        this.variableListener = variableListener;
        if (this.value != null) {
            this.notifyChanged();
        }
    }

    private void notifyChanged() {
        if (this.variableListener != null && !this.variableListener.isDisposed()) {
            this.variableListener.variableChanged(this, this.longValue, this.precLongValue, this.toUpdate);
            this.toUpdate = true;
        }
    }

    public void setLastBindedValue(String strVarValue) {
        if (this.value != null && strVarValue != null && this.value.compareTo(strVarValue) != 0) {
            this.lastVbindedValue = strVarValue;
        }
    }

    public boolean isOriginalSourceModified() {
        return this.originalSourceModified;
    }

    public void setOriginalSourceModified(boolean originalSourceModified) {
        this.originalSourceModified = originalSourceModified;
    }

    public VariablePublicationMode getVariablePublicationMode() {
        return this.variablePublicationMode;
    }

    public String getLastBindedValue() {
        return this.lastVbindedValue;
    }

    public void setMode(VariablePublicationMode mode) {
        this.variablePublicationMode = mode;
    }

    public static interface VariableListener {
        public void variableChanged(Variable var1, long var2, long var4, boolean var6);

        public boolean isDisposed();
    }
}

