/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.externalvalueresolver;

import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.indy.engine.core.externalvalueresolver.Messages;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.shared.configuration.externalvalueresolver.ExternalValueResolverConfiguration;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalValueResolverManager {
    public static final String PREFIX_PROPERTY = "PREFIX_PROPERTY";
    public static final String CLASS_PROPERTY = "CLASS_PROPERTY";
    private static ExternalValueResolverManager instance = new ExternalValueResolverManager();
    private final Logger logger = LogManager.getLogger(ExternalValueResolverManager.class);
    private List<ResolverWrapper> resolvers = new ArrayList<ResolverWrapper>();
    Comparator<ResolverWrapper> compare = (o1, o2) -> {
        String prefixa = o1.prefix;
        prefixa = prefixa != null ? prefixa : "";
        String prefixb = o2.prefix;
        prefixb = prefixb != null ? prefixb : "";
        int c = prefixa.length() - prefixb.length();
        if (c == 0) {
            return prefixa.compareTo(prefixb);
        }
        return c * -1;
    };
    public static final String START_PATTERN = "%ext{";
    public static final String END_PATTERN = "}ext%";
    static final int END_PATTERN_OFFSET = "}ext%".length();

    public static boolean needResolution(String ... value) {
        if (value != null) {
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.contains(START_PATTERN)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static ExternalValueResolverManager instance() {
        return instance;
    }

    protected ExternalValueResolverManager() {
    }

    protected ClassLoader getConfigurationClassLoader() throws Exception {
        return this.getModuleClassLoader("internal");
    }

    public void init(String runtimeEngineParametersLocation) throws Exception {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getConfigurationClassLoader());
            ExternalValueResolverConfiguration provider = ExternalValueResolverConfiguration.load((String)runtimeEngineParametersLocation);
            if (provider != null && provider.getConfigurations() != null) {
                for (IPluginFactory.IPluginConfiguration cnf : provider.getConfigurations()) {
                    this.createResolver(cnf);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    protected ClassLoader getModuleClassLoader(String classLoaderName) throws Exception {
        return ClassLoaderServiceProvider.instance().getClassLoader(classLoaderName);
    }

    protected IPluginFactory.IRelativePathResolver getRelativePathResolver() {
        return null;
    }

    private void createResolver(IPluginFactory.IPluginConfiguration cnf) throws Exception {
        if (cnf.getModuleProvider() == null) {
            throw new Exception(String.format(Messages.getString("ExternalValueResolverManager.0"), "module", cnf.getProperty("prefix")));
        }
        if (cnf.getPluginFactoryClassName() == null) {
            throw new Exception(String.format(Messages.getString("ExternalValueResolverManager.1"), "class", cnf.getProperty("prefix")));
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.getModuleClassLoader(cnf.getModuleProvider());
        Class<?> clzz = classLoader.loadClass(cnf.getPluginFactoryClassName());
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(Messages.getString("ExternalValueResolverManager.2"), (Object)cnf.getPluginFactoryClassName(), (Object)cnf.getProperty("prefix"));
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            IPluginFactory factory = (IPluginFactory)clzz.newInstance();
            IExternalValueResolverPlugin plugin = (IExternalValueResolverPlugin)factory.createPlugin(cnf, this.getRelativePathResolver());
            ResolverWrapper rw = new ResolverWrapper();
            rw.resolver = plugin;
            rw.prefix = cnf.getProperty("prefix");
            for (ResolverWrapper _resolver : this.resolvers) {
                if (this.compare.compare(_resolver, rw) != 0) continue;
                throw new Exception(Messages.getString("ExternalValueResolverManager.3"));
            }
            this.resolvers.add(rw);
            if (this.resolvers.size() > 1) {
                Collections.sort(this.resolvers, this.compare);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    public void addResolver(String prefix, IExternalValueResolverPlugin resolver) throws Exception {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(Messages.getString("ExternalValueResolverManager.4"), resolver.getClass(), (Object)prefix);
        }
        ResolverWrapper rw = new ResolverWrapper();
        rw.resolver = resolver;
        rw.prefix = prefix;
        for (ResolverWrapper _resolver : this.resolvers) {
            if (this.compare.compare(_resolver, rw) != 0) continue;
            throw new Exception(Messages.getString("ExternalValueResolverManager.5"));
        }
        this.resolvers.add(rw);
        if (this.resolvers.size() > 1) {
            Collections.sort(this.resolvers, this.compare);
        }
    }

    private byte[] getValue(String stringKey) throws IExternalValueResolverPlugin.ExternalValueResolverException {
        if (this.resolvers.isEmpty()) {
            throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.6"), stringKey));
        }
        for (ResolverWrapper resolver : this.resolvers) {
            if (resolver.prefix != null) {
                if (!stringKey.startsWith(resolver.prefix)) continue;
                String key = stringKey.substring(resolver.prefix.length());
                return this.doResolve(resolver, key, stringKey);
            }
            return this.doResolve(resolver, stringKey, stringKey);
        }
        throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.7"), stringKey));
    }

    private byte[] doResolve(ResolverWrapper resolver, String key, String aliasedKey) throws IExternalValueResolverPlugin.ExternalValueResolverException {
        IExternalValueResolverPlugin.Value value = null;
        try {
            value = resolver.resolver.getvalue(key, IExternalValueResolverPlugin.SecurityLevel.level2);
            if (value.errorMessage != null) {
                throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.9"), aliasedKey, value.errorMessage));
            }
            return value.data;
        }
        catch (IExternalValueResolverPlugin.ExternalValueResolverException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.8"), aliasedKey, ex.getMessage()));
        }
    }

    private int indexOf(String str) {
        if (str != null) {
            return str.indexOf(START_PATTERN);
        }
        return -1;
    }

    public Result replace(String str) throws IExternalValueResolverPlugin.ExternalValueResolverException {
        int i = this.indexOf(str);
        if (i > -1) {
            return new Result(this.replace(str, i), true);
        }
        return new Result(str, false);
    }

    private String replace(String str, int firstIndex) throws IExternalValueResolverPlugin.ExternalValueResolverException {
        StringBuilder sb = new StringBuilder();
        int start = -1;
        int end = -1;
        int last = 0;
        do {
            if (start == -1) {
                start = firstIndex;
                end = str.indexOf(END_PATTERN);
            } else {
                start = str.indexOf(START_PATTERN, last);
                end = str.indexOf(END_PATTERN, last);
            }
            if (start <= -1 || end <= -1) continue;
            if (start < end) {
                sb.append(str.substring(last, start));
                String stringKey = str.substring(start + END_PATTERN_OFFSET, end);
                byte[] value = this.getValue(stringKey);
                sb.append(new String(value, StandardCharsets.UTF_8));
                last = end + END_PATTERN_OFFSET;
                continue;
            }
            throw new IExternalValueResolverPlugin.ExternalValueResolverException(String.format(Messages.getString("ExternalValueResolverManager.10"), str));
        } while (start > -1);
        if (last <= str.length()) {
            sb.append(str.substring(last, str.length()));
        }
        return sb.toString();
    }

    class ResolverWrapper {
        IExternalValueResolverPlugin resolver;
        String prefix;

        ResolverWrapper() {
        }
    }

    public record Result(String resolved, boolean wasResolved) {
    }
}

