/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.main.connections;

import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.main.connections.Messages;
import com.indy.engine.core.main.connections.RuntimeDatasource;
import com.indy.engine.core.manager.IActionContext;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionManagerI {
    String connectionType;
    String connectionName;
    private Map<String, String> lstParameters;
    RuntimeDatasource<?> runtimeDataSource = null;
    Set<String> lstTransactions;
    ISessionContext engineContext = null;
    boolean creatingContainer = false;
    private AtomicInteger attachedActionCount = new AtomicInteger(0);
    private AtomicInteger attachedCertifiedActionCount = new AtomicInteger(0);

    public ConnectionManagerI(ISessionContext engineContext, String connName, String connType) {
        this.connectionName = connName;
        this.connectionType = connType;
        this.lstParameters = new ConcurrentHashMap<String, String>();
        this.lstTransactions = ConcurrentHashMap.newKeySet();
        this.engineContext = engineContext;
    }

    public ISessionContext getEngineContext() {
        return this.engineContext;
    }

    public void clear() {
        if (this.lstParameters != null) {
            this.lstParameters.clear();
        }
        if (this.lstTransactions != null) {
            this.lstTransactions.clear();
        }
    }

    public int addConnectionParameter(String paramName, String paramValue) {
        this.lstParameters.put(paramName, paramValue);
        return 0;
    }

    public Iterator<String> getParameterListIterator() {
        return this.lstParameters.keySet().iterator();
    }

    public String transformStringParameter(IActionContext callingAction, String pValue) throws EngineExceptionI {
        String s;
        try {
            String sValue;
            block6: {
                sValue = null;
                String varExpr = this.engineContext.transformVariableExpression(callingAction.getActionName(), pValue);
                try {
                    sValue = callingAction.executeSubstitutionScript(varExpr, "e");
                    sValue = callingAction.executeSubstitutionScript(sValue, "s");
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && callingAction.getAllowsScriptingErrors()) break block6;
                    throw new EngineExceptionI(e);
                }
            }
            s = sValue;
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ConnectionManagerI.0") + pValue + Messages.getString("ConnectionManagerI.1"), e);
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return s;
    }

    public String getConnectionParameter(IActionContext callingAction, String pName) throws EngineExceptionI {
        String ret = null;
        try {
            String paramToEval = this.lstParameters.get(pName);
            if (paramToEval != null) {
                ret = this.transformStringParameter(callingAction, paramToEval);
            }
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(e);
        }
        return ret;
    }

    public String getConnectionParameterWithoutTransfo(String pName) throws EngineExceptionI {
        String ret = null;
        try {
            String paramToEval;
            ret = paramToEval = this.lstParameters.get(pName);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(e);
        }
        return ret;
    }

    public int addTransaction(String transacName) {
        this.lstTransactions.add(transacName);
        return 0;
    }

    public synchronized void unlockAll() {
        this.creatingContainer = false;
        this.notifyAll();
    }

    public synchronized boolean hasRuntimeDataSource() {
        if (this.runtimeDataSource == null) {
            if (this.creatingContainer) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return true;
            }
            this.creatingContainer = true;
            return false;
        }
        return true;
    }

    public RuntimeDatasource<?> getRuntimeDataSource() {
        return this.runtimeDataSource;
    }

    public int setRuntimeDataSource(RuntimeDatasource<?> obj) {
        this.runtimeDataSource = obj;
        return 1;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public int removeConnectionParameter(String paramName) {
        try {
            this.lstParameters.remove(paramName);
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    public int removeTransaction(String transacName) {
        try {
            this.lstTransactions.remove(transacName);
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    public int setConnectionName(String connName) {
        this.connectionName = connName;
        return 0;
    }

    public int setConnectionType(String connType) {
        this.connectionType = connType;
        return 0;
    }

    public void closeAllConnections(boolean commitTrans) throws EngineExceptionI {
        try {
            if (this.runtimeDataSource != null) {
                this.runtimeDataSource.close(commitTrans);
            }
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
    }

    public void addCertifiedObject(boolean isCertified) throws Exception {
        int count = this.attachedActionCount.incrementAndGet();
        int certifiedCount = this.attachedCertifiedActionCount.get();
        if (isCertified) {
            certifiedCount = this.attachedCertifiedActionCount.incrementAndGet();
        }
        if (certifiedCount > 0 && certifiedCount != count) {
            throw new Exception(String.format(Messages.getString("ConnectionManagerI.2"), this.connectionName));
        }
    }
}

