/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.repository;

import com.indy.engine.core.repository.IDeliveryRepositoryInfo;
import com.indy.engine.core.repository.Messages;
import com.indy.engine.shared.configuration.repository.AbstractRepositoryBean;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.util.HashMap;
import java.util.Map;

public abstract class CommonDeliveryRepositoryStore
implements IDeliveryRepositoryInfo {
    private String cacheFolder = null;
    private Boolean webService = null;
    private int synchPollingInterval = 10000;
    private AbstractRepositoryBean.ScanMode scanMode = AbstractRepositoryBean.ScanMode.poll;
    private String name = null;
    private boolean isDefault = false;
    boolean enableMemoryCache = false;

    public CommonDeliveryRepositoryStore(IPluginFactory.IPluginConfiguration conf) {
        this.name = conf.getProperty("name");
        this.cacheFolder = conf.getProperty("cacheFolder");
        if (conf.getProperty("webservice") != null) {
            try {
                this.webService = Boolean.valueOf(conf.getProperty("webservice"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.synchPollingInterval = Integer.valueOf(conf.getProperty("pollInt"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.scanMode = AbstractRepositoryBean.ScanMode.valueOf((String)conf.getProperty("mode"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.scanMode == null) {
            throw new RuntimeException(String.format(Messages.getString("CommonDeliveryRepositoryStore.0"), this.getName()));
        }
        if (conf.getProperty("enableMemoryCache") != null) {
            try {
                this.enableMemoryCache = Boolean.valueOf(conf.getProperty("enableMemoryCache"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (conf.getProperty("default") != null) {
            try {
                this.isDefault = Boolean.valueOf(conf.getProperty("default"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public CommonDeliveryRepositoryStore(String cacheFolder, boolean webService, int synchPollingInterval, AbstractRepositoryBean.ScanMode scanMode, boolean enableMemoryCache, boolean isDefault, String name) {
        this.cacheFolder = cacheFolder;
        this.webService = webService;
        this.synchPollingInterval = synchPollingInterval;
        this.scanMode = scanMode;
        this.enableMemoryCache = enableMemoryCache;
        this.isDefault = isDefault;
        this.name = name;
    }

    @Override
    public Map<String, Object> toMap() {
        CommonDeliveryRepositoryStore repo = this;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDefault", repo.isDefault());
        map.put("isWebservice", repo.isWebservice());
        map.put("scanMode", repo.getStringScanMode());
        map.put("name", repo.getName());
        map.put("type", repo.getType());
        return map;
    }

    public String getCacheFolder() {
        return this.cacheFolder;
    }

    @Override
    public boolean isWebservice() {
        return this.webService != null && this.webService != false || this.getName() != null && this.getName().equals("webservices");
    }

    public Boolean getWebService() {
        return this.webService;
    }

    @Override
    public int getSynchPollingInterval() {
        return this.synchPollingInterval;
    }

    public AbstractRepositoryBean.ScanMode getScanMode() {
        return this.scanMode;
    }

    @Override
    public String getStringScanMode() {
        return this.scanMode.toString();
    }

    public boolean isEnableMemoryCache() {
        return this.enableMemoryCache;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

