/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonConstants;
import com.indy.runtime.json.JsonEventReader;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.json.Messages;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class JsonXmlEventReader
implements XMLEventReader {
    boolean disableAttributes;
    private JsonEventReader reader;
    ArrayMode arrayMode = ArrayMode.ARRAY_TAG;
    String arrayItemName = "item";
    String rootName = "root";
    private JSonEvent nextEvent;
    XMLEventFactory eventFactory;
    LinkedList<XMLEvent> queue = new LinkedList();
    int count = 0;
    boolean isRoot = true;
    LinkedList<StackType> stack = new LinkedList();
    private String encodingProcessing;
    private String xmlVersion = "1.0";
    XMLEvent currentEvent;

    public void setDisableAttributes(boolean disableAttributes) {
        this.disableAttributes = disableAttributes;
    }

    public void setArrayItemName(String arrayItemName) {
        this.arrayItemName = arrayItemName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void setArrayMode(ArrayMode arrayMode) {
        this.arrayMode = arrayMode;
    }

    public JsonXmlEventReader(JsonEventReader jer) throws Exception {
        this.reader = jer;
        this.eventFactory = XMLEventFactory.newInstance();
    }

    public JsonXmlEventReader(InputStream is, String charsetName) throws Exception {
        this.reader = new JsonEventReader(is, charsetName);
        this.eventFactory = XMLEventFactory.newInstance();
    }

    public JsonXmlEventReader(Reader _reader) throws Exception {
        this.reader = new JsonEventReader(_reader);
        this.eventFactory = XMLEventFactory.newInstance();
    }

    @Override
    public Object next() {
        try {
            return this.nextTag();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
    }

    private void createEndElement(String name) {
        this.queue.add(this.eventFactory.createEndElement("", null, name));
    }

    private void createElement(String name, boolean isArray, boolean isArrayItem, JSonEvent evt, StackType parentStack) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (!this.disableAttributes) {
            Attribute attr;
            if (this.arrayMode == ArrayMode.ARRAY_ITEM_TAG && isArrayItem) {
                attr = this.eventFactory.createAttribute(JsonConstants.JSON_ARRAY_ITEM, "true");
                attributes.add(attr);
            } else if ((this.arrayMode == ArrayMode.ARRAY_TAG || this.isRoot) && isArray) {
                attr = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, "json:array");
                attributes.add(attr);
            }
            if (evt.getType() == JSonEvent.Type.STRING) {
                attr = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, "string");
                attributes.add(attr);
            } else if (evt.getType() == JSonEvent.Type.VALUE) {
                String typeName;
                if (evt.getBsonDataType() != -2 && (typeName = evt.getBsonXmlDataType()) != null) {
                    Attribute attr2 = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, typeName);
                    attributes.add(attr2);
                }
                if (evt.getName().toLowerCase().equals("null")) {
                    attr = this.eventFactory.createAttribute(JsonConstants.XML_NIL, "true");
                    attributes.add(attr);
                } else if (evt.getName().equals("true") || evt.getName().equals("false")) {
                    attr = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, "boolean");
                    attributes.add(attr);
                } else if (evt.getName().matches("-?(?:0|[1-9]\\d*)(?:\\.\\d+)?(?:[eE][+-]?\\d+)?")) {
                    attr = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, "decimal");
                    attributes.add(attr);
                } else {
                    attr = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, "string");
                    attributes.add(attr);
                }
            } else if (evt.getType() == JSonEvent.Type.START_OBJECT) {
                attr = this.eventFactory.createAttribute(JsonConstants.XML_TYPE, "json:object");
                attributes.add(attr);
            }
        }
        this.queue.add(this.eventFactory.createStartElement("", null, name, attributes.iterator(), Collections.EMPTY_LIST.iterator()));
        if (this.isRoot) {
            this.queue.add(this.eventFactory.createNamespace("json", "http://www.stambia.com/2014/json"));
            this.queue.add(this.eventFactory.createNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
            this.isRoot = false;
        }
    }

    private String readName(JSonEvent jo) throws XMLStreamException {
        if (JsonUtils.checkIfNameIsValid(jo.getName())) {
            return jo.getName();
        }
        try {
            return "_." + JsonUtils.encodeHexString(jo.getName()) + "._";
        }
        catch (UnsupportedEncodingException e1) {
            throw new XMLStreamException(e1);
        }
    }

    public void setEncodingProcessingInstruction(String encodingProcessing) {
        this.encodingProcessing = encodingProcessing;
    }

    public void setXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    private boolean createEvent(JSonEvent jo) throws XMLStreamException {
        StackType parentStack = this.stack.size() > 0 ? this.stack.getLast() : null;
        boolean arrayItem = parentStack != null && !parentStack.isRoot && parentStack.jo.getType() == JSonEvent.Type.START_ARRAY && this.arrayMode == ArrayMode.ARRAY_ITEM_TAG;
        boolean _continue = false;
        switch (jo.getType()) {
            case START_DOCUMENT: {
                if (this.encodingProcessing != null && !this.encodingProcessing.isEmpty()) {
                    this.queue.add(this.eventFactory.createStartDocument(this.encodingProcessing, this.xmlVersion));
                } else {
                    this.queue.add(this.eventFactory.createStartDocument(null, this.xmlVersion));
                }
                StackType currentStack = new StackType();
                currentStack.jo = jo;
                this.stack.add(currentStack);
                break;
            }
            case END_DOCUMENT: {
                this.queue.add(this.eventFactory.createEndDocument());
                if (parentStack.jo.getType() != JSonEvent.Type.START_DOCUMENT) {
                    throw new XMLStreamException(Messages.getString("JsonXmlEventReader.0"));
                }
                this.stack.removeLast();
                break;
            }
            case MEMBER: {
                if (parentStack.jo.getType() != JSonEvent.Type.START_OBJECT) {
                    throw new XMLStreamException(Messages.getString("JsonXmlEventReader.1"));
                }
                StackType currentStack = new StackType();
                currentStack.jo = jo;
                currentStack.originalName = currentStack.name = this.readName(jo);
                this.stack.add(currentStack);
                return true;
            }
            case START_ARRAY: {
                StackType currentStack = new StackType();
                currentStack.isRoot = this.isRoot;
                currentStack.jo = jo;
                if (parentStack.jo.getType() == JSonEvent.Type.MEMBER) {
                    currentStack.originalName = currentStack.name = this.stack.getLast().name;
                    this.stack.removeLast();
                } else if (parentStack.jo.getType() == JSonEvent.Type.START_ARRAY || parentStack.jo.getType() == JSonEvent.Type.START_DOCUMENT) {
                    currentStack.originalName = this.arrayItemName + String.valueOf(parentStack.count > 1 ? Integer.valueOf(parentStack.count) : "");
                    currentStack.name = arrayItem ? parentStack.originalName : currentStack.originalName;
                    if (this.isRoot) {
                        currentStack.name = this.rootName;
                    } else if (this.getReader().addArrayRoot && parentStack.isRoot) {
                        currentStack.name = this.rootName;
                    }
                } else {
                    throw new XMLStreamException(Messages.getString("JsonXmlEventReader.2"));
                }
                if (this.isRoot || this.arrayMode == ArrayMode.ARRAY_TAG || arrayItem) {
                    this.createElement(currentStack.name, true, arrayItem, jo, parentStack);
                    currentStack.elementIsWrited = true;
                } else {
                    _continue = true;
                }
                this.stack.add(currentStack);
                this.isRoot = false;
                break;
            }
            case START_OBJECT: {
                StackType currentStack = new StackType();
                currentStack.isRoot = this.isRoot;
                currentStack.jo = jo;
                if (parentStack.jo.getType() == JSonEvent.Type.MEMBER) {
                    currentStack.originalName = currentStack.name = this.stack.getLast().name;
                    this.stack.removeLast();
                } else if (parentStack.jo.getType() == JSonEvent.Type.START_ARRAY || parentStack.jo.getType() == JSonEvent.Type.START_DOCUMENT) {
                    currentStack.originalName = this.arrayItemName + String.valueOf(parentStack.count > 1 ? Integer.valueOf(parentStack.count) : "");
                    currentStack.name = arrayItem ? parentStack.originalName : currentStack.originalName;
                    if (this.isRoot) {
                        currentStack.name = this.rootName;
                    } else if (this.getReader().addArrayRoot && parentStack.isRoot) {
                        currentStack.name = this.rootName;
                    }
                } else {
                    throw new XMLStreamException(Messages.getString("JsonXmlEventReader.3"));
                }
                this.createElement(currentStack.name, false, arrayItem, jo, parentStack);
                currentStack.elementIsWrited = true;
                this.stack.add(currentStack);
                this.isRoot = false;
                break;
            }
            case END_ARRAY: {
                if (parentStack.jo.getType() != JSonEvent.Type.START_ARRAY) {
                    throw new XMLStreamException(Messages.getString("JsonXmlEventReader.4"));
                }
                if (parentStack.elementIsWrited) {
                    this.createEndElement(parentStack.name);
                } else {
                    _continue = true;
                }
                this.stack.removeLast();
                break;
            }
            case END_OBJECT: {
                if (parentStack.jo.getType() != JSonEvent.Type.START_OBJECT) {
                    throw new XMLStreamException(Messages.getString("JsonXmlEventReader.5"));
                }
                this.createEndElement(parentStack.name);
                this.stack.removeLast();
                break;
            }
            case STRING: 
            case VALUE: {
                if (parentStack.jo.getType() == JSonEvent.Type.MEMBER) {
                    this.createElement(parentStack.name, false, arrayItem, jo, parentStack);
                    if (jo.getType() != JSonEvent.Type.VALUE || !jo.getName().toLowerCase().equals("null")) {
                        this.queue.add(this.eventFactory.createCharacters(this.bsonData(jo)));
                    }
                    this.createEndElement(parentStack.name);
                    this.stack.removeLast();
                    break;
                }
                if (parentStack.jo.getType() == JSonEvent.Type.START_ARRAY || parentStack.jo.getType() == JSonEvent.Type.START_DOCUMENT) {
                    Object name = arrayItem ? parentStack.originalName : this.arrayItemName + String.valueOf(parentStack.count > 1 ? Integer.valueOf(parentStack.count) : "");
                    if (this.isRoot) {
                        name = this.rootName;
                    } else if (this.getReader().addArrayRoot && parentStack.isRoot) {
                        name = this.rootName;
                    }
                    this.createElement((String)name, false, arrayItem, jo, parentStack);
                    this.queue.add(this.eventFactory.createCharacters(jo.getName()));
                    this.createEndElement((String)name);
                    break;
                }
                throw new XMLStreamException(Messages.getString("JsonXmlEventReader.6"));
            }
            default: {
                throw new XMLStreamException(Messages.getString("JsonXmlEventReader.7") + String.valueOf((Object)jo.getType()) + Messages.getString("JsonXmlEventReader.8"));
            }
        }
        return _continue;
    }

    public void setBsonStyle(boolean bsonStyle) {
        this.reader.setBsonStyle(bsonStyle);
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.queue.size() > 0) {
            this.currentEvent = this.queue.poll();
            return this.currentEvent;
        }
        try {
            this.nextEvent = this.reader.readNext();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
        if (this.nextEvent != null) {
            while (this.createEvent(this.nextEvent)) {
                try {
                    this.nextEvent = this.reader.readNext();
                }
                catch (Exception e) {
                    throw new XMLStreamException(e);
                }
            }
            if (this.queue.size() > 0) {
                this.currentEvent = this.queue.poll();
                return this.currentEvent;
            }
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        if (this.queue.size() > 0) {
            return true;
        }
        return this.reader != null && this.reader.hasNext();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (this.currentEvent != null) {
            return this.currentEvent;
        }
        return this.currentEvent;
    }

    @Override
    public String getElementText() throws XMLStreamException {
        throw new XMLStreamException();
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        return this.nextEvent();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public void close() throws XMLStreamException {
        try {
            this.reader.close();
        }
        catch (Exception e) {
            throw new XMLStreamException(e.getMessage(), e);
        }
        this.reader = null;
    }

    public JsonEventReader getReader() {
        return this.reader;
    }

    private String bsonData(JSonEvent evt) {
        if (evt.getBsonDataType() != -2) {
            String data = evt.convertToXmlData();
            return data;
        }
        return evt.getName();
    }

    public static enum ArrayMode {
        ARRAY_TAG,
        ARRAY_ITEM_TAG;

    }

    class StackType {
        JSonEvent jo;
        String name;
        String originalName;
        int count = 0;
        boolean elementIsWrited = false;
        boolean isRoot = false;

        StackType() {
        }
    }
}

