/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json;

import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonConstants;
import com.indy.runtime.json.JsonEventWriter;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.json.Messages;
import com.indy.runtime.json.internal.XMLArrayTransformer;
import java.io.OutputStream;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class JsonXmlEventWriter
implements XMLEventWriter {
    JsonEventWriter x;
    LinkedList<Element> parents = new LinkedList();
    XMLArrayTransformer transformer = new XMLArrayTransformer(){

        @Override
        public void handle(XMLEvent event) throws XMLStreamException {
            JsonXmlEventWriter.this._add(event);
        }
    };
    boolean bsonStyle = false;

    public JsonXmlEventWriter(OutputStream out, String charsetName) throws XMLStreamException {
        this.x = new JsonEventWriter(out, charsetName);
    }

    public JsonXmlEventWriter(JsonEventWriter jew) throws XMLStreamException {
        this.x = jew;
    }

    @Override
    public void flush() throws XMLStreamException {
        this.x.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        if (this.x != null) {
            this.x.close();
            this.x = null;
        }
    }

    public void setSkipSlashCharacterEscaping(boolean skipSlashCharacterEscaping) {
        this.x.setSkipSlashCharacterEscaping(skipSlashCharacterEscaping);
    }

    void addElement(Element elt) {
        Element parent;
        elt.parent = parent = this.parents.size() > 0 ? this.parents.getLast() : null;
        this.parents.add(elt);
    }

    void removeLast() {
        Element last;
        Element element = last = this.parents.size() > 0 ? this.parents.getLast() : null;
        if (last != null) {
            last.parent = null;
            this.parents.removeLast();
        }
    }

    @Override
    public void add(XMLEvent paramXMLEvent) throws XMLStreamException {
        this.transformer.add(paramXMLEvent);
    }

    public void add2(XMLEvent param, XMLEventWriter writer) {
    }

    public void setBsonStyle(boolean bsonStyle) {
        this.bsonStyle = bsonStyle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _add(XMLEvent paramXMLEvent) throws XMLStreamException {
        try {
            Element parent = this.parents.size() > 0 ? this.parents.getLast() : null;
            switch (paramXMLEvent.getEventType()) {
                case 7: {
                    this.x.add(JSonEvent.createStartDocument());
                    return;
                }
                case 8: {
                    this.x.add(JSonEvent.createEndDocument());
                    return;
                }
                case 1: {
                    StartElement se = paramXMLEvent.asStartElement();
                    if (parent != null && parent.mode == Type.Object) {
                        String name = se.getName().getLocalPart();
                        if (name.startsWith("_.") && name.endsWith("._")) {
                            name = name.substring(2, name.length() - 2);
                            name = JsonUtils.decodeHexString(name);
                        }
                        this.x.add(JSonEvent.createMember(name));
                    }
                    Attribute type = se.getAttributeByName(JsonConstants.XML_TYPE);
                    Attribute nil = se.getAttributeByName(JsonConstants.XML_NIL);
                    Element elt = new Element();
                    if (nil != null && nil.getValue().equals("true")) {
                        elt.mode = Type.NULL;
                    } else if (type != null) {
                        String lower;
                        elt.type = lower = type.getValue().toLowerCase();
                        if (this.bsonStyle) {
                            if (lower.equals("number")) {
                                elt.mode = Type.Value;
                            } else if (lower.equals("decimal")) {
                                elt.mode = Type.Value;
                            } else if (lower.equals("string")) {
                                elt.mode = Type.String;
                            } else if (lower.equals("double")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 1;
                            } else if (lower.equals("int")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 16;
                            } else if (lower.equals("long")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 18;
                            } else if (lower.equals("boolean")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 8;
                            } else if (lower.equals("datetime")) {
                                elt.bsonDataType = 9;
                                elt.mode = Type.Value;
                            } else if (lower.equals("base64binary")) {
                                elt.bsonDataType = 5;
                                elt.mode = Type.Value;
                            } else if (lower.equals("bson:maxkey")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 127;
                            } else if (lower.equals("bson:minkey")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = -1;
                            } else if (lower.equals("bson:timestamp")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 17;
                            } else if (lower.equals("bson:javascriptwithscope")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 15;
                            } else if (lower.equals("bson:symbol")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 14;
                            } else if (lower.equals("bson:javascript")) {
                                elt.mode = Type.Value;
                                elt.bsonDataType = 13;
                            } else if (!lower.equals("bson:dbpointer")) {
                                if (lower.equals("bson:regex")) {
                                    elt.mode = Type.Value;
                                    elt.bsonDataType = 11;
                                } else if (lower.equals("bson:objectid")) {
                                    elt.mode = Type.Value;
                                    elt.bsonDataType = 7;
                                } else if (lower.equals("json:array")) {
                                    elt.mode = Type.Array;
                                    this.x.add(JSonEvent.createStartArray());
                                } else if (lower.equals("json:anonymous")) {
                                    elt.mode = Type.NO;
                                } else if (lower.equals("json:object")) {
                                    elt.mode = Type.Object;
                                    this.x.add(JSonEvent.createStartObject());
                                }
                            }
                        } else if (lower.equals("string") || lower.equals("qname") || lower.equals("ncname") || lower.equals("name")) {
                            elt.mode = Type.String;
                        } else if (lower.equals("int") || lower.equals("integer") || lower.equals("short") || lower.equals("float") || lower.equals("double") || lower.equals("long") || lower.equals("decimal") || lower.equals("byte") || lower.equals("negativeinteger") || lower.equals("nonNegativeinteger") || lower.equals("nonPositiveinteger") || lower.equals("positiveinteger") || lower.equals("unsignedlong") || lower.equals("unsignedint") || lower.equals("unsignedshort") || lower.equals("unsignedbyte") || lower.equals("boolean")) {
                            elt.mode = Type.Value;
                        } else if (lower.equals("json:array")) {
                            elt.mode = Type.Array;
                            this.x.add(JSonEvent.createStartArray());
                        } else if (lower.equals("json:anonymous")) {
                            elt.mode = Type.NO;
                        } else if (lower.equals("json:object")) {
                            elt.mode = Type.Object;
                            this.x.add(JSonEvent.createStartObject());
                        } else {
                            elt.mode = Type.String;
                        }
                    } else if (se.getAttributeByName(JsonConstants.JSON_ARRAY) != null) {
                        elt.mode = Type.Array;
                        this.x.add(JSonEvent.createStartArray());
                    } else if (se.getAttributeByName(XMLArrayTransformer.anonymous) != null) {
                        elt.mode = Type.NO;
                    } else {
                        elt.mode = Type.Object;
                        this.x.add(JSonEvent.createStartObject());
                    }
                    this.addElement(elt);
                    return;
                }
                case 4: 
                case 12: {
                    if (parent == null) {
                        throw new XMLStreamException(Messages.getString("JsonXmlEventWriter.0"));
                    }
                    if (parent.mode == Type.Value) {
                        String val = paramXMLEvent.asCharacters().getData();
                        if (val != null && val.isEmpty()) {
                            if (!parent.canBeSetWithEmptyString()) throw new XMLStreamException(Messages.getString("JsonXmlEventWriter.1") + parent.type + Messages.getString("JsonXmlEventWriter.2"));
                            this.x.add(JSonEvent.createValue(val, parent.bsonDataType));
                        } else {
                            this.x.add(JSonEvent.createValue(val, parent.bsonDataType));
                        }
                        parent.isWrited = true;
                        return;
                    }
                    if (parent.mode != Type.String) return;
                    this.x.add(JSonEvent.createString(paramXMLEvent.asCharacters().getData()));
                    parent.isWrited = true;
                    return;
                }
                case 99: {
                    this.x.add(JSonEvent.createNewLineCharacter());
                    return;
                }
                case 2: {
                    if (parent == null) {
                        throw new XMLStreamException(Messages.getString("JsonXmlEventWriter.4"));
                    }
                    if (parent.mode == Type.Object) {
                        this.x.add(JSonEvent.createEndObject());
                        this.removeLast();
                        return;
                    }
                    if (parent.mode == Type.Array) {
                        this.x.add(JSonEvent.createEndArray());
                        this.removeLast();
                        return;
                    }
                    if (parent.mode == Type.Value) {
                        if (!parent.isWrited) {
                            if (!parent.canBeSetWithEmptyString()) {
                                throw new XMLStreamException(Messages.getString("JsonXmlEventWriter.5") + parent.type + Messages.getString("JsonXmlEventWriter.6"));
                            }
                            this.x.add(JSonEvent.createValue("", parent.bsonDataType));
                            parent.isWrited = true;
                        }
                        this.removeLast();
                        return;
                    }
                    if (parent.mode == Type.String) {
                        if (!parent.isWrited) {
                            this.x.add(JSonEvent.createString(""));
                            parent.isWrited = true;
                        }
                        this.removeLast();
                        return;
                    }
                    if (parent.mode == Type.NO) {
                        this.removeLast();
                        return;
                    }
                    if (parent.mode != Type.NULL) throw new XMLStreamException();
                    this.x.add(JSonEvent.createNull());
                    this.removeLast();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public void add(XMLEventReader xmlReader) throws XMLStreamException {
        try {
            while (xmlReader.hasNext()) {
                XMLEvent event = xmlReader.nextEvent();
                this.add(event);
            }
        }
        catch (Exception ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public String getPrefix(String paramString) throws XMLStreamException {
        return null;
    }

    @Override
    public void setPrefix(String paramString1, String paramString2) throws XMLStreamException {
    }

    @Override
    public void setDefaultNamespace(String paramString) throws XMLStreamException {
    }

    @Override
    public void setNamespaceContext(NamespaceContext paramNamespaceContext) throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    class Element {
        Element parent;
        boolean isNull;
        int bsonDataType;
        Type mode;
        QName name;
        QName arrayItemName = null;
        boolean isWrited;
        public String type;

        Element() {
        }

        public boolean canBeSetWithEmptyString() {
            return this.mode == Type.String || this.mode == Type.Value && (this.bsonDataType == 5 || this.bsonDataType == 13 || this.bsonDataType == 15 || this.bsonDataType == 14 || this.bsonDataType == 11);
        }

        String getPath() {
            Object ret = "";
            if (this.parent != null) {
                ret = (String)ret + this.parent.getPath();
            }
            ret = (String)ret + "/" + this.name.getLocalPart();
            return ret;
        }
    }

    public static enum Type {
        String,
        Value,
        Array,
        Object,
        NO,
        NULL;

    }
}

