/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.json.internal;

import com.indy.engine.core.IJsonUtils;
import com.indy.runtime.json.IIterativeValue;
import com.indy.runtime.json.JSonEvent;
import com.indy.runtime.json.JsonEventReader;
import com.indy.runtime.json.JsonEventWriter;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.json.JsonXmlEventReader;
import com.indy.runtime.json.internal.JsonEventCatcher;
import com.indy.runtime.json.internal.Messages;
import jakarta.xml.bind.DatatypeConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class JsonNodeToObject {
    public static final String DISABLE_DECIMAL_POLYMORPHY = "DISABLE_DECIMAL_POLYMORPHY";
    public static final String DECIMAL_AS_DOUBLE = "DECIMAL_AS_DOUBLE";
    public static final String INTEGER_AS_LONG = "INTEGER_AS_LONG";
    public static final String INTEGER_AS_INTEGER = "INTEGER_AS_INTEGER";
    public static final String ITERATIVE_MAP_VALUES_AS_LIST = "ITERATIVE_MAP_VALUES_AS_LIST";
    public static final String INTEGER_AS_INTEGER_OR_LONG = "INTEGER_AS_INTEGER_OR_LONG";
    public static final String INTEGER_AS_BIGINTEGER = "INTEGER_AS_BIGINTEGER";
    public static final String RESULT_AS_JSON_STRING = "RESULT_AS_JSON_STRING";
    public static final String PARSE_BSON_DATATYPE = "PARSE_BSON_DATATYPE";
    public static final String KEEP_NULL_VALUE = "KEEP_NULL_VALUE";
    public static final String KEEP_NULL_ITEM = "KEEP_NULL_ITEM";
    public static final String KEEP_EMPTY_VALUE = "KEEP_EMPTY_VALUE";
    public static final String START_PATH = "START_PATH";
    public static final String BASE64BINARY_AS_BYTE_ARRAY = "BASE64BINARY_AS_BYTE_ARRAY";
    boolean decimalAsDouble;
    boolean keepNullValue;
    boolean keepNullItem;
    boolean keepEmptyValue;
    boolean base64BinaryAsByteArray;
    IntegerBehaviour integerBehaviour = IntegerBehaviour.integerAsInteger;
    private boolean iterativeMapValuesAsList;
    private boolean disableDecimalPolymorphy;
    static final QName type = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
    static final QName nil = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");
    XMLEventReader jxer;
    JsonEventReader jer;
    private boolean resultAsJsonString;
    private boolean parseBsonDataType;

    public JsonNodeToObject(InputStream is, String encoding, Map<String, Object> properties) throws Exception {
        this(is, encoding, properties, false);
    }

    private Boolean _getBooleanValue(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new Exception(Messages.getString("JsonNodeToObject.0") + String.valueOf(value));
    }

    public JsonNodeToObject(InputStream is, String encoding, Map<String, Object> properties, boolean inputXml) throws Exception {
        if (inputXml) {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            factory.setProperty("javax.xml.stream.supportDTD", false);
            this.jxer = factory.createXMLEventReader(is, encoding);
        } else {
            this.jer = new JsonEventReader(is, encoding);
            this.jxer = new JsonXmlEventReader(this.jer);
            ((JsonXmlEventReader)this.jxer).setArrayMode(JsonXmlEventReader.ArrayMode.ARRAY_TAG);
        }
        Boolean b = this._getBooleanValue(properties.get(DECIMAL_AS_DOUBLE));
        if (Boolean.TRUE.equals(b)) {
            this.decimalAsDouble = true;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(INTEGER_AS_LONG)))) {
            this.integerBehaviour = IntegerBehaviour.integerAsLong;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(INTEGER_AS_INTEGER)))) {
            this.integerBehaviour = IntegerBehaviour.integerAsLong;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(INTEGER_AS_INTEGER_OR_LONG)))) {
            this.integerBehaviour = IntegerBehaviour.integerAsIntegerOrLong;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(INTEGER_AS_BIGINTEGER)))) {
            this.integerBehaviour = IntegerBehaviour.integerAsBigInteger;
        }
        if ((b = this._getBooleanValue(properties.get(KEEP_NULL_ITEM))) != null) {
            this.keepNullItem = b;
        }
        if ((b = this._getBooleanValue(properties.get(KEEP_NULL_VALUE))) != null) {
            this.keepNullValue = b;
        }
        if ((b = this._getBooleanValue(properties.get(KEEP_EMPTY_VALUE))) != null) {
            this.keepEmptyValue = b;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(RESULT_AS_JSON_STRING)))) {
            this.resultAsJsonString = true;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(PARSE_BSON_DATATYPE)))) {
            this.parseBsonDataType = true;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(BASE64BINARY_AS_BYTE_ARRAY)))) {
            this.base64BinaryAsByteArray = true;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(ITERATIVE_MAP_VALUES_AS_LIST)))) {
            this.iterativeMapValuesAsList = true;
        }
        if (Boolean.TRUE.equals(b = this._getBooleanValue(properties.get(DISABLE_DECIMAL_POLYMORPHY)))) {
            this.disableDecimalPolymorphy = true;
        }
        if (this.jxer instanceof JsonXmlEventReader) {
            ((JsonXmlEventReader)this.jxer).setBsonStyle(this.parseBsonDataType);
        }
    }

    public boolean read(JsonNodeToObjectHandler handler, String _path, Map<String, JsonNodeToStringHandler> stringContentHandler) throws Exception {
        if ((this.parseBsonDataType || this.resultAsJsonString) && this.jer != null) {
            return this.read2(handler, _path);
        }
        XMLEventFactory eventFactory = null;
        Object ret = null;
        String currentName = null;
        int _type = 0;
        Path path = new Path(_path);
        Path currentPath = new Path();
        Stack stack = null;
        boolean deletedPath = false;
        boolean _ret = false;
        HashMap currentId = new HashMap();
        boolean end = false;
        while (this.jxer.hasNext() && !end) {
            XMLEvent event;
            block77: {
                Object value;
                block79: {
                    String data;
                    block81: {
                        block82: {
                            block80: {
                                block78: {
                                    event = this.jxer.nextEvent();
                                    if (event.isStartElement()) {
                                        Object parent;
                                        currentName = event.asStartElement().getName().getLocalPart();
                                        if (currentName.startsWith("_.") && currentName.endsWith("._")) {
                                            currentName = currentName.substring(2, currentName.length() - 2);
                                            currentName = JsonUtils.decodeHexString(currentName);
                                        }
                                        currentPath.add(currentName);
                                        if (currentPath.equals(path)) {
                                            stack = new Stack();
                                        }
                                        if (stack == null) continue;
                                        boolean stringHandler = false;
                                        if (stringContentHandler != null) {
                                            for (Map.Entry<String, JsonNodeToStringHandler> entry : stringContentHandler.entrySet()) {
                                                Path __path = new Path(entry.getKey());
                                                if (!currentPath.equals(__path)) continue;
                                                stringHandler = true;
                                                ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
                                                Iterator<Attribute> it = event.asStartElement().getAttributes();
                                                ArrayList<Attribute> attrs = new ArrayList<Attribute>();
                                                while (it.hasNext()) {
                                                    Attribute attr = it.next();
                                                    attrs.add(attr);
                                                }
                                                if (eventFactory == null) {
                                                    eventFactory = XMLEventFactory.newFactory();
                                                }
                                                event = eventFactory.createStartElement(event.asStartElement().getName().getPrefix(), event.asStartElement().getName().getNamespaceURI(), event.asStartElement().getName().getLocalPart(), attrs.iterator(), event.asStartElement().getNamespaces(), event.asStartElement().getNamespaceContext());
                                                events.addAll(this.getEvents(this.jxer));
                                                events.remove(events.size() - 1);
                                                IJsonUtils.Adapter coll = entry.getValue().createAdapter(events);
                                                if (stack.size() > 0) {
                                                    Object parent2 = stack.lastElement();
                                                    if (parent2 instanceof List) {
                                                        ((List)parent2).add(coll);
                                                    } else if (parent2 instanceof Map) {
                                                        this.putValue((Map)parent2, currentName, coll);
                                                    }
                                                }
                                                currentPath.remove();
                                            }
                                        }
                                        if (stringHandler) continue;
                                        _type = 0;
                                        Cloneable newObject = null;
                                        Attribute attrNil = event.asStartElement().getAttributeByName(nil);
                                        if (attrNil != null && attrNil.getValue().equals("true")) {
                                            Object parent3;
                                            _type = 4;
                                            if (_type != 4 || stack.size() <= 0 || !((parent3 = stack.lastElement()) instanceof Map)) continue;
                                            this.putValue((Map)parent3, currentName, null);
                                            continue;
                                        }
                                        Attribute attr = event.asStartElement().getAttributeByName(type);
                                        if (attr != null) {
                                            if (attr.getValue().equals("json:array")) {
                                                newObject = new ArrayList();
                                            } else if (attr.getValue().equals("json:object")) {
                                                newObject = new LinkedHashMap();
                                            } else if (attr.getValue().equals("string")) {
                                                _type = 1;
                                            } else if (attr.getValue().equals("boolean")) {
                                                _type = 2;
                                            } else if (attr.getValue().equals("decimal")) {
                                                _type = 3;
                                            } else if (attr.getValue().equals("base64Binary") && this.base64BinaryAsByteArray) {
                                                _type = 5;
                                            } else if (attr.getValue().equals("integer")) {
                                                _type = 6;
                                            } else if (attr.getValue().equals("int")) {
                                                _type = 7;
                                            } else if (attr.getValue().equals("long")) {
                                                _type = 8;
                                            } else if (attr.getValue().equals("double")) {
                                                _type = 9;
                                            } else if (attr.getValue().equals("float")) {
                                                _type = 10;
                                            } else if (attr.getValue().equals("short")) {
                                                _type = 11;
                                            } else if (attr.getValue().equals("byte")) {
                                                _type = 12;
                                            }
                                        }
                                        if (newObject != null) {
                                            if (stack.size() > 0) {
                                                parent = stack.lastElement();
                                                if (parent instanceof List) {
                                                    ((List)parent).add(newObject);
                                                } else if (parent instanceof Map) {
                                                    this.putValue((Map)parent, currentName, newObject);
                                                }
                                            }
                                            stack.add(newObject);
                                        }
                                        if (!this.keepEmptyValue || _type != 1 || !this.jxer.peek().isEndElement() || stack.size() <= 0) continue;
                                        parent = stack.lastElement();
                                        if (parent instanceof List) {
                                            ((List)parent).add("");
                                            continue;
                                        }
                                        if (!(parent instanceof Map)) continue;
                                        this.putValue((Map)parent, currentName, "");
                                        continue;
                                    }
                                    if (event.isEndElement()) {
                                        if (stack != null && _type == 0 && stack.size() > 0 && !deletedPath) {
                                            ret = stack.pop();
                                            if (currentPath.equals(path) && ret != null) {
                                                _ret = true;
                                                handler.handleNode(ret);
                                                stack = null;
                                                currentId.clear();
                                            }
                                        }
                                        if (!deletedPath) {
                                            currentPath.remove();
                                        }
                                        deletedPath = false;
                                        _type = 0;
                                        continue;
                                    }
                                    if (!event.isCharacters()) break block77;
                                    if (stack == null) continue;
                                    data = event.asCharacters().getData();
                                    value = null;
                                    if (_type != true) break block78;
                                    value = data;
                                    break block79;
                                }
                                if (_type != 2) break block80;
                                value = Boolean.valueOf(data);
                                break block79;
                            }
                            if (_type != 3) break block81;
                            if (!this.disableDecimalPolymorphy && !data.contains(".")) break block82;
                            value = this.decimalAsDouble ? Double.valueOf(Double.parseDouble(data)) : DatatypeConverter.parseDecimal((String)data);
                            break block79;
                        }
                        switch (this.integerBehaviour) {
                            case integerAsBigInteger: {
                                value = DatatypeConverter.parseInteger((String)data);
                                break;
                            }
                            case integerAsLong: {
                                value = Long.parseLong(data);
                                break;
                            }
                            case integerAsInteger: {
                                value = Integer.parseInt(data);
                                break;
                            }
                            case integerAsIntegerOrLong: {
                                try {
                                    value = Integer.parseInt(data);
                                }
                                catch (NumberFormatException nfe) {
                                    value = Long.parseLong(data);
                                }
                                break block79;
                            }
                            default: {
                                value = DatatypeConverter.parseInt((String)data);
                                break;
                            }
                        }
                        break block79;
                    }
                    if (_type == 4) {
                        value = null;
                    } else if (_type == 5 && this.base64BinaryAsByteArray) {
                        value = DatatypeConverter.parseBase64Binary((String)data);
                    } else if (_type == 6) {
                        value = DatatypeConverter.parseInteger((String)data);
                    } else if (_type == 7) {
                        value = DatatypeConverter.parseInt((String)data);
                    } else if (_type == 8) {
                        value = DatatypeConverter.parseLong((String)data);
                    } else if (_type == 9) {
                        value = DatatypeConverter.parseDouble((String)data);
                    } else if (_type == 10) {
                        value = Float.valueOf(DatatypeConverter.parseFloat((String)data));
                    } else if (_type == 11) {
                        value = DatatypeConverter.parseShort((String)data);
                    } else if (_type == 12) {
                        value = DatatypeConverter.parseByte((String)data);
                    }
                }
                if (stack.size() > 0) {
                    Object parent = stack.lastElement();
                    if (parent instanceof List && (_type != 4 || this.keepNullItem)) {
                        ((List)parent).add(value);
                        continue;
                    }
                    if (!(parent instanceof Map)) continue;
                    this.putValue((Map)parent, currentName, value);
                    continue;
                }
                ret = value;
                continue;
            }
            if (!event.isEndDocument()) continue;
            handler.handleEnd();
        }
        return _ret;
    }

    private List<XMLEvent> getEvents(XMLEventReader jxer2) throws XMLStreamException {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        int depth = 1;
        while (jxer2.hasNext() && depth > 0) {
            XMLEvent event = jxer2.nextEvent();
            events.add(event);
            if (event.isStartElement()) {
                ++depth;
                continue;
            }
            if (!event.isEndElement()) continue;
            --depth;
        }
        return events;
    }

    private boolean read2(final JsonNodeToObjectHandler handler, String _path) throws Exception {
        final boolean[] ret = new boolean[]{false};
        new JsonEventCatcher(this.jer).read(new JsonEventCatcher.JsonEventHandler(){
            Stack stack;

            @Override
            public void handleStart() {
                this.stack = new Stack();
                ret[0] = true;
            }

            @Override
            public void handleEvent(JSonEvent event) throws IOException {
                this.stack.add(event);
            }

            @Override
            public void handleEnd() throws Exception {
                if (JsonNodeToObject.this.resultAsJsonString) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    JsonEventWriter jew = new JsonEventWriter(baos, "UTF-8");
                    for (JSonEvent je : this.stack) {
                        jew.add(je);
                    }
                    jew.close();
                    handler.handleNode(new String(baos.toByteArray(), Charset.forName("UTF-8")));
                } else {
                    Stack _stack = new Stack();
                    Object root = null;
                    String memberName = null;
                    Iterator it = this.stack.iterator();
                    while (it.hasNext()) {
                        Object parent = _stack.size() > 0 ? _stack.peek() : null;
                        JSonEvent je = (JSonEvent)it.next();
                        Object newObject = null;
                        if (je.getType() == JSonEvent.Type.START_ARRAY) {
                            newObject = new ArrayList();
                            if (root == null) {
                                root = newObject;
                            }
                            _stack.add(newObject);
                        } else if (je.getType() == JSonEvent.Type.START_OBJECT) {
                            newObject = new HashMap();
                            _stack.add(newObject);
                            if (root == null) {
                                root = newObject;
                            }
                        } else {
                            if (je.getType() == JSonEvent.Type.MEMBER) {
                                memberName = je.getName();
                                continue;
                            }
                            if (je.getType() == JSonEvent.Type.VALUE) {
                                String tmp = je.getName();
                                int bsonDatatype = je.getBsonDataType();
                                if (bsonDatatype != -2) {
                                    switch (bsonDatatype) {
                                        case 9: {
                                            newObject = new Date(DatatypeConverter.parseLong((String)tmp));
                                        }
                                    }
                                }
                                if (newObject == null) {
                                    if (tmp.equals("null")) {
                                        newObject = null;
                                    } else if (tmp.equals("true")) {
                                        newObject = true;
                                    } else if (tmp.equals("false")) {
                                        newObject = false;
                                    } else if (tmp.contains(".")) {
                                        newObject = JsonNodeToObject.this.decimalAsDouble ? Double.valueOf(Double.parseDouble(tmp)) : DatatypeConverter.parseDecimal((String)tmp);
                                    } else {
                                        switch (JsonNodeToObject.this.integerBehaviour) {
                                            case integerAsBigInteger: {
                                                newObject = DatatypeConverter.parseInteger((String)tmp);
                                                break;
                                            }
                                            case integerAsLong: {
                                                newObject = Long.parseLong(tmp);
                                                break;
                                            }
                                            case integerAsInteger: {
                                                newObject = Integer.parseInt(tmp);
                                                break;
                                            }
                                            case integerAsIntegerOrLong: {
                                                try {
                                                    newObject = Integer.parseInt(tmp);
                                                }
                                                catch (NumberFormatException nfe) {
                                                    newObject = Long.parseLong(tmp);
                                                }
                                                break;
                                            }
                                            default: {
                                                newObject = DatatypeConverter.parseInt((String)tmp);
                                            }
                                        }
                                    }
                                    if (root == null) {
                                        root = newObject;
                                    }
                                }
                            } else if (je.getType() == JSonEvent.Type.STRING) {
                                newObject = je.getName();
                                if (root == null) {
                                    root = newObject;
                                }
                            } else if (je.getType() == JSonEvent.Type.END_OBJECT || je.getType() == JSonEvent.Type.END_ARRAY) {
                                _stack.pop();
                            }
                        }
                        if (parent instanceof List) {
                            if (newObject != null || JsonNodeToObject.this.keepNullItem && je.getType() == JSonEvent.Type.VALUE) {
                                ((List)parent).add(newObject);
                            }
                        } else if (parent instanceof Map && memberName != null && (newObject != null || JsonNodeToObject.this.keepNullValue)) {
                            JsonNodeToObject.this.putValue(parent, memberName, newObject);
                        }
                        memberName = null;
                    }
                    handler.handleNode(root);
                }
                this.stack = null;
            }
        }, _path);
        handler.handleEnd();
        return ret[0];
    }

    private void putValue(Map map, String key, Object value) {
        if (this.iterativeMapValuesAsList) {
            Object o = map.get(key);
            if (o != null) {
                List list = null;
                if (o instanceof List) {
                    list = (List)o;
                } else {
                    list = new IterativeValueArrayList();
                    map.put(key, list);
                    list.add(o);
                }
                list.add(value);
            } else {
                map.put(key, value);
            }
        } else {
            map.put(key, value);
        }
    }

    static enum IntegerBehaviour {
        integerAsLong,
        integerAsInteger,
        integerAsIntegerOrLong,
        integerAsBigInteger;

    }

    public static class IterativeValueArrayList
    extends ArrayList
    implements IIterativeValue {
    }

    public static interface JsonNodeToObjectHandler {
        public void handleNode(Object var1) throws Exception;

        public void handleEnd() throws Exception;
    }

    public static interface JsonNodeToStringHandler {
        public IJsonUtils.Adapter createAdapter(Collection<XMLEvent> var1) throws Exception;
    }

    static class Path {
        Stack stack = new Stack();

        public Path() {
        }

        public Path(String path) {
            String[] stringArray = path.split("/");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                this.add(str);
                ++n2;
            }
        }

        void add(String str) {
            this.stack.add(str);
        }

        void remove() {
            if (!this.stack.isEmpty()) {
                this.stack.pop();
            }
        }

        public int hashCode() {
            return Objects.hash(this.stack);
        }

        public boolean equals(Object o) {
            if (o instanceof Path) {
                Path path = (Path)o;
                if (path.stack.size() == this.stack.size()) {
                    int i = 0;
                    while (i < this.stack.size()) {
                        Object str = path.stack.get(i);
                        if (!str.equals("*") && !this.stack.get(i).equals(str)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            Object ret = "";
            int i = 0;
            while (i < this.stack.size()) {
                ret = (String)ret + "/" + String.valueOf(this.stack.get(i));
                ++i;
            }
            return ret;
        }

        public int size() {
            return this.stack.size();
        }
    }
}

