<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:map="http://www.indy.com/v2/map" xmlns:mapold="http://www.example.org/map" xmlns:deliv="http://www.stambia.com/deliv" xmlns:common="http://exslt.org/common" xmlns:rdbms="http://www.example.org/rdbms" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:UUID="java.util.UUID">
	<xsl:preserve-space elements="*"/>
	<xsl:output method="text" encoding="UTF-8"/>
	<xsl:param name="mode">normal</xsl:param>
	<xsl:template name="ancestorName">
		<xsl:param name="position"/>
		<xsl:for-each select="ancestor-or-self::*[name()!='map:map' and name()!='mapold:map']">/<xsl:value-of select="name()"/>:<xsl:choose>
				<xsl:when test="@alias!=''">
					<xsl:value-of select="@alias"/>
				</xsl:when>
				<xsl:when test="@name!=''">
					<xsl:value-of select="@name"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$position"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="/">
		<xsl:variable name="root">
			<map>
				<xsl:apply-templates mode="transform" select="mapold:map | map:map"/>
			</map>
		</xsl:variable>
		<xsl:apply-templates select="$root/*"/>
	</xsl:template>
	<xsl:template match="trgField|srcField|field" mode="transform">
		<xsl:element name="field">
			<xsl:apply-templates mode="transform" select="@*"/>
			<xsl:if test="expression">
				<xsl:attribute name="expression" select="expression"/>
			</xsl:if>
			<xsl:if test="not(@location!='') ">
				<xsl:attribute name="location">SRC</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates mode="transform" select="*[not(name()='expression')]|text()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="join|filter" mode="transform">
		<xsl:element name="{name()}">
			<xsl:apply-templates mode="transform" select="@*"/>
			<xsl:if test="expression">
				<xsl:attribute name="expression" select="expression"/>
			</xsl:if>
			<xsl:if test="not(@location!='') ">
				<xsl:attribute name="location">SRC</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates mode="transform" select="*[not(name()='expression')]|text()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="trgField/@mapping" mode="transform">
		<xsl:attribute name="expression" select="."/>
	</xsl:template>
	<xsl:template match="target/@name" mode="transform">
		<xsl:attribute name="alias" select="."/>
	</xsl:template>
	<xsl:template match="*" mode="transform">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*" mode="transform">
				<xsl:sort select="if (name()='name') then 'alias' else name()"/>
			</xsl:apply-templates>
			<xsl:apply-templates mode="transform" select="*|text()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="source|target" mode="transform">
		<xsl:element name="datastore">
			<xsl:apply-templates mode="transform" select="@*|*|text()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="process" mode="transform">
		<xsl:element name="template">
			<xsl:apply-templates mode="transform" select="@*|*|text()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="transform" match="@id|@subExpression|@ref|@connection|@tech|source/@name|@dataset|@fieldSelectorEnabled|@internalExpression|srcRef|@status|@nodeCode|@templateCriteria|link|targetRef|ref|@position|@mandatory|@internalMapping|@type|@size|@fullName|@precision|setDescriptor|usage|annotation|@message"/>
	<xsl:template mode="transform" match="@updateKey[.='false']"/>
	<xsl:template match="target/@name" mode="transform">
		<xsl:attribute name="alias" select="."/>
	</xsl:template>
	<xsl:template match="process/@target" mode="transform">
		<xsl:attribute name="process" select="."/>
	</xsl:template>
	<xsl:template match="@*" mode="transform">
		<xsl:attribute name="{name()}" select="."/>
	</xsl:template>
	<xsl:template match="text()" mode="transform">
		<xsl:value-of select="."/>
	</xsl:template>
	<xsl:template match="map:map | mapold:map">mapping:<xsl:value-of select="@name"/>#
<xsl:apply-templates select="datastore|target|source">
			<xsl:sort select="if (@alias!='') then @alias else @name"/>
		</xsl:apply-templates>
		<xsl:for-each select="join">
			<xsl:sort select="if (@expression!='') then @expression else  expression"/>
			<xsl:apply-templates select=".">
				<xsl:with-param name="position" select="position()"/>
			</xsl:apply-templates>
		</xsl:for-each>
		<xsl:for-each select="filter">
			<xsl:sort select="expression"/>
			<xsl:apply-templates select=".">
				<xsl:with-param name="position" select="position()"/>
			</xsl:apply-templates>
		</xsl:for-each>
		<xsl:apply-templates select="template|process">
			<xsl:sort select="@name"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="*">
		<xsl:param name="position"/>
		<xsl:for-each select="@*|*">
			<xsl:sort select="if (name()='name') then 'alias' else name()"/>
			<xsl:apply-templates select=".">
				<xsl:with-param name="position" select="$position"/>
			</xsl:apply-templates>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="@*|expression">
		<xsl:param name="position"/>
		<xsl:call-template name="attr">
			<xsl:with-param name="name" select="name()"/>
			<xsl:with-param name="value" select="."/>
			<xsl:with-param name="position" select="$position"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="attr">
		<xsl:param name="position"/>
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:if test="$value!='' and not(name()='joinMode' and .='Default')">
			<xsl:call-template name="ancestorName">
				<xsl:with-param name="position" select="$position"/>
			</xsl:call-template>/<xsl:value-of select="$name"/>=<xsl:value-of select="$value"/>#
</xsl:if>
	</xsl:template>
</xsl:stylesheet>
