<xsl:stylesheet version="2.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:map="http://www.indy.com/v2/map" xmlns:common="http://exslt.org/common" xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions" xmlns:wbi="java:com.semarchy.xdi.designer.generation.xsl.global.WorkbenchInvocation" xmlns:mdv="java:com.semarchy.xdi.designer.generation.xsl.global.Variables" xmlns:mds="java:com.semarchy.xdi.designer.generation.xsl.global.Strings" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:saxon="http://saxon.sf.net/" xmlns:ex="http://www.stambia.com/externalize" exclude-result-prefixes="fn mdj saxon xsl common" xmlns:UUID="java.util.UUID"  extension-element-prefixes="saxon">
	<!--Crée un seul proc en allant chercher toute les références
Supprime les étapes et les liens qui sont désactivés par les generationCondition
Les altId sont récupérés
Il faut virer les conditions génération-->
	<xsl:character-map name="map">
		<xsl:output-character character=" " string="&#xA0;"/>
	</xsl:character-map>
	<xsl:preserve-space elements="p th td"/>
	<xsl:variable name="mapDirectory" select="'/indy.build/map/'"/>
	<!-- contains the path of the wrk2/metadata.xml  if it exists to be able to extract the date of the delivery -->
	<xsl:param name="externalize_file_in"/>
	<xsl:variable name="deliveryDate" select="if ($externalize_file_in) then format-dateTime(xs:dateTime(document(concat('file:///',replace($externalize_file_in, '#', '%23')))/ex:externalize/@date), '[Y0001]/[M01]/[D01] [H01]:[m01]:[s01]') else None"/>
	
	<xsl:param name="mode">normal</xsl:param>
	<xsl:param name="startDir"/>
	<xsl:param name="endDir"/>
	<xsl:output method="html" encoding="UTF-8"/>
	<xsl:template match="/">
		<xsl:apply-templates mode="html"/>
		<xsl:value-of select="wbi:clearImages()"/>
		
		
		<xsl:if test=".=$root">
			<xsl:apply-templates select="*" mode="index"/>
			<xsl:if test="1=1">
				<xsl:value-of select="wbi:buildImages($directory/string(@id),$startDir)"/>
			</xsl:if>
		</xsl:if>
		<xsl:value-of select="wbi:clearImages()"/>
	</xsl:template>
	<!--INDEX-->
	<xsl:variable name="space">   </xsl:variable>
	<xsl:template match="*" mode="index">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
				<title>Index</title>
				<link rel="shortcut icon" href="images/Logo16x16.png" type="image/x-icon"/>
				<link rel="icon" href="images/Logo16x16.png" type="image/x-icon"/>
				<link rel="StyleSheet" href="css/layout1.css"/>
			</head>
			<body>
				<div id="Header">
					<div>
					<xsl:if test="$deliveryDate!=''">
							<div id="HeaderExtra">Package Date <xsl:value-of select="$deliveryDate" />
							</div>
						</xsl:if>
						<a title="Menu">Menu</a>
					</div>
					
				</div>
				<div id="Title">
					<h1>
						<img src="images/32/Logo32x32.png"/>  Menu</h1>
				</div>
				
				<div id="Content_Without_Menu">
					<xsl:call-template name="index">
						<xsl:with-param name="eval">ends-with(@local,'proc') and not(@isTpl='true')</xsl:with-param>
						<xsl:with-param name="title">Process</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="index">
						<xsl:with-param name="title">Mapping</xsl:with-param>
						<xsl:with-param name="eval">ends-with(@local,'.map')</xsl:with-param>
					</xsl:call-template>
					<xsl:call-template name="index">
						<xsl:with-param name="title">Template</xsl:with-param>
						<xsl:with-param name="eval">@isTpl='true'</xsl:with-param>
					</xsl:call-template>
				</div>
				
			</body>
		</html>
	</xsl:template>
	<xsl:template name="index">
		<xsl:param name="eval"/>
		<xsl:param name="title"/>
		
		<xsl:variable name="tmp">
			<h2>
				<xsl:value-of select="$title"/>
			</h2>
			<table>
				<xsl:for-each select="$directory[saxon:evaluate($eval)]">
					<xsl:sort select="@local"/>
					<xsl:if test="@local!=''">
						<tr>
							<td>      </td>
							<td>
								<xsl:variable name="id" select="@id"/>
								<xsl:variable name="img">
									<xsl:copy-of select="img"/>
								</xsl:variable>
								<xsl:copy-of select="$img"/>
								<xsl:text>  </xsl:text>
								<xsl:variable name="path">
									<xsl:choose>
										<xsl:when
											test="contains(@local, '.metadata/.plugins/com.semarchy.xdi.designer.index/')">
											<xsl:value-of select="substring-after(@local, '.metadata/.plugins/com.semarchy.xdi.designer.index')"/>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="@local"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:variable>
								
								
								<xsl:for-each select="tokenize($path,'/')">
									<xsl:if test="position()=last()" />
									<a>
										<xsl:if test="position()=last()">
											<xsl:attribute name="href"
												select="concat($id,'.html')" />
										</xsl:if>
										<xsl:if test="not(position()=1)">
											/
										</xsl:if>
										<xsl:value-of select="replace(.,'%20',' ')" />
									</a>
								</xsl:for-each>
								

							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</table>
			<br/>
		</xsl:variable>
		<xsl:if test="$tmp/table/*">
			<xsl:copy-of select="$tmp"/>
		</xsl:if>
	</xsl:template>
	<xsl:variable name="directory" saxon:assignable="yes">
		<empty/>
	</xsl:variable>
	<xsl:template mode="html" match="*"/>
	<xsl:template mode="html" match="@*"/>
	<xsl:template mode="html" match="text()"/>
	<xsl:variable name="root" select="/"/>
	<!--HTML-->
	<xsl:function name="proc:getRefTemplate">
		<xsl:param name="context"/>
		<xsl:variable name="refId">
			<xsl:choose>
				<xsl:when test="$context/name()='actionProcessRef'">
					<xsl:value-of select="proc:getRefId($context/@targetName)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="proc:getRefId($context/@process)"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:sequence select="document(wbi:getRawLocationURI($refId))"/>
	</xsl:function>
	<xsl:template match="actionProcessRef | template[not(@visibility='false')]" mode="html">
		<xsl:apply-templates select="proc:getRefTemplate(.)"/>
	</xsl:template>
	<xsl:template match="proc:process | subProcess | actionCode | map:map" mode="html">
		<xsl:if test="mdj:getFileInfo(concat($endDir,'/',@id,'.html'),'exists')='false'">
			<xsl:apply-templates select="." mode="directory"/>
			<xsl:result-document href="./{@id}.html" method="html" encoding="UTF-8">
				<html xmlns="http://www.w3.org/1999/xhtml">
					<head>
						<meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
						<title>
							<xsl:value-of select="@name"/>
						</title>
						<xsl:variable name="img">
							<xsl:apply-templates select="." mode="icon"/>
						</xsl:variable>
						<link rel="shortcut icon" href="{$img/img/@src}" type="image/x-icon"/>
						<link rel="icon" href="{$img/img/@src}" type="image/x-icon"/>
						<link rel="StyleSheet" href="css/layout1.css"/>
					</head>
					<body>
						<div id="Header">
							<div>
								<xsl:if test="$deliveryDate!=''" >
									<div id="HeaderExtra">Package Date <xsl:value-of select="$deliveryDate"/></div>
								</xsl:if>
								<a href="index.html" title="Index">Menu</a>
								<xsl:apply-templates mode="location" select=".">
								<xsl:with-param name="isFirst" select="true()"/>
								</xsl:apply-templates>
							</div>
							
							
						</div>
						<div id="Title">
							<h1>
								<xsl:apply-templates select="." mode="icon">
									<xsl:with-param name="big" select="true()"/>
								</xsl:apply-templates>  <xsl:value-of select="@name"/>
							</h1>
						</div>
						<!--Menu-->
						<xsl:if test="subProcess  | actionProcessRef | actionCode">
							<div id="Menu_Title">
								<h2>Steps</h2>
							</div>
							<div id="Menu">
								<xsl:for-each select="subProcess | actionProcessRef  | actionCode">
									<div id="Menu_Entry">
										<xsl:apply-templates select="." mode="icon"/>
										<xsl:apply-templates select="." mode="link"/>
									</div>
									<br/>
								</xsl:for-each>
							</div>
						</xsl:if>
						<!--Content-->
						<div>
							<xsl:choose>
								<xsl:when test="name()='actionCode'">
									<xsl:attribute name="id">Content_Without_Menu</xsl:attribute>
								</xsl:when>
								<xsl:when test="name()='map:map'">
									<xsl:attribute name="id">Content_Without_Menu</xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name="id">Content</xsl:attribute>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:choose>
								<xsl:when test="name()='map:map'">
									<a href="{@id}-proc.html">Open Process</a>
								</xsl:when>
								<xsl:when test="name()='proc:process' and ends-with(@id,'-proc')">
									<a href="{substring-before(@id,'-proc')}.html">Open Mapping</a>
								</xsl:when>
							</xsl:choose>
							<xsl:if test="@description!=''">
								<h2>Description</h2>
								<p>
									 <xsl:call-template name="insertBreaks">  
										<xsl:with-param name="pText" select="@description"/>  
									</xsl:call-template>  
								</p>
								<br/>
							</xsl:if>
							<xsl:if test="parameter">
								<h2>Parameters</h2>
								<xsl:variable name="template" select="if (name()='actionProcessRef') then proc:getRefTemplate(.) else None"/>
								<xsl:call-template name="paremeters">
									<xsl:with-param name="instance" select="."/>
									<xsl:with-param name="template" select="$template"/>
								</xsl:call-template>
								<br/>
							</xsl:if>
							<xsl:if test="name()='map:map'">
								<table>
									<tr>
										<xsl:if test="datastore | query">
											<td valign="top">
												<br/>
												<h2>Source</h2>
												<table>
													<xsl:for-each select="datastore | query">
														<tr>
															<td>
																<xsl:apply-templates select="." mode="link"/>
																<xsl:apply-templates select="." mode="icon"/>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</td>
										</xsl:if>
										
										<xsl:if test="datastore | query">
											<td valign="top">
												<br/>
												<h2>Target</h2>
												<table>
													<xsl:for-each select="datastore[setDescriptor] | query[setDescriptor]">
														<tr>
															<td>
																<xsl:apply-templates select="." mode="icon"/>
																<xsl:apply-templates select="." mode="link"/>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</td>
										</xsl:if>
										
									</tr>
									<xsl:if test="datastore/field/expression | query/field/expression">
										<xsl:for-each select="datastore[setDescriptor]|query[setDescriptor]" >
										<tr>
											<td valign="top" colspan="2">
												<br/>
												
												<h2>Mapping <xsl:value-of select="@alias"/> 
													<xsl:if test="count(setDescriptor) &gt; 1" >
													(<xsl:value-of select="@subExpression"/> )
													</xsl:if>
												</h2>
												<table cellpadding="0" cellspacing="0">
													<tbody>
														<tr id="gray1">
															<th valign="top" align="left">Field</th>
															<th valign="top" align="left">
																<xsl:value-of select="$space"/>Set</th>
															<th valign="top" align="left">
																<xsl:value-of select="$space"/>Expression</th>
															
															<th valign="top" align="center">Location</th>
															<th valign="top" align="left">
																<xsl:value-of select="$space"/>Description</th>
														</tr>
													</tbody>
													<xsl:for-each select="field/expression/expression[text()!='']">
													
													<xsl:if test="not(../../@enable='false')" >
														<tr>
															<xsl:if test="(position() mod 2 )=0">
																<xsl:attribute name="id">gray1</xsl:attribute>
															</xsl:if>
															<td valign="top" align="left">
																<xsl:apply-templates select="../.." mode="icon"/>
																<xsl:apply-templates select="../.." mode="link"/>
															</td>
															
															<td valign="top" align="left">
																<xsl:value-of select="$space"/>
																<xsl:variable name="setDescriptorRef" select="../@setDescriptorRef" />
																<xsl:value-of select="../../../setDescriptor[@id=$setDescriptorRef]/@label"/>
															</td>
															<td valign="top" align="left">
																<xsl:value-of select="$space"/>
																<xsl:value-of select=".."/>
															</td>
															<td align="center" valign="top">
																<xsl:choose>
																	<xsl:when test="not(../@location)">
																		<xsl:if test="../../../name()='datastore'">
																			<img src="images/LocationSource16x16.png" style="background: url(images/BackgroundRed1_16x16.png) no-repeat left top"/>
																		</xsl:if>
																		<xsl:if test="../../../name()='query'">
																			<img src="images/LocationWork16x16.png" style="background: url(images/BackgroundRed1_16x16.png) no-repeat left top"/>
																		</xsl:if>
																	</xsl:when> 
																	<xsl:otherwise>
																		<xsl:apply-templates select="../@location"/>
																	</xsl:otherwise>
																</xsl:choose>
																</td>
															<td valign="top">
																<xsl:value-of select="$space"/>
																<xsl:call-template name="insertBreaks">  
																	<xsl:with-param name="pText" select="../../@description"/>  
																</xsl:call-template>  

															</td>
														</tr>
														</xsl:if>
													</xsl:for-each>
												</table>
												<xsl:if test="targetFilter[not(@enable='false')]">
													<table cellpadding="0" cellspacing="0">
														<tbody>
															<tr>
																<th valign="top" align="left" colspan="3">Target Filters</th>
															</tr>
															<tr id="gray1">
																<th valign="top" align="left">Expression</th>
																<th valign="top" align="center">Location</th>
																<th valign="top" align="left">Description</th>
															</tr>
															<xsl:for-each select="targetFilter[not(@enable='false')]">
																<tr>
																<xsl:if test="(position() mod 2 )=0">
																	<xsl:attribute name="id">gray1</xsl:attribute>
																</xsl:if>
																<td valign="top" align="left">
																	<xsl:apply-templates select="." mode="icon"/>
																	<xsl:value-of select="./expression/text()"/>
																</td>
																<td align="center" valign="top"> <img src="images/LocationWork16x16.png" style="background: url(images/BackgroundRed1_16x16.png) no-repeat left top"/>
																</td>
																<td valign="top">
																	<xsl:value-of select="$space"/>
																	<xsl:call-template name="insertBreaks">  
																		<xsl:with-param name="pText" select="@description"/>  
																	</xsl:call-template>  
																</td>
															</tr>
															</xsl:for-each>
														</tbody>
													</table>
												</xsl:if>
											</td>
										</tr>
										</xsl:for-each>
									</xsl:if>
									<xsl:if test="(join | filter)[not(@enable='false')]">
										<tr>
											<td valign="top" colspan="2">
												<br/>
												<h2>Join and Filter</h2>
												<table cellpadding="0" cellspacing="0">
													<tbody>
														<tr id="gray1">
															<th valign="top" align="left">Expression</th>
															<th valign="top" align="center"> Location</th>
															<th align="left" valign="top">
																<xsl:value-of select="$space"/>Description</th>
														</tr>
													</tbody>
													<xsl:for-each select="(join | filter)[not(@enable='false')]">
														<tr>
															<xsl:if test="(position() mod 2 )=0">
																<xsl:attribute name="id">gray1</xsl:attribute>
															</xsl:if>
															<td valign="top" align="left">
																<xsl:apply-templates select="." mode="icon"/>
																<xsl:value-of select="./expression/text()"/>
															</td>
															<td align="center" valign="top"> <xsl:apply-templates select="@location"/>
															</td>
															<td valign="top">
																<xsl:value-of select="$space"/>
																<xsl:call-template name="insertBreaks">  
																	<xsl:with-param name="pText" select="@description"/>  
																</xsl:call-template>  
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="template[not(@visibility='false')]">
										<tr>
											<td valign="top" colspan="2">
												<br/>
												<h2>Template</h2>
												<xsl:for-each select="template[not(@visibility='false')]">
													<xsl:apply-templates select="." mode="icon"/>
													<xsl:apply-templates select="." mode="link"/>
													<xsl:if test="@description"> (<xsl:call-template name="insertBreaks">  
																	<xsl:with-param name="pText" select="@description"/>  
																</xsl:call-template>  )</xsl:if>
													<xsl:variable name="template" select="proc:getRefTemplate(.)"/>
													<xsl:call-template name="paremeters">
														<xsl:with-param name="instance" select="."/>
														<xsl:with-param name="template" select="$template"/>
													</xsl:call-template>
													<br/>
												</xsl:for-each>
											</td>
										</tr>
									</xsl:if>
								</table>
								<br/>
							</xsl:if>
							<xsl:choose>
								<xsl:when test="name()='map:map'">
									<h2>Diagram</h2>
									<img src="./{@id}.png" border="1"/>
								</xsl:when>
								<xsl:when test="name()!='actionCode'">
									<h2>Diagram</h2>
									<img src="./{@id}.png" border="1"/>
								</xsl:when>
								<xsl:otherwise>
									<h2>Code</h2>
									<p>
										<pre>
											<xsl:value-of select="code"/>
										</pre>
									</p>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<!-- BlueRobot was here. -->
					</body>
				</html>
			</xsl:result-document>
			<xsl:apply-templates select="subProcess  | actionCode | actionProcessRef | template" mode="html"/>
			<xsl:if test="name()='map:map'">
				<xsl:variable name="document" select="document(wbi:getRawLocationURI(concat(@id,'-proc')))"/>
				<xsl:apply-templates select="$document"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<!--ICON-->
	<xsl:template match="trgField | srcField | field |queryField" mode="icon"/>
	<xsl:template match="join" mode="icon">
		<img src="images/JoinFondNormal16x22.gif" width="16"/>
	</xsl:template>
	<xsl:template match="filter" mode="icon">
		<img width="16" src="images/Filtre22x22SimpleBleu.gif"/>
	</xsl:template>
	<xsl:template match="query | datastore" mode="icon">
		<img src="images/MappingTarget28x16.png"/>
	</xsl:template>
	<xsl:template match="source" mode="icon">
		<img src="images/MappingSource28x16.png"/>
	</xsl:template>
	<xsl:template name="paremeters">
		<xsl:param name="instance"/>
		<xsl:param name="template"/>
		<xsl:variable name="template" select="if (exists($template)) then $template/* else $instance"/>
		<table cellpadding="0" cellspacing="0">
			<tbody>
				<tr id="gray1">
					<th align="left">Name</th>
					<th align="left">
						<xsl:value-of select="$space"/>Value</th>
					<xsl:if test="$instance!=$template">
						<th align="left">
							<xsl:value-of select="$space"/>Default</th>
					</xsl:if>
					<th align="left">
						<xsl:value-of select="$space"/>Type</th>
					<th align="left">
						<xsl:value-of select="$space"/>Description</th>
				</tr>
				<xsl:for-each select="$template/parameter">
					<xsl:variable name="parameter" select="$instance/parameter[@name=current()/@name]"/>
					<tr>
						<xsl:if test="(position() mod 2 )=0">
							<xsl:attribute name="id">gray1</xsl:attribute>
						</xsl:if>
						<td valign="top" align="left">
							<xsl:choose>
								<xsl:when test="@type='String'">
									<img src="images/ParamString.png"/>
								</xsl:when>
								<xsl:when test="@type='Integer'">
									<img src="images/ParamInteger.png"/>
								</xsl:when>
								<xsl:when test="@type='Boolean'">
									<img src="images/ParamBoolean.png"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="images/ParamGene.png"/>
								</xsl:otherwise>
							</xsl:choose>
							<xsl:text>  </xsl:text>
							<xsl:value-of select="@name"/>
						</td>
						<td valign="top" align="left">
							<xsl:value-of select="$space"/>
							<xsl:value-of select="$parameter/@value"/>
						</td>
						<xsl:if test="$instance!=$template">
							<td valign="top" align="left">
								<xsl:value-of select="$space"/>
								<xsl:value-of select="@value"/>
							</td>
						</xsl:if>
						<td valign="top" align="left">
							<xsl:value-of select="$space"/>
							<xsl:value-of select="@type"/>
						</td>
						<td align="left" valign="top">
							<xsl:value-of select="$space"/>
							<xsl:call-template name="insertBreaks">  
								<xsl:with-param name="pText" select="@description"/>  
							</xsl:call-template>  
						</td>
					</tr>
					<!--Ajouter image de paramètre-->
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>
	<xsl:template match="subProcess | proc:process" mode="icon">
		<xsl:param name="big" select="false()"/>
		<img src="images/{if ($big) then '32/' else ''}ActionProcess.png"/>
	</xsl:template>
	<xsl:template match="actionProcessRef" mode="icon">
		<xsl:param name="big" select="false()"/>
		<xsl:choose>
			<xsl:when test="contains(@targetName,'.proc#')">
				<img src="images/{if ($big) then '32/' else ''}ActionProcessRef.png"/>
			</xsl:when>
			<xsl:otherwise>
				<img src="images/{if ($big) then '32/' else ''}Map.png"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="map:map" mode="icon">
		<xsl:param name="big" select="false()"/>
		<img src="images/{if ($big) then '32/' else ''}Map.png"/>
	</xsl:template>
	<xsl:template match="template" mode="icon">
		<xsl:param name="big" select="false()"/>
		<img src="images/{if ($big) then '32/' else ''}ActionProcessRef.png"/>
	</xsl:template>
	<xsl:template match="actionCode" mode="icon">
		<xsl:param name="big" select="false()"/>
		<xsl:variable name="fileNameRelative" select="concat('actionCode-',if (@enable='false') then 'false' else 'true','-',@technology,if ($big) then '-large' else '','.png')"/>
		<xsl:variable name="fileName" select="concat($endDir,'/',$fileNameRelative)"/>
		<xsl:if test="name()='actionCode' and mdj:getFileInfo($fileName,'exists')='false'">
			<xsl:value-of select="wbi:buildActionCodeImage(@technology, if (@enable='false') then 'false' else 'true' , $fileName, if ($big) then 'true' else 'false')"/>
		</xsl:if>
		<img src="./{$fileNameRelative}"/>
	</xsl:template>
	<!--LOCATION-->
	<xsl:template match="proc:process | subProcess | actionCode | map:map" mode="location">
		<xsl:param name="isFirst" select="false()"/>
		<xsl:if test=".!=/">
			<xsl:apply-templates select=".." mode="location"/>
		</xsl:if>
		<xsl:if test="not(.=/)">
			<a>/</a>
		</xsl:if>
		<xsl:choose>
			<xsl:when test=".=/">
				<xsl:variable name="localLocation" select="replace(wbi:getLocalLocationURI(@id),'%20',' ')"/>
				<xsl:variable name="current" select="."/>
				<xsl:for-each select="tokenize($localLocation,'/')">
					<xsl:if test=".!=''">
						<a title="{.}">
							<xsl:if test="not($isFirst) and position()=last()">
								<xsl:attribute name="href" select="concat($current/@id,'.html')"/>
							</xsl:if>
							<xsl:if test="not(position()=1)">/</xsl:if>
							<xsl:value-of select="."/>
						</a>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="not($isFirst)">
				<a href="{concat(@id,'.html')}" title="{@name}">
					<xsl:value-of select="@name"/>
				</a>
			</xsl:when>
			<xsl:otherwise>
				<a title="{@name}">
					<xsl:value-of select="@name"/>
				</a>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template match="*" mode="directory">
		<xsl:variable name="localLocation" select="wbi:getLocalLocationURI(@id)"/>
		<xsl:variable name="isTpl" select="if (ends-with($localLocation, '.proc')) then wbi:isTemplate(@id) else 'false'"/>
		<xsl:if test="not($directory/location=$localLocation)">
			<saxon:assign name="directory">
				<xsl:copy-of select="$directory"/>
				<location local="{$localLocation}" id="{@id}" isTpl="{$isTpl}" >
					<xsl:apply-templates select="." mode="icon"/>
				</location>
			</saxon:assign>
		</xsl:if>
	</xsl:template>
	<!--LOCATION_ICON-->
	<xsl:template match="@location[.='SRC']">
		<img src="images/LocationSource16x16.png" style="background: url(images/BackgroundRed1_16x16.png) no-repeat left top"/>
	</xsl:template>
	<xsl:template match="@location[.='WRK']">
		<img src="images/LocationWork16x16.png" style="background: url(images/BackgroundRed1_16x16.png) no-repeat left top"/>
	</xsl:template>
	<xsl:template match="@location[.='TRG']">
		<img src="images/LocationTarget16x16.png" style="background: url(images/BackgroundRed1_16x16.png) no-repeat left top"/>
	</xsl:template>
	<!--MAPPING-->
	<xsl:template match="map:map2">
		<xsl:if test="mdj:getFileInfo(concat($endDir,'/',@id,'.html'),'exists')='false'">
			<xsl:result-document href="./{@id}.html" method="html" encoding="UTF-8">
				<html>
					<head>
						<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
						<link rel="StyleSheet" href="css/docMap.css"/>
						<title>Mapping <xsl:value-of select="@name"/>
						</title>
					</head>
					<body>
						<p/>
						<p>MAPPING: <xsl:value-of select="@name"/>
						</p>
						<table cellpadding="5">
							<tr>
								<td>Target</td>
								<td class="little_heading_red">
									<font>
										<xsl:value-of select="target/@name"/>
									</font>
								</td>
							</tr>
							<tr>
								<td colspan="5">
									<p style="TEXT-DECORATION: underline">Sources</p>
									<xsl:for-each select="source">
										<p>
											<xsl:value-of select="@alias"/>
											<xsl:if test="@alias!=@name"> (<xsl:value-of select="@name"/>)</xsl:if>
										</p>
									</xsl:for-each>
								</td>
							</tr>
						</table>
						<p/>
						<p class="title_1_red">Templates utilisés</p>
						<ul>
							<li class="red_ul_li">
Load tralala </li>
							<li class="orange_ul_li"> Load tralali</li>
						</ul>
						<img src="./{@id}.png"/>
					</body>
				</html>
			</xsl:result-document>
			<xsl:apply-templates select="*"/>
			<xsl:apply-templates select="." mode="directory"/>
		</xsl:if>
	</xsl:template>
	<!--MENU-->
	<xsl:template match="proc:process | subProcess" mode="menu">
		<xsl:param name="ident"/>
		<xsl:param name="isFirst" select="false()"/>
		<p>
			<a>
				<xsl:choose>
					<xsl:when test="not($isFirst)">
						<xsl:attribute name="href" select="concat(@id,'.html')"/>
						<xsl:attribute name="title" select="@name"/>
					</xsl:when>
				</xsl:choose>
				<xsl:value-of select="@name"/>
			</a>
		</p>
		<xsl:if test="1=2">
			<xsl:apply-templates select="subProcess" mode="menu">
				<xsl:with-param name="ident" select="concat($ident,'	')"/>
			</xsl:apply-templates>
		</xsl:if>
	</xsl:template>
	<xsl:function name="proc:findURI">
		<xsl:param name="id"/>
		<xsl:value-of select="mdj:findURIByFileId($id)"/>
	</xsl:function>
	<xsl:function name="proc:getEltId">
		<xsl:param name="ref"/>
		<xsl:value-of select="if (contains($ref,'?')) then substring-before($ref,'?')  else $ref"/>
	</xsl:function>
	<xsl:function name="proc:getType">
		<xsl:param name="var"/>
		<xsl:variable select="substring-after($var,'type=')" name="tmp"/>
		<xsl:value-of select="if (contains($tmp,'$')) then substring-before($tmp,'$') else substring-before($tmp,'?') "/>
	</xsl:function>
	<xsl:function name="proc:getFileId">
		<xsl:param name="var"/>
		<xsl:variable select="substring-after($var,'fileId=')" name="tmp"/>
		<xsl:value-of select="if (contains($tmp,'$')) then substring-before($tmp,'$') else substring-before($tmp,'?') "/>
	</xsl:function>
	<xsl:function name="proc:getRefId">
		<xsl:param name="var"/>
		<xsl:variable name="refId">
			<xsl:value-of select="substring-after($var,'#')"/>
		</xsl:variable>
		<xsl:variable name="eltId" select="proc:getEltId($refId)"/>
		<xsl:value-of select="$eltId"/>
	</xsl:function>
	<!--Arriver à intégrer image
Recursif-->
	<!--LINK-->
	<!-- 
	<xsl:template match="source" mode="link">
		<a title="{@name}">
			<xsl:value-of select="concat(@name,if (@name!=@alias) then concat(' (',@alias,')') else '')"/>
		</a>
	</xsl:template>
	 -->
	<xsl:template match="query" mode="link">
		<a title="{@alias}">
			<xsl:value-of select="@alias"/>
		</a>
	</xsl:template>
	<xsl:template match="datastore" mode="link">
		<a title="{@alias}">
			<xsl:value-of select="concat(@alias, wbi:datastorePhysicalName(@alias, @id, ancestor-or-self::map/@id))"/>
		</a>
	</xsl:template>
	<xsl:template match="field | queryField" mode="link">
		<a title="{@name}">
			<xsl:value-of select="@name"/>
		</a>
	</xsl:template>
	<xsl:template match="subProcess" mode="link">
		<a href="{@id}.html" title="{@name}">
			<xsl:text>  </xsl:text>
			<xsl:value-of select="@name"/>
		</a>
	</xsl:template>
	<xsl:template match="actionProcessRef" mode="link">
		<a href="{proc:getRefId(@targetName)}.html" title="{@name}">
			<xsl:text>  </xsl:text>
			<xsl:value-of select="@name"/>
		</a>
	</xsl:template>
	<xsl:template match="actionCode" mode="link">
		<a href="{@id}.html" title="{code}">
			<xsl:text>  </xsl:text>
			<xsl:value-of select="@name"/>
		</a>
	</xsl:template>
	<xsl:template match="template" mode="link">
		<a href="{proc:getRefId(@process)}.html" title="{@name}">
			<xsl:text>  </xsl:text>
			<xsl:value-of select="@name"/>
		</a>
	</xsl:template>
	
	<xsl:template name="insertBreaks">  
		<xsl:param name="pText"/>  

   <xsl:choose>  
     <xsl:when test="not(contains($pText, '&#xA;'))">  
       <xsl:value-of select="$pText"/>  
     </xsl:when>  
     <xsl:otherwise>  
       <xsl:value-of select="substring-before($pText, '&#xA;')"/>  
       <br />  
       <xsl:call-template name="insertBreaks">  
         <xsl:with-param name="pText" select=  
           "substring-after($pText, '&#xA;')"/>  
       </xsl:call-template>  
     </xsl:otherwise>  
   </xsl:choose>  
 </xsl:template> 
</xsl:stylesheet>
