--
-- You have to replace XDI_RUNTIME_SCHEDULER occurrences with the
-- org.quartz.scheduler.instanceName parameter value contained into
-- engineScheduler.properties file.
--

USE [enter_db_name_here]
GO


--
-- drop tables that are no longer used
--
drop table [dbo].[stb_job_listeners];
drop table [dbo].[stb_trigger_listeners];

--
-- drop columns that are no longer used
--
alter table [dbo].[stb_job_details] drop column is_volatile;
alter table [dbo].[stb_triggers] drop column is_volatile;
alter table [dbo].[stb_fired_triggers] drop column is_volatile;

--
-- add new columns that replace the 'is_stateful' column
--
alter table [dbo].[stb_job_details] add is_nonconcurrent [VARCHAR] (1) NULL;
alter table [dbo].[stb_job_details] add is_update_data [VARCHAR] (1) NULL;
update [dbo].[stb_job_details] set is_nonconcurrent = is_stateful;
update [dbo].[stb_job_details] set is_update_data = is_stateful;
alter table [dbo].[stb_job_details] drop column is_stateful;
alter table [dbo].[stb_fired_triggers] add is_nonconcurrent [VARCHAR] (1) NULL;
update [dbo].[stb_fired_triggers] set is_nonconcurrent = is_stateful;
alter table [dbo].[stb_fired_triggers] drop column is_stateful;

--
-- add new 'sched_name' column to all tables --- replace "XDI_RUNTIME_SCHEDULER" with your scheduler's configured name
--
alter table [dbo].[stb_blob_triggers] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_calendars] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_cron_triggers] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_fired_triggers] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_job_details] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_locks] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_paused_trigger_grps] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_scheduler_state] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_simple_triggers] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table [dbo].[stb_triggers] add sched_name  [VARCHAR] (120)  NOT NULL DEFAULT 'XDI_RUNTIME_SCHEDULER';

--
-- add new 'sched_time' column to stb_fired_triggers
--
alter table [dbo].[stb_fired_triggers] add sched_time [BIGINT] NULL;
update [dbo].[stb_fired_triggers] set sched_time = fired_time;
alter table [dbo].[stb_fired_triggers] ALTER COLUMN sched_time [BIGINT] NOT NULL;

--
-- drop all primary and foreign key constraints, so that we can define new ones
--
alter table [dbo].[stb_triggers] drop constraint FK_STB_TRIGGERS_STB_JOB_DETAILS;
alter table [dbo].[stb_simple_triggers] drop constraint PK_STB_SIMPLE_TRIGGERS;
alter table [dbo].[stb_simple_triggers] drop constraint FK_STB_SIMPLE_TRIGGERS_STB_TRIGGERS;
alter table [dbo].[stb_cron_triggers] drop constraint PK_STB_CRON_TRIGGERS;
alter table [dbo].[stb_cron_triggers] drop constraint FK_STB_CRON_TRIGGERS_STB_TRIGGERS;
alter table [dbo].[stb_job_details] drop constraint PK_STB_JOB_DETAILS;
alter table [dbo].[stb_job_details] add primary key (sched_name, job_name, job_group);
alter table [dbo].[stb_triggers] drop constraint PK_STB_TRIGGERS;

--
-- add all primary and foreign key constraints, based on new columns
--
alter table [dbo].[stb_triggers] add primary key (sched_name, trigger_name, trigger_group);
alter table [dbo].[stb_triggers] add foreign key (sched_name, job_name, job_group) references stb_job_details(sched_name, job_name, job_group);
alter table [dbo].[stb_blob_triggers] add primary key (sched_name, trigger_name, trigger_group);
alter table [dbo].[stb_blob_triggers] add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table [dbo].[stb_cron_triggers] add primary key (sched_name, trigger_name, trigger_group);
alter table [dbo].[stb_cron_triggers] add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table [dbo].[stb_simple_triggers] add primary key (sched_name, trigger_name, trigger_group);
alter table [dbo].[stb_simple_triggers] add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table [dbo].[stb_fired_triggers] drop constraint PK_STB_FIRED_TRIGGERS;
alter table [dbo].[stb_fired_triggers] add primary key (sched_name, entry_id);
alter table [dbo].[stb_calendars] drop constraint PK_STB_CALENDARS;
alter table [dbo].[stb_calendars] add primary key (sched_name, calendar_name);
alter table [dbo].[stb_locks] drop constraint PK_STB_LOCKS;
alter table [dbo].[stb_locks] add primary key (sched_name, lock_name);
alter table [dbo].[stb_paused_trigger_grps] drop constraint PK_STB_PAUSED_TRIGGER_GRPS;
alter table [dbo].[stb_paused_trigger_grps] add primary key (sched_name, trigger_group);
alter table [dbo].[stb_scheduler_state] drop constraint PK_STB_SCHEDULER_STATE;
alter table [dbo].[stb_scheduler_state] add primary key (sched_name, instance_name);

--
-- add new simprop_triggers table
--
CREATE TABLE [dbo].[STB_SIMPROP_TRIGGERS] (
  [SCHED_NAME] [VARCHAR] (120)  NOT NULL ,
  [TRIGGER_NAME] [VARCHAR] (200)  NOT NULL ,
  [TRIGGER_GROUP] [VARCHAR] (200)  NOT NULL ,
  [STR_PROP_1] [VARCHAR] (512) NULL,
  [STR_PROP_2] [VARCHAR] (512) NULL,
  [STR_PROP_3] [VARCHAR] (512) NULL,
  [INT_PROP_1] [INT] NULL,
  [INT_PROP_2] [INT] NULL,
  [LONG_PROP_1] [BIGINT] NULL,
  [LONG_PROP_2] [BIGINT] NULL,
  [DEC_PROP_1] [NUMERIC] (13,4) NULL,
  [DEC_PROP_2] [NUMERIC] (13,4) NULL,
  [BOOL_PROP_1] [VARCHAR] (1) NULL,
  [BOOL_PROP_2] [VARCHAR] (1) NULL,
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[STB_SIMPROP_TRIGGERS] WITH NOCHECK ADD
  CONSTRAINT [PK_STB_SIMPROP_TRIGGERS] PRIMARY KEY  CLUSTERED
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  )  ON [PRIMARY]
GO

ALTER TABLE [dbo].[STB_SIMPROP_TRIGGERS] ADD
  CONSTRAINT [FK_STB_SIMPROP_TRIGGERS_STB_TRIGGERS] FOREIGN KEY
  (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  ) REFERENCES [dbo].[STB_TRIGGERS] (
    [SCHED_NAME],
    [TRIGGER_NAME],
    [TRIGGER_GROUP]
  ) ON DELETE CASCADE
GO