#!/bin/bash
SESSIONLOGS_TCPPORT=42100
SCHEDULER_TCPPORT=42110

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

PRGDIR=`dirname "$PRG"`

. "$PRGDIR"/initvariables.sh

. "$XDI_RUNTIME_HOME/external/hsqldb/bin/baseInternal.sh" -database sessionLogs -tcpPort $SESSIONLOGS_TCPPORT &
. "$XDI_RUNTIME_HOME/external/hsqldb/bin/baseInternal.sh" -database scheduler -tcpPort $SCHEDULER_TCPPORT &


