#!/bin/bash
#
# Copyright (c) Semarchy.  All rights reserved.
#
# PRODUCT Semarchy xDI Runtime
#   
#	This script allows to execute several commands on a remote runtime.
#	When it is executed without any parameters it opens a prompt that allows the user to type commands dynamically.
#
#	The first command should always be a "connect" command.
#
#	Note:
#	To have an overview of the possible parameters, use the -usage parameter
#	
#	Examples:
#	startcommand.sh -usage
#	startcommand.sh "connect;help"
#	startcommand.sh "connect;versions"
#	startcommand.sh "connect;execute delivery mydeliv"
#

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

PRGDIR=`dirname "$PRG"`

. "$PRGDIR"/initvariables.sh

"$RUNJAVA" $ADD_OPEN_OPTIONS $XDI_COMMAND_OPTS -classpath "$XDI_RUNTIME_CLASSPATH" "${XDI_RUNTIME_VM_PROPERTIES[@]}" com.indy.engine.launcher.MainLauncher -mainclass com.indy.engine.command.EngineCommandStartI -conf "$XDI_RUNTIME_CONF_FILE_LOCATION" "$@"