
CREATE SCHEMA extensions;
GRANT USAGE ON SCHEMA extensions TO PUBLIC;
ALTER DEFAULT PRIVILEGES IN SCHEMA extensions GRANT EXECUTE ON FUNCTIONS TO PUBLIC;
ALTER DATABASE semarchy_repository SET SEARCH_PATH TO "$user",public,extensions;

CREATE EXTENSION IF NOT EXISTS "uuid-ossp"     with schema extensions;
CREATE EXTENSION IF NOT EXISTS "fuzzystrmatch" with schema extensions;

/* Create the repository user and schema */
CREATE USER <semarchy_repository_username> WITH PASSWORD '<semarchy_repository_password>';

/*
 Grants access to the repository to the superuser.
 */
GRANT semarchy_repository TO <db_cluster_username>;

CREATE SCHEMA <semarchy_repository> AUTHORIZATION <semarchy_repository_username>;

/* Create the repository read-only user */
CREATE USER <semarchy_repository_ro_username> WITH PASSWORD '<semarchy_repository_ro_password>';


GRANT CONNECT ON DATABASE semarchy_repository to <semarchy_repository_ro_username>;

/* Setting the search path to include the repository */
ALTER ROLE <semarchy_repository_ro_username> SET SEARCH_PATH TO "$user", <semarchy_repository>,public,extensions;

GRANT USAGE ON SCHEMA semarchy_repository TO <semarchy_repository_ro_username>;
