package com.acme.phonestandardizer.tests;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.junit.Test;

import com.semarchy.engine.extensionpoint.DataRow;
import com.semarchy.engine.extensionpoint.IDataRow;
import com.semarchy.engine.extensionpoint.RowTransformerExecutor;

public class TestPhoneFrance {

	@Test
	public void testTransformNullPhones() {
		checkPhoneTransform(true, null, null);
		checkPhoneTransform(false, null, null);
	}

	@Test
	public void testTransformBadPhones() {
		checkPhoneTransform(true, "abcd", null);
		checkPhoneTransform(false, "abcd", "abcd");
		checkPhoneTransform(true, "64169710", null);
		checkPhoneTransform(false, "64169710", "64169710");
		checkPhoneTransform(true, "111164169710", null);
		checkPhoneTransform(false, "111164169710", "111164169710");
		checkPhoneTransform(true, "+44664169710", null);
		checkPhoneTransform(false, "+44664169710", "+44664169710");
		checkPhoneTransform(true, "1664169710", null);
		checkPhoneTransform(false, "1664169710", "1664169710");
	}

	@Test
	public void testTransformGoodPhones() {
		checkPhoneTransform(true, "0664169710", "+33664169710");
		checkPhoneTransform(true, "664169710", "+33664169710");
		checkPhoneTransform(true, "+33664169710", "+33664169710");
		checkPhoneTransform(true, "0478339229", "+33478339229");
		checkPhoneTransform(true, "(0)4.78.33.92.29...", "+33478339229");
	}

	/**
	 * 
	 * Tests the behavior of the phone transformer. It takes three parameters
	 * corresponding to the parameter, the input and output string of the
	 * transformeR.
	 * 
	 * 
	 * @param nullifyOnError
	 * @param inputPhone
	 * @param expectedOutputPhone
	 */
	private void checkPhoneTransform(Boolean nullifyOnError, String inputPhone, String expectedOutputPhone) {
		
		// Define the mapped inputs.
		Set<String> mappedInputs = new HashSet<String>();
		mappedInputs.add("INPUTPHONE");
		
		// Define the mapped outputs.
		Set<String> mappedOuputs = new HashSet<String>();
		mappedOuputs.add("STANDARDIZEDPHONE");
		
		// Define the mapped parameters
		Map<String,Object> parameters = new HashMap<String, Object>();
		parameters.put("NULLIFYONERROR", nullifyOnError);
		
		// Create the rowTransformerExecutor
		RowTransformerExecutor rowTransformerExecutor = new RowTransformerExecutor("com.acme.phoneStandardizer.intlPhoneStandardizer",null,mappedInputs,mappedOuputs);

		// Setting up the plugin.
		rowTransformerExecutor.setUp(parameters);
		
		try{
			
			// Creating a new data row with the test phone number 
			IDataRow inDataRow = new DataRow();
			((DataRow) inDataRow).setValue("INPUTPHONE", inputPhone);
			
			// Inserting this data row in a list of data rows.
			List<IDataRow> inDataRowList = new ArrayList<IDataRow>();
			inDataRowList.add(inDataRow);
			
			// Enriching the list of input data rows.			
			List<IDataRow> outDataRowList = rowTransformerExecutor.transform(inDataRowList);
			
			// Testing the resulting phone number.
			assertEquals(expectedOutputPhone, outDataRowList.get(0).getValue("STANDARDIZEDPHONE"));
			
		} finally {
			
			// Tearing down the plugin.
			rowTransformerExecutor.tearDown();
		}
	}

}
