/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.tool.jee.tomcat.jndi;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class JndiLookupFactory
implements ObjectFactory {
    private final Logger logger = Logger.getLogger(JndiLookupFactory.class.getName());
    private static final String JNDI_KEY_PARAM = "jndiKey";
    private static final String ICF = "initialCtxFactory";
    private static final String URL = "providerUrl";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final Set<String> FACTORY_PARAM = new HashSet<String>(Arrays.asList("auth", "type", "scope", "singleton", "factory"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        Enumeration<RefAddr> addrs = ref.getAll();
        Hashtable<String, String> jndiEnvironment = new Hashtable<String, String>();
        String jndiKey = null;
        while (addrs.hasMoreElements()) {
            RefAddr addr = addrs.nextElement();
            String type = addr.getType();
            if (FACTORY_PARAM.contains(type)) continue;
            String value = (String)addr.getContent();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("factory param " + type + " = " + value);
            }
            if (JNDI_KEY_PARAM.equals(type)) {
                jndiKey = value;
                continue;
            }
            if (ICF.equals(type)) {
                jndiEnvironment.put("java.naming.factory.initial", value);
                continue;
            }
            if (URL.equals(type)) {
                jndiEnvironment.put("java.naming.provider.url", value);
                continue;
            }
            if (USERNAME.equals(type)) {
                jndiEnvironment.put("java.naming.security.principal", value);
                continue;
            }
            if (PASSWORD.equals(type)) {
                jndiEnvironment.put("java.naming.security.credentials", value);
                continue;
            }
            jndiEnvironment.put(type, value);
        }
        if (jndiKey == null) {
            throw new IllegalStateException("missing 'jndiKey' mandatory parameter");
        }
        try (InitialContext jndiContext = new InitialContext(jndiEnvironment);){
            Object object = jndiContext.lookup(jndiKey);
            return object;
        }
    }
}

