rem =============================================================================
rem Semarchy xDM Sample Startup Configuration
rem Version : 5.3.0
rem Updated : 03-May-2021
rem -----------------------------------------------------------------------------
rem This file contains samples for the Startup Configuration using environment
rem variables.
rem It does not work as is and should be adapted to your configuration.
rem See *Startup Configuration* in the Semarchy xDM documentation 
rem for more information and a detailed description of each variable.
rem -----------------------------------------------------------------------------
rem CONTENTS
rem   - Use a configuration file
rem   - Repository Datasources
rem     - PostgreSQL
rem     - Microsoft SQL Server
rem     - Oracle
rem   - Key Management Services (KMS)
rem     - Current Key Management Service
rem     - Local key
rem     - Local Keystore file
rem     - Amazon Web Services Key Management Service
rem     - Azure Key Vault
rem     - Google Cloud Key Management
rem   - Secrets Manager
rem     - Amazon Web Services Secrets Manager.
rem     - Azure Key Vault
rem     - Google Cloud Secrets Manager
rem =============================================================================

rem The following lines should be copied from Tomcat's default setenv.bat file.
set "CATALINA_OPTS=%CATALINA_OPTS% -server -XX:+UseG1GC"
set "CATALINA_OPTS=%CATALINA_OPTS% -Dorg.apache.cxf.Logger=org.apache.cxf.common.logging.Slf4jLogger -Dorg.ops4j.pax.logging.property.file=%CATALINA_BASE%\conf\log4j2.semarchy.xml -Dgroovy.GStringTemplateEngine.reuseClassLoader=true -Duser.language=en -Duser.country=US -Djava.awt.headless=true --add-opens=java.base/java.nio=ALL-UNNAMED -Dnet.snowflake.jdbc.enableBouncyCastle=true -Dspring.jdbc.getParameterType.ignore=false"

rem =============================================================================
rem USE A CONFIGURATION FILE
rem -----------------------------------------------------------------------------
rem To use a configuration file that contains all the startup configuration, set 
rem the location of this file using the XDM_CONFIG_FILE property.
rem See config_sample.properties for a sample configuration file.
rem You can also define each startup property as an environment variable
rem set XDM_CONFIG_FILE=configuration_file_location

rem =============================================================================
rem REPOSITORY DATASOURCES
rem -----------------------------------------------------------------------------
rem The repository datasources are required by the Semarchy xDM to 
rem connect the repository database. 
rem   - The XDM_REPOSITORY_* variables configure the connection to the 
rem     repository schema with read-write privileges.
rem   - The XDM_REPOSITORY_READONLY_* variables configure the credentials to  
rem     connect the repository schema with read-only privileges.
rem =============================================================================

rem -----------------------------------------------------------------------------
rem PostgreSQL
rem Comment this section if you do not use this technology.
rem -----------------------------------------------------------------------------
rem Repository datasource
set XDM_REPOSITORY_DRIVER=org.postgresql.Driver
set XDM_REPOSITORY_URL=jdbc:postgresql://localhost:5432/postgres
set XDM_REPOSITORY_USERNAME=repository_user
set XDM_REPOSITORY_PASSWORD=repository_password
rem Repository read-only datasource credentials
set XDM_REPOSITORY_READONLY_USERNAME=repository_readonly_user
set XDM_REPOSITORY_READONLY_PASSWORD=repository_readonly_password

rem -----------------------------------------------------------------------------
rem Microsoft SQL Server
rem Uncomment this section to use this technology.
rem -----------------------------------------------------------------------------
rem rem Repository datasource
rem set XDM_REPOSITORY_DRIVER=com.microsoft.sqlserver.jdbc.SQLServerDriver
rem set XDM_REPOSITORY_URL=jdbc:sqlserver://localhost:1433;databaseName=REPOSITORY;encrypt=false
rem set XDM_REPOSITORY_USERNAME=repository_user
rem set XDM_REPOSITORY_PASSWORD=repository_password
rem rem Repository read-only datasource credentials
rem set XDM_REPOSITORY_READONLY_USERNAME=repository_readonly_user
rem set XDM_REPOSITORY_READONLY_PASSWORD=repository_readonly_password

rem -----------------------------------------------------------------------------
rem Oracle
rem Uncomment this section to use this technology.
rem -----------------------------------------------------------------------------
rem rem Repository datasource
rem set XDM_REPOSITORY_DRIVER=oracle.jdbc.OracleDriver
rem set XDM_REPOSITORY_URL=jdbc:oracle:thin:@localhost:1521:XE
rem set XDM_REPOSITORY_USERNAME=repository_user
rem set XDM_REPOSITORY_PASSWORD=repository_password
rem rem Repository read-only datasource credentials
rem set XDM_REPOSITORY_READONLY_USERNAME=repository_readonly_user
rem set XDM_REPOSITORY_READONLY_PASSWORD=repository_readonly_password
rem rem Set the current schema of the readonly user to the repository
rem set XDM_REPOSITORY_READONLY_CONNECTIONINITSQL=ALTER SESSION SET CURRENT_SCHEMA = repository_user
rem =============================================================================

rem =============================================================================
rem SECRETS MANAGEMENT: KEY MANAGEMENT SERVICES
rem -----------------------------------------------------------------------------
rem To encrypt secrets stored in the repository (passwords, keys, etc), you can 
rem configure multiple Key Management Services (KMS). One of these must be 
rem set as the *Current KMS*. Others are only used to decrypt previously 
rem encrypted secrets.
rem 
rem Note that the KMS *alias* appears in the variable name in uppercase. For exemple, 
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEY_TYPE configures the type of the KMS which
rem alias is *localkey*.
rem =============================================================================

rem -----------------------------------------------------------------------------
rem Current Key Management Service (KMS)
rem Uncomment the following line and update it to set the current KMS' alias.
rem set XDM_SECRETS_INTERNAL_KMS_CURRENT=localkey
rem -----------------------------------------------------------------------------

rem -----------------------------------------------------------------------------
rem Sample KMS: localkey
rem Local KMS using a key (Base64 encoded, AES-256 bit) passed as a value.
rem Uncomment this section to configure and use this KMS technology.
rem -----------------------------------------------------------------------------
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEY_TYPE=LOCAL
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEY_KEY=your_base_64_key

rem -----------------------------------------------------------------------------
rem Sample KMS: localkeystore
rem Local KMS using a keystore file storing a Base64 encoded AES-256 bit key.
rem Uncomment this section to configure and use this KMS technology.
rem -----------------------------------------------------------------------------
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_TYPE=LOCAL
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_FILE=keystore_file_location
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_PASSWORD=keystore_password
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_KEY=key_alias
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_KEYPASSWORD=optional_key_password
rem set XDM_SECRETS_INTERNAL_KMS_LOCALKEYSTORE_KEYSTORE_TYPE=pkcs12

rem -----------------------------------------------------------------------------
rem Sample KMS: aws
rem KMS using the Amazon Web Services Key Management Service.
rem Uncomment this section to configure and use this KMS technology.
rem -----------------------------------------------------------------------------
rem set XDM_SECRETS_INTERNAL_KMS_AWS_TYPE=AWS
rem set XDM_SECRETS_INTERNAL_KMS_AWS_KEYID=customer_master_key_alias
rem set XDM_SECRETS_INTERNAL_KMS_AWS_REGION=us-west-1
rem rem Optional credentials using an access key and a secret access key.
rem set XDM_SECRETS_INTERNAL_KMS_AWS_CREDENTIALS_BASIC_ACCESSKEY=aws_access_key
rem set XDM_SECRETS_INTERNAL_KMS_AWS_CREDENTIALS_BASIC_SECRETKEY=aws_secret_key

rem -----------------------------------------------------------------------------
rem Sample KMS: azure
rem KMS using Azure Key Vault.
rem Uncomment this section to configure and use this KMS technology.
rem -----------------------------------------------------------------------------
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_TYPE=AZURE
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_VAULTURL=azure_key_vault_base_url
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_KEYNAME=azure_key_vault_key_name
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_WRAPALGORITHM=RSA1_5
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_KEYVERSION=optional_key_version
rem rem Optional credentials using a clientid and client secret.
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_TENANTID=tenant_id
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_CLIENTID=client_id
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_CLIENTSECRET=client_secret
rem rem Optional credentials using a username and password
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_USERNAME=user_name
rem set XDM_SECRETS_INTERNAL_KMS_AZURE_CREDENTIALS_PASSWORD=password

rem -----------------------------------------------------------------------------
rem Sample KMS: google
rem KMS using Google Cloud Key Management.
rem Uncomment this section to configure and use this KMS technology.
rem -----------------------------------------------------------------------------
rem set XDM_SECRETS_INTERNAL_KMS_GOOGLE_TYPE=GCP
rem set XDM_SECRETS_INTERNAL_KMS_GOOGLE_PROJECTID=project_id
rem set XDM_SECRETS_INTERNAL_KMS_GOOGLE_KEYRINGNAME=keyring_name
rem set XDM_SECRETS_INTERNAL_KMS_GOOGLE_LOCATION=keyring_location
rem set XDM_SECRETS_INTERNAL_KMS_GOOGLE_KEYNAME=crypto_key_resource_name
rem rem Credentials using a service account key file
rem set XDM_SECRETS_INTERNAL_KMS_GOOGLE_CREDENTIALS_FILE=key_file
rem rem Credentials using the service account key file contents
rem set XDM_SECRETS_INTERNAL_KMS_GOOGLE_CREDENTIALS_VALUE=key_file_contents


rem =============================================================================
rem SECRETS MANAGEMENT: SECRETS MANAGERS
rem -----------------------------------------------------------------------------
rem You can access secrets (passwords, keys, etc) stored in one or more external 
rem secrets manager.
rem 
rem Note that the secrets manager *alias* appears in the variable name in uppercase.
rem For exemple, XDM_SECRETS_EXTERNAL_AWSSECRETS_TYPE configures the type of the
rem secrets manager which alias is *awssecrets*.
rem =============================================================================

rem -----------------------------------------------------------------------------
rem Sample Secrets Manager: awssecrets
rem External secrets manager using the Amazon Web Services Secrets Manager.
rem Uncomment this section to configure and use this secrets manager technology.
rem -----------------------------------------------------------------------------
rem set XDM_SECRETS_EXTERNAL_AWSSECRETS_TYPE=AWS
rem set XDM_SECRETS_EXTERNAL_AWSSECRETS_REGION=us-west-1
rem rem Optional credentials using an access key and a secret access key.
rem set XDM_SECRETS_EXTERNAL_AWSSECRETS_CREDENTIALS_BASIC_ACCESSKEY=aws_access_key
rem set XDM_SECRETS_EXTERNAL_AWSSECRETS_CREDENTIALS_BASIC_SECRETKEY=aws_secret_key

rem -----------------------------------------------------------------------------
rem Sample Secrets Manager: azuresecrets
rem External secrets manager using the Azure Key Vault Secrets Manager.
rem Uncomment this section to configure and use this secrets manager technology.
rem -----------------------------------------------------------------------------
rem set XDM_SECRETS_EXTERNAL_AZURESECRETS_TYPE=AZURE
rem set XDM_SECRETS_EXTERNAL_AZURESECRETS_VAULTURL=azure_key_vault_base_url
rem rem Optional credentials using a clientid and client secret.
rem set XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_TENANTID=tenant_id
rem set XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_CLIENTID=client_id
rem set XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_CLIENTSECRET=cllient_secret
rem rem Optional credentials using a username and password
rem set XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_USERNAME=user_name
rem set XDM_SECRETS_EXTERNAL_AZURESECRETS_CREDENTIALS_PASSWORD=password

rem -----------------------------------------------------------------------------
rem Sample Secrets Manager: googlesecrets
rem External secrets manager using the Google Cloud Secrets Manager.
rem Uncomment this section to configure and use this secrets manager technology.
rem -----------------------------------------------------------------------------
rem set XDM_SECRETS_EXTERNAL_GOOGLESECRETS_TYPE=GCP
rem set XDM_SECRETS_EXTERNAL_GOOGLESECRETS_PROJECTID=project_id
rem rem Credentials using a service account key file
rem set XDM_SECRETS_EXTERNAL_GOOGLESECRETS_CREDENTIALS_FILE=key_file
rem rem Credentials using the service account key file contents
rem set XDM_SECRETS_EXTERNAL_GOOGLESECRETS_CREDENTIALS_VALUE=key_file_contents
