/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.legacy.crypto.qtesla;

import net.snowflake.client.jdbc.internal.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.snowflake.client.jdbc.internal.org.bouncycastle.pqc.legacy.crypto.qtesla.QTESLASecurityCategory;
import net.snowflake.client.jdbc.internal.org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class QTESLAPrivateKeyParameters
extends AsymmetricKeyParameter {
    private int securityCategory;
    private byte[] privateKey;

    public QTESLAPrivateKeyParameters(int n, byte[] byArray) {
        super(true);
        if (byArray.length != QTESLASecurityCategory.getPrivateSize(n)) {
            throw new IllegalArgumentException("invalid key size for security category");
        }
        this.securityCategory = n;
        this.privateKey = Arrays.clone(byArray);
    }

    public int getSecurityCategory() {
        return this.securityCategory;
    }

    public byte[] getSecret() {
        return Arrays.clone(this.privateKey);
    }
}

