/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallLocation;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.StructuredPojo;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.GenerateRandomRequest;

@SdkInternalApi
public class GenerateRandomRequestMarshaller {
    private static final MarshallingInfo<Integer> NUMBEROFBYTES_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfBytes").build();
    private static final MarshallingInfo<String> CUSTOMKEYSTOREID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CustomKeyStoreId").build();
    private static final MarshallingInfo<StructuredPojo> RECIPIENT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Recipient").build();
    private static final GenerateRandomRequestMarshaller instance = new GenerateRandomRequestMarshaller();

    public static GenerateRandomRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(GenerateRandomRequest generateRandomRequest, ProtocolMarshaller protocolMarshaller) {
        if (generateRandomRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(generateRandomRequest.getNumberOfBytes(), NUMBEROFBYTES_BINDING);
            protocolMarshaller.marshall(generateRandomRequest.getCustomKeyStoreId(), CUSTOMKEYSTOREID_BINDING);
            protocolMarshaller.marshall(generateRandomRequest.getRecipient(), RECIPIENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

