/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.rp;

import java.net.URI;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.Secret;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.client.ClientUpdateRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Immutable
public class OIDCClientUpdateRequest
extends ClientUpdateRequest {
    public OIDCClientUpdateRequest(URI endpoint, ClientID id, BearerAccessToken accessToken, OIDCClientMetadata metadata, Secret secret) {
        super(endpoint, id, accessToken, metadata, secret);
    }

    public OIDCClientMetadata getOIDCClientMetadata() {
        return (OIDCClientMetadata)this.getClientMetadata();
    }

    public static OIDCClientUpdateRequest parse(HTTPRequest httpRequest) throws ParseException {
        httpRequest.ensureMethod(HTTPRequest.Method.PUT);
        BearerAccessToken accessToken = BearerAccessToken.parse(httpRequest.getAuthorization());
        JSONObject jsonObject = httpRequest.getBodyAsJSONObject();
        ClientID id = new ClientID(JSONObjectUtils.getNonBlankString(jsonObject, "client_id"));
        OIDCClientMetadata metadata = OIDCClientMetadata.parse(jsonObject);
        Secret clientSecret = null;
        if (jsonObject.get("client_secret") != null) {
            clientSecret = new Secret(JSONObjectUtils.getNonBlankString(jsonObject, "client_secret"));
        }
        URI endpointURI = httpRequest.getURI();
        return new OIDCClientUpdateRequest(endpointURI, id, accessToken, metadata, clientSecret);
    }
}

