/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.snowflake.runtime;

import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.semarchy.xdi.component.snowflake.runtime.Messages;
import com.semarchy.xdi.component.snowflake.runtime.SnowpipeStreamingChannelHandlerBuilder;
import com.semarchy.xdi.component.snowflake.runtime.SnowpipeStreamingOffsetManager;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.snowflake.ingest.streaming.InsertValidationResponse;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestChannel;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestClient;

public class SnowpipeStreamingChannelHandler {
    private int batchSize;
    private String offsetColumnName;
    private boolean offsetTokenComparison = true;
    private int batchRowCount;
    private int batchErrorCount;
    private long totalErrorCount;
    private long totalRowCount;
    private List<Map<String, Object>> rows;
    private SnowflakeStreamingIngestClient client;
    private SnowflakeStreamingIngestChannel channel;
    private SnowpipeStreamingOffsetManager offsetManager;
    private IPreparedStatementToResultSet errorPreparedStatement;
    private boolean processErrors = false;
    private Map<Integer, String> columnLabels;
    private Consumer<StatEntry> statisticPublisher;
    private Consumer<VariableEntry> variablePublisher;

    public SnowpipeStreamingChannelHandler(SnowpipeStreamingChannelHandlerBuilder builder) {
        this.client = builder.getClient();
        this.channel = builder.getChannel();
        this.offsetColumnName = builder.getOffsetColumnName();
        this.offsetTokenComparison = builder.getOffsetTokenComparison();
        this.processErrors = builder.getProcessErrors();
        this.errorPreparedStatement = builder.getErrorPreparedStatement();
        this.statisticPublisher = builder.getStatisticPublisher();
        this.variablePublisher = builder.getVariablePublisher();
        this.offsetManager = new SnowpipeStreamingOffsetManager(this.channel);
        this.batchSize = builder.getBatchSize();
    }

    private void getColumnLabelsFromResultSet(ResultSetMetaData sourceResultSetMetaData) throws Exception {
        this.columnLabels = new HashMap<Integer, String>();
        int columnCount = sourceResultSetMetaData.getColumnCount();
        int columnNum = 1;
        int i = 1;
        while (i <= columnCount) {
            if (!sourceResultSetMetaData.getColumnLabel(i).equals(this.offsetColumnName)) {
                this.columnLabels.put(i, this.addQuotes(sourceResultSetMetaData.getColumnLabel(i)));
                if (this.processErrors) {
                    this.errorPreparedStatement.setColumn(columnNum, sourceResultSetMetaData.getColumnLabel(i), sourceResultSetMetaData.getColumnType(i));
                }
                ++columnNum;
            }
            ++i;
        }
        if (this.processErrors) {
            this.errorPreparedStatement.setColumn(columnNum, "REJECT_MESSAGE");
        }
    }

    private String addQuotes(String columnLabel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        stringBuilder.append(columnLabel);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    protected int processResultSet(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws Exception {
        int ret = 0;
        this.getColumnLabelsFromResultSet(resultSetMetaData);
        this.rows = new ArrayList<Map<String, Object>>();
        boolean processRows = !this.offsetTokenComparison;
        int columnCount = resultSetMetaData.getColumnCount();
        this.batchRowCount = 0;
        this.batchErrorCount = 0;
        this.totalRowCount = 0L;
        this.totalErrorCount = 0L;
        this.publishActionStatistics();
        do {
            this.offsetManager.setCurrentOffset(resultSet.getObject(this.offsetColumnName));
            if (!processRows && this.offsetManager.isLatestComittedOffsetReached()) {
                processRows = true;
            }
            if (!processRows) continue;
            this.addRow(resultSet, resultSetMetaData, columnCount);
        } while (resultSet.next());
        this.finalizeProcessing();
        this.channel.close().get();
        this.verifyIfDataCommittedAndWithoutErrors();
        return ret;
    }

    private void finalizeProcessing() throws SQLException {
        this.executeBatch(this.offsetManager.getCurrentOffsetToken());
        if (this.processErrors && this.batchErrorCount > 0) {
            this.errorPreparedStatement.executeBatch();
            this.batchErrorCount = 0;
        }
        if (this.processErrors) {
            this.errorPreparedStatement.end();
        }
    }

    private void addRow(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int columnCount) throws SQLException {
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        int i = 1;
        while (i <= columnCount) {
            if (!resultSetMetaData.getColumnLabel(i).equals(this.offsetColumnName)) {
                Object columnValue = this.convertColumnValue(resultSet.getObject(i));
                row.put(this.columnLabels.get(i), columnValue);
            }
            ++i;
        }
        this.rows.add(row);
        ++this.batchRowCount;
        if (this.batchRowCount == this.batchSize) {
            this.executeBatch(this.offsetManager.getCurrentOffsetToken());
        }
    }

    private Object convertColumnValue(Object columnValue) {
        if (columnValue instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)columnValue;
            return timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (columnValue instanceof Time) {
            Time time = (Time)columnValue;
            return time.toLocalTime();
        }
        if (columnValue instanceof Date) {
            Date date = (Date)columnValue;
            return date.toLocalDate();
        }
        return columnValue;
    }

    private void logErrorsToResultSet(List<InsertValidationResponse.InsertError> insertErrors) throws SQLException {
        for (InsertValidationResponse.InsertError insertError : insertErrors) {
            Map errorRowData = (Map)insertError.getRowContent();
            int columnNum = 1;
            for (Map.Entry entry : errorRowData.entrySet()) {
                this.errorPreparedStatement.setObject(columnNum, entry.getValue());
                ++columnNum;
            }
            this.errorPreparedStatement.setString(columnNum, insertError.getMessage());
            this.errorPreparedStatement.addBatch();
            ++this.batchErrorCount;
            if (this.batchErrorCount != this.batchSize) continue;
            this.errorPreparedStatement.executeBatch();
            this.batchErrorCount = 0;
        }
    }

    private void publishTokenVariables() {
        this.variablePublisher.accept(new VariableEntry("SNOWPIPE_LAST_SENT_OFFSET_TOKEN", this.offsetManager.getCurrentOffsetToken(), "String"));
        this.variablePublisher.accept(new VariableEntry("SNOWPIPE_LAST_COMMITTED_OFFSET_TOKEN", this.offsetManager.getLatestCommittedOffsetToken(), "String"));
    }

    private void verifyIfDataCommittedAndWithoutErrors() throws EngineExceptionI {
        if (this.totalRowCount > 0L && !this.offsetManager.isCurrentOffsetComitted()) {
            Map latestCommittedOffsetTokens = this.client.getLatestCommittedOffsetTokens(Collections.singletonList(this.channel));
            this.offsetManager.setLatestCommittedOffsetToken((String)latestCommittedOffsetTokens.get(this.channel.getFullyQualifiedName()));
            if (!this.offsetManager.isCurrentOffsetComitted()) {
                this.publishTokenVariables();
                throw new EngineExceptionI(String.format(Messages.getString("SnowpipeStreamingActionCodeI.4"), this.offsetManager.getCurrentOffsetToken(), this.offsetManager.getLatestCommittedOffsetToken()));
            }
        }
        if (this.totalErrorCount > 0L && this.processErrors) {
            throw new EngineExceptionI(Messages.getString("SnowpipeStreamingActionCodeI.2"));
        }
    }

    private void executeBatch(String offsetToken) throws SQLException {
        InsertValidationResponse response = this.channel.insertRows(this.rows, offsetToken);
        this.rows.clear();
        this.totalRowCount += (long)this.batchRowCount;
        this.totalErrorCount += (long)response.getErrorRowCount();
        this.batchRowCount = 0;
        if (this.processErrors && response.hasErrors()) {
            this.logErrorsToResultSet(response.getInsertErrors());
        }
        this.publishActionStatistics();
    }

    private void publishActionStatistics() {
        this.statisticPublisher.accept(new StatEntry("SNOWPIPE_ERROR", this.totalErrorCount));
        this.statisticPublisher.accept(new StatEntry("SNOWPIPE_INSERT", this.totalRowCount - this.totalErrorCount));
    }

    public void close() throws Exception {
        this.client.close();
        if (this.errorPreparedStatement != null) {
            this.errorPreparedStatement.close();
        }
    }

    record StatEntry(String name, Long value) {
    }

    record VariableEntry(String name, Object value, String type) {
    }
}

