/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.snowflake.runtime;

import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.semarchy.xdi.component.snowflake.runtime.SnowpipeStreamingActionCodeI;
import com.semarchy.xdi.component.snowflake.runtime.SnowpipeStreamingChannelHandler;
import com.semarchy.xdi.component.snowflake.runtime.SnowpipeStreamingConnection;
import java.util.function.Consumer;
import net.snowflake.ingest.streaming.OpenChannelRequest;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestChannel;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestClient;

public class SnowpipeStreamingChannelHandlerBuilder {
    String accountUrl;
    String user;
    String privateKeyPath;
    String privateKeyPassword;
    private String targetTableName;
    private String targetSchemaName;
    private String targetDbName;
    private String channelName;
    private int batchSize;
    private String offsetColumnName;
    private boolean offsetTokenComparison = true;
    private static final String CLIENT_NAME = "Semarchy xDI";
    private SnowflakeStreamingIngestClient client;
    private SnowflakeStreamingIngestChannel channel;
    private IPreparedStatementToResultSet errorPreparedStatement;
    private boolean processErrors = false;
    private Consumer<SnowpipeStreamingChannelHandler.StatEntry> statisticPublisher;
    private Consumer<SnowpipeStreamingChannelHandler.VariableEntry> variablePublisher;
    private SnowpipeStreamingActionCodeI.OnErrorBehavior onErrorBehavior;

    public SnowpipeStreamingChannelHandlerBuilder setAccountUrl(String accountUrl) {
        this.accountUrl = accountUrl;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setUser(String user) {
        this.user = user;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setPrivateKeyPassword(String privateKeyPasswordUncrypted) {
        this.privateKeyPassword = privateKeyPasswordUncrypted;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setTargetSchemaName(String targetSchemaName) {
        this.targetSchemaName = targetSchemaName;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setTargetDatabase(String targetDbName) {
        this.targetDbName = targetDbName;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setOnErrorBehavior(SnowpipeStreamingActionCodeI.OnErrorBehavior onErrorBehavior) {
        this.onErrorBehavior = onErrorBehavior;
        this.processErrors = onErrorBehavior == SnowpipeStreamingActionCodeI.OnErrorBehavior.CONTINUE_EXECUTION;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setChannelName(String chanelName) {
        this.channelName = chanelName;
        return this;
    }

    public SnowpipeStreamingChannelHandler build() throws Exception {
        SnowpipeStreamingConnection snowpipeStreamingConnection = new SnowpipeStreamingConnection(this.accountUrl, this.user, this.privateKeyPath, this.privateKeyPassword);
        this.client = snowpipeStreamingConnection.createClient(CLIENT_NAME);
        OpenChannelRequest.OnErrorOption onErrorOption = this.onErrorBehavior == SnowpipeStreamingActionCodeI.OnErrorBehavior.ABORT_EXECUTION ? OpenChannelRequest.OnErrorOption.ABORT : OpenChannelRequest.OnErrorOption.CONTINUE;
        OpenChannelRequest request = OpenChannelRequest.builder((String)this.channelName).setDBName(this.targetDbName).setSchemaName(this.targetSchemaName).setTableName(this.targetTableName).setOnErrorOption(onErrorOption).build();
        this.channel = this.client.openChannel(request);
        return new SnowpipeStreamingChannelHandler(this);
    }

    public SnowpipeStreamingChannelHandlerBuilder setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setOffsetColumnName(String offsetColumnName) {
        this.offsetColumnName = offsetColumnName;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setStatisticPublisher(Consumer<SnowpipeStreamingChannelHandler.StatEntry> statisticPublisher) {
        this.statisticPublisher = statisticPublisher;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setVariablePublisher(Consumer<SnowpipeStreamingChannelHandler.VariableEntry> variablePublisher) {
        this.variablePublisher = variablePublisher;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setErrorPreparedStatement(IPreparedStatementToResultSet errorPreparedStatement) {
        this.errorPreparedStatement = errorPreparedStatement;
        return this;
    }

    public SnowpipeStreamingChannelHandlerBuilder setOffsetComparison(SnowpipeStreamingActionCodeI.OffsetTokenComparison offsetTokenComparison) {
        this.offsetTokenComparison = offsetTokenComparison == SnowpipeStreamingActionCodeI.OffsetTokenComparison.ENABLE;
        return this;
    }

    public SnowflakeStreamingIngestClient getClient() {
        return this.client;
    }

    public SnowflakeStreamingIngestChannel getChannel() {
        return this.channel;
    }

    public String getOffsetColumnName() {
        return this.offsetColumnName;
    }

    public IPreparedStatementToResultSet getErrorPreparedStatement() {
        return this.errorPreparedStatement;
    }

    public boolean getProcessErrors() {
        return this.processErrors;
    }

    public Consumer<SnowpipeStreamingChannelHandler.StatEntry> getStatisticPublisher() {
        return this.statisticPublisher;
    }

    public Consumer<SnowpipeStreamingChannelHandler.VariableEntry> getVariablePublisher() {
        return this.variablePublisher;
    }

    public boolean getOffsetTokenComparison() {
        return this.offsetTokenComparison;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

