/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.snowflake.runtime;

import com.semarchy.xdi.component.snowflake.runtime.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.Base64;
import java.util.Properties;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestClient;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestClientFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class SnowpipeStreamingConnection {
    String user;
    String url;
    String privateKeyPath;
    String privateKeyPass;

    public SnowpipeStreamingConnection(String url, String user, String privateKeyPath, String privateKeyPass) {
        this.url = url;
        this.user = user;
        this.privateKeyPass = privateKeyPass;
        this.privateKeyPath = privateKeyPath;
    }

    public SnowpipeStreamingConnection(String url, String user, String privateKeyPath) {
        this(url, user, privateKeyPath, "");
    }

    private Properties getSnowflakeStreamingProperties() throws Exception {
        Properties props = new Properties();
        String pkString = SnowpipeStreamingConnection.getPrivateKeyString(this.privateKeyPath, this.privateKeyPass);
        props.put("user", this.user);
        props.put("url", this.url);
        props.put("private_key", pkString);
        return props;
    }

    private static String getPrivateKeyString(String privateKeyPath, String privateKeyPass) throws Exception {
        BouncyCastleProvider bcProvider;
        PrivateKeyInfo privateKeyInfo;
        block11: {
            privateKeyInfo = null;
            bcProvider = new BouncyCastleProvider();
            Throwable throwable = null;
            Object var5_6 = null;
            try (PEMParser pemParser = new PEMParser((Reader)new FileReader(Paths.get(privateKeyPath, new String[0]).toFile()));){
                Object pemObject = pemParser.readObject();
                if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                    PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObject;
                    InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider((Provider)bcProvider).build(privateKeyPass.toCharArray());
                    privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(pkcs8Prov);
                    break block11;
                }
                if (pemObject instanceof PrivateKeyInfo) {
                    privateKeyInfo = (PrivateKeyInfo)pemObject;
                    break block11;
                }
                throw new EngineExceptionI(Messages.getString("SnowpipeStreamingConnection.0"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider((Provider)bcProvider);
        PrivateKey pk = converter.getPrivateKey(privateKeyInfo);
        return Base64.getEncoder().encodeToString(pk.getEncoded());
    }

    public SnowflakeStreamingIngestClient createClient(String clientName) throws Exception {
        return SnowflakeStreamingIngestClientFactory.builder((String)clientName).setProperties(this.getSnowflakeStreamingProperties()).build();
    }
}

