/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.snowflake.runtime;

import com.semarchy.xdi.component.snowflake.runtime.Messages;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import net.snowflake.ingest.streaming.SnowflakeStreamingIngestChannel;

public class SnowpipeStreamingOffsetManager {
    private Object currentOffset;
    private String latestCommittedOffsetToken;
    private String currentOffsetToken;
    final DateTimeFormatter localDatetimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS");
    private SnowflakeStreamingIngestChannel channel;

    public SnowpipeStreamingOffsetManager(SnowflakeStreamingIngestChannel channel) {
        this.channel = channel;
        this.latestCommittedOffsetToken = this.channel.getLatestCommittedOffsetToken();
    }

    public void setCurrentOffset(Object currentOffset) {
        if (currentOffset instanceof Timestamp) {
            Timestamp castedCurrentOffset = (Timestamp)currentOffset;
            this.currentOffset = castedCurrentOffset.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            this.currentOffsetToken = ((LocalDateTime)this.currentOffset).format(this.localDatetimeFormat);
        } else {
            this.currentOffset = currentOffset;
            this.currentOffsetToken = currentOffset.toString();
        }
    }

    public void setLatestCommittedOffsetToken(String latestCommittedOffsetToken) {
        this.latestCommittedOffsetToken = latestCommittedOffsetToken;
    }

    public String getCurrentOffsetToken() {
        return this.currentOffsetToken;
    }

    public boolean isLatestComittedOffsetReached() throws EngineExceptionI {
        return this.compareOffsets() > 0;
    }

    public boolean isCurrentOffsetComitted() throws EngineExceptionI {
        return this.compareOffsets() == 0;
    }

    private int compareOffsets() throws EngineExceptionI {
        if (this.latestCommittedOffsetToken == null || this.latestCommittedOffsetToken.equals("")) {
            return 1;
        }
        try {
            Object object = this.currentOffset;
            if (object instanceof LocalDateTime) {
                LocalDateTime localDateTimeCurrentOffset = (LocalDateTime)object;
                LocalDateTime latestComittedOffset = LocalDateTime.parse(this.latestCommittedOffsetToken, this.localDatetimeFormat);
                return localDateTimeCurrentOffset.compareTo(latestComittedOffset);
            }
            Object object2 = this.currentOffset;
            if (object2 instanceof Integer) {
                Integer integerCurrentOffset = (Integer)object2;
                Integer latestComittedOffset = Integer.valueOf(this.latestCommittedOffsetToken);
                return integerCurrentOffset.compareTo(latestComittedOffset);
            }
            Object object3 = this.currentOffset;
            if (object3 instanceof Long) {
                Long longCurrentOffset = (Long)object3;
                Long latestComittedOffset = Long.valueOf(this.latestCommittedOffsetToken);
                return longCurrentOffset.compareTo(latestComittedOffset);
            }
            Object object4 = this.currentOffset;
            if (object4 instanceof String) {
                String stringCurrentOffset = (String)object4;
                String latestComittedOffset = this.latestCommittedOffsetToken;
                return stringCurrentOffset.compareTo(latestComittedOffset);
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("SnowpipeStreamingOffsetManager.1"), (Throwable)e);
        }
        throw new EngineExceptionI(Messages.getString("SnowpipeStreamingOffsetManager.0"));
    }

    public void refreshLatestCommittedOffsetToken() {
        this.latestCommittedOffsetToken = this.channel.getLatestCommittedOffsetToken();
    }

    public String getLatestCommittedOffsetToken() {
        return this.latestCommittedOffsetToken;
    }
}

