/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.sap.properties;

import com.indy.addons.sap.Activator;
import com.indy.addons.sap.Messages;
import com.indy.addons.sap.reverse.SAPFactoryProvider;
import com.indy.connector.sap.core.ISAPReverseAPI;
import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.md.ui.editor.ui.MdControlManager;
import com.stambia.md.MdNode;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class SapConnectionComposite
extends Composite {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private MdControlManager mcm;
    private Text nameField;
    private MdNode sapServer;
    private Text host;
    private Text user;
    private Text password;
    private Text client;
    private Text system;
    private Text language;
    private Button connect;
    private Combo reverseLanguage;
    private Button enableMs;
    private Text r3name;
    private Text group;
    private static final Logger logger = LogManager.getLogger(SapConnectionComposite.class);
    private SelectionListener msListener;

    public abstract void handleErrorMessage(String var1);

    public SapConnectionComposite(Composite parent, int style, MdNode _sapServer) {
        super(parent, style);
        this.sapServer = _sapServer;
        SapConnectionComposite composite = this;
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData(new GridData(1808));
        composite.setFont(parent.getFont());
        Composite nameGroup = new Composite((Composite)composite, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 10;
        nameGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 0x1000000, true, false);
        nameGroup.setLayoutData((Object)data);
        this.mcm = new MdControlManager();
        Label label = new Label(nameGroup, 64);
        label.setText("Name");
        this.nameField = new Text(nameGroup, 2048);
        this.nameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (SapConnectionComposite.this.nameField.getText() != null) {
                    if (SapConnectionComposite.this.nameField.getText().matches("[A-Za-z][A-Za-z0-9]*")) {
                        SapConnectionComposite.this.handleErrorMessage(null);
                    } else {
                        SapConnectionComposite.this.handleErrorMessage(Messages.SapConnectionComposite_1);
                    }
                }
                if (SapConnectionComposite.this.nameField.getText() == null || SapConnectionComposite.this.nameField.getText().isEmpty()) {
                    SapConnectionComposite.this.handleErrorMessage(Messages.SapConnectionComposite_2);
                }
            }
        });
        this.mcm.addControl((Control)this.nameField, this.sapServer, null, 3, true, false);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.nameField.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "host", 0, true, false);
        this.host = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.host, this.sapServer, "host", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.host.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "ms", 0, true, false);
        this.enableMs = new Button(nameGroup, 32);
        this.mcm.addControl((Control)this.enableMs, this.sapServer, "ms", 1, true, false);
        data = new GridData(768);
        this.enableMs.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "group", 0, true, false);
        this.group = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.group, this.sapServer, "group", 1, true, false);
        data = new GridData(768);
        data.widthHint = 250;
        this.group.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "r3name", 0, true, false);
        this.r3name = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.r3name, this.sapServer, "r3name", 1, true, false);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.r3name.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "client", 0, true, false);
        this.client = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.client, this.sapServer, "client", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.client.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "user", 0, true, false);
        this.user = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.user, this.sapServer, "user", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.user.setLayoutData((Object)data);
        MdControlManager.MdControl mc = this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "password", 0, true, false);
        this.password = new Text(nameGroup, 0x400800);
        this.mcm.addControl((Control)this.password, this.sapServer, "password", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.password.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "language", 0, true, false);
        this.language = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.language, this.sapServer, "language", 1, true, false);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.language.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "system", 0, true, false);
        this.system = new Text(nameGroup, 2048);
        this.mcm.addControl((Control)this.system, this.sapServer, "system", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.system.setLayoutData((Object)data);
        this.mcm.addControl((Control)new Label(nameGroup, 64), this.sapServer, "reverseLanguage", 0, true, false);
        this.reverseLanguage = new Combo(nameGroup, 2048);
        this.mcm.addControl((Control)this.reverseLanguage, this.sapServer, "reverseLanguage", 1, true, true);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 250;
        this.reverseLanguage.setLayoutData((Object)data);
        this.connect = new Button(nameGroup, 2048);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.connect.setLayoutData((Object)data);
        this.connect.setText(Messages.SapConnectionComposite_23);
        this.connect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    if (!SapConnectionComposite.isConnected(SapConnectionComposite.this.sapServer)) {
                        SapConnectionComposite.connect(SapConnectionComposite.this.sapServer, true, true);
                        SapConnectionComposite.this.connectOrDisconnect();
                        MessageDialog.openInformation((Shell)SapConnectionComposite.this.getShell(), (String)Messages.SapConnectionComposite_24, (String)Messages.SapConnectionComposite_25);
                    } else {
                        SapConnectionComposite.disConnect(SapConnectionComposite.this.sapServer);
                        SapConnectionComposite.this.connectOrDisconnect();
                    }
                }
                catch (Throwable e) {
                    SapConnectionComposite.printException(e, SapConnectionComposite.this.getShell());
                }
            }
        });
        this.mcm.init();
        this.msListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (SapConnectionComposite.this.enableMs.getSelection()) {
                    SapConnectionComposite.this.group.setEnabled(true);
                    SapConnectionComposite.this.r3name.setEnabled(true);
                } else {
                    SapConnectionComposite.this.group.setEnabled(false);
                    SapConnectionComposite.this.r3name.setEnabled(false);
                }
            }
        };
        this.msListener.widgetSelected(null);
        this.enableMs.addSelectionListener(this.msListener);
    }

    public static void printException(Throwable t, Shell shell) {
        MessageDialog.openError((Shell)shell, (String)Messages.SapConnectionComposite_26, (String)t.toString());
        Activator.error(Messages.SapConnectionComposite_27, t);
        logger.warn("unexpected", t);
    }

    public static boolean isConnected(MdNode sapServer) throws Exception {
        ISAPReverseAPI.ISAPConnection destination = (ISAPReverseAPI.ISAPConnection)sapServer.getConnection();
        return destination != null && destination.isValid();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.connectOrDisconnect();
            }
            catch (Throwable e) {
                SapConnectionComposite.printException(e, this.getShell());
            }
        }
    }

    public void dispose() {
        super.dispose();
        try {
            SapConnectionComposite.disConnect(this.sapServer);
        }
        catch (Exception e) {
            logger.warn("unexpected", (Throwable)e);
        }
    }

    public void connectOrDisconnect() throws Exception {
        boolean _connect = SapConnectionComposite.isConnected(this.sapServer);
        if (_connect) {
            this.connect.setText(Messages.SapConnectionComposite_28);
        } else {
            this.connect.setText(Messages.SapConnectionComposite_29);
        }
        this.host.setEnabled(!_connect);
        this.password.setEnabled(!_connect);
        this.user.setEnabled(!_connect);
        this.client.setEnabled(!_connect);
        this.system.setEnabled(!_connect);
        this.language.setEnabled(!_connect);
        this.reverseLanguage.setEnabled(!_connect);
        this.enableMs.setEnabled(!_connect);
        this.group.setEnabled(!_connect);
        this.r3name.setEnabled(!_connect);
        this.msListener.widgetSelected(null);
        this.handleConnection(_connect);
    }

    public abstract void handleConnection(boolean var1);

    public static synchronized void connect(MdNode sapServer, boolean reinit, boolean forceReconnection) throws Exception {
        String user = sapServer.evaluate("@user");
        String password = sapServer.evaluate("@password");
        if (password != null && !password.isEmpty()) {
            try {
                String decrypt;
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                password = decrypt = semaphoreManager.getStringAsciiInfo(password);
            }
            catch (Exception e) {
                logger.warn("unexpected", (Throwable)e);
            }
        }
        String language = sapServer.evaluate("@language");
        String host = sapServer.evaluate("@host");
        String enableMs = sapServer.evaluate("@ms");
        String group = sapServer.evaluate("@group");
        String r3Name = sapServer.evaluate("@r3name");
        String system = sapServer.evaluate("@system");
        String _client = sapServer.evaluate("@client");
        ISAPReverseAPI.ISAPConnection connection = null;
        Properties properties = new Properties();
        if (enableMs != null && enableMs.equals("true")) {
            properties.setProperty("jco.mshost", host);
            if (group != null && !group.isEmpty()) {
                properties.setProperty("jco.group", group);
            }
            if (r3Name != null && !r3Name.isEmpty()) {
                properties.setProperty("jco.r3name", r3Name);
            }
        } else {
            properties.setProperty("jco.ahost", host);
        }
        properties.setProperty("jco.sysnr", system);
        properties.setProperty("jco.client", _client);
        properties.setProperty("jco.user", user);
        properties.setProperty("jco.pwd", password);
        properties.setProperty("jco.lang", language);
        properties.setProperty("jco.repositoryDest", sapServer.getId());
        String moduleName = sapServer.evaluate("@module");
        connection = SAPFactoryProvider.INSTANCE.getReverseFactory(moduleName).createConnection(sapServer.getId(), properties);
        sapServer.setConnection((Object)connection);
    }

    public static synchronized void disConnect(MdNode sapServer) {
        ISAPReverseAPI.ISAPConnection connection = (ISAPReverseAPI.ISAPConnection)sapServer.getConnection();
        if (connection != null) {
            connection.close();
        }
        sapServer.setConnection(null);
    }
}

