/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.sap.properties;

import com.indy.addons.sap.reverse.SAPFactoryProvider;
import com.indy.connector.sap.core.ISAPReverseAPI;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class SapReverse
extends MdReverse {
    private ISAPReverseAPI.IJCoFunction function;
    private ISAPReverseAPI.IJCoTable codes;
    private HashMap<String, String> componentLabels;
    private HashMap<String, MyIdoc> idocs;
    private HashMap<String, MyTable> tables;
    private HashMap<String, MyDataSource> dataSources;
    private HashMap<String, String> components;
    private String language;
    private boolean tableReversed;
    private ISAPReverseAPI sapReverseAPI;
    private ISAPReverseAPI.ISAPConnection connection;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    DataTypeDesc empty = new DataTypeDesc();
    Map<String, DataTypeDesc> datatypes = new HashMap<String, DataTypeDesc>();
    Map<String, String> devClassToComponent;
    boolean commonReverse = false;
    boolean idocReversed = false;
    boolean bapiReversed = false;
    boolean rfcReversed = false;
    boolean datasourceReversed = false;
    boolean idoc = true;
    boolean bapi = true;
    boolean rfc = true;
    boolean table = true;
    boolean dataSource = true;
    MdNode currentNode;

    public void close() {
    }

    private void reverseFields(MdNode container, ISAPReverseAPI.IJCoMetaData md) {
        int k = 0;
        while (k < md.getFieldCount()) {
            this.reverseField(container, md, k);
            ++k;
        }
    }

    private void reverseField(MdNode container, ISAPReverseAPI.IJCoMetaData md, int index) {
        MdNode field = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi.field");
        field.setName(md.getName(index));
        field.setPosition(new BigInteger(String.valueOf(index)));
        container.getNode().add((Object)field);
        String tmp = md.getTypeAsString(index);
        if (tmp != null) {
            field.setAttribute("type", tmp, false);
        }
        int decimal = md.getDecimals(index);
        field.setAttribute("decimal", Integer.toString(md.getDecimals(index)), false);
        field.setAttribute("size", Integer.toString(md.getLength(index) + decimal), false);
        field.setAttribute("description", md.getDescription(index), false);
    }

    private void reverseTable(MdNode container, boolean readTable, String tableOrStructureName) throws Exception {
        String str = "";
        HashMap<String, MdNode> fields = new HashMap<String, MdNode>();
        if (readTable) {
            ReadSapTable tble = new ReadSapTable(container.getName(), null, new String[0]);
            tble.noData = true;
            tble.prepare();
            tble.execute();
            int i = 0;
            while (i < tble.getNumColumns()) {
                String FIELD_TEXT = tble.getFieldText(i);
                String FIELDNAME = tble.getFieldName(i);
                String FIELD_TYPE = tble.getFieldType(i);
                MdNode _field = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.table.field");
                container.getNode().add((Object)_field);
                _field.setName(FIELDNAME);
                if (FIELD_TEXT != null) {
                    _field.setAttribute("description", FIELD_TEXT, false);
                }
                fields.put(FIELDNAME, _field);
                ++i;
            }
        }
        String value = tableOrStructureName != null ? tableOrStructureName : container.getName();
        ReadSapTable field = new ReadSapTable("DD03L", "TABNAME = '" + value + "'", "FIELDNAME", "POSITION", "MANDATORY", "NOTNULL", "DATATYPE", "LENG", "DECIMALS", "ROLLNAME");
        field.prepare();
        field.execute();
        do {
            int i;
            String FIELDNAME;
            MdNode _field;
            if ((_field = (MdNode)fields.get(FIELDNAME = field.getString("FIELDNAME"))) == null) {
                _field = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.table.field");
                container.getNode().add((Object)_field);
                _field.setName(FIELDNAME);
                fields.put(FIELDNAME, _field);
            }
            if (_field == null) continue;
            String MANDATORY = field.getString("MANDATORY");
            String NOTNULL = field.getString("NOTNULL");
            String DATATYPE = field.getString("DATATYPE");
            String LENGTH = field.getString("LENG");
            String DECIMALS = field.getString("DECIMALS");
            String POSITION = field.getString("POSITION");
            String ROLLNAME = field.getString("ROLLNAME");
            if (NOTNULL == null || !NOTNULL.equals("X")) {
                _field.setAttribute("optional", "true", false);
            }
            if (DECIMALS != null) {
                i = Integer.valueOf(DECIMALS);
                _field.setAttribute("decimal", String.valueOf(i), false);
            }
            _field.setAttribute("type", DATATYPE, false);
            if (LENGTH != null) {
                i = Integer.valueOf(LENGTH);
                _field.setAttribute("size", String.valueOf(i), false);
            }
            _field.setPosition(new BigInteger(POSITION));
        } while (field.next());
    }

    private void reverseParameters(MdNode node, ISAPReverseAPI.IJCoParameterList list, MdNode structureContainer, MdNode parametersContainer, MdNode tablesContainer, boolean isChanging) {
        ISAPReverseAPI.IJCoListMetaData md;
        if (list != null && (md = list.getListMetaData()).getFieldCount() > 0) {
            int j = 0;
            while (j < md.getFieldCount()) {
                if (md.isStructure(j)) {
                    if (structureContainer == null) {
                        structureContainer = node;
                    } else {
                        node.getNode().add((Object)structureContainer);
                    }
                    MdNode MdStructure = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi.structure");
                    MdStructure.setPosition(new BigInteger(String.valueOf(j)));
                    structureContainer.getNode().add((Object)MdStructure);
                    String structureName = md.getName(j);
                    MdStructure.setName(structureName);
                    ISAPReverseAPI.IJCoStructure structure = list.getStructure(structureName);
                    MdStructure.setAttribute("description", md.getDescription(j), false);
                    String changing = isChanging ? "true" : "false";
                    MdStructure.setAttribute("changing", changing, false);
                    ISAPReverseAPI.IJCoMetaData colMd = structure.getMetaData();
                    this.reverseFields(MdStructure, colMd);
                } else if (md.isImport(j) || md.isExport(j) || md.isChanging(j)) {
                    if (parametersContainer == null) {
                        parametersContainer = node;
                    } else {
                        node.getNode().add((Object)parametersContainer);
                    }
                    this.reverseField(parametersContainer, (ISAPReverseAPI.IJCoMetaData)md, j);
                } else if (md.isTable(j)) {
                    if (tablesContainer == null) {
                        tablesContainer = node;
                    } else {
                        node.getNode().add((Object)tablesContainer);
                    }
                    MdNode mdTable = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi.table");
                    mdTable.setPosition(new BigInteger(String.valueOf(j)));
                    tablesContainer.getNode().add((Object)mdTable);
                    String tableName = md.getName(j);
                    mdTable.setName(tableName);
                    ISAPReverseAPI.IJCoTable table = list.getTable(tableName);
                    ISAPReverseAPI.IJCoMetaData colMd = table.getMetaData();
                    mdTable.setAttribute("description", md.getDescription(j), false);
                    if (md.isOptional(j)) {
                        mdTable.setAttribute("optional", "true", false);
                    }
                    this.reverseFields(mdTable, colMd);
                } else {
                    this.logger.debug("other");
                }
                ++j;
            }
        }
    }

    public List<MdNode> doReverse(Object[] selectedChildren) throws ReverseException {
        HashMap<CallSite, MdNode> toReverse = new HashMap<CallSite, MdNode>();
        Object[] objectArray = selectedChildren;
        int n = selectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            MdNode node = (MdNode)o;
            TreeIterator it = node.eAllContents();
            while (it.hasNext()) {
                String tmp2;
                String tmp;
                EObject o2 = (EObject)it.next();
                if (o2 instanceof MdNode && ((MdNode)o2).getDefType().equals("com.stambia.appl.sap.bapi")) {
                    try {
                        tmp = ((MdNode)o2).evaluateXpathExpression("COMPONENT_NAME");
                        tmp2 = ((MdNode)o2).evaluateXpathExpression("ABAP_NAME");
                        toReverse.put((CallSite)((Object)(tmp + "/bapis/" + tmp2)), (MdNode)o2);
                    }
                    catch (XPathExpressionException e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    continue;
                }
                if (o2 instanceof MdNode && ((MdNode)o2).getDefType().equals("com.stambia.appl.sap.idoc")) {
                    try {
                        tmp = ((MdNode)o2).evaluateXpathExpression("COMPONENT_NAME");
                        tmp2 = ((MdNode)o2).getName();
                        toReverse.put((CallSite)((Object)(tmp + "/idocs/" + tmp2)), (MdNode)o2);
                    }
                    catch (XPathExpressionException e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    continue;
                }
                if (o2 instanceof MdNode && ((MdNode)o2).getDefType().equals("com.stambia.appl.sap.table")) {
                    try {
                        tmp = ((MdNode)o2).evaluateXpathExpression("COMPONENT_NAME");
                        tmp2 = ((MdNode)o2).getName();
                        toReverse.put((CallSite)((Object)(tmp + "/tables/" + tmp2)), (MdNode)o2);
                    }
                    catch (XPathExpressionException e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    continue;
                }
                if (!(o2 instanceof MdNode) || !((MdNode)o2).getDefType().equals("com.stambia.appl.sap.dataSource")) continue;
                try {
                    tmp = ((MdNode)o2).evaluateXpathExpression("COMPONENT_NAME");
                    tmp2 = ((MdNode)o2).getName();
                    toReverse.put((CallSite)((Object)(tmp + "/dataSources/" + tmp2)), (MdNode)o2);
                }
                catch (XPathExpressionException e) {
                    this.logger.warn("unexpected", (Throwable)e);
                }
            }
            ++n2;
        }
        try {
            HashMap map = new HashMap();
            this.fireReverseStarted(toReverse.keySet().toArray(), "Bapis");
            for (MdNode node : toReverse.values()) {
                String componentName = node.evaluateXpathExpression("COMPONENT_NAME");
                if (node.getDefType().equals("com.stambia.appl.sap.bapi")) {
                    this.fireObjectReverseStarted(componentName + "/" + node.getName(), "bapi");
                    String abapName = node.evaluateXpathExpression("ABAP_NAME");
                    this.function = this.createFunction(abapName);
                    ISAPReverseAPI.IJCoParameterList list = this.function.getImportParameterList();
                    MdNode parametersContainer = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi.importParameterContainer");
                    parametersContainer.setName("ImportParameters");
                    MdNode structureContainer = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi.importStructureContainer");
                    structureContainer.setName("ImportStructures");
                    this.reverseParameters(node, list, structureContainer, parametersContainer, null, false);
                    ISAPReverseAPI.IJCoParameterList listChanging = this.function.getChangingParameterList();
                    this.reverseParameters(node, listChanging, structureContainer, parametersContainer, null, true);
                    list = this.function.getTableParameterList();
                    MdNode tablesContainer = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi.tableContainer");
                    tablesContainer.setName("Tables");
                    this.reverseParameters(node, list, null, null, tablesContainer, false);
                    list = this.function.getExportParameterList();
                    parametersContainer = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi.exportParameterContainer");
                    parametersContainer.setName("ExportParameters");
                    structureContainer = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi.exportStructureContainer");
                    structureContainer.setName("ExportStructures");
                    this.reverseParameters(node, list, structureContainer, parametersContainer, null, false);
                    this.reverseParameters(node, listChanging, structureContainer, parametersContainer, null, true);
                    this.fireObjectReverseEnded(componentName + "/" + node.getName(), "bapi");
                    continue;
                }
                if (node.getDefType().equals("com.stambia.appl.sap.idoc")) {
                    this.fireObjectReverseStarted(componentName + "/" + node.getName(), "idoc");
                    try {
                        String tid = this.connection.createTID();
                        ISAPReverseAPI.WIDocFactory iDocFactory = this.sapReverseAPI.getIDocFactory();
                        ISAPReverseAPI.WIDocDocument doc = null;
                        String idocFrom = node.evaluate("@basicType");
                        doc = idocFrom != null && !idocFrom.isEmpty() ? iDocFactory.createIDocDocument(idocFrom, node.getName()) : iDocFactory.createIDocDocument(node.getName());
                        doc.setClient("hello");
                        this.createEDI_DC40Segment(node);
                        ISAPReverseAPI.WIDocSegment segment = doc.getRootSegment();
                        ISAPReverseAPI.WIDocSegmentMetaData sm = segment.getSegmentMetaData();
                        int i = 1;
                        for (ISAPReverseAPI.WIDocSegmentMetaData child : sm.getChildren()) {
                            this.reverseSegment(node, child, i++);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    this.fireObjectReverseEnded(componentName + "/" + node.getName(), "idoc");
                    continue;
                }
                if (node.getDefType().equals("com.stambia.appl.sap.table")) {
                    this.fireObjectReverseStarted(componentName + "/" + node.getName(), "table");
                    try {
                        this.reverseTable(node, true, null);
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    this.fireObjectReverseEnded(componentName + "/" + node.getName(), "table");
                    continue;
                }
                if (!node.getDefType().equals("com.stambia.appl.sap.dataSource")) continue;
                this.fireObjectReverseStarted(componentName + "/" + node.getName(), "data Source");
                try {
                    this.reverseTable(node, false, node.getAttributeValueByXmlName("structureName"));
                }
                catch (Exception e) {
                    this.logger.warn("unexpected", (Throwable)e);
                }
                this.fireObjectReverseEnded(componentName + "/" + node.getName(), "data Source");
            }
        }
        catch (Exception e) {
            throw new ReverseException((Throwable)e);
        }
        List<Object> result = Arrays.asList(selectedChildren);
        return result;
    }

    private DataTypeDesc getDatatype(String dataElementName) {
        DataTypeDesc dtd = this.datatypes.get(dataElementName);
        if (dtd == null) {
            this.logger.debug("###############");
            dtd = this.empty;
            ReadSapTable field = new ReadSapTable("DD04L", "ROLLNAME = '" + dataElementName + "' AND AS4LOCAL = 'A'", "DECIMALS", "LENG");
            try {
                field.prepare();
                field.execute();
                int _precision = Integer.valueOf(field.getString("DECIMALS"));
                int _length = Integer.valueOf(field.getString("LENG"));
                dtd = new DataTypeDesc();
                dtd.decimal = _precision;
                dtd.length = _length;
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
            this.datatypes.put(dataElementName, dtd);
        }
        return dtd;
    }

    private int reverseRecordMetadata(MdNode mdSegment, ISAPReverseAPI.WIDocRecordMetaData rm) {
        Integer _i = rm.getNumFields();
        if (_i != null && _i > 0) {
            int i = 0;
            while (i < _i) {
                MdNode mdField = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.idoc.field", (MdNode)mdSegment);
                mdField.setPosition(BigInteger.valueOf(i + 1));
                if (rm.isDatatypeDecimal(i)) {
                    int length = rm.getLength(i);
                    int internalLength = rm.getInternalLength(i);
                    int outlength = rm.getOutputLength(i);
                    int precision = rm.getOutputLength(i) - rm.getInternalLength(i) - 1;
                    DataTypeDesc dtd = this.getDatatype(rm.getDataElementName(i));
                    if (dtd != null && dtd != this.empty) {
                        int _length;
                        int _precision = dtd.decimal;
                        if (_precision != precision) {
                            this.logger.debug(rm.getDomainName(i) + "," + rm.getDataElementName(i) + rm.getName(i) + "," + precision + "," + _precision + ",decimal");
                            precision = _precision;
                        }
                        if ((_length = dtd.length) != length) {
                            this.logger.debug(rm.getDomainName(i) + "," + rm.getDataElementName(i) + rm.getName(i) + "," + length + "," + _length + ",length");
                            length = _length;
                        }
                    }
                    if (precision > 0) {
                        mdField.setAttribute("decimal", Long.toString(precision), false);
                    }
                }
                mdField.setName(rm.getName(i));
                mdField.setAttribute("type", rm.getDataTypeName(i), false);
                mdField.setAttribute("size", Long.toString(rm.getInternalLength(i)), false);
                mdField.setAttribute("description", rm.getDescription(i), false);
                ++i;
            }
        }
        return _i;
    }

    private void reverseSegment(MdNode parent, ISAPReverseAPI.WIDocSegmentMetaData sm, int position) {
        MdNode mdSegment = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.idoc.segment", (MdNode)parent);
        mdSegment.setName(sm.getType());
        mdSegment.setPosition(BigInteger.valueOf(position));
        mdSegment.setAttribute("description", sm.getDescription(), false);
        mdSegment.setAttribute("minOccurs", Long.toString(sm.getMinOccurrence()), false);
        mdSegment.setAttribute("maxOccurs", Long.toString(sm.getMaxOccurrence()), false);
        int i = this.reverseRecordMetadata(mdSegment, sm.getRecordMetaData()) + 1;
        for (ISAPReverseAPI.WIDocSegmentMetaData child : sm.getChildren()) {
            this.reverseSegment(mdSegment, child, i++);
        }
    }

    private void createEDI_DC40Segment(MdNode parent) {
        MdNode mdSegment = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.idoc.segment", (MdNode)parent);
        mdSegment.setName("EDI_DC40");
        mdSegment.setPosition(BigInteger.valueOf(0L));
        mdSegment.setAttribute("minOccurs", Long.toString(1L), false);
        mdSegment.setAttribute("maxOccurs", Long.toString(1L), false);
        int i = 1;
        this.createFieldSegement(mdSegment, i++, "TABNAM", "CHAR", 10, "Name of Table Structure");
        this.createFieldSegement(mdSegment, i++, "MANDT", "CLNT", 3, "Client");
        this.createFieldSegement(mdSegment, i++, "DOCNUM", "CHAR", 16, "IDoc number");
        this.createFieldSegement(mdSegment, i++, "DOCREL", "CHAR", 4, "SAP Release for IDoc");
        this.createFieldSegement(mdSegment, i++, "STATUS", "CHAR", 2, "Status of IDoc");
        this.createFieldSegement(mdSegment, i++, "DIRECT", "CHAR", 1, "Direction");
        this.createFieldSegement(mdSegment, i++, "OUTMOD", "CHAR", 1, "Output mode");
        this.createFieldSegement(mdSegment, i++, "EXPRSS", "CHAR", 1, "Overriding in inbound processing");
        this.createFieldSegement(mdSegment, i++, "TEST", "CHAR", 1, "Test flag");
        this.createFieldSegement(mdSegment, i++, "IDOCTYP", "CHAR", 30, "Name of basic type");
        this.createFieldSegement(mdSegment, i++, "CIMTYP", "CHAR", 30, "Extension (defined by customer)");
        this.createFieldSegement(mdSegment, i++, "MESTYP", "CHAR", 30, "Message type");
        this.createFieldSegement(mdSegment, i++, "MESCOD", "CHAR", 3, "Message code");
        this.createFieldSegement(mdSegment, i++, "MESFCT", "CHAR", 3, "Message Function");
        this.createFieldSegement(mdSegment, i++, "STD", "CHAR", 1, "EDI standard, flag");
        this.createFieldSegement(mdSegment, i++, "STDVRS", "CHAR", 6, "EDI standard, version and release");
        this.createFieldSegement(mdSegment, i++, "STDMES", "CHAR", 6, "EDI message type");
        this.createFieldSegement(mdSegment, i++, "SNDPOR", "CHAR", 10, "Sender port (SAP System, external subsystem)");
        this.createFieldSegement(mdSegment, i++, "SNDPRT", "CHAR", 2, "Partner type of sender");
        this.createFieldSegement(mdSegment, i++, "SNDPFC", "CHAR", 2, "Partner Function of sender");
        this.createFieldSegement(mdSegment, i++, "SNDPRN", "CHAR", 10, "Partner Number of sender");
        this.createFieldSegement(mdSegment, i++, "SNDSAD", "CHAR", 21, "Sender address (SADR)");
        this.createFieldSegement(mdSegment, i++, "SNDLAD", "CHAR", 70, "Logical address of sender");
        this.createFieldSegement(mdSegment, i++, "RCVPOR", "CHAR", 10, "Receiver port");
        this.createFieldSegement(mdSegment, i++, "RCVPRT", "CHAR", 2, "Partner Type of Receiver");
        this.createFieldSegement(mdSegment, i++, "RCVPFC", "CHAR", 2, "Partner function of recipient");
        this.createFieldSegement(mdSegment, i++, "RCVPRN", "CHAR", 10, "Partner Number of Receiver");
        this.createFieldSegement(mdSegment, i++, "RCVSAD", "CHAR", 21, "Recipeint address (SADR)");
        this.createFieldSegement(mdSegment, i++, "RCVLAD", "CHAR", 70, "Logical address of recipient");
        this.createFieldSegement(mdSegment, i++, "CREDAT", "DATS", 8, "Created on");
        this.createFieldSegement(mdSegment, i++, "CRETIM", "TIMS", 6, "Created at");
        this.createFieldSegement(mdSegment, i++, "REFINT", "CHAR", 14, "Transmission file (EDI interchange)");
        this.createFieldSegement(mdSegment, i++, "REFGRP", "CHAR", 14, "Message group (EDI Message Group)");
        this.createFieldSegement(mdSegment, i++, "REFMES", "CHAR", 14, "Message (EDI Message)");
        this.createFieldSegement(mdSegment, i++, "ARCKEY", "CHAR", 70, "Key for external message archive");
        this.createFieldSegement(mdSegment, i++, "SERIAL", "CHAR", 20, "Serialization");
    }

    private void createFieldSegement(MdNode segment, int position, String name, String type, int size, String description) {
        MdNode mdField = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.idoc.field", (MdNode)segment);
        mdField.setPosition(BigInteger.valueOf(position));
        mdField.setName(name);
        mdField.setAttribute("type", type, false);
        mdField.setAttribute("size", Long.toString(size), false);
        if (description != null) {
            mdField.setAttribute("description", description, false);
        }
    }

    public AttributeRefResolver getAttributeRefResolver() {
        return null;
    }

    public List<String> getChildren(String type, String parentName, String nameFilter, String ... typesFilter) throws ReverseException {
        return null;
    }

    public List<Attribute> getMandatoryField() {
        return null;
    }

    public ISAPReverseAPI.IJCoFunction createFunction(String name) throws Exception {
        return this.sapReverseAPI.createFunction(name);
    }

    void refreshList() throws Exception {
        ReadSapTable[] readSapTableArray;
        ReadSapTable[] rsts;
        String T002 = "Language Keys";
        String DF14L = "Application Components";
        String DF14T = "Business Application Component Names";
        String TDEVC = "Object Directory & Packages";
        String TADIR1 = "Directory of Repository Objects";
        String TADIR2 = "Directory of Repository Objects";
        String EDCIM = "Extensions";
        String EDIMSG = "Output Types and Assignment to IDoc Types";
        String EDIDOT = "Short description of IDoc types";
        String TADIR3 = "Directory of Repository Objects";
        String DD02L = "SAP Tables";
        String DD02T = "SAP Table Texts";
        String BAPI_MONITOR_GETLIST = "Get List";
        Object[] reverse = new String[]{T002, DF14L, DF14T, TDEVC, TADIR1, TADIR2, EDCIM, EDIMSG, EDIDOT, TADIR3, DD02L, DD02T, BAPI_MONITOR_GETLIST};
        this.fireReverseStarted(reverse, "Preparing");
        if (!this.commonReverse) {
            String _language = this.currentNode.evaluateXpathExpression("INTERNAL_REVERSE_LANGUAGE");
            this.language = null;
            this.fireObjectReverseStarted(T002, "Table");
            if (_language != null && !_language.isEmpty()) {
                ReadSapTable rstLanguage = new ReadSapTable("T002", null, "LAISO", "SPRAS");
                rstLanguage.prepare();
                rstLanguage.execute();
                HashMap<String, String> languages = new HashMap<String, String>();
                do {
                    String LAISO = rstLanguage.getString("LAISO").trim();
                    String _SPRAS = rstLanguage.getString("SPRAS");
                    String SPRAS = null;
                    if (_SPRAS == null) continue;
                    SPRAS = _SPRAS.trim();
                    languages.put(LAISO, SPRAS);
                } while (rstLanguage.next());
                this.language = (String)languages.get(_language);
            }
            if (this.language == null) {
                this.language = "E";
            }
            this.fireObjectReverseEnded(T002, "Table");
            this.fireObjectReverseStarted(DF14L, "Table");
            ReadSapTable rst2 = new ReadSapTable("DF14L", null, "FCTR_ID", "PS_POSID");
            rst2.prepare();
            rst2.execute();
            this.components = new HashMap();
            do {
                String FCTR_ID = rst2.getString("FCTR_ID");
                String PS_POSID = rst2.getString("PS_POSID");
                if (PS_POSID == null || FCTR_ID == null) continue;
                this.components.put(FCTR_ID.trim(), PS_POSID.trim());
            } while (rst2.next());
            this.fireObjectReverseEnded(DF14L, "Table");
            this.fireObjectReverseStarted(DF14T, "Table");
            ReadSapTable rst1 = new ReadSapTable("DF14T", "LANGU = '" + this.language + "'", "FCTR_ID", "NAME");
            rst1.prepare();
            rst1.execute();
            this.componentLabels = new HashMap();
            if (rst1.hasData()) {
                do {
                    String FCTR_ID = rst1.getString("FCTR_ID").trim();
                    String NAME = rst1.getString("NAME").trim();
                    String PS_POSID = this.components.get(FCTR_ID);
                    this.componentLabels.put(PS_POSID, NAME);
                } while (rst1.next());
            }
            this.fireObjectReverseEnded(DF14T, "Table");
            this.fireObjectReverseStarted(TDEVC, "Table");
            this.devClassToComponent = new HashMap<String, String>();
            ReadSapTable rst5 = new ReadSapTable("TDEVC", null, "COMPONENT", "DEVCLASS");
            rst5.prepare();
            rst5.execute();
            if (rst5.hasData()) {
                do {
                    String COMPONENT = rst5.getString("COMPONENT").trim();
                    String DEVCLASS = rst5.getString("DEVCLASS").trim();
                    this.devClassToComponent.put(DEVCLASS, COMPONENT);
                } while (rst5.next());
            }
            this.commonReverse = true;
            this.fireObjectReverseEnded(TDEVC, "Table");
        } else {
            this.fireObjectReverseStarted(T002, "Table");
            this.fireObjectReverseEnded(T002, "Table");
            this.fireObjectReverseStarted(DF14L, "Table");
            this.fireObjectReverseEnded(DF14L, "Table");
            this.fireObjectReverseStarted(DF14T, "Table");
            this.fireObjectReverseEnded(DF14T, "Table");
            this.fireObjectReverseStarted(TDEVC, "Table");
            this.fireObjectReverseEnded(TDEVC, "Table");
        }
        if (this.idoc && !this.idocReversed) {
            MyIdoc idoc;
            rsts = new ReadSapTable[]{new ReadSapTable("TADIR", "OBJECT = 'IDOC'", "OBJ_NAME", "DEVCLASS"), new ReadSapTable("TADIR", "OBJECT = 'IEXT'", "OBJ_NAME", "DEVCLASS")};
            HashMap<String, ArrayList<String>> idocsDevClass = new HashMap<String, ArrayList<String>>();
            this.idocs = new HashMap();
            boolean i = true;
            ReadSapTable[] readSapTableArray2 = rsts;
            int DEVCLASS = rsts.length;
            int COMPONENT = 0;
            while (COMPONENT < DEVCLASS) {
                ReadSapTable rst3 = readSapTableArray2[COMPONENT];
                if (i) {
                    this.fireObjectReverseStarted(TADIR1, "Table");
                } else {
                    this.fireObjectReverseStarted(TADIR2, "Table");
                }
                rst3.prepare();
                rst3.execute();
                if (rst3.hasData()) {
                    do {
                        idoc = new MyIdoc();
                        idoc.IDOCTYPE = idoc.DOCTYPE = rst3.getString("OBJ_NAME").trim();
                        this.idocs.put(idoc.IDOCTYPE, idoc);
                        String DOCTYPE = rst3.getString("OBJ_NAME").trim();
                        String DEVCLASS2 = rst3.getString("DEVCLASS").trim();
                        String str = this.devClassToComponent.get(DEVCLASS2);
                        idoc.PS_POSID = this.components.get(str);
                        ArrayList<String> list = (ArrayList<String>)idocsDevClass.get(DEVCLASS2);
                        if (list == null) {
                            list = new ArrayList<String>();
                            idocsDevClass.put(DEVCLASS2, list);
                        }
                        list.add(DOCTYPE);
                    } while (rst3.next());
                }
                if (i) {
                    this.fireObjectReverseEnded(TADIR1, "Table");
                } else {
                    this.fireObjectReverseEnded(TADIR2, "Table");
                }
                ++COMPONENT;
            }
            this.fireObjectReverseStarted(EDCIM, "Table");
            ReadSapTable rst6 = new ReadSapTable("EDCIM", null, "CIMTYP", "IDOCTYP");
            rst6.prepare();
            rst6.execute();
            if (rst6.hasData()) {
                do {
                    String IDOCTYP = rst6.getString("IDOCTYP").trim();
                    String CIMTYP = rst6.getString("CIMTYP").trim();
                    MyIdoc idoc2 = this.idocs.get(CIMTYP);
                    if (idoc2 == null) continue;
                    idoc2.baseType = IDOCTYP;
                } while (rst6.next());
            }
            this.fireObjectReverseEnded(EDCIM, "Table");
            this.fireObjectReverseStarted(EDIMSG, "Table");
            ReadSapTable rst7 = new ReadSapTable("EDIMSG", null, "MESTYP", "IDOCTYP", "CIMTYP");
            rst7.prepare();
            rst7.execute();
            if (rst7.hasData()) {
                do {
                    MyIdoc idoc3;
                    String IDOCTYP = rst7.getString("IDOCTYP").trim();
                    String CIMTYP = rst7.getString("CIMTYP");
                    CIMTYP = CIMTYP != null ? CIMTYP.trim() : null;
                    String MESTYP = rst7.getString("MESTYP").trim();
                    if (CIMTYP != null && (idoc3 = this.idocs.get(CIMTYP)) != null) {
                        idoc3.mesTypes.add(MESTYP);
                    }
                    if ((idoc3 = this.idocs.get(IDOCTYP)) == null) continue;
                    idoc3.mesTypes.add(MESTYP);
                } while (rst6.next());
            }
            this.fireObjectReverseEnded(EDIMSG, "Table");
            this.fireObjectReverseStarted(EDIDOT, "Table");
            ReadSapTable rst4 = new ReadSapTable("EDIDOT", "LANGUA =  '" + this.language + "'", "DOCTYP", "DESCRP");
            rst4.prepare();
            rst4.execute();
            if (rst4.hasData()) {
                do {
                    String DOCTYPE;
                    if ((idoc = this.idocs.get(DOCTYPE = rst4.getString("DOCTYP"))) == null) continue;
                    idoc.DESCR = rst4.getString("DESCRP");
                } while (rst4.next());
            }
            this.fireObjectReverseEnded(EDIDOT, "Table");
            this.idocReversed = true;
        } else {
            rsts = new ReadSapTable[]{new ReadSapTable("TADIR", "OBJECT = 'IDOC'", "OBJ_NAME", "DEVCLASS"), new ReadSapTable("TADIR", "OBJECT = 'IEXT'", "OBJ_NAME", "DEVCLASS")};
            this.fireObjectReverseStarted(TADIR1, "Table");
            this.fireObjectReverseEnded(TADIR1, "Table");
            this.fireObjectReverseStarted(TADIR2, "Table");
            this.fireObjectReverseEnded(TADIR2, "Table");
            this.fireObjectReverseStarted(EDCIM, "Table");
            this.fireObjectReverseEnded(EDCIM, "Table");
            this.fireObjectReverseStarted(EDIMSG, "Table");
            this.fireObjectReverseEnded(EDIMSG, "Table");
            this.fireObjectReverseStarted(EDIDOT, "Table");
            this.fireObjectReverseEnded(EDIDOT, "Table");
        }
        if (this.table && !this.tableReversed) {
            rsts = new ReadSapTable[1];
            this.fireObjectReverseStarted(TADIR3, "Table");
            rsts[0] = new ReadSapTable("TADIR", "OBJECT = 'TABL'", "OBJ_NAME", "DEVCLASS");
            HashMap<String, MyTable> _tables = new HashMap<String, MyTable>();
            this.tables = new HashMap();
            readSapTableArray = rsts;
            int rst7 = rsts.length;
            int rst6 = 0;
            while (rst6 < rst7) {
                ReadSapTable rst3 = readSapTableArray[rst6];
                rst3.prepare();
                rst3.execute();
                if (rst3.hasData()) {
                    do {
                        MyTable _table = new MyTable();
                        _table.tabname = rst3.getString("OBJ_NAME").trim();
                        _table.devclass = rst3.getString("DEVCLASS").trim();
                        String str = this.devClassToComponent.get(_table.devclass);
                        _table.PS_POSID = this.components.get(str);
                        _tables.put(_table.tabname, _table);
                    } while (rst3.next());
                }
                ++rst6;
            }
            this.fireObjectReverseEnded(TADIR3, "Table");
            this.fireObjectReverseEnded(DD02L, "Table");
            ReadSapTable _table = new ReadSapTable("DD02L", "TABCLASS <> 'INTTAB' AND TABCLASS <> 'APPEND'", "TABNAME", "TABCLASS");
            _table.prepare();
            _table.execute();
            if (_table.hasData()) {
                do {
                    String tabbname;
                    MyTable table;
                    if ((table = (MyTable)_tables.get(tabbname = _table.getString("TABNAME"))) != null) {
                        table.type = _table.getString("TABCLASS");
                    } else {
                        table = new MyTable();
                        table.tabname = tabbname;
                    }
                    this.tables.put(tabbname, table);
                } while (_table.next());
            }
            this.fireObjectReverseEnded(DD02L, "Table");
            this.fireObjectReverseEnded(DD02T, "Table");
            _table = new ReadSapTable("DD02T", "DDLANGUAGE =  '" + this.language + "'", "TABNAME", "DDTEXT");
            _table.prepare();
            _table.execute();
            if (_table.hasData()) {
                do {
                    String tabbname;
                    MyTable table;
                    if ((table = this.tables.get(tabbname = _table.getString("TABNAME"))) == null) continue;
                    table.DESCR = _table.getString("DDTEXT");
                } while (_table.next());
            }
            this.fireObjectReverseEnded(DD02T, "Table");
            this.tableReversed = true;
        } else {
            this.fireObjectReverseStarted(TADIR3, "Table");
            this.fireObjectReverseEnded(TADIR3, "Table");
            this.fireObjectReverseEnded(DD02L, "Table");
            this.fireObjectReverseEnded(DD02L, "Table");
            this.fireObjectReverseEnded(DD02T, "Table");
            this.fireObjectReverseEnded(DD02T, "Table");
        }
        if (this.dataSource && !this.datasourceReversed) {
            rsts = new ReadSapTable[]{new ReadSapTable("ROOSOURCE", "EXSTRUCT is not null", "OLTPSOURCE", "APPLNM", "EXSTRUCT", "OBJVERS")};
            HashMap _dtsources = new HashMap();
            this.dataSources = new HashMap();
            readSapTableArray = rsts;
            int n = rsts.length;
            int n2 = 0;
            while (n2 < n) {
                ReadSapTable rst3 = readSapTableArray[n2];
                rst3.prepare();
                rst3.execute();
                if (rst3.hasData()) {
                    do {
                        MyDataSource _dtsource = new MyDataSource();
                        _dtsource.datasourcename = rst3.getString("OLTPSOURCE").trim();
                        _dtsource.exStruct = rst3.getString("EXSTRUCT").trim();
                        this.dataSources.put(_dtsource.datasourcename, _dtsource);
                    } while (rst3.next());
                }
                ++n2;
            }
            this.datasourceReversed = true;
        }
        if (this.bapi && !this.bapiReversed) {
            this.fireObjectReverseStarted(BAPI_MONITOR_GETLIST, "Bapi");
            this.function = this.createFunction("BAPI_MONITOR_GETLIST");
            if (this.function == null) {
                this.logger.debug("BAPI_MONITOR_GETLIST not found in SAP.");
                System.exit(1);
            }
            this.function.getImportParameterList().setValue("BAPIS_POTENTIAL", (Object)"X");
            this.function.execute();
            ISAPReverseAPI.IJCoStructure returnStructure = this.function.getExportParameterList().getStructure("RETURN");
            if (!returnStructure.getString("TYPE").equals("") && !returnStructure.getString("TYPE").equals("S")) {
                this.logger.debug(returnStructure.getString("MESSAGE"));
                System.exit(1);
            }
            this.codes = this.function.getTableParameterList().getTable("BAPILIST");
            this.fireObjectReverseEnded(BAPI_MONITOR_GETLIST, "Bapi");
            this.bapiReversed = true;
        } else {
            this.fireObjectReverseStarted(BAPI_MONITOR_GETLIST, "Bapi");
            this.fireObjectReverseEnded(BAPI_MONITOR_GETLIST, "Bapi");
        }
    }

    private static boolean testName(String name, String expression) {
        if (name != null) {
            String exp = SapReverse.replaceWildCharsWithGroups(expression);
            return name.toUpperCase().matches(exp.toUpperCase());
        }
        return false;
    }

    private static String replaceWildCharsWithGroups(String wild) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = wild.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '*') {
                buffer.append("(.*)");
            } else if (chars[i] == '?') {
                buffer.append("(.)");
            } else if ("+()^$.{}[]|\\".indexOf(chars[i]) != -1) {
                buffer.append('\\').append(chars[i]);
            } else {
                buffer.append(chars[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public List<MdNode> getMdNodeChildren(String type, String parentName, String nameFilter, String ... typesFilter) throws ReverseException {
        this.idoc = false;
        this.bapi = false;
        this.rfc = false;
        this.table = false;
        this.dataSource = false;
        if (typesFilter != null) {
            String[] stringArray = typesFilter;
            int n = typesFilter.length;
            int n2 = 0;
            while (n2 < n) {
                String _type = stringArray[n2];
                if (_type.equals("bapi or rfc")) {
                    this.bapi = true;
                    this.rfc = true;
                } else if (_type.equals("idoc")) {
                    this.idoc = true;
                } else if (_type.equals("table")) {
                    this.table = true;
                } else if (_type.equals("data source")) {
                    this.dataSource = true;
                }
                ++n2;
            }
        }
        try {
            if (nameFilter.length() > 0 && !nameFilter.contains("*")) {
                this.function = this.createFunction(nameFilter);
            }
            this.refreshList();
            HashMap<String, MdNode> map = new HashMap<String, MdNode>();
            ArrayList<MdNode> list = new ArrayList<MdNode>();
            HashSet<String> allComponents = new HashSet<String>();
            if (this.bapi || this.rfc) {
                if (nameFilter != null && !nameFilter.contains("*")) {
                    try {
                        ISAPReverseAPI.IJCoFunction func = this.createFunction(nameFilter);
                        if (func != null) {
                            this.createBapi(allComponents, map, list, null, null, nameFilter, nameFilter, false);
                        }
                    }
                    catch (Exception func) {
                        // empty catch block
                    }
                }
                int i = 0;
                while (i < this.codes.getNumRows()) {
                    this.codes.setRow(i);
                    String abapName = this.codes.getString("ABAPNAME");
                    String bapiName = this.codes.getString("BAPINAME");
                    String objectName = this.codes.getString("OBJECTNAME");
                    String componentName = this.codes.getString("COMP");
                    if (abapName != null && !abapName.isEmpty() && (nameFilter == null || nameFilter.isEmpty() || SapReverse.testName(bapiName, nameFilter) || SapReverse.testName(objectName, nameFilter) || SapReverse.testName(componentName, nameFilter) || SapReverse.testName(abapName, nameFilter))) {
                        this.createBapi(allComponents, map, list, componentName, objectName, bapiName, abapName, true);
                    }
                    ++i;
                }
            }
            if (this.idoc) {
                for (MyIdoc idoc : this.idocs.values()) {
                    if (nameFilter != null && !nameFilter.isEmpty() && !SapReverse.testName(idoc.DOCTYPE, nameFilter) && !SapReverse.testName(idoc.PS_POSID, nameFilter)) continue;
                    this.createIdoc(idoc, allComponents, map, list);
                }
            }
            if (this.table) {
                for (MyTable table : this.tables.values()) {
                    if (nameFilter != null && !nameFilter.isEmpty() && !SapReverse.testName(table.tabname, nameFilter) && !SapReverse.testName(table.PS_POSID, nameFilter)) continue;
                    this.createTable(table, allComponents, map, list);
                }
            }
            if (this.dataSource) {
                for (MyDataSource table : this.dataSources.values()) {
                    if (nameFilter != null && !nameFilter.isEmpty() && !SapReverse.testName(table.datasourcename, nameFilter) && !SapReverse.testName(table.PS_POSID, nameFilter)) continue;
                    this.createDataSource(table, allComponents, map, list);
                }
            }
            return list;
        }
        catch (Exception e) {
            throw new ReverseException((Throwable)e);
        }
    }

    private void createIdoc(MyIdoc idoc, HashSet<String> allComponents, HashMap<String, MdNode> map, List<MdNode> list) {
        MdNode _node = this.createComponent(allComponents, map, list, idoc.PS_POSID);
        MdNode idocContainer = null;
        if (_node == null) {
            for (MdNode __node : list) {
                if (!__node.getDefType().equals("com.stambia.appl.sap.idocContainer") || __node.getSubstituteContainer() != this.currentNode) continue;
                idocContainer = __node;
                break;
            }
        } else {
            List nodes = _node.getNodeByCode("com.stambia.appl.sap.idocContainer");
            if (nodes.size() > 0) {
                idocContainer = (MdNode)nodes.get(0);
            }
        }
        if (idocContainer == null) {
            idocContainer = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.idocContainer");
            idocContainer.setName("Idocs");
            if (_node != null) {
                _node.getNode().add((Object)idocContainer);
            } else {
                idocContainer.setSubstituteContainer((EObject)this.currentNode);
                list.add(idocContainer);
            }
        }
        MdNode _idoc = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.idoc");
        _idoc.setName(idoc.DOCTYPE);
        idocContainer.getNode().add((Object)_idoc);
        if (idoc.baseType != null) {
            _idoc.setAttribute("basicType", idoc.baseType, false);
        }
        _idoc.setAttribute("description", idoc.DESCR, false);
    }

    private void createTable(MyTable table, HashSet<String> allComponents, HashMap<String, MdNode> map, List<MdNode> list) {
        MdNode _node = this.createComponent(allComponents, map, list, table.PS_POSID);
        MdNode tableContainer = null;
        if (_node == null) {
            for (MdNode __node : list) {
                if (!__node.getDefType().equals("com.stambia.appl.sap.tableContainer") || __node.getSubstituteContainer() != this.currentNode) continue;
                tableContainer = __node;
                break;
            }
        } else {
            List nodes = _node.getNodeByCode("com.stambia.appl.sap.tableContainer");
            if (nodes.size() > 0) {
                tableContainer = (MdNode)nodes.get(0);
            }
        }
        if (tableContainer == null) {
            tableContainer = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.tableContainer");
            tableContainer.setName("Tables");
            if (_node != null) {
                _node.getNode().add((Object)tableContainer);
            } else {
                tableContainer.setSubstituteContainer((EObject)this.currentNode);
                list.add(tableContainer);
            }
        }
        MdNode _table = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.table");
        _table.setName(table.tabname);
        tableContainer.getNode().add((Object)_table);
        _table.setAttribute("description", table.DESCR, false);
        _table.setAttribute("type", table.type, false);
    }

    private void createDataSource(MyDataSource table, HashSet<String> allComponents, HashMap<String, MdNode> map, List<MdNode> list) {
        MdNode _node = this.createComponent(allComponents, map, list, table.PS_POSID);
        MdNode tableContainer = null;
        if (_node == null) {
            for (MdNode __node : list) {
                if (!__node.getDefType().equals("com.stambia.appl.sap.dataSourceContainer") || __node.getSubstituteContainer() != this.currentNode) continue;
                tableContainer = __node;
                break;
            }
        } else {
            List nodes = _node.getNodeByCode("com.stambia.appl.sap.dataSourceContainer");
            if (nodes.size() > 0) {
                tableContainer = (MdNode)nodes.get(0);
            }
        }
        if (tableContainer == null) {
            tableContainer = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.dataSourceContainer");
            if (_node != null) {
                _node.getNode().add((Object)tableContainer);
            } else {
                tableContainer.setSubstituteContainer((EObject)this.currentNode);
                list.add(tableContainer);
            }
            tableContainer.setName("Data Sources");
        }
        MdNode _table = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.dataSource");
        _table.setName(table.datasourcename);
        tableContainer.getNode().add((Object)_table);
        _table.setAttribute("description", table.DESCR, false);
        _table.setAttribute("type", table.type, false);
        _table.setAttribute("structureName", table.exStruct, false);
    }

    private MdNode createComponent(HashSet<String> allComponents, HashMap<String, MdNode> map, List<MdNode> list, String componentName) {
        MdNode _node = null;
        if (componentName != null && !componentName.isEmpty()) {
            if (!allComponents.contains(componentName)) {
                allComponents.add(componentName);
            }
            String[] splits = componentName.split("-");
            Object prec = "";
            MdNode precNode = null;
            _node = map.get(componentName);
            if (_node == null && splits != null) {
                String[] stringArray = splits;
                int n = splits.length;
                int n2 = 0;
                while (n2 < n) {
                    String n3 = stringArray[n2];
                    if (!((String)prec).isEmpty()) {
                        prec = (String)prec + "-";
                    }
                    if ((_node = map.get(prec = (String)prec + n3)) == null) {
                        _node = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.component");
                        if (precNode != null) {
                            precNode.getNode().add((Object)_node);
                        } else {
                            _node.setSubstituteContainer((EObject)this.currentNode);
                            list.add(_node);
                        }
                        String label = this.componentLabels.get(prec);
                        if (label != null) {
                            _node.setAttribute("description", label, false);
                        }
                        _node.setName((String)prec);
                        map.put((String)prec, _node);
                    }
                    precNode = _node;
                    ++n2;
                }
            }
        }
        return _node;
    }

    private void createBapi(HashSet<String> allComponents, HashMap<String, MdNode> map, List<MdNode> list, String componentName, String objectName, String bapiName, String abapName, boolean useCodes) {
        MdNode _node = this.createComponent(allComponents, map, list, componentName);
        MdNode bapiContanier = null;
        if (_node == null) {
            for (MdNode __node : list) {
                if (!__node.getDefType().equals("com.stambia.appl.sap.bapiContainer") || __node.getSubstituteContainer() != this.currentNode) continue;
                bapiContanier = __node;
                break;
            }
        } else {
            List nodes = _node.getNodeByCode("com.stambia.appl.sap.bapiContainer");
            if (nodes.size() > 0) {
                bapiContanier = (MdNode)nodes.get(0);
            }
        }
        if (bapiContanier == null) {
            bapiContanier = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapiContainer");
            bapiContanier.setName("Bapis/Rfcs");
            if (_node != null) {
                _node.getNode().add((Object)bapiContanier);
            } else {
                bapiContanier.setSubstituteContainer((EObject)this.currentNode);
                list.add(bapiContanier);
            }
        }
        MdNode _p = null;
        if (objectName != null && !objectName.isEmpty()) {
            _p = bapiContanier.getNodeByName("com.stambia.appl.sap.object", objectName);
            if (_p == null) {
                _p = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.object");
                _p.setName(objectName);
                bapiContanier.getNode().add((Object)_p);
            }
        } else {
            _p = bapiContanier;
        }
        MdNode bapi = MdFactoryHelper.createMdNode((String)"com.stambia.appl.sap.bapi");
        bapi.setName(!bapiName.isEmpty() ? bapiName : abapName);
        _p.getNode().add((Object)bapi);
        bapi.setAttribute("abapName", abapName, false);
        if (useCodes) {
            bapi.setAttribute("description", this.codes.getString("BAPI_TEXT"), false);
        }
    }

    public void setConf(String conf) {
    }

    public void setConnection(Object connection) throws ReverseException {
        if (this.connection != connection) {
            this.connection = (ISAPReverseAPI.ISAPConnection)connection;
            this.commonReverse = false;
            this.bapiReversed = false;
            this.idocReversed = false;
            this.rfcReversed = false;
            String moduleName = null;
            try {
                try {
                    moduleName = this.currentNode.evaluate("@module");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sapReverseAPI = SAPFactoryProvider.INSTANCE.getReverseFactory(moduleName).createAPI((ISAPReverseAPI.ISAPConnection)connection);
            }
            catch (Exception ex) {
                throw new ReverseException(ex.getMessage(), ex);
            }
        }
    }

    public void setNode(MdNode node) {
        this.currentNode = node;
    }

    class DataTypeDesc {
        int decimal;
        int length;

        DataTypeDesc() {
        }
    }

    class MyDataSource {
        public String datasourcename;
        String devclass;
        String DESCR;
        String PS_POSID;
        String type;
        String exStruct;

        MyDataSource() {
        }
    }

    class MyIdoc {
        public String IDOCTYPE;
        String DOCTYPE;
        String DESCR;
        String PS_POSID;
        String baseType;
        Set<String> mesTypes = new HashSet<String>();

        MyIdoc() {
        }
    }

    class MyTable {
        public String tabname;
        String devclass;
        String DESCR;
        String PS_POSID;
        String type;

        MyTable() {
        }
    }

    class ReadSapTable {
        String tableName;
        String delimiter = ",";
        String[] fields;
        String[] filters;
        Map<String, Integer> positions = new HashMap<String, Integer>();
        ISAPReverseAPI.IJCoFunction myFunction;
        boolean noData = false;
        private SapTableOutPutData data;
        private boolean hasData;
        String[] datas;

        public ReadSapTable(String tableName, String filters, String ... fields) {
            this.filters = filters != null ? filters.split(",") : null;
            this.tableName = tableName;
            this.fields = fields;
        }

        public int getNumColumns() {
            return this.myFunction.getTableParameterList().getTable("FIELDS").getNumRows();
        }

        public String getFieldText(int position) {
            ISAPReverseAPI.IJCoTable _fields = this.myFunction.getTableParameterList().getTable("FIELDS");
            _fields.setRow(position);
            return _fields.getString("FIELDTEXT");
        }

        public String getFieldName(int position) {
            ISAPReverseAPI.IJCoTable _fields = this.myFunction.getTableParameterList().getTable("FIELDS");
            _fields.setRow(position);
            return _fields.getString("FIELDNAME");
        }

        public String getFieldType(int position) {
            ISAPReverseAPI.IJCoTable _fields = this.myFunction.getTableParameterList().getTable("FIELDS");
            _fields.setRow(position);
            return _fields.getString("TYPE");
        }

        public void prepare() throws Exception {
            int n;
            this.myFunction = SapReverse.this.createFunction("/SAPDS/RFC_READ_TABLE2");
            ISAPReverseAPI.IJCoParameterList imp = this.myFunction.getImportParameterList();
            if (this.noData) {
                imp.setValue("NO_DATA", (Object)"Y");
            }
            imp.setValue("QUERY_TABLE", (Object)this.tableName);
            if (this.delimiter != null) {
                imp.setValue("DELIMITER", (Object)this.delimiter);
            }
            if (this.filters != null && this.filters.length > 0) {
                ISAPReverseAPI.IJCoTable _filters = this.myFunction.getTableParameterList().getTable("OPTIONS");
                String[] stringArray = this.filters;
                n = this.filters.length;
                int n2 = 0;
                while (n2 < n) {
                    String filter = stringArray[n2];
                    _filters.appendRow();
                    _filters.setValue("TEXT", (Object)filter);
                    ++n2;
                }
            }
            if (this.fields.length > 0) {
                ISAPReverseAPI.IJCoTable _fields = this.myFunction.getTableParameterList().getTable("FIELDS");
                int i = 0;
                String[] stringArray = this.fields;
                int n3 = this.fields.length;
                n = 0;
                while (n < n3) {
                    String field = stringArray[n];
                    this.positions.put(field, i);
                    ++i;
                    _fields.appendRow();
                    _fields.setValue("FIELDNAME", (Object)field);
                    ++n;
                }
            }
        }

        public void execute() throws Exception {
            this.myFunction.execute();
            this.data = new SapTableOutPutData();
            this.hasData();
            this.splitData();
        }

        private void splitData() {
            String tmp;
            if (this.hasData() && (tmp = this.data.getWa()) != null) {
                this.datas = tmp.split(this.delimiter);
            }
        }

        public boolean next() {
            boolean b = this.data.nextRow();
            if (b) {
                this.splitData();
            }
            return b;
        }

        public boolean hasData() {
            this.hasData = this.data.hasData();
            return this.hasData;
        }

        public String getString(String name) {
            int position = this.positions.get(name);
            if (this.datas != null && this.datas.length > position) {
                String tmp = this.datas[position];
                return tmp != null ? tmp.trim() : null;
            }
            return null;
        }

        private class SapTableOutPutData {
            private final ISAPReverseAPI.IJCoTable data128;
            private final ISAPReverseAPI.IJCoTable data512;
            private final ISAPReverseAPI.IJCoTable data2048;
            private final ISAPReverseAPI.IJCoTable data8192;
            private final ISAPReverseAPI.IJCoTable data30k;
            private ISAPReverseAPI.IJCoTable currentData;

            private SapTableOutPutData() {
                this.data128 = ReadSapTable.this.myFunction.getTableParameterList().getTable("TBLOUT128");
                this.data512 = ReadSapTable.this.myFunction.getTableParameterList().getTable("TBLOUT512");
                this.data2048 = ReadSapTable.this.myFunction.getTableParameterList().getTable("TBLOUT2048");
                this.data8192 = ReadSapTable.this.myFunction.getTableParameterList().getTable("TBLOUT8192");
                this.data30k = ReadSapTable.this.myFunction.getTableParameterList().getTable("TBLOUT30000");
                this.currentData = this.data128;
            }

            private String getWa() {
                String wa = this.currentData.getString("WA");
                if ((wa == null || wa.isEmpty()) && this.data30k != this.currentData) {
                    this.nextRow();
                    wa = this.getWa();
                }
                return wa;
            }

            private boolean nextRow() {
                boolean hasNext = this.currentData.nextRow();
                if (!hasNext && this.data30k != this.currentData) {
                    if (this.data128 == this.currentData) {
                        this.currentData = this.data512;
                    } else if (this.data512 == this.currentData) {
                        this.currentData = this.data2048;
                    } else if (this.data2048 == this.currentData) {
                        this.currentData = this.data8192;
                    } else if (this.data8192 == this.currentData) {
                        this.currentData = this.data30k;
                    }
                    hasNext = this.nextRow();
                }
                return hasNext;
            }

            private boolean hasData() {
                boolean hasData;
                boolean bl = hasData = this.currentData.getNumColumns() > 0 && this.currentData.getNumRows() > 0;
                if (!hasData && this.data30k != this.currentData) {
                    this.nextRow();
                    hasData = this.hasData();
                }
                return hasData;
            }
        }
    }
}

