/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.sap.ui;

import com.indy.addons.sap.Messages;
import com.indy.addons.sap.ui.BapiControler;
import com.indy.addons.sap.ui.EditableViewerUI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class BapiTestControl {
    private static Pattern pattern = Pattern.compile("\\((.*?)\\)");
    private EditableViewerUI inputParametersUI;
    private EditableViewerUI outputParametersUI;
    private Map<String, EditableViewerUI> inputTablesUIMap = new HashMap<String, EditableViewerUI>();
    private Map<String, EditableViewerUI> inputStructuresUIMap = new HashMap<String, EditableViewerUI>();
    private Map<String, EditableViewerUI> outputTablesUIMap = new HashMap<String, EditableViewerUI>();
    private Map<String, EditableViewerUI> outputStructuresUIMap = new HashMap<String, EditableViewerUI>();
    private Composite outputContent;

    public Composite createControl(Composite parent, BapiControler controler) {
        SashForm sash = new SashForm(parent, 256);
        sash.setLayoutData((Object)new GridData(1808));
        SashForm input = new SashForm((Composite)sash, 512);
        Composite output = new Composite((Composite)sash, 0);
        FillLayout layout = null;
        layout = new FillLayout();
        output.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.outputContent = output;
        if (!controler.getInputParametersColumns().isEmpty()) {
            Group iparameterG = new Group((Composite)input, 0);
            iparameterG.setLayoutData((Object)new GridData(1808));
            iparameterG.setLayout((Layout)new GridLayout());
            iparameterG.setText(Messages.BapiTestControl_1);
            this.inputParametersUI = new EditableViewerUI();
            Composite ui = this.inputParametersUI.createControl((Composite)iparameterG, controler.getInputParametersColumns(), EditableViewerUI.Mode.LIST, true);
            ui.setLayoutData((Object)new GridData(1808));
        }
        if (!controler.getInputStructure().isEmpty()) {
            Group istructuresG = new Group((Composite)input, 0);
            istructuresG.setLayout((Layout)new GridLayout());
            istructuresG.setText(Messages.BapiTestControl_2);
            if (!this.createTables(istructuresG, controler.getInputStructure(), EditableViewerUI.Mode.LIST, true, this.inputStructuresUIMap, null, controler.getInputStructureTooltips())) {
                istructuresG.setVisible(false);
            }
        }
        if (!controler.getTables().isEmpty()) {
            Group itablesG = new Group((Composite)input, 0);
            itablesG.setLayoutData((Object)new GridData(1808));
            itablesG.setLayout((Layout)new GridLayout());
            itablesG.setText(Messages.BapiTestControl_3);
            if (!this.createTables(itablesG, controler.getTables(), EditableViewerUI.Mode.TABLE, true, this.inputTablesUIMap, null, controler.getTablesTooltips())) {
                itablesG.setVisible(false);
            }
        }
        return sash;
    }

    private boolean createTables(Group tablesG, Map<String, List<EditableViewerUI.ColumnInfo>> inputTables, EditableViewerUI.Mode mode, boolean input, Map<String, EditableViewerUI> map, Collection<String> keyWithDatas, Map<String, String> tooltips) {
        TabFolder tabFolder = null;
        ArrayList<String> keys = new ArrayList<String>(inputTables.keySet());
        Collections.sort(keys);
        boolean isSet = false;
        for (String k : keys) {
            String tooltip;
            if (keyWithDatas != null && !keyWithDatas.contains(k)) continue;
            if (tabFolder == null) {
                tabFolder = new TabFolder((Composite)tablesG, 1024);
                tabFolder.setLayoutData((Object)new GridData(1808));
                tabFolder.setLayout((Layout)new GridLayout());
            }
            final TabItem it = new TabItem(tabFolder, 0);
            it.setText(k);
            String string = tooltip = tooltips != null ? tooltips.get(k) : null;
            if (tooltip != null) {
                it.setToolTipText(tooltip);
            }
            EditableViewerUI ui = new EditableViewerUI();
            Composite control = ui.createControl((Composite)tabFolder, inputTables.get(k), mode, input);
            control.setLayoutData((Object)new GridData(1808));
            it.setControl((Control)control);
            if (mode == EditableViewerUI.Mode.TABLE) {
                ui.addContentListener(new EditableViewerUI.IContentListener(){

                    @Override
                    public void handleContentChanged(int totalRows) {
                        String t = it.getText();
                        String[] p = pattern.split(t);
                        if (totalRows > 0) {
                            if (p.length > 0) {
                                it.setText(p[0].trim() + " (" + totalRows + ")");
                            }
                        } else {
                            it.setText(p[0].trim());
                        }
                    }
                });
            }
            map.put(k, ui);
            if (isSet) continue;
            tabFolder.setSelection(it);
            isSet = true;
        }
        return tabFolder != null;
    }

    public void setOutputDatas(BapiControler controler, List<EditableViewerUI.IElement> params, Map<String, List<EditableViewerUI.IElement>> tablesData, Map<String, List<EditableViewerUI.IElement>> structuresData) {
        Control[] controlArray = this.outputContent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            this.outputParametersUI = null;
            ++n2;
        }
        SashForm sash = new SashForm(this.outputContent, 512);
        this.outputStructuresUIMap.clear();
        this.outputTablesUIMap.clear();
        if (!params.isEmpty()) {
            Group parameterG = new Group((Composite)sash, 0);
            parameterG.setLayoutData((Object)new GridData(1808));
            parameterG.setLayout((Layout)new GridLayout());
            parameterG.setText(Messages.BapiTestControl_6);
            this.outputParametersUI = new EditableViewerUI();
            Composite ui = this.outputParametersUI.createControl((Composite)parameterG, controler.getOutputParametersColumns(), EditableViewerUI.Mode.LIST, true);
            ui.setLayoutData((Object)new GridData(1808));
        }
        if (!controler.getOutputStructures().isEmpty()) {
            ArrayList<String> tablesWithDatas = new ArrayList<String>();
            for (String k : structuresData.keySet()) {
                if (structuresData.get(k) == null || structuresData.get(k).isEmpty()) continue;
                tablesWithDatas.add(k);
            }
            Group structuresG = new Group((Composite)sash, 0);
            structuresG.setLayoutData((Object)new GridData(1808));
            structuresG.setLayout((Layout)new GridLayout());
            structuresG.setText(Messages.BapiTestControl_7);
            if (!this.createTables(structuresG, controler.getOutputStructures(), EditableViewerUI.Mode.LIST, false, this.outputStructuresUIMap, tablesWithDatas, controler.getOutputStructureTooltips())) {
                structuresG.setVisible(false);
            }
        }
        if (!controler.getTables().isEmpty()) {
            ArrayList<String> tablesWithDatas = new ArrayList<String>();
            for (String k : tablesData.keySet()) {
                if (tablesData.get(k) == null || tablesData.get(k).isEmpty()) continue;
                tablesWithDatas.add(k);
            }
            Group tablesG = new Group((Composite)sash, 0);
            tablesG.setLayoutData((Object)new GridData(1808));
            tablesG.setLayout((Layout)new GridLayout());
            tablesG.setText(Messages.BapiTestControl_8);
            if (!this.createTables(tablesG, controler.getTables(), EditableViewerUI.Mode.TABLE, false, this.outputTablesUIMap, tablesWithDatas, controler.getTablesTooltips())) {
                tablesG.setVisible(false);
            }
        }
        this.setDatas(params, tablesData, structuresData, this.outputParametersUI, this.outputTablesUIMap, this.outputStructuresUIMap);
        this.outputContent.layout(true);
    }

    public void setInputDatas(List<EditableViewerUI.IElement> params, Map<String, List<EditableViewerUI.IElement>> tablesData, Map<String, List<EditableViewerUI.IElement>> structuresData) {
        this.setDatas(params, tablesData, structuresData, this.inputParametersUI, this.inputTablesUIMap, this.inputStructuresUIMap);
    }

    protected void setDatas(List<EditableViewerUI.IElement> parameterdata, Map<String, List<EditableViewerUI.IElement>> tablesData, Map<String, List<EditableViewerUI.IElement>> structuresData, EditableViewerUI parameterUI, Map<String, EditableViewerUI> tableUI, Map<String, EditableViewerUI> structureUI) {
        EditableViewerUI ui;
        if (parameterUI != null) {
            parameterUI.setInput(parameterdata);
        }
        for (String s : tablesData.keySet()) {
            ui = tableUI.get(s);
            if (ui == null) continue;
            ui.setInput(tablesData.get(s));
        }
        for (String s : structuresData.keySet()) {
            ui = structureUI.get(s);
            if (ui == null) continue;
            ui.setInput(structuresData.get(s));
        }
    }

    public Map<String, EditableViewerUI.IElement> getInputStructureData() {
        HashMap<String, EditableViewerUI.IElement> map = new HashMap<String, EditableViewerUI.IElement>();
        for (String s : this.inputStructuresUIMap.keySet()) {
            EditableViewerUI ui = this.inputStructuresUIMap.get(s);
            if (ui == null) continue;
            EditableViewerUI.IElement e = (EditableViewerUI.IElement)((List)ui.getViewer().getInput()).get(0);
            map.put(s, e);
        }
        return map;
    }

    public List<EditableViewerUI.IElement> getInputParameterData() {
        if (this.inputParametersUI != null) {
            return (List)this.inputParametersUI.getViewer().getInput();
        }
        return Collections.EMPTY_LIST;
    }

    public Map<String, List<EditableViewerUI.IElement>> getInputTableData() {
        HashMap<String, List<EditableViewerUI.IElement>> map = new HashMap<String, List<EditableViewerUI.IElement>>();
        for (String s : this.inputTablesUIMap.keySet()) {
            EditableViewerUI ui = this.inputTablesUIMap.get(s);
            if (ui == null) continue;
            map.put(s, (List)ui.getViewer().getInput());
        }
        return map;
    }
}

