/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.google.platform.runtime;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class GooglePlatformCredentialsHelper {
    public static final String PRIVATE_KEY = "private_key";
    public static final String PRIVATE_KEY_ID = "private_key_id";
    public static final String CLIENT_EMAIL = "client_email";
    public static final String LOCAL_FILE_CREDENTIAL_MODE = "LocalFile";
    public static final String APPLICATION_DEFAULT_CREDENTIAL_MODE = "ApplicationDefault";
    public static final String STRING_CREDENTIAL_MODE = "String";
    private static final String GOOGLE_APPLICATION_CREDENTIALS_ENVIRONMENT_VARIABLE = "GOOGLE_APPLICATION_CREDENTIALS";
    private static final String CREDENTIALS_NOT_FOUND_MESSAGE = "Unable to find credentials information to connect to Google Cloud, make sure you configured the connection properly.";
    private static GsonFactory jacksonFactory;

    public static Map<String, String> getCredentials(String credentialsMode, String jsonCredentialsFile, String jsonCredentialsString) {
        Map<String, String> credentialsMap;
        block36: {
            credentialsMap = null;
            if (LOCAL_FILE_CREDENTIAL_MODE.equals(credentialsMode) && jsonCredentialsFile != null && !jsonCredentialsFile.isEmpty()) {
                try {
                    Throwable throwable = null;
                    Object var5_11 = null;
                    try (FileInputStream credentialsStream22 = new FileInputStream(jsonCredentialsFile);){
                        credentialsMap = GooglePlatformCredentialsHelper.getCredentialsMap(credentialsStream22);
                        break block36;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(CREDENTIALS_NOT_FOUND_MESSAGE, e);
                }
            }
            if (APPLICATION_DEFAULT_CREDENTIAL_MODE.equals(credentialsMode)) {
                String credentials = System.getenv(GOOGLE_APPLICATION_CREDENTIALS_ENVIRONMENT_VARIABLE);
                try {
                    Throwable throwable = null;
                    Object credentialsStream22 = null;
                    try (FileInputStream credentialsStream = new FileInputStream(credentials);){
                        credentialsMap = GooglePlatformCredentialsHelper.getCredentialsMap(credentialsStream);
                        break block36;
                    }
                    catch (Throwable credentialsStream22) {
                        if (throwable == null) {
                            throwable = credentialsStream22;
                        } else if (throwable != credentialsStream22) {
                            throwable.addSuppressed(credentialsStream22);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(CREDENTIALS_NOT_FOUND_MESSAGE, e);
                }
            }
            if (STRING_CREDENTIAL_MODE.equals(credentialsMode) && jsonCredentialsString != null && !jsonCredentialsString.isEmpty()) {
                try {
                    Throwable credentials = null;
                    Object var5_16 = null;
                    try (ByteArrayInputStream credentialsStream = new ByteArrayInputStream(jsonCredentialsString.getBytes(Charset.forName("UTF-8")));){
                        credentialsMap = GooglePlatformCredentialsHelper.getCredentialsMap(credentialsStream);
                        break block36;
                    }
                    catch (Throwable throwable) {
                        if (credentials == null) {
                            credentials = throwable;
                        } else if (credentials != throwable) {
                            credentials.addSuppressed(throwable);
                        }
                        throw credentials;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(CREDENTIALS_NOT_FOUND_MESSAGE, e);
                }
            }
            throw new RuntimeException(CREDENTIALS_NOT_FOUND_MESSAGE);
        }
        return credentialsMap;
    }

    private static Map<String, String> getCredentialsMap(InputStream credentialsStream) throws Exception {
        HashMap<String, String> credentialMap = new HashMap<String, String>();
        JsonObjectParser parser = new JsonObjectParser(GooglePlatformCredentialsHelper.getGsonFactory());
        GenericJson fileContents = (GenericJson)parser.parseAndClose(credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
        credentialMap.put(CLIENT_EMAIL, (String)fileContents.get((Object)CLIENT_EMAIL));
        credentialMap.put(PRIVATE_KEY_ID, (String)fileContents.get((Object)PRIVATE_KEY_ID));
        credentialMap.put(PRIVATE_KEY, (String)fileContents.get((Object)PRIVATE_KEY));
        return credentialMap;
    }

    private static JsonFactory getGsonFactory() {
        if (jacksonFactory == null) {
            jacksonFactory = new GsonFactory();
        }
        return jacksonFactory;
    }
}

