/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.table.storage.runtime;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableServiceClient;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.data.tables.models.ListEntitiesOptions;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.TableItem;
import com.semarchy.xdi.component.azure.table.storage.runtime.AzureTableMetadata;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AzureTableStorageReverser {
    private TableServiceClient tableServiceClient;
    private TableClient tableClient;
    private static Set<String> filteredProperties = new HashSet<String>();

    static {
        filteredProperties.add("odata.type");
        filteredProperties.add("odata.id");
        filteredProperties.add("odata.editLink");
        filteredProperties.add("odata.etag");
    }

    public void initServiceClient(String connString) {
        TableServiceClientBuilder builder = new TableServiceClientBuilder();
        builder.connectionString(connString);
        this.tableServiceClient = builder.buildClient();
    }

    private void initTableClient(String tableName) {
        this.tableClient = this.tableServiceClient.getTableClient(tableName);
    }

    public Set<String> getTables() {
        HashSet<String> allTables = new HashSet<String>();
        for (TableItem table : this.tableServiceClient.listTables()) {
            allTables.add(table.getName());
        }
        return allTables;
    }

    public Map<String, String> getTableProperties(String tableName, int sampleSize) {
        this.initTableClient(tableName);
        PagedIterable entities = this.tableClient.listEntities(new ListEntitiesOptions().setTop(Integer.valueOf(sampleSize)), null, null);
        HashMap<String, String> properties = new HashMap<String, String>();
        for (TableEntity entity : ((PagedResponse)entities.iterableByPage().iterator().next()).getValue()) {
            for (Map.Entry entry : entity.getProperties().entrySet()) {
                if (filteredProperties.contains(entry.getKey()) || ((String)entry.getKey()).endsWith("@odata.type")) continue;
                properties.put((String)entry.getKey(), AzureTableMetadata.ODataType.fromObject(entry.getValue()).toODataName());
            }
        }
        return properties;
    }

    protected Map<String, AzureTableMetadata.ODataType> getQueryProperties(String tableName, String filter, List<String> select, int sampleSize) {
        this.initTableClient(tableName);
        HashMap<String, AzureTableMetadata.ODataType> properties = new HashMap<String, AzureTableMetadata.ODataType>();
        ListEntitiesOptions query = new ListEntitiesOptions();
        if (filter != null && !filter.isEmpty()) {
            query.setFilter(filter);
        }
        if (select != null && !select.isEmpty()) {
            query.setSelect(select);
        }
        query.setTop(Integer.valueOf(sampleSize));
        PagedIterable entities = this.tableClient.listEntities(query, Duration.ofSeconds(10L), null);
        for (TableEntity entity : entities) {
            for (Map.Entry entry : entity.getProperties().entrySet()) {
                if (filteredProperties.contains(entry.getKey()) || ((String)entry.getKey()).endsWith("@odata.type")) continue;
                properties.put((String)entry.getKey(), AzureTableMetadata.ODataType.fromObject(entry.getValue()));
            }
        }
        return properties;
    }
}

