/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.addons.salesforce;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.action.common.SecretValueImpl;
import com.indy.engine.addons.salesforce.Messages;
import com.indy.runtime.json.JsonUtils;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.sforce.async.ConcurrencyMode;
import com.stambia.salesforce.connector.BulkConnectonHelper;
import com.stambia.salesforce.connector.SalesForceBulkConnection;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class SForceBaseActionCodeI
extends ActionCodeTypeI {
    private static final String SF_BULK_CONCURRENCY_MODE = "SF_BULK_CONCURRENCY_MODE";
    protected String login;
    protected String password;
    protected String authenticationEndPoint;
    private String securityToken;
    private String serviceEndpoint;
    protected List<String> sObjectList;
    private HashMap<String, QueryInf> queryList;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    protected Integer sForceConnectionTimeout;
    protected Integer sForceReadTimeout;
    private boolean removeSpecialChar;
    protected OAuth2Metadata otmd;
    private int sForceReadBulkWaitTimeout;
    private long sForceReadBulkWaitPollInt;
    private int sForceReadBulkChunkSize;
    private boolean disableLogout;
    private Boolean useTmpFile4sForceResponse;
    protected ConcurrencyMode sForceBulkConcurrencyMode;
    private Function<Object, String> resolveFunction = t -> {
        if (t instanceof String || t instanceof Integer) {
            try {
                return new SecretValueImpl(t.toString(), s -> this.getActionContext().decryptString(s), s -> this.getActionContext().encryptString(s)).resolveStringSecretValue();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    };

    public int prepare(ResultSet sourceRSet) throws EngineExceptionI {
        String internalSForceBulkConcurrencyMode = this.getLocalStringBindedParameter(sourceRSet, SF_BULK_CONCURRENCY_MODE, "Serial");
        this.sForceBulkConcurrencyMode = ConcurrencyMode.valueOf((String)internalSForceBulkConcurrencyMode);
        this.proxyHost = this.getLocalStringBindedParameter(sourceRSet, "PROXY_HOST", null);
        this.proxyPort = this.getLocalIntegerBindedParameter(sourceRSet, "PROXY_PORT", null);
        this.proxyUser = this.getLocalStringBindedParameter(sourceRSet, "PROXY_USER", null);
        this.proxyPassword = this.getLocalStringBindedParameter(sourceRSet, "PROXY_PASSWORD", null);
        this.useTmpFile4sForceResponse = this.getLocalBooleanBindedParameter(sourceRSet, "SFORCE_RESPONSE_USE_TMP_FILE", Boolean.FALSE);
        if (this.proxyPassword != null) {
            this.proxyPassword = this.decryptString(this.proxyPassword);
        }
        Properties properties = null;
        String interlanJsonProps = this.getLocalStringBindedParameter(sourceRSet, "SFORCE_AUTH_JSON", null);
        String internalAuthProps = this.getLocalStringBindedParameter(sourceRSet, "SFORCE_AUTH_PROPERTIES", null);
        if (interlanJsonProps != null) {
            try {
                properties = this.authJsonToProperties(interlanJsonProps);
            }
            catch (Exception e) {
                throw new EngineExceptionI(Messages.getString("SForceBaseActionCodeI.0"));
            }
        }
        if (internalAuthProps != null) {
            properties = new Properties();
            try {
                properties.load(new ByteArrayInputStream(this.getLocalStringBindedParameter(sourceRSet, "SFORCE_AUTH_PROPERTIES", "").getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e1) {
                throw new EngineExceptionI(Messages.getString("SForceBaseActionCodeI.1"));
            }
        }
        if (properties == null) {
            this.login = this.getLocalStringBindedParameter(sourceRSet, "SFORCE_LOGIN");
            this.password = this.getLocalPasswordParameter(sourceRSet, "SFORCE_PASSWORD", "SFORCE_UNCRYPTED_PASSWORD");
        } else {
            this.login = this.getLocalStringBindedParameter(sourceRSet, "SFORCE_LOGIN", null);
            this.password = this.getLocalPasswordParameter(sourceRSet, "SFORCE_PASSWORD", "SFORCE_UNCRYPTED_PASSWORD", null);
            this.otmd = new OAuth2Metadata();
            this.otmd.securityToken = this.getLocalStringBindedParameter(sourceRSet, "SFORCE_SECURITY_TOKEN", null);
            this.otmd.flowType = properties.getProperty("flowType");
            this.otmd.password = interlanJsonProps != null ? properties.getProperty("password") : (properties.getProperty("password") == null ? null : this.decryptString(properties.getProperty("password")));
            this.otmd.login = properties.getProperty("username");
            this.otmd.tokenEndpoint = properties.getProperty("tokenEndpoint");
            this.otmd.authEndpoint = properties.getProperty("authorizationEndpoint");
            this.otmd.clientId = properties.getProperty("clientId");
            this.otmd.clientSecret = interlanJsonProps != null ? properties.getProperty("clientSecret") : this.decryptString(properties.getProperty("clientSecret"));
            this.otmd.refreshToken = properties.getProperty("refreshToken");
            this.otmd.accessToken = properties.getProperty("accessToken");
            this.otmd.tokenEndpointHttpMethod = properties.getProperty("tokenEndpointHttpMethod") == null ? "POST" : properties.getProperty("tokenEndpointHttpMethod");
            this.otmd.clientCredentialPolicy = OAuth2Utils.computeClientCredentialPolicy((Properties)properties);
            this.otmd.proxyHost = this.proxyHost;
            this.otmd.proxyPort = this.proxyPort == null ? -1 : this.proxyPort;
            this.otmd.proxyUser = this.proxyUser;
            this.otmd.proxyPassword = this.proxyPassword;
            HashMap<String, String> additionalParameters = new HashMap<String, String>();
            for (Object key : properties.keySet()) {
                if (((String)key).matches("properties\\.(.*)\\.key") && properties.get(key).equals("instance_url")) {
                    this.serviceEndpoint = properties.getProperty(((String)key).split(".key")[0]);
                    continue;
                }
                if (((String)key).matches("authorizationParameter\\.(.*)\\.key") && properties.get(key).equals("scope")) {
                    this.otmd.scope = properties.getProperty(((String)key).split(".key")[0]);
                    continue;
                }
                if (((String)key).matches("authorizationParameter\\.(.*)\\.key") && properties.get(key).equals("state")) {
                    this.otmd.state = properties.getProperty(((String)key).split(".key")[0]);
                    continue;
                }
                if (((String)key).matches("authorizationParameter\\.(.*)\\.key") && properties.get(key).equals("token_endpoint")) {
                    this.otmd.tokenEndpoint = properties.getProperty(((String)key).split(".key")[0]);
                    continue;
                }
                if (!((String)key).matches("authorizationParameter\\.(.*)\\.key")) continue;
                String parameterKey = properties.getProperty((String)key);
                String parameterValue = properties.getProperty(((String)key).split(".key")[0]);
                additionalParameters.put(parameterKey, parameterValue);
            }
            if (!additionalParameters.isEmpty()) {
                this.otmd.additionnalParameters = additionalParameters;
            }
        }
        this.securityToken = this.getLocalStringBindedParameter(sourceRSet, "SFORCE_SECURITY_TOKEN", null);
        this.authenticationEndPoint = this.getLocalStringBindedParameter(sourceRSet, "SFORCE_AUTH_END_POINT", null);
        this.sForceConnectionTimeout = this.getLocalIntegerBindedParameter(sourceRSet, "SF_CONNECTION_TIMEOUT", null);
        this.sForceReadTimeout = this.getLocalIntegerBindedParameter(sourceRSet, "SF_READ_TIMEOUT", null);
        this.sForceReadBulkWaitTimeout = this.getLocalIntegerBindedParameter(sourceRSet, "SF_READ_BULK_WAIT_TIMEOUT", -1);
        this.sForceReadBulkWaitPollInt = this.getLocalLongBindedParameter(sourceRSet, "SF_READ_BULK_WAIT_POLL_INT", 1000L);
        this.sForceReadBulkChunkSize = this.getLocalIntegerBindedParameter(sourceRSet, "SF_READ_BULK_CHUNK_SIZE", 0);
        this.removeSpecialChar = this.getLocalBooleanBindedParameter(sourceRSet, "SF_CLEAN_INVALID_CHAR", false);
        this.disableLogout = this.getLocalBooleanBindedParameter(sourceRSet, "SF_DISABLE_LOGOUT", false);
        if (this.serviceEndpoint == null) {
            this.serviceEndpoint = this.authenticationEndPoint;
        }
        return 0;
    }

    SalesForceBulkConnection connect() throws EngineExceptionI {
        try {
            return BulkConnectonHelper.createConnection(this.login, this.password, this.securityToken, this.authenticationEndPoint, this.removeSpecialChar, this.useTmpFile4sForceResponse, this.sForceReadBulkWaitTimeout, this.sForceReadBulkWaitPollInt, this.sForceReadBulkChunkSize, this.disableLogout, this.proxyHost, this.proxyPort, this.proxyUser, this.proxyPassword, this.sForceConnectionTimeout, this.sForceReadTimeout, this.otmd, this.serviceEndpoint, this.resolveFunction);
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("SForceBaseActionCodeI.2"), (Throwable)e);
        }
    }

    void parseQueries() throws EngineExceptionI {
        String queries;
        String string = queries = this.actionTxtCode != null && !this.actionTxtCode.equals("") ? this.actionTxtCode : null;
        if (queries == null) {
            throw new EngineExceptionI(Messages.getString("SForceBaseActionCodeI.5"));
        }
        XMLEventReader reader = null;
        try {
            try {
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setProperty("javax.xml.stream.supportDTD", false);
                inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(queries.getBytes());){
                    reader = inputFactory.createXMLEventReader(inputStream, StandardCharsets.UTF_8.name());
                    this.sObjectList = new ArrayList<String>();
                    this.queryList = new HashMap();
                    QueryInf qi = null;
                    while (reader.hasNext()) {
                        EndElement ee;
                        XMLEvent event = reader.nextEvent();
                        if (qi != null && event.isCharacters()) {
                            this.sObjectList.add(qi.sObjectType);
                            qi.query = event.asCharacters().getData();
                            this.queryList.put(qi.sObjectType, qi);
                        }
                        if (event.isStartElement()) {
                            StartElement se = event.asStartElement();
                            if (qi != null && se.getName().getLocalPart().equals("field")) {
                                String tmp;
                                QueryInf.FieldInf fi = qi.addField();
                                try {
                                    fi.name = tmp = se.getAttributeByName(new QName("name")).getValue();
                                }
                                catch (Exception e) {
                                    this.logger.debug("cannot get attribute", (Throwable)e);
                                }
                                try {
                                    fi.xmlType = tmp = se.getAttributeByName(new QName("xmlType")).getValue();
                                }
                                catch (Exception e) {
                                    this.logger.debug("cannot get attribute", (Throwable)e);
                                }
                                try {
                                    tmp = se.getAttributeByName(new QName("fixedwidth")).getValue();
                                    fi.fixedWidth = Integer.valueOf(tmp);
                                }
                                catch (Exception e) {
                                    this.logger.debug("cannot get attribute", (Throwable)e);
                                }
                                continue;
                            }
                            if (!se.getName().getLocalPart().equals("query")) continue;
                            qi = new QueryInf();
                            qi.sObjectType = event.asStartElement().getAttributeByName(new QName("sObjectName")).getValue();
                            qi.getDeletedData = false;
                            try {
                                qi.getDeletedData = DatatypeConverter.parseBoolean((String)se.getAttributeByName(new QName("getDeletedRow")).getValue());
                            }
                            catch (Exception e) {
                                this.logger.debug("cannot get attribute", (Throwable)e);
                            }
                            if (!qi.getDeletedData) continue;
                            try {
                                qi.deletetionStartDate = DatatypeConverter.parseDateTime((String)se.getAttributeByName(new QName("deletetionStartDate")).getValue());
                            }
                            catch (Exception e) {
                                qi.deletetionStartDate = null;
                            }
                            try {
                                qi.deletetionEndDate = DatatypeConverter.parseDateTime((String)se.getAttributeByName(new QName("deletetionEndDate")).getValue());
                            }
                            catch (Exception e) {
                                qi.deletetionEndDate = null;
                                this.logger.debug("cannot get attribute", (Throwable)e);
                            }
                            if (qi.deletetionStartDate != null) continue;
                            try {
                                qi.offset = Integer.valueOf(se.getAttributeByName(new QName("deletionDateOffset")).getValue());
                            }
                            catch (Exception e) {
                                qi.offset = 1;
                                this.logger.debug("cannot get attribute", (Throwable)e);
                            }
                            try {
                                String tmp = se.getAttributeByName(new QName("deletionDateOffsetUnit")).getValue();
                                if (tmp.equals("DAY")) {
                                    qi.offsetUnit = 5;
                                    continue;
                                }
                                if (tmp.equals("HOUR")) {
                                    qi.offsetUnit = 10;
                                    continue;
                                }
                                if (tmp.equals("MINUTE")) {
                                    qi.offsetUnit = 12;
                                    continue;
                                }
                                if (tmp.equals("MILLISECOND")) {
                                    qi.offsetUnit = 12;
                                    continue;
                                }
                                if (tmp.equals("MONTH")) {
                                    qi.offsetUnit = 2;
                                    continue;
                                }
                                qi.offsetUnit = 5;
                            }
                            catch (Exception e) {
                                qi.offsetUnit = 5;
                                this.logger.debug("cannot get attribute", (Throwable)e);
                            }
                            continue;
                        }
                        if (!event.isEndElement() || !(ee = event.asEndElement()).getName().getLocalPart().equals("query")) continue;
                        qi = null;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | FactoryConfigurationError | XMLStreamException e) {
                throw new EngineExceptionI(e);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    this.logger.warn("cannot close", (Throwable)e);
                }
            }
        }
    }

    public abstract int executeSimpleCode() throws EngineExceptionI;

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public QueryInf quetQuery(String sObject) {
        return this.queryList.get(sObject);
    }

    private void doAuthJsonToProperties(Object node, String name, Properties props) {
        block3: {
            block4: {
                block2: {
                    if (!(node instanceof String)) break block2;
                    props.put(name, node);
                    break block3;
                }
                if (!(node instanceof Map)) break block4;
                int i = 1;
                for (String k : ((Map)node).keySet()) {
                    if (!(((Map)node).get(k) instanceof String)) continue;
                    props.put(name + "." + i + ".key", k);
                    props.put(name + "." + i, ((Map)node).get(k));
                    ++i;
                }
                break block3;
            }
            if (!(node instanceof List)) break block3;
            int i = 1;
            for (Object v : (List)node) {
                if (!(v instanceof String)) continue;
                props.put(name + "." + i, v);
                ++i;
            }
        }
    }

    private Properties authJsonToProperties(String json) throws Exception {
        Map root = (Map)JsonUtils.jsonNodeToObject((String)json);
        Map node = (Map)root.get("security");
        Properties props = new Properties();
        for (Map.Entry e : node.entrySet()) {
            this.doAuthJsonToProperties(e.getValue(), (String)e.getKey(), props);
        }
        return props;
    }

    class QueryInf {
        String sObjectType;
        String query;
        int offsetUnit = 5;
        int offset;
        public boolean getDeletedData;
        public Calendar deletetionStartDate;
        public Calendar deletetionEndDate;
        List<FieldInf> sortedField = new ArrayList<FieldInf>();

        QueryInf() {
        }

        public FieldInf addField() {
            FieldInf fi = new FieldInf();
            this.sortedField.add(fi);
            return fi;
        }

        public List<String> getSortedFieldNames() {
            ArrayList<String> list = new ArrayList<String>();
            for (FieldInf fi : this.sortedField) {
                list.add(fi.name);
            }
            return list;
        }

        public Map<String, String> getXmlTypes() {
            HashMap<String, String> map = new HashMap<String, String>();
            for (FieldInf fi : this.sortedField) {
                map.put(fi.name, fi.xmlType);
            }
            return map;
        }

        class FieldInf {
            String name;
            int fixedWidth = -1;
            public String xmlType;

            FieldInf() {
            }
        }
    }
}

