/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.bulk.jobController;

import com.indy.engine.addons.salesforce.SForceErrorAcceptance;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.stambia.salesforce.bulk.configuration.SfBulkConfiguration;
import com.stambia.salesforce.bulk.jobController.Messages;
import com.stambia.salesforce.bulk.jobController.RawResponseLine;
import com.stambia.salesforce.bulk.recordState.JobRecordStateV2;
import com.stambia.salesforce.bulk.utils.SalesForceBulkUtils;
import endolabs.salesforce.bulkv2.Bulk2Client;
import endolabs.salesforce.bulkv2.request.CreateJobRequest;
import endolabs.salesforce.bulkv2.response.CreateJobResponse;
import endolabs.salesforce.bulkv2.response.GetJobInfoResponse;
import endolabs.salesforce.bulkv2.type.JobStateEnum;
import endolabs.salesforce.bulkv2.type.OperationEnum;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;

public class JobControllerV2
implements Runnable {
    private final Bulk2Client client;
    private final OperationEnum operation;
    private final String sfObjectName;
    private final Set<String> externalIdFieldNames;
    private final String folderPath;
    private final String fileNamePattern;
    private final Map<String, Integer> recordIdToNumber;
    private final Map<Integer, Set<Integer>> jobNumberToRecordNumbers = new HashMap<Integer, Set<Integer>>();
    private final Map<String, JobStatus> jobToState = new ConcurrentHashMap<String, JobStatus>();
    private final Map<String, JobRecordStateV2> jobToRecordState = new ConcurrentHashMap<String, JobRecordStateV2>();
    private final Set<String> processingJobs = new ConcurrentSkipListSet<String>();
    private final Set<Integer> skippedRecords = new ConcurrentSkipListSet<Integer>();
    private final Deque<RunnableWithExtraInfo> queue = new ArrayDeque<RunnableWithExtraInfo>();
    private final Thread checkJobsStatus = new Thread(this);
    private final Logger logger;
    private final int pollInterval;
    private final Map<String, Integer> jobIdToNumber = new HashMap<String, Integer>();
    private boolean checkJobsStatusInterrupted = true;
    private Exception threadException = null;
    private int maxConcurrentBatch;
    private SForceErrorAcceptance errorAcceptance;
    private static final int MAX_RETRY = 4;
    private Integer readTimeout;
    private Integer connectionTimeout;

    public JobControllerV2(SfBulkConfiguration sfBulkConfiguration, Map<String, Integer> recordIdToNumber) throws Exception {
        SfBulkConfiguration.SalesforceParameter salesforceParameter = sfBulkConfiguration.getSalesforceParameter();
        this.sfObjectName = salesforceParameter.getName();
        this.pollInterval = salesforceParameter.getPollInterval();
        this.externalIdFieldNames = salesforceParameter.getExternalIdFieldNames();
        this.maxConcurrentBatch = salesforceParameter.getBulkMaxConcurrentBatch();
        this.errorAcceptance = salesforceParameter.getErrorAcceptance();
        SfBulkConfiguration.WorkingFolder workingFolder = sfBulkConfiguration.getWorkingFolder();
        this.folderPath = workingFolder.getFolderPath();
        this.fileNamePattern = workingFolder.getFileNamePattern();
        this.checkJobsStatus.setName("JobController Check Job Status Thread");
        this.logger = sfBulkConfiguration.getLogger();
        this.recordIdToNumber = recordIdToNumber;
        this.operation = salesforceParameter.getOperation();
        OAuth2Metadata oAuth2Parameter = sfBulkConfiguration.getOAuth2Parameter();
        String endpoint = sfBulkConfiguration.getSalesforceParameter().getEndpoint();
        this.readTimeout = salesforceParameter.getReadTimeout();
        this.connectionTimeout = salesforceParameter.getConnectionTimeout();
        this.client = SalesForceBulkUtils.getBulk2Client(oAuth2Parameter, endpoint, this.readTimeout, this.connectionTimeout);
        String message = Messages.getString("JobControllerV2.0") + this.sfObjectName + Messages.getString("JobControllerV2.1") + String.valueOf((Object)this.operation) + Messages.getString("JobControllerV2.2") + this.folderPath;
        this.logger.info(message);
    }

    public final Map<String, JobStatus> getJobToState() {
        return this.jobToState;
    }

    public final Set<String> getProcessingJobs() {
        return this.processingJobs;
    }

    public final Exception getThreadException() {
        return this.threadException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendNewCsvJob(int jobNumber, String csvFileName, Collection<Integer> recordsNumbers, Consumer<String> jobIdCallback) {
        HashSet<Integer> lostRecordsNumbers = new HashSet<Integer>(recordsNumbers);
        this.jobNumberToRecordNumbers.put(jobNumber, lostRecordsNumbers);
        Runnable createJobRunnable = () -> this.createJob(jobNumber, csvFileName, jobIdCallback);
        if (this.maxConcurrentBatch != -1 && this.getNumberOfJobProcessing() >= (long)this.maxConcurrentBatch) {
            Deque<RunnableWithExtraInfo> deque = this.queue;
            synchronized (deque) {
                this.queue.add(new RunnableWithExtraInfo(createJobRunnable, recordsNumbers));
            }
        } else {
            createJobRunnable.run();
        }
        if (this.checkJobsStatusInterrupted) {
            this.checkJobsStatusInterrupted = false;
            this.checkJobsStatus.start();
        }
    }

    private long getNumberOfJobProcessing() {
        return this.jobToState.values().stream().filter(jobStatus -> jobStatus == JobStatus.PROCESSING).count();
    }

    private void createJob(int jobNumber, String csvFileName, Consumer<String> jobIdCallback) {
        CreateJobResponse jobInfo = this.operation == OperationEnum.UPSERT ? this.client.createJob(this.sfObjectName, this.operation, (CreateJobRequest.Builder request) -> {
            if (this.externalIdFieldNames != null) {
                for (String externalIdFieldName : this.externalIdFieldNames) {
                    request = request.withExternalIdFieldName(externalIdFieldName);
                }
            }
        }) : this.client.createJob(this.sfObjectName, this.operation);
        String jobId = jobInfo.getId();
        String fullFilePath = this.folderPath + "/" + csvFileName;
        File csvFile = new File(fullFilePath);
        this.client.uploadJobData(jobId, csvFile);
        GetJobInfoResponse jobInfoResponse = this.client.getJobInfo(jobId);
        JobStateEnum jobState = jobInfoResponse.getState();
        if (jobState == JobStateEnum.OPEN) {
            this.client.closeJob(jobId);
        }
        this.jobToState.put(jobId, JobStatus.PROCESSING);
        this.processingJobs.add(jobId);
        String message = Messages.getString("JobControllerV2.3") + csvFileName + Messages.getString("JobControllerV2.4") + jobId + Messages.getString("JobControllerV2.5") + jobNumber;
        this.logger.info(message);
        this.jobIdToNumber.put(jobId, jobNumber);
        jobIdCallback.accept(jobId);
    }

    @Override
    public final void run() {
        AtomicInteger errors = new AtomicInteger(0);
        while (this.threadException == null && !this.checkJobsStatusInterrupted) {
            CallSite message;
            try {
                TimeUnit.MILLISECONDS.sleep(this.pollInterval);
                for (String jobId : this.processingJobs) {
                    GetJobInfoResponse jobInfo = this.client.getJobInfo(jobId);
                    if (!jobInfo.isFinished()) continue;
                    this.processFinishedJob(errors, jobId);
                }
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                this.logger.error(exception.getMessage(), (Throwable)exception);
                message = Messages.getString("JobControllerV2.6") + String.valueOf(this.jobToState);
                this.logger.info((String)((Object)message));
                continue;
            }
            catch (Exception exception) {
                try {
                    this.logger.error(exception.getMessage(), (Throwable)exception);
                    this.threadException = exception;
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    message = Messages.getString("JobControllerV2.6") + String.valueOf(this.jobToState);
                    this.logger.info((String)((Object)message));
                }
            }
            message = Messages.getString("JobControllerV2.6") + String.valueOf(this.jobToState);
            this.logger.info((String)((Object)message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinishedJob(AtomicInteger errors, String jobId) throws Exception {
        JobRecordStateV2 jobRecordState = this.createJobRecordState(jobId);
        errors.addAndGet(jobRecordState.getFailedRecords().size());
        this.jobToRecordState.put(jobId, jobRecordState);
        if (this.errorAcceptance.toleratedErrorReached(errors.get())) {
            Deque<RunnableWithExtraInfo> deque = this.queue;
            synchronized (deque) {
                while (!this.queue.isEmpty()) {
                    RunnableWithExtraInfo runnableWithExtraInfo = this.queue.pop();
                    this.skippedRecords.addAll(runnableWithExtraInfo.recordsNumbers);
                }
            }
        } else {
            this.addJobFromQueueIfExists();
        }
        this.jobToState.put(jobId, JobStatus.DONE);
        this.processingJobs.remove(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJobFromQueueIfExists() {
        Deque<RunnableWithExtraInfo> deque = this.queue;
        synchronized (deque) {
            if (!this.queue.isEmpty()) {
                this.addJobFromQueue();
            }
        }
    }

    protected void addJobFromQueue() {
        try {
            this.queue.getFirst().runnable().run();
        }
        finally {
            this.queue.pop();
        }
    }

    public final void close(boolean removeFiles) throws IOException, InterruptedException {
        if (removeFiles) {
            File folder = new File(this.folderPath);
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String fileName = file.getName();
                boolean isUsedFile = fileName.startsWith(this.fileNamePattern);
                if (isUsedFile) {
                    Files.deleteIfExists(file.toPath());
                }
                ++n2;
            }
        }
        this.checkJobsStatusInterrupted = true;
        try {
            this.checkJobsStatus.join();
        }
        catch (InterruptedException exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.logger.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        this.logger.info(Messages.getString("JobControllerV2.7"));
    }

    public JobStatus getJobStatus(String jobId) {
        return this.jobToState.get(jobId);
    }

    public final JobRecordStateV2 getJobRecordState(String jobId) {
        return this.jobToRecordState.get(jobId);
    }

    public Set<Integer> getSkippedRecords() {
        return this.skippedRecords;
    }

    private final JobRecordStateV2 createJobRecordState(String jobId) throws Exception {
        Map<Integer, SalesForceResponse> successResponses = this.readResponses(jobId, true);
        Set<Integer> successResponsesNumbers = successResponses.keySet();
        Map<Integer, SalesForceResponse> failResponses = this.readResponses(jobId, false);
        Set<Integer> failResponsesNumbers = failResponses.keySet();
        Set<Integer> lostRecords = this.getLostRecords(jobId, successResponsesNumbers, failResponsesNumbers);
        JobRecordStateV2 jobRecordState = new JobRecordStateV2(successResponses, failResponses, lostRecords);
        this.readUnprocessedResponses(jobId);
        int jobNumber = this.jobIdToNumber.get(jobId);
        String message = Messages.getString("JobControllerV2.8") + jobId + Messages.getString("JobControllerV2.9") + jobNumber;
        this.logger.info(message);
        return jobRecordState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Map<Integer, SalesForceResponse> readResponses(String jobId, boolean success) throws Exception {
        int jobNumber = this.jobIdToNumber.get(jobId);
        String context = success ? "success" : "fail";
        String outputFilePath = this.folderPath + "/" + this.fileNamePattern + "_" + jobNumber + "_" + context + ".csv";
        HashMap<Integer, SalesForceResponse> responses = new HashMap<Integer, SalesForceResponse>();
        int retryNumber = 0;
        boolean readDone = false;
        while (true) {
            if (readDone || retryNumber >= 4) {
                String message = "job " + context + Messages.getString("JobControllerV2.10") + jobId + Messages.getString("JobControllerV2.11") + jobNumber + Messages.getString("JobControllerV2.12") + outputFilePath;
                this.logger.info(message);
                return responses;
            }
            responses.clear();
            boolean header = true;
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                try {
                    Reader reader = success ? this.client.getJobSuccessfulRecordResults(jobId) : this.client.getJobFailedRecordResults(jobId);
                    try {
                        block39: {
                            BufferedReader bufferedReader = new BufferedReader(reader);
                            try {
                                block38: {
                                    Stream<String> linesStream = bufferedReader.lines();
                                    try {
                                        block37: {
                                            FileWriter fileWriter = new FileWriter(outputFilePath);
                                            try {
                                                try (BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                                                    Iterator linesIterator = linesStream.iterator();
                                                    LinkedHashMap<String, String> fields = null;
                                                    StringBuilder concatenatedLine = new StringBuilder();
                                                    while (true) {
                                                        if (!linesIterator.hasNext()) {
                                                            readDone = true;
                                                            break;
                                                        }
                                                        String linePart = (String)linesIterator.next();
                                                        bufferedWriter.write(linePart + "\n");
                                                        if (header) {
                                                            fields = SalesForceBulkUtils.parseResponseHeader(linePart);
                                                            header = false;
                                                            continue;
                                                        }
                                                        concatenatedLine.append(linePart);
                                                        if (linePart.endsWith("\"")) {
                                                            SalesForceResponse response = this.parseLine(concatenatedLine.toString(), fields);
                                                            String recordId = response.getStambiaId();
                                                            Integer recordNumber = this.recordIdToNumber.get(recordId);
                                                            if (recordNumber != null) {
                                                                responses.put(recordNumber, response);
                                                            }
                                                            concatenatedLine.delete(0, concatenatedLine.length());
                                                            continue;
                                                        }
                                                        concatenatedLine.append("\n");
                                                    }
                                                }
                                                if (fileWriter == null) break block37;
                                            }
                                            catch (Throwable throwable2) {
                                                if (throwable == null) {
                                                    throwable = throwable2;
                                                } else if (throwable != throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                                if (fileWriter == null) throw throwable;
                                                fileWriter.close();
                                                throw throwable;
                                            }
                                            fileWriter.close();
                                        }
                                        if (linesStream == null) break block38;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        if (linesStream == null) throw throwable;
                                        linesStream.close();
                                        throw throwable;
                                    }
                                    linesStream.close();
                                }
                                if (bufferedReader == null) break block39;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (bufferedReader == null) throw throwable;
                                bufferedReader.close();
                                throw throwable;
                            }
                            bufferedReader.close();
                        }
                        if (reader == null) continue;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                    continue;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            catch (Exception exception) {
                this.logger.error(exception.getMessage(), (Throwable)exception);
                retryNumber = this.waitForRetry(retryNumber, exception);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readUnprocessedResponses(String jobId) throws Exception {
        int jobNumber = this.jobIdToNumber.get(jobId);
        String outputFilePath = this.folderPath + "/" + this.fileNamePattern + "_" + jobNumber + "_unprocessed.csv";
        int retryNumber = 0;
        boolean readDone = false;
        while (true) {
            if (readDone || retryNumber >= 4) {
                String message = Messages.getString("JobControllerV2.13") + jobId + Messages.getString("JobControllerV2.14") + jobNumber + Messages.getString("JobControllerV2.15") + outputFilePath;
                this.logger.info(message);
                return;
            }
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    Reader reader = this.client.getJobUnprocessedRecordResults(jobId);
                    try {
                        block36: {
                            BufferedReader bufferedReader = new BufferedReader(reader);
                            try {
                                block35: {
                                    FileWriter fileWriter = new FileWriter(outputFilePath);
                                    try {
                                        block34: {
                                            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                                            try {
                                                try (Stream<String> linesStream = bufferedReader.lines();){
                                                    Iterator linesIterator = linesStream.iterator();
                                                    while (true) {
                                                        if (!linesIterator.hasNext()) {
                                                            readDone = true;
                                                            break;
                                                        }
                                                        String linePart = (String)linesIterator.next();
                                                        bufferedWriter.write(linePart + "\n");
                                                    }
                                                }
                                                if (bufferedWriter == null) break block34;
                                            }
                                            catch (Throwable throwable2) {
                                                if (throwable == null) {
                                                    throwable = throwable2;
                                                } else if (throwable != throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                                if (bufferedWriter == null) throw throwable;
                                                bufferedWriter.close();
                                                throw throwable;
                                            }
                                            bufferedWriter.close();
                                        }
                                        if (fileWriter == null) break block35;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        if (fileWriter == null) throw throwable;
                                        fileWriter.close();
                                        throw throwable;
                                    }
                                    fileWriter.close();
                                }
                                if (bufferedReader == null) break block36;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (bufferedReader == null) throw throwable;
                                bufferedReader.close();
                                throw throwable;
                            }
                            bufferedReader.close();
                        }
                        if (reader == null) continue;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (reader == null) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                    continue;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            catch (Exception exception) {
                this.logger.error(exception.getMessage(), (Throwable)exception);
                retryNumber = this.waitForRetry(retryNumber, exception);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int waitForRetry(int retryNumber, Exception exception) throws Exception {
        this.logger.warn("unexpected", (Throwable)exception);
        try {
            JobControllerV2 jobControllerV2 = this;
            synchronized (jobControllerV2) {
                long waitTimeSec = (long)Math.pow(2.0, retryNumber);
                this.wait(waitTimeSec * 1000L);
            }
        }
        catch (Exception waitException) {
            if (waitException instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.logger.error(waitException.getMessage(), (Throwable)waitException);
            throw waitException;
        }
        if (retryNumber == 4) {
            throw exception;
        }
        return ++retryNumber;
    }

    private final Set<Integer> getLostRecords(String jobId, Set<Integer> successResponses, Set<Integer> failResponses) {
        HashSet<Integer> foundRecordNumbers = new HashSet<Integer>(successResponses);
        foundRecordNumbers.addAll(failResponses);
        int jobNumber = this.jobIdToNumber.get(jobId);
        Set<Integer> recordNumbers = this.jobNumberToRecordNumbers.get(jobNumber);
        HashSet<Integer> lostRecordNumbers = new HashSet<Integer>(recordNumbers);
        for (int recordNumber : recordNumbers) {
            if (!foundRecordNumbers.contains(recordNumber)) continue;
            lostRecordNumbers.remove(recordNumber);
        }
        return lostRecordNumbers;
    }

    private final SalesForceResponse parseLine(String line, LinkedHashMap<String, String> fields) {
        RawResponseLine rawResponseLine = SalesForceBulkUtils.parseResponseLine(line, fields);
        String stambiaId = this.getRecordId(rawResponseLine);
        String salesForceId = rawResponseLine.getSalesForceId();
        String message = rawResponseLine.getMessage();
        return new SalesForceResponse(stambiaId, salesForceId, message);
    }

    private final String getRecordId(RawResponseLine rawResponseLine) {
        return switch (this.operation) {
            case OperationEnum.INSERT, OperationEnum.UPSERT -> {
                Map<String, String> businessFields = rawResponseLine.getBusinessFields();
                yield SalesForceBulkUtils.computeHash(businessFields);
            }
            case OperationEnum.DELETE, OperationEnum.UPDATE -> rawResponseLine.getSalesForceId();
            default -> throw new RuntimeException(Messages.getString("JobControllerV2.16") + String.valueOf((Object)this.operation));
        };
    }

    public static enum JobStatus {
        PROCESSING,
        DONE;

    }

    private record RunnableWithExtraInfo(Runnable runnable, Collection<Integer> recordsNumbers) {
    }

    public static class SalesForceResponse {
        private final String stambiaId;
        private final String salesForceId;
        private final String message;

        public SalesForceResponse(String stambiaId, String salesForceId, String message) {
            this.stambiaId = stambiaId;
            this.salesForceId = salesForceId;
            this.message = message;
        }

        public String getStambiaId() {
            return this.stambiaId;
        }

        public String getSalesForceId() {
            return this.salesForceId;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "SalesForceResponse [stambiaId=" + this.stambiaId + ", salesForceId=" + this.salesForceId + ", message=" + this.message + "]";
        }
    }
}

