/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.bulk.recordController;

import com.stambia.salesforce.bulk.configuration.SfBulkConfiguration;
import com.stambia.salesforce.bulk.csvwriter.CsvJobWriter;
import com.stambia.salesforce.bulk.jobController.JobControllerV2;
import com.stambia.salesforce.bulk.recordController.Messages;
import com.stambia.salesforce.bulk.recordState.JobRecordStateV2;
import com.stambia.salesforce.bulk.recordState.RecordStateAndStatus;
import com.stambia.salesforce.bulk.recordState.RecordStatus;
import com.stambia.salesforce.bulk.utils.SalesForceBulkUtils;
import endolabs.salesforce.bulkv2.type.OperationEnum;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class RecordControllerV2 {
    private final Map<String, Integer> recordIdToNumber = new HashMap<String, Integer>();
    private final Map<Integer, String> recordNumberToJob = new HashMap<Integer, String>();
    private final JobControllerV2 jobController;
    private final int jobMaximumSize;
    private final String folderPath;
    private final String fileNamePattern;
    private final List<String> fieldsNames;
    private final Map<String, String> currentfields = new LinkedHashMap<String, String>();
    private final OperationEnum operation;
    private Set<Integer> currentJobRecordNumbers = new HashSet<Integer>();
    private int currentJobNumber = 0;
    private int currentLineNumber = 0;
    private String currentJobFileName;
    private OutputStream currentFileOutputStream;
    private CsvJobWriter csvJobWriter;
    private final Logger logger;

    public RecordControllerV2(SfBulkConfiguration sfBulkConfiguration) throws Exception {
        this.jobController = new JobControllerV2(sfBulkConfiguration, this.recordIdToNumber);
        SfBulkConfiguration.SalesforceParameter salesforceParameter = sfBulkConfiguration.getSalesforceParameter();
        this.jobMaximumSize = salesforceParameter.getJobMaximumSize();
        this.fieldsNames = salesforceParameter.getFieldsNames();
        SfBulkConfiguration.WorkingFolder workingFolder = sfBulkConfiguration.getWorkingFolder();
        this.folderPath = workingFolder.getFolderPath();
        this.fileNamePattern = workingFolder.getFileNamePattern();
        this.logger = sfBulkConfiguration.getLogger();
        this.operation = salesforceParameter.getOperation();
        for (String fieldName : salesforceParameter.getFieldsNames()) {
            this.currentfields.put(fieldName, null);
        }
        String message = Messages.getString("RecordControllerV2.0") + this.jobMaximumSize;
        this.logger.info(message);
        this.renewCsvJobWritter();
    }

    public final Set<String> getJobsIds() {
        Collection<String> jobIdsC = this.recordNumberToJob.values();
        HashSet<String> jobIdsS = new HashSet<String>();
        jobIdsS.addAll(jobIdsC);
        return jobIdsS;
    }

    public final Map<String, Integer> getRecordIdToNumber() {
        return this.recordIdToNumber;
    }

    public final List<String> getFieldsNames() {
        return this.fieldsNames;
    }

    private final void renewCsvJobWritter() throws Exception {
        this.currentJobFileName = this.fileNamePattern + "_" + this.currentJobNumber + "_input.csv";
        String currentJobPath = this.folderPath + "/" + this.currentJobFileName;
        File currentJobFile = new File(currentJobPath);
        this.currentFileOutputStream = new FileOutputStream(currentJobFile);
        this.csvJobWriter = new CsvJobWriter(this.currentFileOutputStream);
        this.csvJobWriter.addRow(this.fieldsNames);
    }

    public final void newRecord(int recordNumber, List<String> fieldValues) throws Exception {
        this.currentJobRecordNumbers.add(recordNumber);
        this.csvJobWriter.addRow(fieldValues);
        ++this.currentLineNumber;
        int fieldIndex = 0;
        for (String fieldName : this.currentfields.keySet()) {
            String fieldValue = fieldValues.get(fieldIndex);
            this.currentfields.put(fieldName, fieldValue);
            ++fieldIndex;
        }
        String recordId = this.getRecordId();
        this.recordIdToNumber.put(recordId, recordNumber);
        if (this.currentLineNumber == this.jobMaximumSize) {
            String message = Messages.getString("RecordControllerV2.1") + this.currentJobFileName;
            this.logger.info(message);
            this.closeCurrentJobOutputStream();
            this.sendJobAndMemorize();
            this.currentJobRecordNumbers.clear();
            this.currentLineNumber = 0;
            ++this.currentJobNumber;
            this.renewCsvJobWritter();
        }
    }

    private final String getRecordId() {
        return switch (this.operation) {
            case OperationEnum.INSERT, OperationEnum.UPSERT -> SalesForceBulkUtils.computeHash(this.currentfields);
            case OperationEnum.DELETE, OperationEnum.UPDATE -> this.currentfields.get("Id");
            default -> throw new RuntimeException(Messages.getString("RecordControllerV2.2") + String.valueOf((Object)this.operation));
        };
    }

    private final void sendJobAndMemorize() {
        if (this.currentLineNumber > 0) {
            ArrayList<Integer> jobRecordNumbers = new ArrayList<Integer>(this.currentJobRecordNumbers);
            this.jobController.sendNewCsvJob(this.currentJobNumber, this.currentJobFileName, jobRecordNumbers, jobId -> {
                Iterator iterator = jobRecordNumbers.iterator();
                while (iterator.hasNext()) {
                    int currentRecordNumber = (Integer)iterator.next();
                    this.recordNumberToJob.put(currentRecordNumber, (String)jobId);
                }
            });
        }
    }

    public final void close(boolean removeFiles) throws IOException, InterruptedException {
        this.closeCurrentJobOutputStream();
        this.jobController.close(removeFiles);
        this.logger.info(Messages.getString("RecordControllerV2.3"));
    }

    private final void closeCurrentJobOutputStream() {
        if (this.currentFileOutputStream != null) {
            try {
                this.currentFileOutputStream.close();
            }
            catch (Exception exception) {
                this.logger.error(exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void stopSendRecord() {
        String message = Messages.getString("RecordControllerV2.4") + this.currentJobFileName;
        this.logger.info(message);
        this.closeCurrentJobOutputStream();
        this.sendJobAndMemorize();
    }

    public RecordStateAndStatus getRecordStateAndStatus(int recordNumber) {
        RecordStatus recordStatus;
        JobRecordStateV2 jobRecordState = null;
        String jobId = this.recordNumberToJob.get(recordNumber);
        if (jobId != null) {
            JobControllerV2.JobStatus jobStatus = this.jobController.getJobStatus(jobId);
            if (jobStatus == JobControllerV2.JobStatus.DONE) {
                jobRecordState = this.jobController.getJobRecordState(jobId);
                recordStatus = jobRecordState.getRecordStatus(recordNumber);
            } else {
                recordStatus = RecordStatus.PROCESSING;
            }
        } else {
            recordStatus = this.jobController.getSkippedRecords().contains(recordNumber) ? RecordStatus.SKIPPED : null;
        }
        String message = Messages.getString("RecordControllerV2.5") + recordNumber + Messages.getString("RecordControllerV2.6") + String.valueOf((Object)recordStatus);
        this.logger.info(message);
        return new RecordStateAndStatus(jobRecordState, recordStatus);
    }

    public JobControllerV2 getJobController() {
        return this.jobController;
    }
}

