/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.bulk.recordState;

import com.stambia.salesforce.bulk.jobController.JobControllerV2;
import com.stambia.salesforce.bulk.recordState.RecordStatus;
import java.util.Collection;
import java.util.Map;

public final class JobRecordStateV2 {
    private final Map<Integer, JobControllerV2.SalesForceResponse> successRecords;
    private final Map<Integer, JobControllerV2.SalesForceResponse> failedRecords;
    private final Collection<Integer> lostRecords;

    public JobRecordStateV2(Map<Integer, JobControllerV2.SalesForceResponse> successRecords, Map<Integer, JobControllerV2.SalesForceResponse> failedRecords, Collection<Integer> lostRecords) {
        this.successRecords = successRecords;
        this.failedRecords = failedRecords;
        this.lostRecords = lostRecords;
    }

    public final Map<Integer, JobControllerV2.SalesForceResponse> getSuccessRecords() {
        return this.successRecords;
    }

    public final Map<Integer, JobControllerV2.SalesForceResponse> getFailedRecords() {
        return this.failedRecords;
    }

    public final RecordStatus getRecordStatus(int recordNumber) {
        boolean successRecord = this.successRecords.containsKey(recordNumber);
        boolean failedRecord = this.failedRecords.containsKey(recordNumber);
        boolean lostRecord = this.lostRecords.contains(recordNumber);
        RecordStatus recordStatus = successRecord ? RecordStatus.SUCCESS : (failedRecord || lostRecord ? RecordStatus.ERROR : null);
        return recordStatus;
    }

    public final JobControllerV2.SalesForceResponse getRecordResponse(int recordNumber) {
        JobControllerV2.SalesForceResponse recordResponse;
        RecordStatus recordStatus = this.getRecordStatus(recordNumber);
        if (recordStatus != null) {
            switch (recordStatus) {
                case SUCCESS: {
                    recordResponse = this.successRecords.get(recordNumber);
                    break;
                }
                case ERROR: {
                    recordResponse = this.failedRecords.get(recordNumber);
                    break;
                }
                default: {
                    recordResponse = null;
                    break;
                }
            }
        } else {
            recordResponse = null;
        }
        return recordResponse;
    }
}

