/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.bulk.utils;

import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.stambia.salesforce.bulk.jobController.RawResponseLine;
import com.stambia.salesforce.bulk.recordController.RecordControllerV2;
import com.stambia.salesforce.bulk.recordState.RecordStateAndStatus;
import com.stambia.salesforce.bulk.recordState.RecordStatus;
import endolabs.salesforce.bulkv2.Bulk2Client;
import endolabs.salesforce.bulkv2.Bulk2ClientBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class SalesForceBulkUtils {
    public static final String jobNameExtension = ".csv";
    public static final String jobNumberSeparator = "_";
    public static final String jobFolderSeparator = "/";
    public static final String SANDBOX_URL_PATTERN = "://test.salesforce.com";
    public static final String fieldDelimiteur = "\"";
    public static final String escapedFieldDelimiteur = "\"\"";
    public static final String fieldSeparator = ",";
    public static final String UTF8 = "UTF-8";
    public static final String newLine = "\n";

    public static final String computeHash(Map<String, String> fields) {
        TreeMap<String, String> sortedFields = new TreeMap<String, String>();
        sortedFields.putAll(fields);
        int hash = sortedFields.hashCode();
        return String.valueOf(hash);
    }

    public static final Bulk2Client getBulk2Client(OAuth2Metadata oAuth2Parameter, String sfEndpoint, Integer readTimeout, Integer connectionTimeout) throws Exception {
        String sessionId = OAuth2.getToken((OAuth2Metadata)oAuth2Parameter);
        Bulk2ClientBuilder bulk2ClientBuilder = new Bulk2ClientBuilder().withSessionId(sessionId, sfEndpoint);
        boolean useSandbox = sfEndpoint.contains(SANDBOX_URL_PATTERN);
        if (useSandbox) {
            bulk2ClientBuilder = bulk2ClientBuilder.useSandbox();
        }
        if (readTimeout != null) {
            bulk2ClientBuilder = bulk2ClientBuilder.setReadTimeout(readTimeout);
        }
        if (connectionTimeout != null) {
            bulk2ClientBuilder = bulk2ClientBuilder.setConnectionTimeout(connectionTimeout);
        }
        return bulk2ClientBuilder.build();
    }

    public static final String[] parseCsvLine(String line) {
        String unquotedExtremityLine;
        String lineLeftover = unquotedExtremityLine = line.substring(1, line.length() - 1);
        int maximumIndex = lineLeftover.length() - 1;
        ArrayList<String> splittedLineL = new ArrayList<String>();
        int index = 1;
        while (index < maximumIndex) {
            boolean splitMark;
            String previousCharacter = String.valueOf(lineLeftover.charAt(index - 1));
            String currentCharacter = String.valueOf(lineLeftover.charAt(index));
            String nextCharacter = String.valueOf(lineLeftover.charAt(index + 1));
            boolean bl = splitMark = previousCharacter.equals(fieldDelimiteur) && currentCharacter.equals(fieldSeparator) && nextCharacter.equals(fieldDelimiteur);
            if (splitMark && index > 1) {
                previousCharacter = String.valueOf(lineLeftover.charAt(index - 2));
                boolean bl2 = splitMark = !previousCharacter.equals(fieldDelimiteur);
                if (!splitMark && index > 2) {
                    previousCharacter = String.valueOf(lineLeftover.charAt(index - 3));
                    splitMark = previousCharacter.equals(fieldDelimiteur);
                }
            }
            if (splitMark) {
                String field = lineLeftover.substring(0, index - 1);
                splittedLineL.add(field);
                int nextIndex = index + 2;
                if (nextIndex > maximumIndex) {
                    nextIndex = maximumIndex;
                }
                lineLeftover = lineLeftover.substring(nextIndex);
                index = 0;
                maximumIndex = lineLeftover.length() - 1;
            }
            ++index;
        }
        if (fieldDelimiteur.equals(lineLeftover)) {
            lineLeftover = "";
        }
        splittedLineL.add(lineLeftover);
        maximumIndex = splittedLineL.size();
        String[] splittedLineA = new String[maximumIndex];
        int index2 = 0;
        while (index2 < maximumIndex) {
            String field;
            splittedLineA[index2] = field = ((String)splittedLineL.get(index2)).replace(escapedFieldDelimiteur, fieldDelimiteur);
            ++index2;
        }
        return splittedLineA;
    }

    public static final LinkedHashMap<String, String> parseResponseHeader(String line) throws Exception {
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        String[] splittedLine = SalesForceBulkUtils.parseCsvLine(line);
        int length = splittedLine.length;
        int position = 2;
        while (position < length) {
            String field = splittedLine[position];
            fields.put(field, null);
            ++position;
        }
        return fields;
    }

    public static final RawResponseLine parseResponseLine(String line, LinkedHashMap<String, String> fields) {
        int length;
        String salesForceId = null;
        String message = null;
        String[] splittedLine = SalesForceBulkUtils.parseCsvLine(line);
        if (splittedLine != null && (length = splittedLine.length) > 0) {
            salesForceId = splittedLine[0];
            if (length > 1) {
                message = splittedLine[1];
                if (length > 2) {
                    SalesForceBulkUtils.parseBusinessFields(splittedLine, fields);
                }
            }
        }
        RawResponseLine rawResponseLine = new RawResponseLine(salesForceId, message, fields);
        return rawResponseLine;
    }

    private static final void parseBusinessFields(String[] businnessFields, LinkedHashMap<String, String> fields) {
        int fieldIndex = 2;
        Set<String> fieldNames = fields.keySet();
        for (String fieldName : fieldNames) {
            String fieldValue = businnessFields[fieldIndex];
            fields.put(fieldName, fieldValue);
            ++fieldIndex;
        }
    }

    public static final RecordStateAndStatus waitRecordProcessed(RecordControllerV2 recordController, int currentRecordNumber, int waitingTime) throws InterruptedException {
        RecordStateAndStatus currentRecordStatus = recordController.getRecordStateAndStatus(currentRecordNumber);
        while (currentRecordStatus.status() == RecordStatus.PROCESSING || currentRecordStatus.status() == null) {
            TimeUnit.MILLISECONDS.sleep(waitingTime);
            currentRecordStatus = recordController.getRecordStateAndStatus(currentRecordNumber);
        }
        return currentRecordStatus;
    }
}

