/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector;

import com.indy.engine.addons.salesforce.Messages;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.salesforce.connector.SalesForceBulkConnection;
import java.util.function.Function;

public class BulkConnectonHelper {
    private BulkConnectonHelper() {
    }

    public static SalesForceBulkConnection createConnection(String login, String password, String securityToken, String authenticationEndPoint, boolean removeSpecialChar, Boolean useTmpFile4sForceResponse, int sForceReadBulkWaitTimeout, long sForceReadBulkWaitPollInt, int sForceReadBulkChunkSize, boolean disableLogout, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword, Integer sForceConnectionTimeout, Integer sForceReadTimeout, OAuth2Metadata otmd, String serviceEndpoint, Function<Object, String> resolve) throws Exception {
        SalesForceBulkConnection con = new SalesForceBulkConnection(resolve.apply(login), resolve.apply(password), resolve.apply(securityToken), resolve.apply(authenticationEndPoint), removeSpecialChar, useTmpFile4sForceResponse);
        con.setReadBulkWaitTimeOut(sForceReadBulkWaitTimeout);
        con.setReadBulkPollInt(sForceReadBulkWaitPollInt);
        if (sForceReadBulkChunkSize > 0) {
            con.setChunkSize(sForceReadBulkChunkSize);
        }
        con.setDisableLogout(disableLogout);
        if (proxyHost != null) {
            con.setProxyHost(resolve.apply(proxyHost));
        }
        if (proxyPort != null) {
            con.setProxyPort(Integer.valueOf(resolve.apply(proxyPort)));
        }
        if (proxyUser != null) {
            con.setProxyUsername(resolve.apply(proxyUser));
        }
        if (proxyPassword != null) {
            con.setProxyPassword(resolve.apply(proxyPassword));
        }
        if (sForceConnectionTimeout != null) {
            con.setConnectionTimeout(sForceConnectionTimeout);
        }
        if (sForceReadTimeout != null) {
            con.setReadTimeout(sForceReadTimeout);
        }
        if (otmd != null) {
            otmd.accessToken = OAuth2.getToken((OAuth2Metadata)otmd);
            con.setSessionId(resolve.apply(otmd.accessToken));
            con.setServiceEndpoint(serviceEndpoint);
        }
        try {
            con.login();
            return con;
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("SForceBaseActionCodeI.4"), (Throwable)e);
        }
    }
}

