/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.BulkConnection;
import com.sforce.async.CSVReader;
import com.sforce.async.ConcurrencyMode;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.JobStateEnum;
import com.sforce.async.OperationEnum;
import com.sforce.async.QueryResultList;
import com.sforce.soap.partner.Connector;
import com.sforce.ws.ConnectorConfig;
import com.stambia.salesforce.connector.IResultSet;
import com.stambia.salesforce.connector.IResultSetMetadata;
import com.stambia.salesforce.connector.Messages;
import com.stambia.salesforce.connector.SalesForceConnection;
import com.stambia.salesforce.connector.util.BatchIterator;
import com.stambia.salesforce.connector.util.ResultIterator;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SalesForceBulkConnection
extends SalesForceConnection {
    private static final int MAX_BYTES_PER_BATCH = 10000000;
    private static final int MAX_ROWS_PER_BATCH = 10000;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static String API_VERSION;
    private List<BatchedJob> currentJobs = Collections.synchronizedList(new ArrayList());
    private long sleepingTime = 10000L;
    private ConnectorConfig bulkConfig;
    private BulkConnection bulkConnection;
    private ContentType contentType = ContentType.CSV;
    private int maxRowPerBatch = 10000;
    private int timeOut = 1800000;
    boolean removeSpecialChar = false;
    private int chunkSize;
    private Boolean disableLogout;
    private static boolean useTempFileForResponse;
    static Set<String> chunckableObject;

    static {
        useTempFileForResponse = false;
        chunckableObject = new HashSet<String>();
    }

    public static String getAuthEndPoint() throws Exception {
        if (API_VERSION == null) {
            Field field = Connector.class.getField("END_POINT");
            String endpt = (String)field.get(null);
            API_VERSION = endpt.substring(endpt.lastIndexOf("/") + 1);
        }
        return API_VERSION;
    }

    public SalesForceBulkConnection(String login, String password, String securityToken, String authenticationEndPoint) throws Exception {
        this(login, password, securityToken, authenticationEndPoint, false, false);
    }

    public SalesForceBulkConnection(String login, String password, String securityToken, String authenticationEndPoint, boolean removeSpecialChar, boolean useTempFileForResponse) throws Exception {
        super(login, password, securityToken, authenticationEndPoint);
        chunckableObject.add("Account");
        chunckableObject.add("Campaign");
        chunckableObject.add("CampaignMember");
        chunckableObject.add("Case");
        chunckableObject.add("CaseHistory");
        chunckableObject.add("Contact");
        chunckableObject.add("Event");
        chunckableObject.add("EventRelation");
        chunckableObject.add("Lead");
        chunckableObject.add("LoginHistory");
        chunckableObject.add("Opportunity");
        chunckableObject.add("Task");
        chunckableObject.add("User");
        this.removeSpecialChar = removeSpecialChar;
        SalesForceBulkConnection.useTempFileForResponse = useTempFileForResponse;
    }

    public SalesForceBulkConnection(String login, String password, String securityToken, String authenticationEndPoint, int maxRowPerBatch, int timeOut, int tickTime) throws Exception {
        super(login, password, securityToken, authenticationEndPoint);
        chunckableObject.add("Account");
        chunckableObject.add("Campaign");
        chunckableObject.add("CampaignMember");
        chunckableObject.add("Case");
        chunckableObject.add("CaseHistory");
        chunckableObject.add("Contact");
        chunckableObject.add("Event");
        chunckableObject.add("EventRelation");
        chunckableObject.add("Lead");
        chunckableObject.add("LoginHistory");
        chunckableObject.add("Opportunity");
        chunckableObject.add("Task");
        chunckableObject.add("User");
        if (maxRowPerBatch > 0 && maxRowPerBatch < 10000) {
            this.maxRowPerBatch = maxRowPerBatch;
        }
        if (timeOut > 0) {
            this.timeOut = timeOut;
        }
        if (tickTime > 0) {
            this.sleepingTime = tickTime;
        }
    }

    @Override
    public void login() throws Exception {
        super.login();
        this.bulkConfig = new ConnectorConfig();
        this.bulkConfig.setSessionId(this.getPartnerConfig().getSessionId());
        String soapEndpoint = this.getPartnerConfig().getServiceEndpoint();
        String restEndpoint = soapEndpoint.substring(0, soapEndpoint.indexOf("Soap/")) + "async/" + SalesForceBulkConnection.getAuthEndPoint();
        this.bulkConfig.setRestEndpoint(restEndpoint);
        if (this.getPartnerConfig().getProxy() != null) {
            this.bulkConfig.setProxy(this.getPartnerConfig().getProxy());
        }
        if (this.getPartnerConfig().getProxyUsername() != null) {
            this.bulkConfig.setProxyUsername(this.getPartnerConfig().getProxyUsername());
        }
        if (this.getPartnerConfig().getProxyPassword() != null) {
            this.bulkConfig.setProxyPassword(this.getPartnerConfig().getProxyPassword());
        }
        if (this.getPartnerConfig().getConnectionTimeout() != 0) {
            this.bulkConfig.setConnectionTimeout(this.getPartnerConfig().getConnectionTimeout());
        }
        if (this.getPartnerConfig().getReadTimeout() != 0) {
            this.bulkConfig.setReadTimeout(this.getPartnerConfig().getReadTimeout());
        }
        this.bulkConfig.setCompression(true);
        this.bulkConfig.setTraceMessage(false);
        this.bulkConnection = new BulkConnection(this.bulkConfig);
    }

    private boolean enableChunk(String sobjectType) {
        return sobjectType.endsWith("__c") || chunckableObject.contains(sobjectType);
    }

    private JobInfo queryJob(String sobjectType, ConcurrencyMode mode) throws AsyncApiException {
        JobInfo job = new JobInfo();
        job.setObject(sobjectType);
        job.setOperation(OperationEnum.query);
        job.setContentType(this.contentType);
        job.setConcurrencyMode(mode);
        if (this.chunkSize > 0 && this.enableChunk(sobjectType)) {
            this.bulkConnection.addHeader("Sforce-Enable-PKChunking", "chunkSize=" + this.chunkSize);
        } else {
            this.bulkConnection.addHeader("Sforce-Enable-PKChunking", "FALSE");
        }
        job = this.bulkConnection.createJob(job);
        return job;
    }

    private void closeJob(String jobId) throws AsyncApiException {
        JobInfo job = new JobInfo();
        job.setId(jobId);
        job.setState(JobStateEnum.Closed);
        this.bulkConnection.updateJob(job);
    }

    public IResultSet executeQuery(String objectType, String query, ConcurrencyMode mode) throws Exception {
        JobInfo job = this.queryJob(objectType, mode);
        boolean errorOccured = false;
        try {
            job = this.bulkConnection.getJobStatus(job.getId());
            BatchInfo bacthInfo = this.bulkConnection.createBatchFromStream(job, (InputStream)new ByteArrayInputStream(query.getBytes("UTF-8")));
            ArrayList<BatchInfo> batchInfos = new ArrayList<BatchInfo>();
            batchInfos.add(bacthInfo);
            BulkQueryReader bulkQueryReader = new BulkQueryReader(this.bulkConnection, job, bacthInfo, this.sleepingTime, this.removeSpecialChar);
            return bulkQueryReader;
        }
        catch (Throwable ex) {
            errorOccured = true;
            throw new Exception(Messages.getString("SalesForceBulkConnection.6") + query, ex);
        }
        finally {
            if (errorOccured) {
                this.bulkConnection.abortJob(job.getId());
            }
        }
    }

    public BatchedJob createBatchJob(OperationEnum operation, String objectType, String headerRow) throws Exception {
        JobInfo job = new JobInfo();
        job.setObject(objectType);
        job.setOperation(operation);
        job.setContentType(this.contentType);
        job = this.bulkConnection.createJob(job);
        BatchedJob res = new BatchedJob(job, headerRow);
        this.currentJobs.add(res);
        return res;
    }

    private static ByteArrayOutputStream dumpStream(InputStream is) throws Exception {
        byte[] buffer = new byte[2048];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int l = -1;
        do {
            if (l == -1) continue;
            bos.write(buffer, 0, l);
        } while ((l = is.read(buffer, 0, 2048)) != -1);
        is.close();
        buffer = null;
        return bos;
    }

    private List<String> awaitCompletion(JobInfo job, List<BatchInfo> batchInfoList) throws Exception {
        long sleepTime = 0L;
        HashSet<String> incomplete = new HashSet<String>();
        ArrayList<String> complete = new ArrayList<String>();
        for (BatchInfo bi : batchInfoList) {
            incomplete.add(bi.getId());
            complete.add(bi.getId());
        }
        long startTime = new Date().getTime();
        while (!incomplete.isEmpty()) {
            BatchInfo[] statusList;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            long curr = new Date().getTime();
            if (this.timeOut != -1 && curr >= startTime + (long)this.timeOut) {
                throw new Exception(Messages.getString("SalesForceBulkConnection.7") + this.timeOut + ")");
            }
            curr -= startTime;
            Thread.sleep(sleepTime);
            sleepTime = this.sleepingTime;
            BatchInfo[] batchInfoArray = statusList = this.bulkConnection.getBatchInfoList(job.getId()).getBatchInfo();
            int n = statusList.length;
            int n2 = 0;
            while (n2 < n) {
                BatchInfo b = batchInfoArray[n2];
                if (b.getState() == BatchStateEnum.Completed || b.getState() == BatchStateEnum.Failed || b.getState() == BatchStateEnum.NotProcessed) {
                    incomplete.remove(b.getId());
                }
                ++n2;
            }
        }
        complete.removeAll(incomplete);
        return complete;
    }

    private BatchInfo createBatch(InputStream is, JobInfo jobInfo) throws IOException, AsyncApiException {
        BatchInfo batchInfo = this.bulkConnection.createBatchFromStream(jobInfo, is);
        return batchInfo;
    }

    private JobResult checkResults(JobInfo job, List<BatchInfo> batchInfoList) throws AsyncApiException, IOException {
        ArrayList<String> failureId = new ArrayList<String>();
        int count = 0;
        for (BatchInfo b : batchInfoList) {
            ArrayList row;
            CSVReader rdr = new CSVReader(this.bulkConnection.getBatchResultStream(job.getId(), b.getId()));
            ArrayList resultHeader = rdr.nextRecord();
            int resultCols = resultHeader.size();
            while ((row = rdr.nextRecord()) != null) {
                HashMap<String, String> resultInfo = new HashMap<String, String>();
                int i = 0;
                while (i < resultCols) {
                    resultInfo.put((String)resultHeader.get(i), (String)row.get(i));
                    ++i;
                }
                boolean success = Boolean.valueOf((String)resultInfo.get("Success"));
                if (success) {
                    ++count;
                    continue;
                }
                failureId.add((String)resultInfo.get("Id"));
            }
        }
        return new JobResult(failureId, count);
    }

    public BulkConnection getBulkConnection() {
        return this.bulkConnection;
    }

    public void setReadBulkWaitTimeOut(Integer sForceReadBulkWaitTimeout) {
        this.timeOut = sForceReadBulkWaitTimeout;
    }

    public void setReadBulkPollInt(Long pollint) {
        this.sleepingTime = pollint;
    }

    public void setChunkSize(int size) {
        this.chunkSize = size;
    }

    public class BatchedJob {
        private JobInfo info;
        private List<BatchInfo> batches = new ArrayList<BatchInfo>();
        private String headerRow;
        private ByteArrayOutputStream bos;
        private int currentRowNumber = 0;
        private boolean close = false;
        private List<String> availableBatchesId = new ArrayList<String>();

        public BatchedJob(JobInfo jobInfo, String headerRow) throws Exception {
            this.info = jobInfo;
            this.headerRow = headerRow;
            this.bos = new ByteArrayOutputStream();
            this.addDataRow(headerRow);
        }

        public void addDataRow(String rowString) throws Exception {
            byte[] data = (rowString + "\n").getBytes("UTF-8");
            if (this.currentRowNumber + 1 >= SalesForceBulkConnection.this.maxRowPerBatch || this.bos.size() + data.length >= 10000000) {
                this.flush();
            }
            this.bos.write(data, 0, data.length);
            ++this.currentRowNumber;
        }

        public void flush() throws Exception {
            this.batches.add(SalesForceBulkConnection.this.createBatch(new ByteArrayInputStream(this.bos.toByteArray()), this.info));
            this.currentRowNumber = 0;
            this.bos.reset();
            this.addDataRow(this.headerRow);
        }

        public void close() throws Exception {
            SalesForceBulkConnection.this.closeJob(this.info.getId());
            this.close = true;
        }

        public boolean join() throws Exception {
            if (this.availableBatchesId.size() == this.batches.size()) {
                return true;
            }
            this.availableBatchesId = SalesForceBulkConnection.this.awaitCompletion(this.info, this.batches);
            return this.availableBatchesId.size() == this.batches.size();
        }

        public void dispose() {
            if (!this.close) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    SalesForceBulkConnection.this.logger.warn("unexpected", (Throwable)e);
                }
            }
            this.batches.clear();
            this.bos = null;
            SalesForceBulkConnection.this.currentJobs.remove(this);
        }

        public JobResult getResult() throws Exception {
            if (!this.join()) {
                throw new Exception(Messages.getString("SalesForceBulkConnection.5"));
            }
            this.batches.clear();
            BatchInfo[] batchInfoArray = SalesForceBulkConnection.this.bulkConnection.getBatchInfoList(this.info.getId()).getBatchInfo();
            int n = batchInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                BatchInfo i = batchInfoArray[n2];
                this.batches.add(i);
                ++n2;
            }
            return SalesForceBulkConnection.this.checkResults(this.info, this.batches);
        }
    }

    public static class BulkQueryReader
    implements IResultSet,
    IResultSetMetadata {
        private BufferedReader currentBufferedReader;
        private CSVReader currentReader;
        Iterator<ResultIterator.Result> resultIterator;
        private String jobId;
        private String batchId;
        private List<String> splitLine;
        private Map<String, Integer> fieldsName;
        BulkConnection bulkConnection;
        private List<File> temporaryFiles = new ArrayList<File>();
        private boolean removeSpecialChar;

        public BulkQueryReader(BulkConnection bulkConnection, JobInfo job, BatchInfo batch, long pollint) throws Exception {
            this(bulkConnection, job, batch, pollint, false);
        }

        public BulkQueryReader(final BulkConnection bulkConnection, JobInfo job, BatchInfo batch, long pollint, boolean removeSpecialChar) throws Exception {
            this.jobId = job.getId();
            this.batchId = batch.getId();
            this.bulkConnection = bulkConnection;
            this.removeSpecialChar = removeSpecialChar;
            this.resultIterator = new ResultIterator(new BatchIterator(bulkConnection, this.jobId, this.batchId, pollint)){

                @Override
                public QueryResultList createQueryResultList(BatchInfo bi) throws Exception {
                    return bulkConnection.getQueryResultList(bi.getJobId(), bi.getId());
                }
            };
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void close() throws Exception {
            this.resultIterator = null;
            try {
                if (this.currentBufferedReader != null) {
                    this.currentBufferedReader.close();
                }
            }
            finally {
                var3_3 = this.temporaryFiles.iterator();
                if (true) ** GOTO lbl19
            }
            {
            }
            do {
                f = var3_3.next();
                try {
                    Files.delete(f.toPath());
                }
                catch (Exception var4_7) {
                    // empty catch block
                }
lbl19:
                // 3 sources

            } while (var3_3.hasNext());
            this.bulkConnection.closeJob(this.jobId);
        }

        private BufferedReader getQueryResultStream(ResultIterator.Result result) throws Exception {
            BufferedReader reader = null;
            if (!useTempFileForResponse) {
                reader = new BufferedReader(new InputStreamReader(this.bulkConnection.getQueryResultStream(result.jobId, result.batchId, result.resultId), "UTF-8"));
            } else {
                File tmpFile = File.createTempFile(SalesForceBulkConnection.class.getName() + "." + result.jobId, result.batchId);
                tmpFile.deleteOnExit();
                Throwable throwable = null;
                Object var5_6 = null;
                try (InputStream br = this.bulkConnection.getQueryResultStream(result.jobId, result.batchId, result.resultId);){
                    Files.copy(br, tmpFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.temporaryFiles.add(tmpFile);
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tmpFile), "UTF-8"));
            }
            return reader;
        }

        @Override
        public boolean next() throws Exception {
            this.splitLine = null;
            if (this.resultIterator == null) {
                throw new Exception(Messages.getString("SalesForceBulkConnection.0"));
            }
            if (this.currentReader != null) {
                this.splitLine = this.currentReader.nextRecord();
                if (this.splitLine == null) {
                    if (this.resultIterator.hasNext()) {
                        ResultIterator.Result res = this.resultIterator.next();
                        this.currentBufferedReader.close();
                        this.currentBufferedReader = this.getQueryResultStream(res);
                        this.currentReader = new CSVReader(this.currentBufferedReader);
                        this.currentReader.setMaxRowsInFile(Integer.MAX_VALUE);
                        this.currentReader.setMaxCharsInFile(Integer.MAX_VALUE);
                        this.splitLine = this.currentReader.nextRecord();
                        this.splitLine = this.currentReader.nextRecord();
                    } else {
                        return false;
                    }
                }
                return this.splitLine != null;
            }
            if (!this.resultIterator.hasNext()) {
                return false;
            }
            ResultIterator.Result res = this.resultIterator.next();
            if (this.currentBufferedReader != null) {
                this.currentBufferedReader.close();
            }
            InputStream is = this.bulkConnection.getQueryResultStream(res.jobId, res.batchId, res.resultId);
            this.currentBufferedReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            this.currentReader = new CSVReader(this.currentBufferedReader);
            this.currentReader.setMaxRowsInFile(Integer.MAX_VALUE);
            this.currentReader.setMaxCharsInFile(Integer.MAX_VALUE);
            this.splitLine = this.currentReader.nextRecord();
            this.parseFields(this.splitLine);
            this.splitLine = this.currentReader.nextRecord();
            return this.splitLine != null;
        }

        private void parseFields(List<String> field) {
            List<String> headers = field;
            this.fieldsName = new HashMap<String, Integer>();
            int i = 0;
            while (i < headers.size()) {
                this.fieldsName.put(headers.get(i), i);
                ++i;
            }
        }

        @Override
        public String[] getFieldNames() throws Exception {
            if (this.fieldsName == null) {
                throw new Exception(Messages.getString("SalesForceBulkConnection.1"));
            }
            String[] str = new String[this.fieldsName.size()];
            this.fieldsName.keySet().toArray(str);
            return str;
        }

        public List<String> splitCurrentRow() throws Exception {
            if (this.splitLine == null) {
                throw new Exception(Messages.getString("SalesForceBulkConnection.2"));
            }
            return this.splitLine;
        }

        @Override
        public String getString(String fieldName) throws Exception {
            Integer index = this.fieldsName.get(fieldName);
            if (index == null) {
                throw new Exception(Messages.getString("SalesForceBulkConnection.3") + fieldName + Messages.getString("SalesForceBulkConnection.4"));
            }
            List<String> split = this.splitCurrentRow();
            String str = split.get(index);
            return this.removeSpecialChar ? BulkQueryReader.cleanInvalidXmlChars(str, "") : str;
        }

        public static String cleanInvalidXmlChars(String text, String replacement) {
            String cleanRegexp = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
            if (text != null) {
                return text.replaceAll(cleanRegexp, replacement);
            }
            return text;
        }
    }

    public static class JobResult {
        private List<String> failedIds;
        private int succeededIds;

        private JobResult(List<String> failedIds, int succeededIds) {
            this.failedIds = failedIds;
            this.succeededIds = succeededIds;
        }

        public List<String> getFailedIds() {
            return this.failedIds;
        }

        public int getSucceededIds() {
            return this.succeededIds;
        }
    }

    class __ResultIterator
    implements Iterator<String> {
        Iterator<BatchInfo> batchIterator;
        Iterator<String> resultIterator;

        __ResultIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.resultIterator == null) {
                if (this.batchIterator == null) {
                    return false;
                }
                return this.batchIterator.hasNext();
            }
            return this.resultIterator.hasNext();
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                if (this.resultIterator != null && this.resultIterator.hasNext()) {
                    return this.resultIterator.next();
                }
                this.resultIterator = null;
                if (this.batchIterator.hasNext()) {
                    BatchInfo bi = this.batchIterator.next();
                    try {
                        QueryResultList qr = SalesForceBulkConnection.this.bulkConnection.getQueryResultList(bi.getJobId(), bi.getId());
                        this.resultIterator = Arrays.asList(qr.getResult()).iterator();
                        if (!this.resultIterator.hasNext()) {
                            this.resultIterator = null;
                        }
                    }
                    catch (AsyncApiException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return null;
        }

        @Override
        public void remove() {
        }
    }

    private class ___Result {
        String batchId;
        String jobId;
        String resultId;

        private ___Result() {
        }
    }
}

