/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.bind;

import com.indy.runtime.api.IBindReader;
import com.stambia.salesforce.connector.bind.AbstractTypeBinder;
import com.stambia.salesforce.connector.util.BulkReader;
import com.stambia.salesforce.connector.util.SalesForceHelper;
import java.util.LinkedHashMap;

public class SalesForceBindReader
extends AbstractTypeBinder
implements IBindReader {
    public static final String BULK_ENDPOINT = "com.stambia.salesforce.connector.bind.bulkEndPoint";
    public static final String SESSION_ID = "com.stambia.salesforce.connector.bind.sessionId";
    public static final String JOB_ID = "com.stambia.salesforce.connector.bind.jobId";
    public static final String BATCH_ID = "com.stambia.salesforce.connector.bind.batchId";
    public static final String TIME_OUT = "com.stambia.salesforce.connector.bind.timeOut";
    public static final String MAP_FIELD_NAME_TYPE_ = "com.stambia.salesforce.connector.bind.fieldTypeMap";
    private BulkReader bulkReader;
    private String sessionId;
    private String jobId;
    private String batchId;
    private String bulkEndPoint;
    private Long timeOut;
    private String[] currentRow;

    public void setParameter(String name, Object value) throws Exception {
        if (BATCH_ID.equals(name)) {
            this.batchId = (String)value;
        } else if (JOB_ID.equals(name)) {
            this.jobId = (String)value;
        } else if (SESSION_ID.equals(name)) {
            this.sessionId = (String)value;
        } else if (BULK_ENDPOINT.equals(name)) {
            this.bulkEndPoint = (String)value;
        } else if (MAP_FIELD_NAME_TYPE_.equals(name)) {
            this.setFieldTypes((LinkedHashMap)value);
        } else if (TIME_OUT.equals(name)) {
            this.timeOut = (Long)value;
        }
    }

    public Object getValue(int index) throws Exception {
        String value = this.currentRow[index];
        if (value == null) {
            return null;
        }
        return this.getDataProvider().getParserProvider().getParser(this.getXmlDataType(index)).doParse(value);
    }

    public void prepare() throws Exception {
        if (this.sessionId == null) {
            throw new Exception("Missing com.stambia.salesforce.connector.bind.sessionId parameter");
        }
        if (this.jobId == null) {
            throw new Exception("Missing com.stambia.salesforce.connector.bind.jobId parameter");
        }
        if (this.batchId == null) {
            throw new Exception("Missing com.stambia.salesforce.connector.bind.batchId parameter");
        }
        if (this.bulkEndPoint == null) {
            throw new Exception("Missing com.stambia.salesforce.connector.bind.bulkEndPoint parameter");
        }
        if (this.timeOut == null) {
            throw new Exception("Missing com.stambia.salesforce.connector.bind.timeOut parameter");
        }
        this.bulkReader = new BulkReader(this.sessionId, this.jobId, this.batchId, this.bulkEndPoint, this.timeOut);
        super.prepareDataTypes();
    }

    public boolean readNext() throws Exception {
        if (this.bulkReader.next()) {
            this.currentRow = this.bulkReader.splitCurrentRow();
            return true;
        }
        return false;
    }

    public void close() throws Exception {
        this.bulkReader.close();
        this.bulkReader = null;
        SalesForceHelper.closeJob(this.sessionId, this.jobId, this.bulkEndPoint);
    }
}

