/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.object;

import com.sforce.async.AsyncApiException;
import com.sforce.async.AsyncExceptionCode;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchRequest;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.BulkConnection;
import com.sforce.async.ConcurrencyMode;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.JobStateEnum;
import com.sforce.async.OperationEnum;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.transport.Transport;
import com.stambia.salesforce.connector.SalesForceBulkConnection;
import com.stambia.salesforce.connector.object.BatchResultStreamIterable;
import com.stambia.salesforce.connector.object.CsvBatchRequest;
import com.stambia.salesforce.connector.object.Messages;
import com.stambia.salesforce.connector.util.XmlToSForce;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.Logger;

public class BulkJob {
    Map<String, BatchInfo> batchInfosMap = new HashMap<String, BatchInfo>();
    Map<String, BatchInfo> batchEndedMap = Collections.synchronizedMap(new HashMap());
    JobInfo job;
    BulkConnection bulkConnection;
    public ContentType type;
    private String logParentMsg;
    long lastScan = 0L;
    long bulkPollint = 100000L;
    long bulkMaxSize = 10L;
    Thread thread;
    Object lock = new Object();
    Logger logger;
    String logMsg = "BulkJob: ";

    public BulkJob(BulkConnection bulkConnection, String parentLogMsg, Logger logger) {
        this.bulkConnection = bulkConnection;
        this.logParentMsg = parentLogMsg;
        this.logger = logger;
    }

    public void closeJob() throws AsyncApiException {
        JobInfo job = new JobInfo();
        job.setId(this.job.getId());
        job.setState(JobStateEnum.Closed);
        this.bulkConnection.updateJob(job);
    }

    public void createJob(String sobjectType, OperationEnum operation, ConcurrencyMode concurrencyMode, String externalIdFieldName) throws AsyncApiException {
        JobInfo job = new JobInfo();
        job.setObject(sobjectType);
        job.setOperation(operation);
        job.setConcurrencyMode(concurrencyMode);
        job.setContentType(this.type);
        if (operation == OperationEnum.upsert) {
            job.setExternalIdFieldName(externalIdFieldName);
        }
        this.job = this.bulkConnection.createJob(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createBatch(com.sforce.async.SObject[] objects) throws IOException, AsyncApiException {
        Object object = this.lock;
        synchronized (object) {
            BatchRequest br = this.createBatch(this.job);
            br.addSObjects(objects);
            BatchInfo bi = br.completeRequest();
            this.batchInfosMap.put(bi.getId(), bi);
            return bi.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createQueryBatch(String query) throws IOException, AsyncApiException {
        Object object = this.lock;
        synchronized (object) {
            BatchInfo bi = this.bulkConnection.createBatchFromStream(this.job, (InputStream)new ByteArrayInputStream(query.getBytes(StandardCharsets.UTF_8)));
            this.batchInfosMap.put(bi.getId(), bi);
            return bi.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createCsvBatch(com.sforce.async.SObject[] objects) throws IOException, AsyncApiException {
        Object object = this.lock;
        synchronized (object) {
            CsvBatchRequest br = this.createCsvBatch(this.job);
            LinkedHashMap<String, Integer> header = new LinkedHashMap<String, Integer>();
            int i = 0;
            com.sforce.async.SObject[] sObjectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                com.sforce.async.SObject so = sObjectArray[n2];
                for (String fieldName : so.getFieldNames()) {
                    Integer ii = (Integer)header.get(fieldName);
                    if (ii != null) continue;
                    header.put(fieldName, i++);
                }
                ++n2;
            }
            String[] _header = new String[header.size()];
            _header = header.keySet().toArray(_header);
            br.addHeader(_header);
            com.sforce.async.SObject[] sObjectArray2 = objects;
            int n3 = objects.length;
            n = 0;
            while (n < n3) {
                com.sforce.async.SObject so = sObjectArray2[n];
                String[] row = new String[header.size()];
                for (Map.Entry entry : header.entrySet()) {
                    row[((Integer)entry.getValue()).intValue()] = so.getField((String)entry.getKey());
                }
                br.addRow(row);
                ++n;
            }
            BatchInfo bi = br.completeRequest();
            this.batchInfosMap.put(bi.getId(), bi);
            return bi.getId();
        }
    }

    private String getRestEndpoint() {
        Object endpoint = this.bulkConnection.getConfig().getRestEndpoint();
        endpoint = ((String)endpoint).endsWith("/") ? endpoint : (String)endpoint + "/";
        return endpoint;
    }

    private HashMap<String, String> getHeaders(String contentType) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put("Content-Type", contentType);
        newMap.put("X-SFDC-Session", this.bulkConnection.getConfig().getSessionId());
        return newMap;
    }

    public CsvBatchRequest createCsvBatch(JobInfo job) throws AsyncApiException {
        try {
            Object endpoint = this.getRestEndpoint();
            Transport transport = this.bulkConnection.getConfig().createTransport();
            endpoint = (String)endpoint + "job/" + job.getId() + "/batch";
            ContentType ct = job.getContentType();
            if (ct != null && ct != ContentType.CSV && ct != ContentType.ZIP_CSV) {
                throw new AsyncApiException(Messages.getString("BulkJob.0"), AsyncExceptionCode.ClientInputError);
            }
            OutputStream out = null;
            if (ct == ContentType.ZIP_CSV) {
                out = new ZipOutputStream(transport.connect((String)endpoint, this.getHeaders("zip/csv"), false));
                ((ZipOutputStream)out).putNextEntry(new ZipEntry(new String("request.txt".getBytes(), StandardCharsets.UTF_8)));
            } else {
                out = transport.connect((String)endpoint, this.getHeaders("text/csv"));
            }
            return new CsvBatchRequest(transport, out);
        }
        catch (IOException e) {
            throw new AsyncApiException(Messages.getString("BulkJob.1"), AsyncExceptionCode.ClientInputError, (Throwable)e);
        }
        catch (ConnectionException e) {
            throw new AsyncApiException(Messages.getString("BulkJob.2"), AsyncExceptionCode.ClientInputError, (Throwable)e);
        }
    }

    public BatchRequest createBatch(JobInfo job) throws AsyncApiException {
        try {
            OutputStream out;
            Object endpoint = this.getRestEndpoint();
            Transport transport = this.bulkConnection.getConfig().createTransport();
            endpoint = (String)endpoint + "job/" + job.getId() + "/batch";
            ContentType ct = job.getContentType();
            if (ct != null && ct != ContentType.XML && ct != ContentType.ZIP_XML && ct != ContentType.JSON && ct != ContentType.ZIP_JSON) {
                throw new AsyncApiException(Messages.getString("BulkJob.3"), AsyncExceptionCode.ClientInputError);
            }
            String jobContentType = "";
            boolean zip = false;
            if (ct == null) {
                jobContentType = "application/xml";
            } else {
                switch (ct) {
                    case ZIP_JSON: {
                        jobContentType = "zip/json";
                        zip = true;
                        break;
                    }
                    case JSON: {
                        jobContentType = "application/json";
                        break;
                    }
                    case ZIP_XML: {
                        jobContentType = "zip/xml";
                        zip = true;
                        break;
                    }
                    default: {
                        jobContentType = "application/xml";
                    }
                }
            }
            if (zip) {
                out = new ZipOutputStream(transport.connect((String)endpoint, this.getHeaders(jobContentType), false));
                ((ZipOutputStream)out).putNextEntry(new ZipEntry(new String("request.txt".getBytes(), StandardCharsets.UTF_8)));
            } else {
                out = transport.connect((String)endpoint, this.getHeaders(jobContentType));
            }
            return new BatchRequest(transport, out);
        }
        catch (IOException e) {
            throw new AsyncApiException(Messages.getString("BulkJob.4"), AsyncExceptionCode.ClientInputError, (Throwable)e);
        }
        catch (ConnectionException x) {
            throw new AsyncApiException(Messages.getString("BulkJob.5"), AsyncExceptionCode.ClientInputError, (Throwable)x);
        }
    }

    public boolean batchIsEnded(BatchInfo bi) throws AsyncApiException {
        return bi.getState() == BatchStateEnum.Completed || bi.getState() == BatchStateEnum.Failed;
    }

    public void checkEndBatch(boolean awaitCompletion) throws AsyncApiException, InterruptedException {
        this.debug("checkEndBatch");
        if (awaitCompletion) {
            this.debug("checkEndBatch: await");
            long sleepTime = 0L;
            while (!this.batchInfosMap.isEmpty()) {
                this.debug("checkEndBatch: await for " + sleepTime);
                Thread.sleep(sleepTime);
                sleepTime = this.bulkPollint;
                this._checkEndBatch();
            }
        } else {
            this.debug("checkEndBatch: not await");
            this._checkEndBatch();
        }
    }

    public void setBulkPollint(long bulkPollint) {
        this.bulkPollint = bulkPollint;
    }

    public void setBulkMaxSize(long bulkMaxSize) {
        this.bulkMaxSize = bulkMaxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BatchInfo> getEndedBatches() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<BatchInfo> list = new ArrayList<BatchInfo>();
            list.addAll(this.batchEndedMap.values());
            this.batchEndedMap.clear();
            return list;
        }
    }

    public XmlToSForce.SelectResult[] getQueryResult(BatchInfo bi, String currentEntityName) throws Exception {
        SalesForceBulkConnection.BulkQueryReader bqr = new SalesForceBulkConnection.BulkQueryReader(this.bulkConnection, this.job, bi, this.bulkPollint);
        ArrayList<XmlToSForce.SelectResult> ret = new ArrayList<XmlToSForce.SelectResult>();
        while (bqr.next()) {
            XmlToSForce.SelectResult qr = new XmlToSForce.SelectResult();
            qr.result = new SObject(currentEntityName);
            String[] stringArray = bqr.getFieldNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                qr.result.addField(name, (Object)bqr.getString(name));
                ++n2;
            }
            ret.add(qr);
        }
        return ret.toArray(new XmlToSForce.SelectResult[ret.size()]);
    }

    public BatchResultStreamIterable getResult(BatchInfo bi) throws AsyncApiException {
        String jobId = this.job.getId();
        String batchId = bi.getId();
        return new BatchResultStreamIterable(this.bulkConnection, jobId, batchId, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _checkEndBatch() throws AsyncApiException {
        Object object = this.lock;
        synchronized (object) {
            this.debug("_checkEndBatch");
            if (this.batchInfosMap.size() > 0) {
                BatchInfo[] statusList;
                this.debug("_checkEndBatch batch sended: " + this.batchInfosMap.size());
                BatchInfo[] batchInfoArray = statusList = this.bulkConnection.getBatchInfoList(this.job.getId()).getBatchInfo();
                int n = statusList.length;
                int n2 = 0;
                while (n2 < n) {
                    BatchInfo b = batchInfoArray[n2];
                    if (this.batchInfosMap.get(b.getId()) != null && (b.getState() == BatchStateEnum.Completed || b.getState() == BatchStateEnum.Failed)) {
                        this.batchEndedMap.put(b.getId(), b);
                        this.batchInfosMap.remove(b.getId());
                    }
                    ++n2;
                }
                this.debug("_checkEndBatch batch ended: " + this.batchEndedMap.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckEndbatchThread() {
        Object object = this.lock;
        synchronized (object) {
            this.thread = new Thread(() -> {
                long sleepTime = this.bulkPollint;
                try {
                    while (true) {
                        if (this.thread.isInterrupted()) {
                            return;
                        }
                        Thread.sleep(sleepTime);
                        try {
                            this.checkEndBatch(false);
                            if (this.batchEndedMap.isEmpty()) continue;
                            this.debug("Scan Thread: send awake");
                            this.awake();
                        }
                        catch (AsyncApiException e) {
                            this.logger.warn("unexpected", (Throwable)e);
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.debug("thread: " + this.thread.getName() + " is interrupted");
                }
            });
            this.thread.setName(Thread.currentThread().getName() + "/SforceBulkJobScanThread");
            this.debug("Start thread: " + this.thread.getName());
            this.thread.start();
        }
    }

    private void debug(String message) {
        this.logger.debug(this.logParentMsg + this.logMsg + message);
    }

    public void stopCheckEndbatch() throws InterruptedException {
        this.debug("stopCheckEndbatch");
        if (this.thread != null) {
            this.debug("stopCheckEndbatch: thread is not null");
            this.thread.interrupt();
            this.thread.join();
            this.debug("stopCheckEndbatch: thread joined");
            this.thread = null;
        }
    }

    public synchronized void awake() {
        this.notifyAll();
    }

    public synchronized void waitForChange() throws InterruptedException {
        this.debug("wait for ended batch");
        try {
            this.wait();
            this.debug("unwait for ended batch");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public long size() {
        return this.batchInfosMap.size();
    }

    public void dispose() throws InterruptedException {
        this.stopCheckEndbatch();
        this.batchEndedMap.clear();
        this.batchInfosMap.clear();
    }

    public void setContentType(ContentType csv) {
        this.job.setContentType(csv);
    }
}

