/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.stambia.salesforce.connector.IResultSet;
import com.stambia.salesforce.connector.util.Messages;
import com.stambia.salesforce.connector.util.SalesForceHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BulkReader
implements IResultSet {
    private BufferedReader currentReader;
    private Iterator<String> resultIterator;
    private String jobId;
    private String batchId;
    private String sessionId;
    private String endPoint;
    private String line;
    private String[] fields;

    public BulkReader(String sessionId, String jobId, String batchId, String endPoint, long timeOut) throws Exception {
        this.jobId = jobId;
        this.batchId = batchId;
        this.sessionId = sessionId;
        this.endPoint = endPoint;
        List<String> l = SalesForceHelper.getResultIds(sessionId, jobId, batchId, endPoint, timeOut);
        this.resultIterator = l.iterator();
    }

    @Override
    public void close() throws Exception {
        this.resultIterator = null;
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }

    @Override
    public boolean next() throws Exception {
        if (this.resultIterator == null) {
            throw new Exception(Messages.getString("BulkReader.0"));
        }
        if (this.currentReader != null) {
            this.line = this.currentReader.readLine();
            if (this.line == null && this.resultIterator.hasNext()) {
                String resId = this.resultIterator.next();
                this.currentReader.close();
                this.currentReader = new BufferedReader(new InputStreamReader(SalesForceHelper.getResultStream(this.sessionId, this.jobId, this.batchId, resId, this.endPoint)));
                this.line = this.currentReader.readLine();
                this.line = this.currentReader.readLine();
            }
            return this.line != null;
        }
        if (this.resultIterator.hasNext()) {
            String resId = this.resultIterator.next();
            this.currentReader = new BufferedReader(new InputStreamReader(SalesForceHelper.getResultStream(this.sessionId, this.jobId, this.batchId, resId, this.endPoint)));
            this.line = this.currentReader.readLine();
            this.parseFields(this.line);
            this.line = this.currentReader.readLine();
            return this.line != null;
        }
        this.line = null;
        return false;
    }

    private void parseFields(String line) {
        ArrayList<String> headers = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        int countQuote = 0;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == '\"') {
                ++countQuote;
            }
            if (countQuote % 2 == 0 && (c == ',' || i == line.length() - 1)) {
                String s = b.toString();
                headers.add(c == ',' ? s.substring(1, s.length() - 1) : s.substring(1));
                b = new StringBuilder();
            } else {
                b.append(c);
            }
            ++i;
        }
        this.fields = headers.toArray(new String[headers.size()]);
    }

    public String[] splitCurrentRow() throws Exception {
        if (this.line == null) {
            throw new Exception(Messages.getString("BulkReader.1"));
        }
        int countQuote = 0;
        StringBuilder currentStr = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < this.line.length()) {
            char c = this.line.charAt(i);
            if (c == '\"') {
                ++countQuote;
            }
            if ((c == ',' || i == this.line.length() - 1) && countQuote % 2 == 0) {
                String s = c == ',' ? currentStr.toString().substring(1, currentStr.length() - 1).replace("\"\"", "\"") : currentStr.toString().substring(1).replace("\"\"", "\"");
                values.add(s);
                currentStr = new StringBuilder();
            } else {
                currentStr.append(c);
            }
            ++i;
        }
        values.add(currentStr.toString().replace("\"\"", "\""));
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String getString(String fieldName) throws Exception {
        Integer index = null;
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].equalsIgnoreCase(fieldName)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == null) {
            throw new Exception(Messages.getString("BulkReader.2") + fieldName + Messages.getString("BulkReader.3"));
        }
        return this.splitCurrentRow()[index];
    }
}

