/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.sforce.async.BatchInfo;
import com.sforce.async.QueryResultList;
import com.stambia.salesforce.connector.util.BatchIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ResultIterator
implements Iterator {
    BatchIterator bi;
    BatchInfo currentBatch;
    Iterator<String> it;
    Result current;
    Result next;

    public ResultIterator(BatchIterator bi) {
        this.bi = bi;
    }

    public Object next() {
        this.fillNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = null;
        return this.current;
    }

    private void fillNext() {
        if (this.next == null) {
            this.next = (Result)this._next();
        }
    }

    @Override
    public boolean hasNext() {
        this.fillNext();
        return this.next != null;
    }

    public abstract QueryResultList createQueryResultList(BatchInfo var1) throws Exception;

    private Object _next() {
        String id = null;
        while (true) {
            if ((this.it == null || !this.it.hasNext()) && this.bi.hasNext()) {
                QueryResultList list;
                this.currentBatch = null;
                while (this.bi.hasNext() && this.currentBatch == null) {
                    this.currentBatch = this.bi.next();
                    if (this.currentBatch.getNumberRecordsProcessed() != 0) continue;
                    this.currentBatch = null;
                }
                if (this.currentBatch == null) continue;
                try {
                    list = this.createQueryResultList(this.currentBatch);
                }
                catch (Exception e) {
                    throw new NoSuchElementException(e.getMessage());
                }
                this.it = list.getResult().length == 0 ? null : Arrays.asList(list.getResult()).iterator();
                continue;
            }
            if (this.it != null && this.it.hasNext()) {
                id = this.it.next();
            }
            if (id != null || !this.bi.hasNext()) break;
        }
        if (id != null && this.currentBatch != null) {
            Result res = new Result();
            res.batchId = this.currentBatch.getId();
            res.jobId = this.currentBatch.getJobId();
            res.resultId = id;
            return res;
        }
        return null;
    }

    @Override
    public void remove() {
    }

    public static final class Result {
        public String batchId;
        public String jobId;
        public String resultId;
    }
}

