/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.indy.runtime.file.DelimitedFileWriter;
import com.stambia.salesforce.connector.IResultSet;
import com.stambia.salesforce.connector.SalesForceConnection;
import com.stambia.salesforce.connector.util.SFQueryToXml;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;

public class SFQueryToFile {
    private SalesForceConnection conn;
    SFQueryToXml.SForceToXmlHandler handler = null;
    String dateFormat = "yyyy/MM/dd";
    String dateTimeFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    String timeFormat = "HH:mm:ss.SSS";
    String decimalSeparator = ".";
    List<String> sortedField = new ArrayList<String>();
    Map<String, String> xmlTypes = new HashMap<String, String>();

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public void setHandler(SFQueryToXml.SForceToXmlHandler sForceToXmlHandler) {
        this.handler = sForceToXmlHandler;
    }

    public SFQueryToFile(SalesForceConnection conn) throws XMLStreamException, FactoryConfigurationError {
        this.conn = conn;
    }

    public void startDocument() throws XMLStreamException {
    }

    public void endDocument() throws XMLStreamException {
    }

    public void addSortedFieldName(String name) {
        this.sortedField.add(name);
    }

    public void addXmlType(String name, String xmlType) {
        this.xmlTypes.put(name, xmlType);
    }

    public long dump(String query, String sObjectName, DelimitedFileWriter writer, boolean delete, Calendar deletetionStartDate, Calendar deletetionEndDate, int deleteOffsetUnit, int deleteOffset) throws Exception {
        int data = 0;
        SimpleDateFormat sdfDateFormat = new SimpleDateFormat(this.dateFormat);
        SimpleDateFormat sdfDateTimeFormat = new SimpleDateFormat(this.dateTimeFormat);
        SimpleDateFormat sdfTimeFormat = new SimpleDateFormat(this.timeFormat);
        IResultSet rs = null;
        try {
            rs = this.conn.executeQuery(query);
            int recordNb = 0;
            while (rs.next()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ++recordNb;
                ++data;
                for (String fieldName : this.sortedField) {
                    String type = this.xmlTypes.get(fieldName);
                    String str = rs.getString(fieldName);
                    if (str != null) {
                        if (type != null) {
                            if (type.equalsIgnoreCase("datetime")) {
                                Calendar cal = DatatypeConverter.parseDateTime((String)str);
                                str = sdfDateTimeFormat.format(cal.getTime());
                                writer.writeString(str);
                                continue;
                            }
                            if (type.equalsIgnoreCase("date")) {
                                Calendar cal = DatatypeConverter.parseDate((String)str);
                                str = sdfDateFormat.format(cal.getTime());
                                writer.writeString(str);
                                continue;
                            }
                            if (type.equalsIgnoreCase("time")) {
                                Calendar cal = DatatypeConverter.parseTime((String)str);
                                str = sdfTimeFormat.format(cal.getTime());
                                writer.writeString(str);
                                continue;
                            }
                            if (type.equalsIgnoreCase("boolean")) {
                                boolean b = Boolean.parseBoolean(str);
                                if (b) {
                                    writer.writeString("1");
                                    continue;
                                }
                                writer.writeString("0");
                                continue;
                            }
                            writer.writeString(str);
                            continue;
                        }
                        writer.writeString(str);
                        continue;
                    }
                    writer.writeString(str);
                }
                writer.endRecord();
                if (recordNb != 1000) continue;
                this.fireEvent(recordNb);
                recordNb = 0;
            }
            if (recordNb > 0) {
                this.fireEvent(recordNb);
            }
            long l = data;
            return l;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
    }

    private void fireEvent(int recordNb) {
        if (this.handler != null) {
            this.handler.handleBatch(recordNb);
        }
    }

    public void close() {
        this.conn = null;
        this.handler = null;
    }
}

