/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.indy.engine.actionCodes.json.JsonReader;
import com.stambia.salesforce.connector.util.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SalesForceHelper {
    private static final String JOB_INFO_END_PAYLOAD = "</jobInfo>";
    private static final String JOB_INFO_START_PAYLOAD = "<jobInfo xmlns=\"http://www.force.com/2009/06/asyncapi/dataload\">";
    private static final String APPLICATION_XML_CHARSET_UTF_8 = "application/xml; charset=UTF-8";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String X_SFDC_SESSION_HEADER = "X-SFDC-Session";
    private static final String AUTHENTICATION_URL = "/services/oauth2/token";

    public static String authenticate(String salesForceLoginUrl, String clientId, String secret, String login, String password, String securityToken) throws Exception {
        Throwable throwable = null;
        Object var7_8 = null;
        try (DefaultHttpClient httpclient = new DefaultHttpClient();){
            String url = salesForceLoginUrl + "/services/oauth2/token?grant_type=password&client_id=" + clientId + "&client_secret=" + secret + "&username=" + login + "&password=" + password + securityToken;
            HttpPost post = new HttpPost(url);
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)post);
            JsonReader jr = new JsonReader("__position__", "item");
            final HashMap map = new HashMap();
            jr.setContentHandler(new ContentHandler(){
                String current = null;

                @Override
                public void startPrefixMapping(String arg0, String arg1) throws SAXException {
                }

                @Override
                public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
                    this.current = arg1;
                }

                @Override
                public void startDocument() throws SAXException {
                }

                @Override
                public void skippedEntity(String arg0) throws SAXException {
                }

                @Override
                public void setDocumentLocator(Locator arg0) {
                }

                @Override
                public void processingInstruction(String arg0, String arg1) throws SAXException {
                }

                @Override
                public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
                }

                @Override
                public void endPrefixMapping(String arg0) throws SAXException {
                }

                @Override
                public void endElement(String arg0, String arg1, String arg2) throws SAXException {
                    this.current = null;
                }

                @Override
                public void endDocument() throws SAXException {
                }

                @Override
                public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
                    if (this.current != null) {
                        map.put(this.current, new String(arg0, arg1, arg2));
                    }
                }
            });
            jr.parse(new InputSource(resp.getEntity().getContent()));
            if (map.containsKey("error")) {
                throw new Exception(Messages.getString("SalesForceHelper.0") + String.valueOf(map));
            }
            return (String)map.get("access_token");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String createJob(String sessionId, String salesForceBulkEnpoint, Operation operation, String sObjectName) throws Exception {
        String sfUrl = salesForceBulkEnpoint + "/job";
        Throwable throwable = null;
        Object var6_7 = null;
        try (DefaultHttpClient httpclient = new DefaultHttpClient();){
            HttpPost httppost = new HttpPost(sfUrl);
            httppost.setHeader(X_SFDC_SESSION_HEADER, sessionId);
            httppost.setHeader(CONTENT_TYPE_HEADER, APPLICATION_XML_CHARSET_UTF_8);
            String content = "<jobInfo xmlns=\"http://www.force.com/2009/06/asyncapi/dataload\"><operation>" + String.valueOf((Object)operation) + "</operation><object>" + sObjectName + "</object><contentType>CSV</contentType></jobInfo>";
            httppost.setEntity((HttpEntity)new StringEntity(content));
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httppost);
            String res = SalesForceHelper.readStream(resp.getEntity().getContent());
            if (res.contains("<id>")) {
                res = res.substring(res.indexOf("<id>"), res.indexOf("</id>")).replace("<id>", "");
            }
            return res;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String createUpsertJob(String sessionId, String salesForceBulkEnpoint, String sObjectName, String externalIdFieldName) throws Exception {
        String sfUrl = salesForceBulkEnpoint + "/job";
        Throwable throwable = null;
        Object var6_7 = null;
        try (DefaultHttpClient httpclient = new DefaultHttpClient();){
            HttpPost httppost = new HttpPost(sfUrl);
            httppost.setHeader(X_SFDC_SESSION_HEADER, sessionId);
            httppost.setHeader(CONTENT_TYPE_HEADER, APPLICATION_XML_CHARSET_UTF_8);
            String content = "<jobInfo xmlns=\"http://www.force.com/2009/06/asyncapi/dataload\"><operation>upsert</operation><object>" + sObjectName + "</object><externalIdFieldName>" + externalIdFieldName + "</externalIdFieldName><contentType>CSV</contentType></jobInfo>";
            httppost.setEntity((HttpEntity)new StringEntity(content));
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httppost);
            String res = SalesForceHelper.readStream(resp.getEntity().getContent());
            if (res.contains("<id>")) {
                res = res.substring(res.indexOf("<id>"), res.indexOf("</id>")).replace("<id>", "");
            }
            return res;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<String> getResultIds(String sessionId, String jobId, String batchId, String salesForceBulkEnpoint, long timeOut) throws Exception {
        String sfUrl = salesForceBulkEnpoint + "/job/" + jobId + "/batch/" + batchId + "/result";
        Throwable throwable = null;
        Object var8_8 = null;
        try (DefaultHttpClient httpclient = new DefaultHttpClient();){
            HttpGet httppost = new HttpGet(sfUrl);
            httppost.setHeader(X_SFDC_SESSION_HEADER, sessionId);
            httppost.setHeader(CONTENT_TYPE_HEADER, APPLICATION_XML_CHARSET_UTF_8);
            ArrayList<String> ids = new ArrayList<String>();
            long startTime = new Date().getTime();
            long endTime = -1L;
            while (ids.isEmpty() || endTime <= startTime + timeOut) {
                CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httppost);
                endTime = new Date().getTime();
                String res = SalesForceHelper.readStream(resp.getEntity().getContent());
                while (res.contains("<result>")) {
                    int start = res.indexOf("<result>");
                    int end = res.indexOf("</result>");
                    String tmp = res.substring(start, end).replace("<result>", "");
                    ids.add(tmp);
                    res = res.substring(end);
                }
                Thread.sleep(100L);
            }
            if (ids.isEmpty() && endTime <= startTime + timeOut) {
                throw new TimeoutException(Messages.getString("SalesForceHelper.1") + timeOut + Messages.getString("SalesForceHelper.2"));
            }
            return ids;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static InputStream getResultStream(String sessionId, String jobId, String batchId, String resultId, String salesForceBulkEnpoint) throws Exception {
        String sfUrl = salesForceBulkEnpoint + "/job/" + jobId + "/batch/" + batchId + "/result/" + resultId;
        Throwable throwable = null;
        Object var7_8 = null;
        try (DefaultHttpClient httpclient = new DefaultHttpClient();){
            HttpGet httppost = new HttpGet(sfUrl);
            httppost.setHeader(X_SFDC_SESSION_HEADER, sessionId);
            httppost.setHeader(CONTENT_TYPE_HEADER, APPLICATION_XML_CHARSET_UTF_8);
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httppost);
            return resp.getEntity().getContent();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String createBatch(String sessionId, String jobId, String batchContent, String salesForceBulkEnpoint) throws Exception {
        String sfUrl = salesForceBulkEnpoint + "/job/" + jobId + "/batch";
        Throwable throwable = null;
        Object var6_7 = null;
        try (DefaultHttpClient httpclient = new DefaultHttpClient();){
            HttpPost httppost = new HttpPost(sfUrl);
            httppost.setHeader(X_SFDC_SESSION_HEADER, sessionId);
            httppost.setHeader(CONTENT_TYPE_HEADER, "text/csv; charset=UTF-8");
            httppost.setEntity((HttpEntity)new StringEntity(batchContent));
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httppost);
            String res = SalesForceHelper.readStream(resp.getEntity().getContent());
            if (res.contains("<id>")) {
                res = res.substring(res.indexOf("<id>"), res.indexOf("</id>")).replace("<id>", "");
            }
            return res;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String readStream(InputStream is) throws Exception {
        String res = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
        StringBuilder sb = new StringBuilder();
        String line = null;
        do {
            if ((line = bufferedReader.readLine()) == null) continue;
            sb.append(line);
        } while (line != null);
        res = sb.toString();
        return res;
    }

    public static boolean closeJob(String sessionId, String jobId, String salesForceBulkEnpoint) throws Exception {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><jobInfo xmlns=\"http://www.force.com/2009/06/asyncapi/dataload\"><state>Closed</state></jobInfo>";
        String sfUrl = salesForceBulkEnpoint + "/job/" + jobId;
        Throwable throwable = null;
        Object var6_7 = null;
        try (DefaultHttpClient httpclient = new DefaultHttpClient();){
            HttpPost httppost = new HttpPost(sfUrl);
            httppost.setHeader(X_SFDC_SESSION_HEADER, sessionId);
            httppost.setHeader(CONTENT_TYPE_HEADER, APPLICATION_XML_CHARSET_UTF_8);
            httppost.setEntity((HttpEntity)new StringEntity(content));
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httppost);
            String res = SalesForceHelper.readStream(resp.getEntity().getContent());
            if (res.contains("<state>")) {
                res = res.substring(res.indexOf("<state>"), res.indexOf("</state>")).replace("<state>", "");
            }
            return res.equals("Closed");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static enum Operation {
        insert,
        update,
        delete,
        query;

    }
}

