/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.indy.addons.salesforce.core.SFField;
import com.indy.engine.addons.salesforce.SForceErrorAcceptance;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.ConcurrencyMode;
import com.sforce.async.ContentType;
import com.sforce.async.OperationEnum;
import com.sforce.async.Result;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.EmptyRecycleBinResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.StatusCode;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.bind.XmlObject;
import com.stambia.salesforce.connector.SalesForceBulkConnection;
import com.stambia.salesforce.connector.SalesForceConnection;
import com.stambia.salesforce.connector.exceptions.EntityProcessingException;
import com.stambia.salesforce.connector.object.Batch;
import com.stambia.salesforce.connector.object.BulkJob;
import com.stambia.salesforce.connector.util.Messages;
import com.stambia.salesforce.connector.util.api.AsynchSObject;
import com.stambia.salesforce.connector.util.api.ResultWrapper;
import com.stambia.salesforce.connector.util.api.SObjectWrapper;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.Logger;

public class XmlToSForce {
    private Map<String, String> externalIds;
    private int batchSize;
    private IntegrationMode mode;
    private SForceErrorAcceptance errorAcceptance;
    private SalesForceConnection conn;
    private Map<String, Map<String, Map<String, String>>> descriptors;
    private TypeMapper typeMapper;
    private boolean dataAsAttribute = true;
    private String nullValueKeyWord;
    private String disableFieldKeyWord;
    XMLEventWriter writer = null;
    String currentEntityName = null;
    String precEntityName = null;
    Batch batch = new Batch();
    boolean hasOneOrMoreError = false;
    SObjectWrapper currentObject;
    SObjectEvents currentsObjectEvent = new SObjectEvents();
    XMLEventFactory eventFactory;
    int errors = 0;
    String firstException = null;
    XmlToSForceHandler handler = null;
    Map<String, Batch> batches = new HashMap<String, Batch>();
    Logger logger;
    String logParentMsg;
    String logMsg = "SalesForce XmlToSforce: ";
    BulkJob bulkJob;
    Thread asynchThread = null;
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
        }
    };
    long lastScan = 0L;
    long bulkPollint = 100000L;
    long bulkMaxSize = 10L;
    ConcurrencyMode bulkConcurrencyMode = ConcurrencyMode.Serial;
    boolean bulkEnable = true;
    ContentType type = ContentType.ZIP_XML;
    boolean readResult = true;
    boolean keepMessage = false;

    public XmlToSForce(SalesForceConnection conn, Map<String, String> externalIds, int batchSize, IntegrationMode mode, SForceErrorAcceptance errorAcceptance, Map<String, Map<String, Map<String, String>>> descriptors, boolean dataAsAttribute, String nullValueKeyWord, String disableFieldKeyWord, boolean bulkMode, long bulkPollint, int bulkMaxConcurentBatch, ConcurrencyMode bulkConcurrencyMode, String parentLogMsg, ContentType sForceContentType, boolean sForceReadResult, Logger logger) throws XMLStreamException, FactoryConfigurationError {
        this.bulkEnable = bulkMode;
        this.externalIds = externalIds;
        this.batchSize = batchSize;
        this.mode = mode;
        this.errorAcceptance = errorAcceptance;
        this.conn = conn;
        this.descriptors = descriptors;
        this.typeMapper = new TypeMapper();
        this.dataAsAttribute = dataAsAttribute;
        this.nullValueKeyWord = nullValueKeyWord;
        this.disableFieldKeyWord = disableFieldKeyWord;
        this.currentObject = this.newSObject();
        this.bulkConcurrencyMode = bulkConcurrencyMode;
        this.bulkMaxSize = bulkMaxConcurentBatch;
        this.bulkPollint = bulkPollint;
        this.logParentMsg = parentLogMsg;
        this.logger = logger;
        this.type = sForceContentType;
        this.readResult = sForceReadResult;
    }

    public void setHandler(XmlToSForceHandler handler) {
        this.handler = handler;
    }

    public void checkDescriptors() throws Exception {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (String sObject : this.descriptors.keySet()) {
            for (String sField : this.descriptors.get(sObject).keySet()) {
                SFField fi;
                Map<String, String> fieldProps = this.descriptors.get(sObject).get(sField);
                String _extId = fieldProps.get("fkExternalId");
                boolean extId = _extId != null && _extId.equals("true");
                String refExtId = fieldProps.get("fkExternalIdName");
                String fkObjectType = fieldProps.get("fkObjectType");
                boolean bl = extId = extId || refExtId != null || fkObjectType != null;
                if (!extId) continue;
                if (fkObjectType == null) {
                    fi = this.conn.getMetaData().getField(sObject, sField);
                    List refs = fi.getReferences();
                    if (refs.size() == 1) {
                        fkObjectType = (String)refs.get(0);
                    } else if (refs.size() == 0) {
                        errors.add((CallSite)((Object)("SObject: " + sObject + Messages.getString("XmlToSForce.0") + sField + Messages.getString("XmlToSForce.1"))));
                    } else if (refs.size() > 1) {
                        errors.add((CallSite)((Object)("SObject: " + sObject + Messages.getString("XmlToSForce.2") + sField + Messages.getString("XmlToSForce.3") + String.valueOf(refs) + Messages.getString("XmlToSForce.4"))));
                    }
                }
                if (fkObjectType != null && refExtId == null) {
                    Object _fi = null;
                    List fis = this.conn.getMetaData().getFields(fkObjectType);
                    ArrayList<String> refs = new ArrayList<String>();
                    for (SFField fi2 : fis) {
                        if (!fi2.isExternalId() || !fi2.isUnique()) continue;
                        refs.add(fi2.getName());
                    }
                    if (refs.size() == 1) {
                        refExtId = (String)refs.get(0);
                    } else if (refs.size() == 0) {
                        errors.add((CallSite)((Object)("SObject: " + sObject + Messages.getString("XmlToSForce.5") + sField + Messages.getString("XmlToSForce.6") + fkObjectType + Messages.getString("XmlToSForce.7"))));
                    } else if (refs.size() > 1) {
                        errors.add((CallSite)((Object)("SObject: " + sObject + Messages.getString("XmlToSForce.8") + sField + Messages.getString("XmlToSForce.9") + fkObjectType + Messages.getString("XmlToSForce.10") + String.valueOf(refs) + Messages.getString("XmlToSForce.11"))));
                    }
                }
                if (fkObjectType != null && refExtId != null) {
                    fi = this.conn.getMetaData().getField(fkObjectType, refExtId);
                    if (fi != null) {
                        fieldProps.put("fkExternalIdType", fi.getType().replaceFirst("_", ""));
                        fieldProps.put("fkExternalIdName", refExtId);
                        fieldProps.put("fkObjectType", fkObjectType);
                        continue;
                    }
                    errors.add((CallSite)((Object)("SObject: " + sObject + " field: " + sField + Messages.getString("XmlToSForce.12") + fkObjectType + Messages.getString("XmlToSForce.13") + refExtId)));
                    fieldProps.remove("fkExternalIdName");
                    fieldProps.remove("fkObjectType");
                    continue;
                }
                fieldProps.remove("fkExternalIdName");
                fieldProps.remove("fkObjectType");
            }
        }
        if (errors.size() > 0) {
            throw new EngineExceptionI("Errors: " + String.valueOf(errors));
        }
    }

    private SObjectWrapper newSObject() {
        if (this.bulkEnable) {
            return new AsynchSObject();
        }
        return new SynchSObject();
    }

    public void readWrite(InputStream is, OutputStream os) throws FactoryConfigurationError, Exception {
        XMLEventReader reader = null;
        try {
            try {
                this.eventFactory = XMLEventFactory.newFactory();
                XMLOutputFactory xof = XMLOutputFactory.newFactory();
                this.writer = xof.createXMLEventWriter(os, StandardCharsets.UTF_8.name());
                XMLInputFactory xif = XMLInputFactory.newFactory();
                xif.setProperty("javax.xml.stream.supportDTD", false);
                xif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                if (xif.getClass().getName().startsWith("com.ctc.wstx.stax.WstxInputFactory")) {
                    xif.setProperty("com.ctc.wstx.maxAttributeSize", Integer.MAX_VALUE);
                }
                reader = xif.createXMLEventReader(is, "UTF-8");
                int proof = 0;
                String currentFieldName = null;
                boolean filter = false;
                Map<String, Map<String, String>> currentDescriptor = null;
                while (reader.hasNext()) {
                    if (Thread.interrupted()) {
                        throw new EngineExceptionI("Thread is interrupted");
                    }
                    XMLEvent event = reader.nextEvent();
                    if (!filter && event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("SForceExchangeOutput")) {
                        filter = true;
                    }
                    if (filter) {
                        if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals("SForceExchangeOutput")) continue;
                        filter = false;
                        continue;
                    }
                    if (this.errorAcceptance.toleratedErrorReached(this.errors)) {
                        this.writeXMLEvent(event);
                        continue;
                    }
                    if (event.isStartElement()) {
                        ++proof;
                    }
                    if (proof >= 2) {
                        if (proof <= 2 || this.keepMessage) {
                            this.currentsObjectEvent.events.add(event);
                        }
                    } else {
                        if (proof == 1 && this.batch.size() > 0) {
                            this.executeBatch();
                        }
                        if (proof == 1 && event.isEndElement()) {
                            this.norMoreBatch();
                        }
                        this.writeXMLEvent(event);
                    }
                    if (proof == 2) {
                        if (event.isStartElement()) {
                            StartElement se = event.asStartElement();
                            this.currentEntityName = se.getName().getLocalPart();
                            this.currentObject.setType(this.currentEntityName);
                            currentDescriptor = this.descriptors.get(this.currentEntityName);
                            Iterator<Attribute> it = se.getAttributes();
                            while (it.hasNext()) {
                                Attribute attr = it.next();
                                String _currentFieldName = attr.getName().getLocalPart();
                                if (this.mode == IntegrationMode.insert && _currentFieldName.equals("Id")) {
                                    _currentFieldName = null;
                                }
                                if (_currentFieldName == null) continue;
                                this.addField(_currentFieldName, attr.getValue(), currentDescriptor);
                            }
                        } else if (event.isEndElement()) {
                            this.currentObject.endObject();
                            this.batch.add(this.currentObject);
                            this.batch.getEvents().put(this.currentObject, this.currentsObjectEvent);
                            if (this.batch.size() == this.batchSize || this.precEntityName != null && !this.precEntityName.equals(this.currentEntityName)) {
                                this.executeBatch();
                            }
                            this.precEntityName = this.currentEntityName;
                            this.currentObject = this.newSObject();
                            this.currentsObjectEvent = new SObjectEvents();
                        }
                    } else if (proof == 3) {
                        if (event.isStartElement()) {
                            currentFieldName = event.asStartElement().getName().getLocalPart();
                            if (this.mode == IntegrationMode.insert && currentFieldName.equals("Id")) {
                                currentFieldName = null;
                            }
                        } else if (event.isCharacters() && currentFieldName != null) {
                            this.addField(currentFieldName, event.asCharacters().getData(), currentDescriptor);
                        } else if (event.isEndElement()) {
                            currentFieldName = null;
                        }
                    }
                    if (!event.isEndElement()) continue;
                    --proof;
                }
                if (this.hasOneOrMoreError && this.errorAcceptance.shouldRaiseAnExceptionFor(this.errors)) {
                    throw new Exception(this.errors + Messages.getString("XmlToSForce.14") + this.firstException);
                }
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
                throw e;
            }
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private synchronized void writeXMLEvent(XMLEvent event) throws XMLStreamException {
        this.writer.add(event);
    }

    private void addField(String currentFieldName, String data, Map<String, Map<String, String>> currentDescriptor) {
        if (this.disableFieldKeyWord != null && data != null && data.equals(this.disableFieldKeyWord)) {
            return;
        }
        if (data == null || this.nullValueKeyWord != null && data.equals(this.nullValueKeyWord)) {
            this.currentObject.setFieldToNull(currentFieldName);
        } else if (currentDescriptor != null) {
            Map desc = currentDescriptor.getOrDefault(currentFieldName, Collections.emptyMap());
            String type = (String)desc.get("xmlType");
            type = type == null ? "string" : (type.equals("integer") ? "int" : type);
            String refExtId = (String)desc.get("fkExternalIdName");
            String fkObjectType = null;
            String refExtIdType = (String)desc.get("fkExternalIdType");
            if (refExtId != null && !refExtId.isEmpty()) {
                fkObjectType = (String)desc.get("fkObjectType");
            }
            if (fkObjectType != null) {
                SObjectWrapper fk = this.newSObject();
                fk.setType(fkObjectType);
                if (this.currentObject.writeXmlStringRawData()) {
                    fk.addField(refExtId, data);
                } else {
                    Object value = this.typeMapper.deserialize(data, new QName("http://www.w3.org/2001/XMLSchema", refExtIdType));
                    fk.addField(refExtId, value);
                }
                String _currentFieldName = currentFieldName.endsWith("__c") ? currentFieldName.replaceAll("__c$", "__r") : (currentFieldName.endsWith("Id") ? currentFieldName.replaceAll("Id$", "") : currentFieldName);
                this.currentObject.setFieldReference(_currentFieldName, fk);
            } else if (this.currentObject.writeXmlStringRawData()) {
                this.currentObject.addField(currentFieldName, data);
            } else {
                Object value = this.typeMapper.deserialize(data, new QName("http://www.w3.org/2001/XMLSchema", type));
                this.currentObject.addField(currentFieldName, value);
            }
        } else {
            this.currentObject.addField(currentFieldName, data);
        }
    }

    private void executeBatch() throws EntityProcessingException, Exception {
        if (this.bulkEnable) {
            this.executeASynchBatch();
        } else {
            this.executeSynchBatch();
        }
    }

    private void info(String message) {
        this.logger.info(this.logParentMsg + this.logMsg + message);
    }

    private void debug(String message) {
        this.logger.debug(this.logParentMsg + this.logMsg + message);
    }

    private void norMoreBatch() throws EntityProcessingException, Exception {
        if (this.bulkJob != null) {
            this.bulkJob.closeJob();
            this.bulkJob.stopCheckEndbatch();
            this.bulkJob.checkEndBatch(true);
            this.checkEndedResults();
        }
    }

    private boolean checkEndedResults() throws EntityProcessingException, Exception {
        if (this.bulkJob != null) {
            List<BatchInfo> list = this.bulkJob.getEndedBatches();
            String batchId = null;
            Batch batch = null;
            String jobId = null;
            XmlToSForceEvent event = null;
            for (BatchInfo bi : list) {
                batchId = bi.getId();
                batch = this.batches.get(batchId);
                batch.state = bi.getState();
                if (this.readResult) {
                    Iterable<Result> res = null;
                    boolean emptyRes = false;
                    if (this.mode == IntegrationMode.query) {
                        SelectResult[] resArray = this.bulkJob.getQueryResult(bi, this.currentEntityName);
                        boolean bl = emptyRes = resArray != null && resArray.length == 0;
                        if (!emptyRes) {
                            res = Arrays.asList(resArray);
                        }
                    } else {
                        res = this.bulkJob.getResult(bi);
                    }
                    if (this.handler != null && (res == null || emptyRes)) {
                        this.hasOneOrMoreError = true;
                        this.errors = bi.getNumberRecordsFailed();
                        jobId = bi.getJobId();
                        this.firstException = String.format(Messages.getString("XmlToSForce.18"), jobId, batchId);
                        event = new XmlToSForceEvent();
                        event.errorNb = this.errors;
                        this.handler.handleBatch(event);
                    }
                    this.writeResult(batch, res, null);
                    if (res instanceof Closeable) {
                        ((Closeable)((Object)res)).close();
                    }
                }
                this.batches.remove(bi.getId());
                batch.clear();
            }
            return !list.isEmpty();
        }
        return false;
    }

    void initBulk() throws Exception {
        OperationEnum op;
        if (this.mode == IntegrationMode.delete) {
            op = OperationEnum.delete;
        } else if (this.mode == IntegrationMode.hardDelete) {
            op = OperationEnum.hardDelete;
        } else {
            if (this.mode == IntegrationMode.deleteFromRecycleBin) {
                throw new Exception(Messages.getString("XmlToSForce.15"));
            }
            if (this.mode == IntegrationMode.insert) {
                op = OperationEnum.insert;
            } else if (this.mode == IntegrationMode.update) {
                op = OperationEnum.update;
            } else if (this.mode == IntegrationMode.upsert) {
                op = OperationEnum.upsert;
            } else if (this.mode == IntegrationMode.query) {
                op = OperationEnum.query;
                this.type = ContentType.CSV;
            } else {
                throw new Exception(String.valueOf((Object)this.mode) + Messages.getString("XmlToSForce.16"));
            }
        }
        this.lastScan = System.currentTimeMillis();
        this.bulkJob = new BulkJob(((SalesForceBulkConnection)this.conn).getBulkConnection(), this.logParentMsg + this.logMsg, this.logger);
        this.bulkJob.type = this.type;
        String id = this.externalIds.get(this.currentEntityName);
        this.bulkJob.createJob(this.currentEntityName, op, this.bulkConcurrencyMode, id != null ? id : "Id");
        this.bulkJob.setBulkMaxSize(this.bulkMaxSize);
        this.bulkJob.setBulkPollint(this.bulkPollint);
    }

    private void executeASynchBatch() throws EntityProcessingException, Exception {
        boolean bulkInit = false;
        if (this.bulkJob == null) {
            bulkInit = true;
            this.initBulk();
        }
        String batchId = this.mode == IntegrationMode.query ? this.bulkJob.createQueryBatch(this.createSelect(this.currentEntityName, this.batch.toWrapperArray(), true)) : (this.type == ContentType.CSV || this.type == ContentType.ZIP_CSV ? this.bulkJob.createCsvBatch(this.batch.toASynchArray()) : this.bulkJob.createBatch(this.batch.toASynchArray()));
        XmlToSForceEvent event = new XmlToSForceEvent();
        event.batchSent = 1;
        if (this.handler != null) {
            this.handler.handleBatch(event);
        }
        this.batch.setId(batchId);
        this.batches.put(batchId, this.batch);
        if (!this.readResult) {
            this.writeResult(this.batch, null, null);
            this.batch.getEvents().clear();
        }
        this.batch = new Batch();
        if (bulkInit) {
            this.bulkJob.startCheckEndbatchThread();
        }
        if (this.bulkMaxSize != -1L && this.bulkJob.size() == this.bulkMaxSize) {
            this.bulkJob.waitForChange();
        }
        this.checkEndedResults();
    }

    private ResultWrapper toResultWrapper(final Object _r) {
        ResultWrapper r = null;
        if (_r instanceof SaveResult) {
            r = new ResultWrapper(){

                @Override
                public boolean isSuccess() {
                    return ((SaveResult)_r).isSuccess();
                }

                @Override
                public String getId() {
                    return ((SaveResult)_r).getId();
                }

                @Override
                public Error[] getErrors() {
                    return ((SaveResult)_r).getErrors();
                }

                @Override
                public boolean isCreated() {
                    return false;
                }
            };
        } else if (_r instanceof UpsertResult) {
            r = new ResultWrapper(){

                @Override
                public boolean isSuccess() {
                    return ((UpsertResult)_r).isSuccess();
                }

                @Override
                public boolean isCreated() {
                    return ((UpsertResult)_r).isCreated();
                }

                @Override
                public String getId() {
                    return ((UpsertResult)_r).getId();
                }

                @Override
                public Error[] getErrors() {
                    return ((UpsertResult)_r).getErrors();
                }
            };
        } else if (_r instanceof DeleteResult) {
            r = new ResultWrapper(){

                @Override
                public boolean isSuccess() {
                    return ((DeleteResult)_r).isSuccess();
                }

                @Override
                public boolean isCreated() {
                    return false;
                }

                @Override
                public String getId() {
                    return ((DeleteResult)_r).getId();
                }

                @Override
                public Error[] getErrors() {
                    return ((DeleteResult)_r).getErrors();
                }
            };
        } else if (_r instanceof ResultWrapper) {
            r = (ResultWrapper)_r;
        } else if (_r instanceof Result) {
            r = new ResultWrapper(){

                @Override
                public boolean isSuccess() {
                    return ((Result)_r).isSuccess();
                }

                @Override
                public boolean isCreated() {
                    return ((Result)_r).isCreated();
                }

                @Override
                public String getId() {
                    return ((Result)_r).getId();
                }

                @Override
                public Error[] getErrors() {
                    Error[] errors = new Error[((Result)_r).getErrors().length];
                    int i = 0;
                    com.sforce.async.Error[] errorArray = ((Result)_r).getErrors();
                    int n = errorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        com.sforce.async.Error error = errorArray[n2];
                        errors[i] = new Error();
                        errors[i].setMessage(error.getMessage());
                        errors[i].setFields(error.getFields());
                        com.sforce.async.StatusCode sfAsyncStatusCode = error.getStatusCode();
                        String rawStatusCode = sfAsyncStatusCode.toString();
                        StatusCode sfAsynStatusCode = StatusCode.valueOf((String)rawStatusCode);
                        errors[i].setStatusCode(sfAsynStatusCode);
                        ++i;
                        ++n2;
                    }
                    return errors;
                }
            };
        } else if (_r instanceof EmptyRecycleBinResult) {
            r = new ResultWrapper(){

                @Override
                public boolean isSuccess() {
                    return ((EmptyRecycleBinResult)_r).isSuccess();
                }

                @Override
                public boolean isCreated() {
                    return false;
                }

                @Override
                public String getId() {
                    return ((EmptyRecycleBinResult)_r).getId();
                }

                @Override
                public Error[] getErrors() {
                    return ((EmptyRecycleBinResult)_r).getErrors();
                }
            };
        } else if (_r instanceof RetrieveResult) {
            r = new ResultWrapper(){

                @Override
                public boolean isSuccess() {
                    return ((RetrieveResult)_r).retrieve != null;
                }

                @Override
                public boolean isCreated() {
                    return false;
                }

                @Override
                public String getId() {
                    if (((RetrieveResult)_r).origin != null) {
                        return ((RetrieveResult)_r).origin.getId();
                    }
                    return ((RetrieveResult)_r).retrieve.getId();
                }

                @Override
                public Error[] getErrors() {
                    return null;
                }
            };
        } else if (_r instanceof SelectResult) {
            r = new ResultWrapper(){

                @Override
                public boolean isSuccess() {
                    return ((SelectResult)_r).result != null;
                }

                @Override
                public boolean isCreated() {
                    return false;
                }

                @Override
                public String getId() {
                    if (((SelectResult)_r).result != null) {
                        return ((SelectResult)_r).result.getId();
                    }
                    return null;
                }

                @Override
                public Error[] getErrors() {
                    return null;
                }
            };
        }
        return r;
    }

    private ResultWrapper combine(final ResultWrapper r, final ResultWrapper r2) {
        if (r == null) {
            return r2;
        }
        if (r2 == null) {
            return r;
        }
        return new ResultWrapper(){

            @Override
            public boolean isSuccess() {
                return r.isSuccess() && r2.isSuccess();
            }

            @Override
            public boolean isCreated() {
                return r.isCreated() && r2.isCreated();
            }

            @Override
            public String getId() {
                return r.getId();
            }

            @Override
            public Error[] getErrors() {
                if (r.getErrors() != null && r2.getErrors() != null) {
                    return XmlToSForce.concat(r.getErrors(), r2.getErrors());
                }
                if (r.getErrors() != null) {
                    return r.getErrors();
                }
                if (r2.getErrors() != null) {
                    return r2.getErrors();
                }
                return null;
            }
        };
    }

    private void writeResult(Batch batch, Iterable<? extends Object> res, Object[] res2) throws Exception {
        XmlToSForceEvent event = new XmlToSForceEvent();
        if (batch.state != null) {
            if (batch.state == BatchStateEnum.Completed) {
                event.batchEnded = 1;
            } else {
                event.batchError = 1;
            }
        }
        if (res != null) {
            int i = 0;
            for (Object object : res) {
                List<Object> _events;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                ResultWrapper r = this.toResultWrapper(object);
                if (res2 != null && res2[i] != null) {
                    r = this.combine(r, this.toResultWrapper(res2[i]));
                }
                if (r != null && !r.isSuccess()) {
                    this.hasOneOrMoreError = true;
                    ++event.errorNb;
                } else if (this.mode == IntegrationMode.insert) {
                    ++event.successCreated;
                } else if (this.mode.isDelete()) {
                    ++event.successDeleted;
                } else if (this.mode == IntegrationMode.update) {
                    ++event.successUpdated;
                } else if (this.mode == IntegrationMode.upsert) {
                    if (r != null && r.isCreated()) {
                        ++event.successCreated;
                    } else {
                        ++event.successUpdated;
                    }
                } else if (this.mode.isGet()) {
                    ++event.successGet;
                }
                SObjectWrapper sObject = null;
                if (this.mode.isGet()) {
                    SObject retrieve;
                    _events = new ArrayList();
                    SObject sObject2 = retrieve = object instanceof RetrieveResult ? ((RetrieveResult)object).retrieve : ((SelectResult)object).result;
                    if (retrieve != null) {
                        ArrayList<Attribute> list = new ArrayList<Attribute>();
                        Iterator it = retrieve.getChildren();
                        while (it.hasNext()) {
                            XmlObject xo = (XmlObject)it.next();
                            if (xo.getValue() == null) continue;
                            list.add(this.eventFactory.createAttribute(xo.getName().getLocalPart(), xo.getValue().toString()));
                        }
                        _events.add(this.eventFactory.createStartElement("", null, retrieve.getType(), list.iterator(), null));
                        _events.add(this.eventFactory.createEndElement("", null, retrieve.getType()));
                    }
                } else {
                    sObject = batch.get(i);
                    SObjectEvents __events = batch.getEvents().get(sObject);
                    _events = __events.events;
                }
                int j = 0;
                while (j < _events.size()) {
                    if (j == _events.size() - 1) {
                        this.writeSForceExchangeOutput(r, sObject);
                    }
                    this.writeXMLEvent((XMLEvent)_events.get(j));
                    ++j;
                }
                ++i;
            }
        } else {
            for (Map.Entry<SObjectWrapper, SObjectEvents> entry : batch.getEvents().entrySet()) {
                for (XMLEvent _event : entry.getValue().events) {
                    this.writeXMLEvent(_event);
                }
            }
        }
        if (this.handler != null) {
            this.handler.handleBatch(event);
        }
    }

    protected void writeSForceExchangeOutput(ResultWrapper result, SObjectWrapper sObject) throws Exception {
        this.writeXMLEvent(this.eventFactory.createStartElement(new QName("SForceExchangeOutput"), null, null));
        if (result.getId() != null) {
            this.addOutputInfo("Id", result.getId());
        }
        this.addOutputInfo("Status", result.isSuccess() ? "success" : "error");
        this.addOutputInfo("IsSuccess", String.valueOf(result.isSuccess()));
        this.addOutputInfo("IsCreated", String.valueOf(result.isCreated()));
        if (result.getErrors() != null) {
            Error[] errorArray = result.getErrors();
            int n = errorArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] fields;
                Error error = errorArray[n2];
                ++this.errors;
                if (this.errors == 1) {
                    this.firstException = result.getId() != null ? "Id=" + result.getId() : (sObject != null && sObject.getId() != null ? "Id=" + String.valueOf(sObject.getId()) : "");
                }
                this.writeXMLEvent(this.eventFactory.createStartElement(new QName("Error"), null, null));
                if (error.getStatusCode() != null) {
                    if (this.errors == 1) {
                        if (!this.firstException.isEmpty()) {
                            this.firstException = String.valueOf(this.firstException) + ", ";
                        }
                        this.firstException = String.valueOf(this.firstException) + "StatusCode=" + String.valueOf(error.getStatusCode());
                    }
                    this.addOutputInfo("StatusCode", error.getStatusCode().toString());
                }
                if (error.getMessage() != null) {
                    if (this.errors == 1) {
                        if (!this.firstException.isEmpty()) {
                            this.firstException = String.valueOf(this.firstException) + ", ";
                        }
                        this.firstException = String.valueOf(this.firstException) + "Message=" + error.getMessage();
                    }
                    this.addOutputInfo("Message", error.getMessage());
                }
                if ((fields = error.getFields()) != null && fields.length > 0) {
                    String field;
                    StringBuilder allFields = new StringBuilder();
                    String[] stringArray = error.getFields();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        field = stringArray[n4];
                        if (allFields.length() > 0) {
                            allFields.append(',');
                        }
                        if (this.errors == 1) {
                            if (!this.firstException.isEmpty()) {
                                this.firstException = String.valueOf(this.firstException) + ", ";
                            }
                            this.firstException = String.valueOf(this.firstException) + "FieldName=" + field;
                        }
                        allFields.append(field);
                        ++n4;
                    }
                    this.addOutputInfo("FieldName", allFields.toString());
                    stringArray = error.getFields();
                    n3 = stringArray.length;
                    n4 = 0;
                    while (n4 < n3) {
                        field = stringArray[n4];
                        this.writeXMLEvent(this.eventFactory.createStartElement(new QName("Field"), null, null));
                        this.addOutputInfo("FieldName", field);
                        this.writeXMLEvent(this.eventFactory.createEndElement(new QName("Field"), null));
                        ++n4;
                    }
                }
                this.writeXMLEvent(this.eventFactory.createEndElement(new QName("Error"), null));
                ++n2;
            }
        }
        this.writeXMLEvent(this.eventFactory.createEndElement(new QName("SForceExchangeOutput"), null));
    }

    private void executeSynchBatch() throws EntityProcessingException, Exception {
        Object[] resArray = null;
        Object[] res2 = null;
        if (this.mode == IntegrationMode.delete) {
            extractIds = this.extractIds(this.batch.toSynchArray());
            resArray = this.delete(this.currentEntityName, extractIds);
        } else if (this.mode == IntegrationMode.deleteFromRecycleBin) {
            extractIds = this.extractIds(this.batch.toSynchArray());
            resArray = this.emptyRecylcyleBin(this.currentEntityName, extractIds);
        } else if (this.mode == IntegrationMode.hardDelete) {
            SObject[] objects = this.batch.toSynchArray();
            String[] extractIds = this.extractIds(objects);
            resArray = this.delete(this.currentEntityName, extractIds);
            res2 = this.emptyRecylcyleBin(this.currentEntityName, extractIds);
        } else if (this.mode == IntegrationMode.insert) {
            resArray = this.insert(this.currentEntityName, this.batch.toSynchArray());
        } else if (this.mode == IntegrationMode.update) {
            resArray = this.update(this.currentEntityName, this.batch.toSynchArray());
        } else if (this.mode == IntegrationMode.upsert) {
            id = this.externalIds.get(this.currentEntityName);
            resArray = this.upsert(this.currentEntityName, id != null ? id : "Id", this.batch.toSynchArray());
        } else if (this.mode == IntegrationMode.retrieve) {
            id = this.externalIds.get(this.currentEntityName);
            resArray = this.retrieve(this.currentEntityName, id, this.batch.toSynchArray());
        } else if (this.mode == IntegrationMode.query) {
            resArray = this.select(this.currentEntityName, this.batch.toWrapperArray());
        }
        XmlToSForceEvent event = new XmlToSForceEvent();
        event.batchSent = 1;
        if (this.handler != null) {
            this.handler.handleBatch(event);
        }
        List<DeleteResult> res = Arrays.asList(resArray);
        this.writeResult(this.batch, res, res2);
        this.batch.clear();
    }

    private void addOutputInfo(String name, String data) throws XMLStreamException {
        if (this.dataAsAttribute) {
            this.writeXMLEvent(this.eventFactory.createAttribute(name, data));
        } else {
            this.writeXMLEvent(this.eventFactory.createStartElement(new QName(name), null, null));
            this.writeXMLEvent(this.eventFactory.createCharacters(data));
            this.writeXMLEvent(this.eventFactory.createEndElement(new QName(name), null));
        }
    }

    public UpsertResult[] upsert(String entityName, String externalIDFieldName, SObject[] toUpsert) throws EntityProcessingException, Exception {
        UpsertResult[] res = this.getPartnerConnection().upsert(externalIDFieldName, toUpsert);
        return res;
    }

    public RetrieveResult[] retrieve(String entityName, String externalIDFieldName, SObject[] toGet) throws EntityProcessingException, Exception {
        DescribeSObjectResult des = this.getPartnerConnection().describeSObject(entityName);
        Object fieldList = null;
        Field[] fieldArray = des.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            fieldList = fieldList == null ? "" : (String)fieldList + ", ";
            fieldList = (String)fieldList + field.getName();
            ++n2;
        }
        RetrieveResult[] res = new RetrieveResult[toGet.length];
        if (externalIDFieldName == null) {
            String[] extractIds = this.extractIds(this.batch.toSynchArray());
            SObject[] resu = this.getPartnerConnection().retrieve((String)fieldList, entityName, extractIds);
            HashMap<String, SObject> map = new HashMap<String, SObject>();
            int i = 0;
            while (i < resu.length) {
                if (resu[i] != null) {
                    map.put(resu[i].getId(), resu[i]);
                }
                ++i;
            }
            i = 0;
            while (i < toGet.length) {
                RetrieveResult rr = new RetrieveResult();
                rr.origin = toGet[i];
                rr.retrieve = (SObject)map.get(toGet[i].getId());
                res[i] = rr;
                ++i;
            }
        } else {
            String[] extractIds = this.extractExternaldIds(this.batch.toSynchArray(), externalIDFieldName);
            Object in = " in(";
            int i = 0;
            while (i < extractIds.length) {
                if (i > 0) {
                    in = (String)in + ",";
                }
                in = (String)in + "'" + extractIds[i] + "'";
                ++i;
            }
            in = (String)in + ")";
            QueryResult result = this.getPartnerConnection().query("select " + (String)fieldList + " from " + entityName + " where " + externalIDFieldName + (String)in);
            SObject[] resu = result.getRecords();
            HashMap<String, SObject> map = new HashMap<String, SObject>();
            int i2 = 0;
            while (i2 < resu.length) {
                map.put(resu[i2].getChild(externalIDFieldName).getValue().toString(), resu[i2]);
                ++i2;
            }
            i2 = 0;
            while (i2 < toGet.length) {
                RetrieveResult rr = new RetrieveResult();
                rr.origin = toGet[i2];
                rr.retrieve = (SObject)map.get(toGet[i2].getChild(externalIDFieldName).getValue().toString());
                res[i2] = rr;
                ++i2;
            }
        }
        return res;
    }

    private String createSelect(String entityName, SObjectWrapper[] toGet, boolean bulk) throws ConnectionException, Exception {
        QName typeQN = new QName("urn:sobject.partner.soap.sforce.com", "type");
        DescribeSObjectResult des = this.getPartnerConnection().describeSObject(entityName);
        Object fieldList = null;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field[] fieldArray = des.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            fields.put(field.getName(), field);
            if (!bulk || field.getType() != FieldType.address) {
                fieldList = fieldList == null ? "" : (String)fieldList + ", ";
                fieldList = (String)fieldList + field.getName();
            }
            ++n2;
        }
        Object exps = null;
        SObjectWrapper[] sObjectWrapperArray = toGet;
        int n3 = toGet.length;
        n = 0;
        while (n < n3) {
            SObjectWrapper so = sObjectWrapperArray[n];
            Object exp = null;
            Set<String> set = so.getFieldNames();
            for (String key : set) {
                Field field = (Field)fields.get(key);
                if (field.getType() == FieldType.id || field.getType() == FieldType.reference || field.getType() == FieldType.string) {
                    exp = exp == null ? "" : (String)exp + " and ";
                    String value = so.getFieldAsString(key);
                    if (value != null) {
                        exp = (String)exp + key + " = '" + value + "'";
                        continue;
                    }
                    exp = (String)exp + key + " = null";
                    continue;
                }
                throw new Exception("Error query doesn't support datatype: " + field.getType().name());
            }
            exps = exps == null ? "(" : (String)exps + " or (";
            exps = (String)exps + exp + ")";
            ++n;
        }
        return "select " + (String)fieldList + " from " + entityName + " where " + exps;
    }

    public SelectResult[] select(String entityName, SObjectWrapper[] toGet) throws EntityProcessingException, Exception {
        String query = this.createSelect(entityName, toGet, false);
        QueryResult result = this.getPartnerConnection().query(query);
        SObject[] resu = result.getRecords();
        SelectResult[] res = new SelectResult[resu.length];
        HashMap map = new HashMap();
        int i = 0;
        while (i < resu.length) {
            SelectResult rr = new SelectResult();
            rr.result = resu[i];
            res[i] = rr;
            ++i;
        }
        return res;
    }

    public SaveResult[] update(String entityName, SObject[] toUpdate) throws ConnectionException, Exception {
        SaveResult[] res = this.getPartnerConnection().update(toUpdate);
        return res;
    }

    private String[] extractIds(SObject[] objects) throws Exception {
        String[] list = new String[objects.length];
        int i = 0;
        while (i < objects.length) {
            SObject so = objects[i];
            if (so.getId() == null) {
                throw new Exception(Messages.getString("XmlToSForce.17") + so.toString());
            }
            list[i] = so.getId();
            ++i;
        }
        return list;
    }

    private String[] extractExternaldIds(SObject[] objects, String extName) throws Exception {
        String[] list = new String[objects.length];
        int i = 0;
        while (i < objects.length) {
            SObject so = objects[i];
            if (so.getChild(extName) == null || so.getChild(extName).getValue() == null) {
                throw new Exception("Missing id:" + so.toString());
            }
            list[i] = so.getChild(extName).getValue().toString();
            ++i;
        }
        return list;
    }

    public DeleteResult[] delete(String entityName, String[] toDelete) throws EntityProcessingException, Exception {
        DeleteResult[] res = this.getPartnerConnection().delete(toDelete);
        return res;
    }

    public EmptyRecycleBinResult[] emptyRecylcyleBin(String entityName, String[] _toDelete) throws EntityProcessingException, Exception {
        EmptyRecycleBinResult[] res = this.getPartnerConnection().emptyRecycleBin(_toDelete);
        return res;
    }

    private PartnerConnection getPartnerConnection() throws Exception {
        return this.conn.getPartnerConnection();
    }

    public SaveResult[] insert(String entityName, SObject[] toCreate) throws ConnectionException, Exception {
        SaveResult[] res = this.getPartnerConnection().create(toCreate);
        return res;
    }

    public void dispose() throws InterruptedException {
        if (this.bulkJob != null) {
            this.bulkJob.dispose();
        }
    }

    public static void main(String[] args) {
        String[] str = new String[]{"aa", "bb"};
        String[] str2 = new String[]{"cc", "dd"};
        String[] stringArray = XmlToSForce.concat(str, str2);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str3 = stringArray[n2];
            System.out.println(str3);
            ++n2;
        }
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static enum IntegrationMode {
        insert(true, false, false, false),
        update(false, true, false, false),
        upsert(true, true, false, false),
        delete(false, false, true, false),
        hardDelete(false, false, true, false),
        deleteFromRecycleBin(false, false, true, false),
        retrieve(false, false, false, true),
        query(false, false, false, true);

        boolean _update;
        boolean _insert;
        boolean _delete;
        boolean _get;

        public boolean isUpdate() {
            return this._update;
        }

        public boolean isInsert() {
            return this._insert;
        }

        public boolean isDelete() {
            return this._delete;
        }

        private IntegrationMode(boolean i, boolean u, boolean d, boolean g) {
            this._insert = i;
            this._update = u;
            this._delete = d;
            this._get = g;
        }

        public boolean isGet() {
            return this._get;
        }
    }

    class RetrieveResult {
        SObject retrieve;
        SObject origin;

        RetrieveResult() {
        }
    }

    public static class SObjectEvents {
        List<XMLEvent> events = new ArrayList<XMLEvent>();
    }

    public static class SelectResult {
        public SObject result;
    }

    static class SynchSObject
    implements SObjectWrapper<SObject> {
        SObject wrapp = new SObject();
        List<String> setFieldsToNull = null;
        QName typeQN = new QName("urn:sobject.partner.soap.sforce.com", "type");
        Map<String, Object> fields;

        SynchSObject() {
        }

        @Override
        public SObject getSObject() {
            return this.wrapp;
        }

        @Override
        public void setType(String currentEntityName) {
            this.wrapp.setType(currentEntityName);
        }

        @Override
        public void addField(String refExtId, Object value) {
            this.wrapp.addField(refExtId, value);
        }

        @Override
        public void setFieldsToNull(String[] str) {
            this.wrapp.setFieldsToNull(str);
        }

        @Override
        public String[] getFieldsToNull() {
            return this.wrapp.getFieldsToNull();
        }

        @Override
        public void setFieldToNull(String str) {
            if (this.setFieldsToNull == null) {
                this.setFieldsToNull = new ArrayList<String>();
            }
            this.setFieldsToNull.add(str);
        }

        @Override
        public void endObject() {
            if (this.setFieldsToNull != null) {
                this.wrapp.setFieldsToNull(this.setFieldsToNull.toArray(new String[this.setFieldsToNull.size()]));
            }
        }

        @Override
        public Object getId() {
            return this.wrapp.getId();
        }

        @Override
        public void setFieldReference(String name, SObjectWrapper ref) {
            this.wrapp.addField(name, ref.getSObject());
        }

        @Override
        public boolean writeXmlStringRawData() {
            return false;
        }

        @Override
        public String getFieldAsString(String name) {
            this.getFieldNames();
            Object o = this.fields.get(name);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Set<String> getFieldNames() {
            if (this.fields == null) {
                this.fields = new HashMap<String, Object>();
                Iterator it = this.wrapp.getChildren();
                while (it.hasNext()) {
                    XmlObject xo = (XmlObject)it.next();
                    if (xo.getName().equals(this.typeQN)) continue;
                    this.fields.put(xo.getName().getLocalPart(), xo.getValue());
                }
            }
            return this.fields.keySet();
        }
    }

    public static class XmlToSForceEvent {
        public int successUpdated;
        public int successCreated;
        public int successGet;
        public int errorNb;
        public int successDeleted;
        public int batchSent;
        public int batchEnded;
        public int batchError;
    }

    public static interface XmlToSForceHandler {
        public void handleBatch(XmlToSForceEvent var1);
    }
}

