/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.salesforce.connector.util;

import com.indy.engine.addons.salesforce.SForceErrorAcceptance;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.salesforce.bulk.configuration.SfBulkConfiguration;
import com.stambia.salesforce.bulk.jobController.JobControllerV2;
import com.stambia.salesforce.bulk.recordController.RecordControllerV2;
import com.stambia.salesforce.bulk.recordState.RecordStateAndStatus;
import com.stambia.salesforce.bulk.recordState.RecordStatus;
import com.stambia.salesforce.bulk.utils.SalesForceBulkUtils;
import com.stambia.salesforce.connector.util.IXmlToSForce;
import com.stambia.salesforce.connector.util.Messages;
import com.stambia.salesforce.connector.util.XmlToSForce;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class XmlToSForceBulkV2
implements IXmlToSForce {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private RecordControllerV2 recordControllerV2;
    private String sfObjectName;
    private String inputFile;
    private String temporaryFile;
    private int sForceBulkAwaitPolling;
    private int processErrorFound = 0;
    private SForceErrorAcceptance errorAcceptance;

    public XmlToSForceBulkV2(OAuth2Metadata oAuth2Metadata, SfBulkConfiguration.SalesforceParameter salesforceParameter, String folderPath, String filePattern, Logger logger, String inputFile) throws Exception {
        SfBulkConfiguration.WorkingFolder workingFolder = new SfBulkConfiguration.WorkingFolder(folderPath, filePattern);
        SfBulkConfiguration sfBulkConfiguration = new SfBulkConfiguration(oAuth2Metadata, salesforceParameter, workingFolder, logger);
        this.recordControllerV2 = new RecordControllerV2(sfBulkConfiguration);
        this.sfObjectName = salesforceParameter.getName();
        this.errorAcceptance = salesforceParameter.getErrorAcceptance();
        this.inputFile = inputFile;
        this.sForceBulkAwaitPolling = salesforceParameter.getPollInterval();
        this.temporaryFile = folderPath + "/" + filePattern + ".temp";
    }

    @Override
    public void readWrite(InputStream is, OutputStream os) throws Exception {
        if (this.recordControllerV2 != null && this.sfObjectName != null) {
            try {
                this.generateTempFile();
                this.read(is);
                this.write(os);
            }
            finally {
                this.dispose();
            }
        }
    }

    private void generateTempFile() throws IOException {
        Path input = new File(this.inputFile).toPath();
        Path temp = new File(this.temporaryFile).toPath();
        Files.copy(input, temp, StandardCopyOption.REPLACE_EXISTING);
    }

    private void read(InputStream is) throws Exception {
        XMLEventReader reader = null;
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.supportDTD", false);
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            reader = xif.createXMLEventReader(is, StandardCharsets.UTF_8.name());
            List<String> fieldsNames = this.recordControllerV2.getFieldsNames();
            int fieldsNumber = fieldsNames.size();
            String[] fieldsInitializer = new String[fieldsNumber];
            int recordNumber = 0;
            while (reader.hasNext()) {
                StartElement startElement;
                String objectName;
                if (Thread.interrupted()) {
                    throw new EngineExceptionI("Thread is interrupted");
                }
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !this.sfObjectName.equals(objectName = (startElement = event.asStartElement()).getName().getLocalPart())) continue;
                List<String> fields = Arrays.asList(fieldsInitializer);
                Iterator<Attribute> attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    String fieldName = attribute.getName().getLocalPart();
                    int fieldIndex = fieldsNames.indexOf(fieldName);
                    String value = attribute.getValue();
                    fields.set(fieldIndex, value);
                }
                this.recordControllerV2.newRecord(recordNumber, fields);
                ++recordNumber;
            }
            this.recordControllerV2.stopSendRecord();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.logger.warn("exception while closing reader", (Throwable)e);
                }
            }
        }
    }

    public void write(OutputStream os) throws IOException, XMLStreamException, InterruptedException, EngineExceptionI {
        XMLEventReader reader = null;
        XMLEventWriter writer = null;
        XMLOutputFactory xof = XMLOutputFactory.newFactory();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream temp = new FileInputStream(this.temporaryFile);){
                writer = xof.createXMLEventWriter(os, StandardCharsets.UTF_8.name());
                XMLEventFactory eventFactory = XMLEventFactory.newFactory();
                writer.add(eventFactory.createStartDocument());
                writer.add(eventFactory.createStartElement("", null, "SForceExchange"));
                XMLInputFactory xif = XMLInputFactory.newFactory();
                xif.setProperty("javax.xml.stream.supportDTD", false);
                xif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                reader = xif.createXMLEventReader(temp, StandardCharsets.UTF_8.name());
                int recordNumber = 0;
                String firstError = null;
                while (reader.hasNext()) {
                    StartElement startElement;
                    String localName;
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    XMLEvent event = reader.nextEvent();
                    if (!event.isStartElement() || !this.sfObjectName.equals(localName = (startElement = event.asStartElement()).getName().getLocalPart())) continue;
                    writer.add(eventFactory.createStartElement("", null, this.sfObjectName));
                    this.copyAttributes(startElement.getAttributes(), writer, eventFactory);
                    RecordStateAndStatus recordStateAndStatus = SalesForceBulkUtils.waitRecordProcessed(this.recordControllerV2, recordNumber, this.sForceBulkAwaitPolling);
                    if (recordStateAndStatus.status() != RecordStatus.SKIPPED) {
                        writer.add(eventFactory.createStartElement("", null, "SForceExchangeOutput"));
                        JobControllerV2.SalesForceResponse recordResponse = recordStateAndStatus.jobRecordState().getRecordResponse(recordNumber);
                        String message = Messages.getString("XmlToSForceBulkV2.2") + recordNumber + Messages.getString("XmlToSForceBulkV2.3") + String.valueOf(recordResponse);
                        this.logger.info(message);
                        switch (recordStateAndStatus.status()) {
                            case SUCCESS: {
                                String recordId = recordResponse.getSalesForceId();
                                String isCreated = recordResponse.getMessage();
                                writer.add(eventFactory.createAttribute("Id", recordId));
                                writer.add(eventFactory.createAttribute("Status", "success"));
                                writer.add(eventFactory.createAttribute("IsCreated", isCreated));
                                break;
                            }
                            case ERROR: {
                                if (recordResponse != null) {
                                    writer.add(eventFactory.createAttribute("Id", recordResponse.getSalesForceId()));
                                }
                                writer.add(eventFactory.createAttribute("Status", "error"));
                                writer.add(eventFactory.createAttribute("IsCreated", "false"));
                                writer.add(eventFactory.createStartElement("", null, "Error"));
                                String errorMessage = recordResponse == null ? Messages.getString("XmlToSForceBulkV2.0") : recordResponse.getMessage();
                                writer.add(eventFactory.createAttribute("Message", errorMessage));
                                writer.add(eventFactory.createEndElement("", null, "Error"));
                                ++this.processErrorFound;
                                if (firstError != null) break;
                                firstError = errorMessage;
                                break;
                            }
                        }
                        writer.add(eventFactory.createEndElement("", null, "SForceExchangeOutput"));
                    }
                    writer.add(eventFactory.createEndElement("", null, this.sfObjectName));
                    ++recordNumber;
                }
                writer.add(eventFactory.createEndElement("", null, "SForceExchange"));
                writer.add(eventFactory.createEndDocument());
                if (this.errorAcceptance.shouldRaiseAnExceptionFor(this.processErrorFound)) {
                    throw new EngineExceptionI(this.processErrorFound + Messages.getString("XmlToSForceBulkV2.1") + firstError);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.logger.warn("exception while close", (Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.logger.warn("exception while close", (Throwable)e);
                }
            }
        }
    }

    private void copyAttributes(Iterator<Attribute> attributes, XMLEventWriter writer, XMLEventFactory eventFactory) throws XMLStreamException {
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            QName name = attribute.getName();
            String value = attribute.getValue();
            writer.add(eventFactory.createAttribute(name, value));
        }
    }

    private void removeTempFile() throws Exception {
        Path temp = new File(this.temporaryFile).toPath();
        Files.deleteIfExists(temp);
    }

    @Override
    public void setHandler(XmlToSForce.XmlToSForceHandler xmlToSForceHandler) {
    }

    @Override
    public void dispose() throws Exception {
        this.recordControllerV2.close(this.processErrorFound == 0);
        this.removeTempFile();
    }

    public RecordControllerV2 getRecordControllerV2() {
        return this.recordControllerV2;
    }
}

