/*
 * Decompiled with CFR 0.152.
 */
package endolabs.salesforce.bulkv2;

import endolabs.salesforce.bulkv2.RestRequester;
import endolabs.salesforce.bulkv2.request.CloseOrAbortJobRequest;
import endolabs.salesforce.bulkv2.request.CreateJobRequest;
import endolabs.salesforce.bulkv2.request.CreateQueryJob;
import endolabs.salesforce.bulkv2.request.GetAllJobsRequest;
import endolabs.salesforce.bulkv2.response.CloseOrAbortJobResponse;
import endolabs.salesforce.bulkv2.response.CreateJobResponse;
import endolabs.salesforce.bulkv2.response.CreateQueryJobResponse;
import endolabs.salesforce.bulkv2.response.GetAllJobsResponse;
import endolabs.salesforce.bulkv2.response.GetJobInfoResponse;
import endolabs.salesforce.bulkv2.response.JobInfo;
import endolabs.salesforce.bulkv2.type.JobStateEnum;
import endolabs.salesforce.bulkv2.type.OperationEnum;
import java.io.File;
import java.io.Reader;
import java.util.function.Consumer;

public class Bulk2Client {
    private static final String API_VERSION = "v62.0";
    private final RestRequester requester;
    private final String instanceUrl;

    public Bulk2Client(RestRequester requester, String instanceUrl) {
        this.instanceUrl = instanceUrl;
        this.requester = requester;
    }

    public CreateJobResponse createJob(String object, OperationEnum operation) {
        return this.createJob(object, operation, new Consumer<CreateJobRequest.Builder>(){

            @Override
            public void accept(CreateJobRequest.Builder request) {
            }
        });
    }

    public CreateJobResponse createJob(String object, OperationEnum operation, Consumer<CreateJobRequest.Builder> requestBuilder) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest");
        CreateJobRequest.Builder builder = new CreateJobRequest.Builder(object, operation);
        requestBuilder.accept(builder);
        return this.requester.post(url, builder.build(), CreateJobResponse.class);
    }

    public CreateQueryJobResponse createQueryJob(String query, OperationEnum operation) {
        return this.createQueryJob(query, operation, request -> {});
    }

    public CreateQueryJobResponse createQueryJob(String query, OperationEnum operation, Consumer<CreateQueryJob.Builder> requestBuilder) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/query");
        CreateQueryJob.Builder builder = new CreateQueryJob.Builder(query, operation);
        requestBuilder.accept(builder);
        return this.requester.post(url, builder.build(), CreateQueryJobResponse.class);
    }

    public CloseOrAbortJobResponse closeOrAbortJob(String jobId, JobStateEnum state) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest/" + jobId);
        CloseOrAbortJobRequest.Builder builder = new CloseOrAbortJobRequest.Builder(state);
        return this.requester.patch(url, builder.build(), CloseOrAbortJobResponse.class);
    }

    public void uploadJobData(String jobId, File sourceFile) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest/" + jobId + "/batches");
        this.requester.putCsv(url, sourceFile, Void.class);
    }

    public void deleteJob(String jobId) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest/" + jobId);
        this.requester.delete(url, null, Void.class);
    }

    public GetAllJobsResponse getAllJobs() {
        return this.getAllJobs(new Consumer<GetAllJobsRequest.Builder>(){

            @Override
            public void accept(GetAllJobsRequest.Builder request) {
            }
        });
    }

    public GetAllJobsResponse getAllJobs(Consumer<GetAllJobsRequest.Builder> requestBuilder) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest");
        GetAllJobsRequest.Builder builder = new GetAllJobsRequest.Builder();
        requestBuilder.accept(builder);
        return this.requester.get(url, builder.buildParameters(), GetAllJobsResponse.class);
    }

    public GetJobInfoResponse getJobInfo(String jobId) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest/" + jobId);
        return this.requester.get(url, GetJobInfoResponse.class);
    }

    public Reader getJobSuccessfulRecordResults(String jobId) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest/" + jobId + "/successfulResults/");
        return this.requester.getCsv(url);
    }

    public String saveQueryJobSuccessfulRecordResults(String jobId, File outFile) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/query/" + jobId + "/results");
        return url;
    }

    public Reader getJobFailedRecordResults(String jobId) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest/" + jobId + "/failedResults/");
        return this.requester.getCsv(url);
    }

    public Reader getJobUnprocessedRecordResults(String jobId) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/ingest/" + jobId + "/unprocessedrecords/");
        return this.requester.getCsv(url);
    }

    public JobInfo closeJob(String jobId) {
        return this.closeOrAbortJob(jobId, JobStateEnum.UPLOAD_COMPLETE);
    }

    public JobInfo abortJob(String jobId) {
        return this.closeOrAbortJob(jobId, JobStateEnum.ABORTED);
    }

    private String buildUrl(String path) {
        boolean hasTrailingSlash = this.instanceUrl.endsWith("/");
        return this.instanceUrl + (hasTrailingSlash ? "/" : "") + path.replace("vXX.X", API_VERSION);
    }

    public GetJobInfoResponse getQueryJobInfo(String jobId) {
        String url = this.buildUrl("/services/data/vXX.X/jobs/query/" + jobId);
        return this.requester.get(url, GetJobInfoResponse.class);
    }
}

