/*
 * Decompiled with CFR 0.152.
 */
package endolabs.salesforce.bulkv2;

import endolabs.salesforce.bulkv2.AccessToken;
import endolabs.salesforce.bulkv2.Bulk2Client;
import endolabs.salesforce.bulkv2.BulkRequestException;
import endolabs.salesforce.bulkv2.Json;
import endolabs.salesforce.bulkv2.RestRequester;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bulk2ClientBuilder {
    private static final boolean enableLog = false;
    private static final Logger log = LoggerFactory.getLogger(Bulk2ClientBuilder.class);
    private static final String TOKEN_REQUEST_ENDPOINT = "https://login.salesforce.com/services/oauth2/token";
    private static final String TOKEN_REQUEST_ENDPOINT_SANDBOX = "https://test.salesforce.com/services/oauth2/token";
    private boolean useSandbox;
    private Supplier<AccessToken> accessTokenSupplier;
    private Integer readTimeout;
    private Integer connectionTimeout;

    public Bulk2ClientBuilder withPassword(String consumerKey, String consumerSecret, String username, String password) {
        this.accessTokenSupplier = () -> this.getAccessTokenUsingPassword(consumerKey, consumerSecret, username, password);
        return this;
    }

    public Bulk2ClientBuilder withSessionId(String token, String instanceUrl) {
        this.accessTokenSupplier = () -> {
            AccessToken accessToken = new AccessToken();
            accessToken.setAccessToken(token);
            accessToken.setInstanceUrl(instanceUrl);
            return accessToken;
        };
        return this;
    }

    public Bulk2ClientBuilder useSandbox() {
        this.useSandbox = true;
        return this;
    }

    public Bulk2ClientBuilder setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Bulk2ClientBuilder setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Bulk2Client build() {
        AccessToken token = this.accessTokenSupplier.get();
        HttpLoggingInterceptor.Level logLevel = HttpLoggingInterceptor.Level.NONE;
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().addInterceptor(this.authorizationInterceptor(token.getAccessToken())).addInterceptor((Interceptor)this.httpLoggingInterceptor(logLevel));
        if (this.connectionTimeout != null) {
            clientBuilder = clientBuilder.connectTimeout((long)this.connectionTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        if (this.readTimeout != null) {
            clientBuilder = clientBuilder.readTimeout((long)this.readTimeout.intValue(), TimeUnit.MILLISECONDS);
        }
        return new Bulk2Client(new RestRequester(clientBuilder.build()), token.getInstanceUrl());
    }

    private AccessToken getAccessTokenUsingPassword(String consumerKey, String consumerSecret, String username, String password) {
        String endpoint = this.useSandbox ? TOKEN_REQUEST_ENDPOINT_SANDBOX : TOKEN_REQUEST_ENDPOINT;
        HttpUrl authorizeUrl = HttpUrl.parse((String)endpoint).newBuilder().build();
        FormBody requestBody = new FormBody.Builder().add("grant_type", "password").add("client_id", consumerKey).add("client_secret", consumerSecret).add("username", username).add("password", password).build();
        Request request = new Request.Builder().url(authorizeUrl).post((RequestBody)requestBody).build();
        HttpLoggingInterceptor.Level logLevel = HttpLoggingInterceptor.Level.NONE;
        OkHttpClient client = new OkHttpClient().newBuilder().addInterceptor((Interceptor)this.httpLoggingInterceptor(logLevel)).build();
        try {
            Response response = client.newCall(request).execute();
            ResponseBody responseBody = response.body();
            return Json.decode(responseBody.string(), AccessToken.class);
        }
        catch (IOException e) {
            throw new BulkRequestException(e);
        }
    }

    private Interceptor authorizationInterceptor(String token) {
        return chain -> {
            Request request = chain.request().newBuilder().addHeader("Authorization", "Bearer " + token).build();
            return chain.proceed(request);
        };
    }

    private HttpLoggingInterceptor httpLoggingInterceptor(HttpLoggingInterceptor.Level level) {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(message -> log.info(message));
        logging.setLevel(level);
        return logging;
    }
}

