/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.couchbase.action.hierarchy;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.manager.bucket.BucketManager;
import com.couchbase.client.java.manager.collection.CollectionManager;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.indy.addons.couchbase.action.ReverseCouchbaseAction;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdFactoryHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public final class ReverseClusterAction
extends ReverseCouchbaseAction {
    private static final String BUCKET_DEF_TYPE = "com.stambia.couchbase.bucket";
    private static final String BUCKET_PHYSICAL_NAME = "bucketPhysicalName";

    @Override
    protected final Map<MdNode, MdNode> reverse() throws Exception {
        HashMap<MdNode, MdNode> reversedNodes = new HashMap<MdNode, MdNode>();
        BucketManager bucketManager = this.cluster.buckets();
        Map buckets = bucketManager.getAllBuckets();
        for (String bucketName : buckets.keySet()) {
            MdNode oldBucketNode = this.rootNode.getNodeByName(BUCKET_DEF_TYPE, bucketName);
            Bucket bucket = this.cluster.bucket(bucketName);
            MdNode newBucketNode = MdFactoryHelper.createMdNode((String)BUCKET_DEF_TYPE);
            newBucketNode.setSubstituteContainer((EObject)this.rootNode);
            newBucketNode.setName(bucketName);
            newBucketNode.setAttribute(BUCKET_PHYSICAL_NAME, bucketName, false);
            CollectionManager collectionManager = bucket.collections();
            List scopeSpecs = collectionManager.getAllScopes();
            for (ScopeSpec scopeSpec : scopeSpecs) {
                this.reverseScope(newBucketNode, scopeSpec, false);
            }
            reversedNodes.put(newBucketNode, oldBucketNode);
        }
        return reversedNodes;
    }
}

