/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.couchbase.action.query;

import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.indy.addons.couchbase.action.query.ReverseQueryAction;
import com.stambia.couchbase.common.handler.query.QueryHandler;
import com.stambia.md.MdNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReverseN1qlAction
extends ReverseQueryAction
implements QueryHandler<JsonObject> {
    private static final String N1QL_QUERY_PARAMETER = "ancestor-or-self::n1qlQuery/@n1qlQuery";
    private static final String N1QL_MAPPING_PARAMETERS = "./document/*[name()='value']";
    private static final QueryOptions QUERY_OPTIONS = QueryOptions.queryOptions().metrics(true);
    private List<JsonObject> jsonObjects = null;

    @Override
    protected final Map<MdNode, MdNode> reverse() throws Exception {
        HashMap<MdNode, MdNode> reversedNodes = new HashMap<MdNode, MdNode>();
        this.getUserParameters();
        this.queryString = this.getQueryString();
        List<MdNode> mappingParameters = this.getMappingParameters();
        if (!mappingParameters.isEmpty()) {
            for (MdNode mappingParameter : mappingParameters) {
                String value = mappingParameter.evaluate("@reverseValue");
                if (value == null) continue;
                String name = mappingParameter.getName();
                this.queryString = this.parametrizedQuery(this.queryString, name, value);
            }
        }
        MdNode oldDocumentNode = this.rootNode.getNodeByName("com.stambia.couchbase.document", "document");
        this.newDocumentNode = ReverseN1qlAction.createNode("com.stambia.couchbase.document", "document", this.rootNode, true);
        this.createExtraNodes();
        this.setSearchRows();
        String jsonRawData = "{}";
        this.processQueryRows();
        if (this.mergedContentNode != null) {
            jsonRawData = this.mergedContentNode;
        }
        ReverseN1qlAction.addContentNode(this.newDocumentNode, jsonRawData);
        reversedNodes.put(this.newDocumentNode, oldDocumentNode);
        return reversedNodes;
    }

    public List<JsonObject> getQueryRows() {
        return this.jsonObjects;
    }

    public void processQueryRow(JsonObject queryRow) throws Exception {
        this.mergedContentNode = (JsonObject)ReverseN1qlAction.mergeJsonObject(queryRow, this.mergedContentNode);
    }

    @Override
    protected String getQueryString() throws Exception {
        String n1qlString = this.rootNode.evaluate(N1QL_QUERY_PARAMETER);
        return n1qlString;
    }

    @Override
    protected void getUserParameters() {
    }

    @Override
    protected List<MdNode> getMappingParameters() throws Exception {
        List n1qlParameters = (List)this.rootNode.evaluateMdSet(N1QL_MAPPING_PARAMETERS);
        return n1qlParameters;
    }

    @Override
    protected void createExtraNodes() {
    }

    @Override
    protected void setSearchRows() throws Exception {
        QueryResult n1qlResult = (QueryResult)this.asyncCluster.query(this.queryString, QUERY_OPTIONS).get();
        this.jsonObjects = n1qlResult.rowsAsObject();
        int n1qlRowsNumber = this.jsonObjects.size();
        if (this.reverseEngineeringSampleSize < n1qlRowsNumber) {
            this.jsonObjects = this.jsonObjects.subList(0, this.reverseEngineeringSampleSize);
        }
    }
}

