/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.delivery.repository.azure.blob.storage.impl;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.indy.engine.core.repository.CommonDeliveryRepositoryStore;
import com.indy.engine.shared.plugin.IPluginFactory;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class AzureBlobStorage
extends CommonDeliveryRepositoryStore {
    public static final String AZURE_TYPE = "Azure Blob Storage";
    public static final String CONTAINER_NAME = "container";
    public static final String STORAGE_NAME = "storage";
    public static final String URL = "url";
    public static final String PATH_ATTR = "path";
    public static final String FILE_EXTENSION = ".deliv";
    public static final String PATH_SEPARATOR = "/";
    private String container = null;
    private String storage = null;
    private String path = null;
    private BlobContainerClient service;
    private long refreshDelay = 1000L;

    public AzureBlobStorage(IPluginFactory.IPluginConfiguration conf) {
        super(conf);
        this.container = conf.getProperty(CONTAINER_NAME);
        this.storage = conf.getProperty(STORAGE_NAME);
        if (conf.getProperty(PATH_ATTR) != null && !conf.getProperty(PATH_ATTR).isEmpty() && !conf.getProperty(PATH_ATTR).equals(PATH_SEPARATOR)) {
            Object confPath = conf.getProperty(PATH_ATTR);
            if (((String)confPath).startsWith(PATH_SEPARATOR)) {
                confPath = ((String)confPath).substring(1);
            }
            if (!((String)confPath).endsWith(PATH_SEPARATOR)) {
                confPath = (String)confPath + PATH_SEPARATOR;
            }
            this.path = confPath;
        } else {
            this.path = "";
        }
        StringBuilder url = new StringBuilder();
        if (conf.getProperty(URL) != null) {
            url.append(conf.getProperty(URL));
            if (!url.toString().endsWith(PATH_SEPARATOR)) {
                url.append(PATH_SEPARATOR);
            }
            if (!url.toString().contains(this.container)) {
                url.append(this.container);
            }
        } else {
            url.append(this.generateDefaultUrl());
        }
        this.service = new BlobServiceClientBuilder().endpoint(url.toString()).credential((TokenCredential)new DefaultAzureCredentialBuilder().build()).buildClient().getBlobContainerClient(this.container);
    }

    private String generateDefaultUrl() {
        return MessageFormat.format(System.getProperty("com.semarchy.xdi.azure.blob.storage.urlpattern", "https://{0}.blob.core.windows.net/{1}"), this.storage, this.container);
    }

    public String getType() {
        return AZURE_TYPE;
    }

    protected String getPath() {
        return this.path;
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public BlobClient getBlobClientFromName(String blobName) {
        return this.service.getBlobClient(blobName);
    }

    public PagedIterable<BlobItem> listBlobs() {
        return this.service.listBlobs(new ListBlobsOptions().setPrefix(this.path), null);
    }

    public BlobClient createDelivery(String deliveryName, File file) throws IOException {
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            throw new IOException("Delivery file name must end with .deliv");
        }
        String deliveryPath = this.getDeliveryPath(deliveryName);
        BlobClient client = this.getBlobClientFromName(deliveryPath);
        client.uploadFromFile(file.getPath(), true);
        return client;
    }

    public void removeDelivery(String deliveryName) throws IOException {
        if (!deliveryName.endsWith(FILE_EXTENSION)) {
            throw new IOException("File does not end with .deliv, it is not a delivery");
        }
        String deliveryPath = this.getDeliveryPath(deliveryName);
        BlobClient client = this.getBlobClientFromName(deliveryPath);
        client.delete();
    }

    private String getDeliveryPath(String deliveryFileName) {
        StringBuilder sb = new StringBuilder(this.path);
        if (!(PATH_SEPARATOR.equals(this.path) || this.path.isEmpty() || this.path.endsWith(PATH_SEPARATOR))) {
            sb.append(PATH_SEPARATOR);
        }
        sb.append(deliveryFileName);
        return sb.toString();
    }
}

