/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.component.azure.table.storage.designer;

import com.stambia.md.MdNode;
import com.stambia.md.util.MdFactoryHelper;
import java.util.Map;

public class MdConverter {
    private static String TABLE_DEF_TYPE = "com.stambia.azure.table.table";
    private static String PROPERTY_DEF_TYPE = "com.stambia.azure.table.property";
    private static String ROW_KEY_DEF_TYPE = "com.stambia.azure.table.rowkey";
    private static String PARTITION_KEY_DEF_TYPE = "com.stambia.azure.table.partitionkey";
    private static String TIMESTAMP_DEF_TYPE = "com.stambia.azure.table.timestamp";

    public static MdNode createTableNode(MdNode rootNode, String tableName, Map<String, String> properties) {
        MdNode tableNode = MdFactoryHelper.createMdNode((String)TABLE_DEF_TYPE, (MdNode)rootNode);
        tableNode.setName(tableName);
        tableNode.setAttribute("physicalName", tableName, false);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String propName = entry.getKey();
            if (propName.equals("RowKey")) {
                MdFactoryHelper.createMdNode((String)ROW_KEY_DEF_TYPE, (MdNode)tableNode);
                continue;
            }
            if (propName.equals("PartitionKey")) {
                MdFactoryHelper.createMdNode((String)PARTITION_KEY_DEF_TYPE, (MdNode)tableNode);
                continue;
            }
            if (propName.equals("Timestamp")) {
                MdFactoryHelper.createMdNode((String)TIMESTAMP_DEF_TYPE, (MdNode)tableNode);
                continue;
            }
            MdNode propertyNode = MdFactoryHelper.createMdNode((String)PROPERTY_DEF_TYPE, (MdNode)tableNode);
            propertyNode.setName(propName);
            propertyNode.setAttribute("physicalName", propName, false);
            if (entry.getValue() == null) continue;
            propertyNode.setAttribute("type", entry.getValue(), false);
        }
        return tableNode;
    }
}

